/*----------------------------------------------------------------------------*
 | This file is part of DEU (Doom Editing Utilities), created by the DEU team:|
 | Raphael Quinet, Brendon Wyber, Ted Vessenes and others.  See README.1ST or |
 | the "about" dialog box for full credits.                                   |
 |                                                                            |
 | DEU is an open project: if you think that you can contribute, please join  |
 | the DEU team.  You will be credited for any code (or ideas) included in    |
 | the next version of the program.                                           |
 |                                                                            |
 | If you want to make any modifications and re-distribute them on your own,  |
 | you must follow the conditions of the DEU license.  Read the file LICENSE  |
 | in this directory or README.1ST in the top directory.  If do not have a    |
 | copy of these files, you can request them from any member of the DEU team, |
 | or by mail: Raphael Quinet, Rue des Martyrs 9, B-4550 Nandrin (Belgium).   |
 |                                                                            |
 | This program comes with absolutely no warranty.  Use it at your own risks! |
 *----------------------------------------------------------------------------*

 W_NAMES.C - Get the name of the editing mode, flags, angles, ...

*/

/* the includes */
#include "deu.h"
#include "w_names.h"

/*
   Get the name of an object type.
*/

char *GetObjectTypeName(int objtype)
{
   switch (objtype)
   {
   case OBJ_THINGS:
      return "Thing";
   case OBJ_LINEDEFS:
      return "LineDef";
   case OBJ_SIDEDEFS:
      return "SideDef";
   case OBJ_VERTEXES:
      return "Vertex";
   case OBJ_SEGS:
      return "Segment";
   case OBJ_SSECTORS:
      return "SSector";
   case OBJ_NODES:
      return "Node";
   case OBJ_SECTORS:
      return "Sector";
   case OBJ_REJECT:
      return "Reject";
   case OBJ_BLOCKMAP:
      return "Blockmap";
   }
   return "< Bug! >";
}


/*
   What are we editing?
*/

char *GetEditModeName(int objtype)
{
   switch (objtype)
   {
   case OBJ_THINGS:
      return "Things";
   case OBJ_LINEDEFS:
   case OBJ_SIDEDEFS:
      return "LineDefs & SideDefs";
   case OBJ_VERTEXES:
      return "Vertices";
   case OBJ_SEGS:
      return "Segments";
   case OBJ_SSECTORS:
      return "Seg-Sectors";
   case OBJ_NODES:
      return "Nodes";
   case OBJ_SECTORS:
      return "Sectors";
   }
   return "< Bug! >";
}


/*
   Get the name of the angle for a thing.
*/

char *GetThingAngleName(UInt16 angle)
{
  switch (angle)
  {
  case 0:
    return "East";
  case 45:
    return "NorthEast";
  case 90:
    return "North";
  case 135:
    return "NorthWest";
  case 180:
    return "West";
  case 225:
    return "SouthWest";
  case 270:
    return "South";
  case 315:
    return "SouthEast";
  }
  return "<ILLEGAL ANGLE>";
}


/*
   Get string of when a thing will appear.
*/

char *GetThingWhenName(UInt16 when)
{
  static char temp[40];

  temp[0] = '\0';
  if (when & 0x01)
    strcat(temp, "D12 ");
  if (when & 0x02)
    strcat(temp, "D3 ");
  if (when & 0x04)
    strcat(temp, "D45 ");
  if (when & 0x08)
    strcat(temp, "Deaf ");
  if (when & 0x10)
    strcat(temp, "Multi ");
  return temp;
}


/*
   Get a short description of the flags of a linedef.
*/

char *GetLineDefFlagsName(UInt16 flags)
{
   static char temp[20];

   if (flags & 0x0100)
      strcpy(temp, "Ma"); /* Already on the map */
   else
      strcpy(temp, "-");
   if (flags & 0x80)
      strcat(temp, "In"); /* Invisible on the map */
   else
      strcat(temp, "-");
   if (flags & 0x40)
      strcat(temp, "So"); /* Blocks sound */
   else
      strcat(temp, "-");
   if (flags & 0x20)
      strcat(temp, "Se"); /* Secret (normal on the map) */
   else
      strcat(temp, "-");
   if (flags & 0x10)
      strcat(temp, "Lo"); /* Lower texture offset changed */
   else
      strcat(temp, "-");
   if (flags & 0x08)
      strcat(temp, "Up"); /* Upper texture offset changed */
   else
      strcat(temp, "-");
   if (flags & 0x04)
      strcat(temp, "2S"); /* Two-sided */
   else
      strcat(temp, "-");
   if (flags & 0x02)
      strcat(temp, "Mo"); /* Monsters can't cross this line */
   else
      strcat(temp, "-");
   if (flags & 0x01)
      strcat(temp, "Im"); /* Impassible */
   else
      strcat(temp, "-");
   if (strlen(temp) > 13)
   {
      temp[13] = '|';
      temp[14] = '\0';
   }
   return temp;
}


/*
   Get a long description of the flags for a linedef.
*/

char *GetLineDefFlagsLongName(UInt16 flags)
{
   if (flags & 0x0100)
      return "Already on the map at startup";
   if (flags & 0x80)
      return "Invisible on the map";
   if (flags & 0x40)
      return "Blocks sound";
   if (flags & 0x20)
      return "Secret (shown as normal on the map)";
   if (flags & 0x10)
      return "Lower texture is \"unpegged\"";
   if (flags & 0x08)
      return "Upper texture is \"unpegged\"";
   if (flags & 0x04)
      return "Two-sided (may be transparent)";
   if (flags & 0x02)
      return "Monsters cannot cross this line";
   if (flags & 0x01)
      return "Impassible";
   return "UNKNOWN";
}


/* end of file */

