/*----------------------------------------------------------------------------*
 | This file is part of DEU (Doom Editing Utilities), created by the DEU team:|
 | Raphael Quinet, Brendon Wyber, Ted Vessenes and others.  See README.1ST or |
 | the "about" dialog box for full credits.                                   |
 |                                                                            |
 | DEU is an open project: if you think that you can contribute, please join  |
 | the DEU team.  You will be credited for any code (or ideas) included in    |
 | the next version of the program.                                           |
 |                                                                            |
 | If you want to make any modifications and re-distribute them on your own,  |
 | you must follow the conditions of the DEU license.  Read the file LICENSE  |
 | in this directory or README.1ST in the top directory.  If do not have a    |
 | copy of these files, you can request them from any member of the DEU team, |
 | or by mail: Raphael Quinet, Rue des Martyrs 9, B-4550 Nandrin (Belgium).   |
 |                                                                            |
 | This program comes with absolutely no warranty.  Use it at your own risks! |
 *----------------------------------------------------------------------------*

 W_THINGS.H

*/

#ifndef _W_THINGS_H_
#define _W_THINGS_H_

/* Thing properties */
#define TP_BLOCK  0x0001  /* Blocks the player */
#define TP_PICK   0x0002  /* Can be picked up */
#define TP_SOUND  0x0004  /* Sound only: invisible, can be outside of map */
#define TP_INVIS  0x0008  /* Invisible or blurred */
#define TP_FLOAT  0x0010  /* Floats or hangs from the ceiling */
#define TP_ITEM   0x0020  /* Counts towards the item ratio at the end */
#define TP_KILL   0x0040  /* Counts towards the kill ratio at the end */
#define TP_LIGHT  0x0080  /* Can be seen in a dark room */
#define TP_PLAYER 0x0100  /* Player starting point */
#define TP_WEAPON 0x0200  /* Weapon */
#define TP_WAMMO  0x0400  /* Ammunition */
#define TP_CORPSE 0x0800  /* Corpse */
#define TP_BAD    0xFFFF  /* Invalid Thing - should not be used */

/* Thing classes */
#define TC_PLAYER 0
#define TC_ENEMY  1
#define TC_WEAPON 2
#define TC_ARTFCT 3
#define TC_EQPMNT 4
#define TC_LIGHT  5
#define TC_HNGDEC 6
#define TC_CORPSE 7
#define TC_SOUND  7 /* Same class on purpose */
#define TC_DECOR  8

/* Thing ranges */
#define MINDTHINGINFO0    1
#define MAXDTHINGINFO0   89
#define MINDTHINGINFO2 2001
#define MAXDTHINGINFO2 2049
#define MINDTHINGINFO3 3001
#define MAXDTHINGINFO3 3006
#define MINHTHINGINFO0    1
#define MAXHTHINGINFO0   96
#define MINHTHINGINFO1 1200
#define MAXHTHINGINFO1 1209
#define MINHTHINGINFO2 2001
#define MAXHTHINGINFO2 2035

/* starting areas */
#define THING_PLAYER1         1
#define THING_PLAYER2         2
#define THING_PLAYER3         3
#define THING_PLAYER4         4
#define THING_DEATHMATCH      11

/* teleport arrival */
#define THING_TELEPORT        14

/* special "enemies" */
#define THING_BOSSSHOOTER     89   /* only in Doom II */
#define THING_SPAWNSPOT       87   /* only in Doom II */
#define THING_DSPARILSPOT     56   /* only in Heretic */
#define THING_BARREL          2035 /* same as Pod in Heretic */

/* keys */
#define THING_DOOM_BLUEKEY   5
#define THING_DOOM_BLUESKL   40
#define THING_DOOM_YELLOWKEY 6
#define THING_DOOM_YELLOWSKL 39
#define THING_DOOM_REDKEY    13
#define THING_DOOM_REDSKL    38
#define THING_HTIC_BLUEKEY   79
#define THING_HTIC_YELLOWKEY 80
#define THING_HTIC_GREENKEY  73

/* key types */
#define KEYTYPE_NONE         0
#define KEYTYPE_BLUE         1
#define KEYTYPE_YLLW         2
#define KEYTYPE_RED          3

/* prototypes */
char  *GetThingName(Int16 type);
char  *GetThingPicName(Int16 type);
Int16  GetThingRadius(Int16 type);
Int16  GetThingHeight(Int16 type);
Int16  GetThingHealth(Int16 type);
Int16  GetThingDamage(Int16 type);
UInt16 GetThingProperties(Int16 type);
Int16  GetThingColour(Int16 type);
Int16  GetThingClass(Int16 type);
Int16  GetKeyType(Int16 type);

#endif /* _W_THINGS_H_ */
/* end of file */
