
 /* 
 
 Copyright(C) 2011 Simon Howard

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 02111-1307, USA.

 --

 Short example program showing how to use the -control API.
 This makes the player always move forwards.

 */

#include <stdio.h>
#include <stdlib.h>

#include "control.h"

static int count = 0;

static void forwards(ticcmd_t *ticcmd, void *unused)
{
    ticcmd->forwardmove = 30;
    ++count;
}

int main(int argc, char *argv[])
{
    if (!control_parse_cmd_line(argc, argv, NULL))
    {
        printf("Usage: %s [args] <cmd line>\n", argv[0]);
        printf("eg. %s doom2.exe -warp 1\n", argv[0]);
        exit(-1);
    }

    control_launch_doom(NULL, forwards, NULL);
    printf("interrupt invoked %i times\n", count);

    return 0;
}

