/*
   DooM PostScript Maps Utility, by Frans P. de Vries.

   DMUNIX.H - Some UNIX specific things.

Derived from:

   Doom Editor Utility, by Brendon Wyber and Raphaël Quinet.

   You are allowed to use any parts of this code in another program, as
   long as you give credits to the authors in the documentation and in
   the program itself.  Read the file README for more information.

   This program comes with absolutely no warranty.
*/


#ifndef DM_UNIX_H
#define DM_UNIX_H

#define huge	/* No huge things in Unix, either */

/* from dmpsmu.c/dmpsmap.c */
extern char *strupr( char *);

/* from wads.c */
#ifdef DM_BIG_ENDIAN
/* big endian machines (eg. Sun, SGI) need to swap bytes within int's/long's */
   extern void swapint( BCINT *i);
   extern void swaplong( int32_t *l);
#else
/* little endian machines (eg. IBM PC) need to do nothing */
#  define swapint(i)
#  define swaplong(l)
#endif


/* global (re)definitions */
#ifndef max
#define max(x,y)	(((x)>(y))?(x):(y))
#define min(x,y)	(((x)<(y))?(x):(y))
#endif

#define exch(a,b)	{ int t=(a); (a)=(b); (b)=t; }

#define GetMemory(x)		malloc(x)
#define FreeMemory(x)		free(x)
#define ResizeMemory(x,y)	realloc(x,y)
#define GetFarMemory(x)		malloc(x)
#define FreeFarMemory(x)	free(x)
#define ResizeFarMemory(x,y)	realloc(x,y)

#endif /* DM_UNIX_H */
