#include <stdio.h> // hell yes.. standard includes means if you really
#include <stdlib.h> // *wanted*, you could compile this for Linux.
#define CURRENTVERSION "1.2c"

char *ver[]={"1.4","1.5beta","1.6beta or 1.666","1.7 or 1.7a","1.8","1.9"};
char *skill[]={"I'm too young to die","Not too rough","Hurt me plenty","Ultraviolence","Nightmare!"};
FILE *infile;

typedef struct{
	int version;
	int skill;
	int episode;
	int mission;
	int mode;
	int respawn;
	int fast;
	int nomonsters;
	int viewpoint;
	int p1p;
	int p2p;
	int p3p;
	int p4p;
}DEMOSTRUCT;

void readinfo(DEMOSTRUCT *demo);
void readinfo(DEMOSTRUCT *demo){
	demo->version=fgetc(infile);
	demo->skill=fgetc(infile);
	demo->episode=fgetc(infile);
	demo->mission=fgetc(infile);
	demo->mode=fgetc(infile);
	demo->respawn=fgetc(infile);
	demo->fast=fgetc(infile);
	demo->nomonsters=fgetc(infile);
	demo->viewpoint=fgetc(infile);
	demo->p1p=fgetc(infile);
	demo->p2p=fgetc(infile);
	demo->p3p=fgetc(infile);
	demo->p4p=fgetc(infile);
}

void main(int argc,char *argv[])
{
	DEMOSTRUCT demo;
	if(argc<2){
		printf("You must specify a demo filename.");
		printf("\nExample: dt mydemo.lmp\n\n");
		exit(1);
	}
	if((infile=fopen(argv[1],"rb"))==NULL){
		printf("\nError opening file.\n");
		exit(1);
	}

	rewind(infile);
	readinfo(&demo);
	if(demo.version<=101 || demo.version>=110){
		printf("This file doesn't seem to be a demo .LMP file.\n\n");
		fclose(infile);
		exit(1);
	}
	if(demo.version<104){
		printf("This demo is from a version prior to Doom 1.4. \
			This program can't");
		printf("\nhandle these earlier demos.\n\n");
		fclose(infile);
		exit(1);
	}
	printf("Demo recorded under Doom version %s.",ver[demo.version-104]);
	printf("\nSkill level: %s",skill[demo.skill]);
	printf("\nEpisode: %d",demo.episode);
	printf("\nMission: %d",demo.mission);
	printf("\nMode: ");
	switch(demo.mode){
		case 0:
			if(!demo.p2p)
				printf("Single player");
			else
				printf("Cooperative");
			break;
		case 1:
			printf("Original Deathmatch");
			break;
		case 2:
			printf("Deathmatch 2.0");
	}
	if(demo.respawn)
		printf("\nRespawn is ON");
	else
		printf("\nRespawn is OFF");
	if(demo.fast)
		printf("\nFast-monsters are ON");
	else
		printf("\nFast-monsters are OFF");
	if(demo.nomonsters)
		printf("\nThere are no monsters in play");
	else
		printf("\nThere are monsters in play");
	printf("\nViewpoint: ");
	switch(demo.viewpoint){
		case 0:
			printf("Player 1 (Green)");
			break;
		case 1:
			printf("Player 2 (Indigo)");
			break;
		case 2:
			printf("Player 3 (Brown)");
			break;
		case 3:
			printf("Player 4 (Red)");
			break;
	}
	printf("\nPlayers present: ");
	if(demo.p1p)
		printf("Green");
	if(demo.p2p)
		printf(", Indigo");
	if(demo.p3p)
		printf(", Brown");
	if(demo.p4p)
		printf(", Red");
	fclose(infile);
	printf("\n\nThanks for using DemoTool %s!\n\n",CURRENTVERSION);
}

