/****************************************************************************\
;                                                                            ;
;  tools.c  -  projekt LMP control center                                    ;
;  implementation                                                            ;
;                                                                            ;
;  general tool routines                                                     ;
;                                                                            ;
;  Uwe Girlich                                                               ;
;  Erika-von-Brockdorff-Strasse 2                                            ;
;  04159 Leipzig                                                             ;
;  Deutschland / Germany                                                     ;
;  E-mail: girlich@aix520.informatik.uni-leipzig.de                          ;
;                                                                            ;
\****************************************************************************/


#include <errno.h>
#include <stdio.h>
#include "tools.h"


char *my_errlist[] = {
			"too few arguments",
			"too many arguments",
			"read error",
			"write error",
			"wrong predefined game type",
			"unknown game type",
			"bad LMP file",
			"bad version byte",
			"unknown version byte",
			"impossible version change",
			"argument missing",
			"too many action parameters",
			"invalid option value",
			"illegal option",
			"missing input filename",
			"missing output filename"
		       };


void syserror(int errno, char* message)
{
  syswarning(errno, message);
  exit(errno);
}

void syswarning(int errno, char* message)
{
  if (0<errno && errno<sys_nerr)
    fprintf(stderr,"lmpc: %s: %s\n", message, sys_errlist[errno]);
  else
    if (err_base<=errno && errno<LASTERR) 
      fprintf(stderr,"lmpc: %s: %s\n", message, my_errlist[errno-err_base]);
    else
      fprintf(stderr,"lmpc: %s: errno=%d\n", message, errno);
}

void syntaxerror(long linenumber, char *message)
{
  fprintf(stderr, "lmpc: Syntax error in line %ld. %s.\n", linenumber, message);
  exit(1);
}

void syntaxwarning(long linenumber, char *message)
{
  fprintf(stderr, "lmpc: Syntax warning in line %ld. %s.\n", linenumber, message);
}

char *Time2String(double time, char *buf)
{
  int hour, min, secFull, sec100;
  double sec;

  hour = time/3600;
  min = (time -3600*hour)/60;
  sec = time -3600*hour -60*min;
  secFull = sec;
  sec100 = (sec-secFull)*100;
  if (hour!=0)
    sprintf(buf, "%d:%02d:%02d.%02dh", hour, min, secFull, sec100);
  else
    if (min!=0)
      sprintf(buf, "%d:%02d.%02dm", min, secFull, sec100);
    else 
      sprintf(buf, "%d.%02ds", secFull, sec100);
  return buf;
}

void copyopenfiles(FILE *f1, FILE *f2)
{
  int c;

  while ((c=fgetc(f1))!=EOF) fputc(c,f2);
}

char *delspaces(char *a)
{
  while(strlen(a)>0 && (a[strlen(a)-1]==' '   || 
			a[strlen(a)-1]=='\t'  || 
			a[strlen(a)-1]=='\n'  ||
			a[strlen(a)-1]=='\015'   )) 
    a[strlen(a)-1]='\0';
  while(strlen(a)>0 && (a[0]==' ' || a[0]=='\t')) 
    a++;
  return a;
}

/*-- file end tools.c --------------------------------------------------------*/
