// Emacs style mode select -*- C++ -*-
//----------------------------------------------------------------------------
//
// Copyright(C) 1998-2005 Simon Howard
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//--------------------------------------------------------------------------

#include "lmpit.h"

/* LMP Statistics *********************************************************/

void statistics()
{
        player_t player[4];
        tic mytic[4];
        FILE *fstream;
        char rubbish[15];
        int num_players, gametics;
        int hours, minutes, seconds;
        long tmp;

//        clrscr();

        num_players=lmp.player[0]+lmp.player[1]+lmp.player[2]+lmp.player[3];

        fstream=fopen(loaded_lmp,"rb");

        fread(&rubbish,sizeof(char),13,fstream);

        for(tmp=0;tmp<4;tmp++)
        {
                player[tmp].walk=0;
                player[tmp].strafe=0;
                player[tmp].turn=0;
                player[tmp].circle_strafe=0;
                player[tmp].controller=KEYBOARD;
        }

        for(gametics=0;!feof(fstream);gametics++)
        {
                fread(&mytic[0],sizeof(tic),num_players,fstream);

/*                printf("%i %i %i \n",mytic[0].forward, mytic[0].turn, mytic[0].strafe);
                printf("%i %i %i \t\t",mytic[1].forward, mytic[1].turn, mytic[1].strafe);
                printf("%i %i %i \t\t",mytic[2].forward, mytic[2].turn, mytic[2].strafe);
                printf("%i %i %i\n",mytic[3].forward, mytic[3].turn, mytic[3].strafe);
  */
                for(tmp=0;tmp<num_players;tmp++)
                {
                        if(mytic[tmp].forward) player[tmp].walk++;
                        if(mytic[tmp].turn) player[tmp].turn++;
                        if(mytic[tmp].strafe) player[tmp].strafe++;
/*
                        if(mytic[tmp].forward>0) player[tmp].walk+=mytic[tmp].forward;
                        if(mytic[tmp].forward<0) player[tmp].walk-=mytic[tmp].forward;

                        if(mytic[tmp].turn>0) player[tmp].turn+=mytic[tmp].turn;
                        if(mytic[tmp].turn<0) player[tmp].turn-=mytic[tmp].turn;

                        if(mytic[tmp].strafe>0) player[tmp].strafe+=mytic[tmp].strafe;
                        if(mytic[tmp].strafe<0) player[tmp].strafe-=mytic[tmp].strafe;
*/
                        if(mytic[tmp].strafe && mytic[tmp].turn) player[tmp].circle_strafe=1;

                        if((mytic[tmp].turn>5) | (mytic[tmp].turn<-5))
                                player[tmp].controller=MOUSE;
                }
        }
        fclose(fstream);

        for(tmp=0;tmp<num_players;tmp++)
        {
                player[tmp].walk=player[tmp].walk*100;
                player[tmp].turn=player[tmp].turn*100;
                player[tmp].strafe=player[tmp].strafe*100;

                player[tmp].walk=player[tmp].walk/(gametics);
                player[tmp].turn=player[tmp].turn/(gametics);
                player[tmp].strafe=player[tmp].strafe/(gametics);
        }

        seconds=gametics/35;
        minutes=seconds/60;
        hours=minutes/60;
        minutes=minutes-(hours*60);
        seconds=seconds-(minutes*60);

        display_screen();

        textbackground(BLACK); textcolor(WHITE);
        gotoxy(9,5); cprintf("                        Statistics                             \n");
        textbackground(LIGHTGRAY); textcolor(BLACK);
        gotoxy(9,6); cprintf("                                                               \n");
        gotoxy(9,7); cprintf("  Time:                                                        \n");
                gotoxy(17,7); cprintf("%i Hours, %i Minutes, %i Seconds\n",hours,minutes,seconds);
        gotoxy(9,8); cprintf("  Players:                                                     \n");
                gotoxy(20,8); cprintf("%i\n",num_players);
        gotoxy(9,9); cprintf("                                                               \n");
        gotoxy(9,10);cprintf("  Player                                                       \n");
        gotoxy(9,11);cprintf("    \n");
        gotoxy(9,12);cprintf("  Walk factor:                                                 \n");
        gotoxy(9,13);cprintf("  Strafe factor:                                               \n");
        gotoxy(9,14);cprintf("  Turn factor:                                                 \n");
        gotoxy(9,15);cprintf("                                                               \n");
        gotoxy(9,16);cprintf("  Circle strafes:                                              \n");
        gotoxy(9,17);cprintf("  Controller:                                                  \n");
        gotoxy(9,18);cprintf("                                                               \n");
        gotoxy(9,19);cprintf("                                                               \n");
        gotoxy(9,20);cprintf("                                                               \n");
        gotoxy(9,21);cprintf("                                                               \n");
        gotoxy(9,22);cprintf("                                                               \n");

        textbackground(BLACK); textcolor(LIGHTGRAY);
        for(tmp=6;tmp<24;tmp++)
        {       gotoxy(72,tmp); cputs(""); }
        gotoxy(11,23);  cputs("");

        textbackground(LIGHTGRAY); textcolor(BLACK);

        if(lmp.player[0])
        {
                gotoxy(28,10); cprintf("1\n");

                gotoxy(28,12); cprintf("%i%%\n",player[0].walk);
                gotoxy(28,13); cprintf("%i%%\n",player[0].turn);
                gotoxy(28,14); cprintf("%i%%\n",player[0].strafe);

                if(player[0].circle_strafe)
                {        gotoxy(28,16); cprintf("Yes\n"); }
                else
                {        gotoxy(28,16); cprintf("No\n");  }
                if(player[0].controller==MOUSE)
                {        gotoxy(28,17); cprintf("Mouse\n");}
                else
                {        gotoxy(28,17); cprintf("Keyboard\n");}
        }
        if(lmp.player[1])
        {
                gotoxy(38,10); cprintf("2\n");

                gotoxy(38,12); cprintf("%i%%\n",player[1].walk);
                gotoxy(38,13); cprintf("%i%%\n",player[1].turn);
                gotoxy(38,14); cprintf("%i%%\n",player[1].strafe);

                if(player[1].circle_strafe)
                {        gotoxy(38,16); cprintf("Yes\n"); }
                else
                {        gotoxy(38,16); cprintf("No\n"); }
                if(player[1].controller==MOUSE)
                {        gotoxy(38,17); cprintf("Mouse\n");}
                else
                {        gotoxy(38,17); cprintf("Keyboard\n"); }
        }
        if(lmp.player[2])
        {
                gotoxy(48,10); cprintf("3\n");

                gotoxy(48,12); cprintf("%i%%\n",player[2].walk);
                gotoxy(48,13); cprintf("%i%%\n",player[2].turn);
                gotoxy(48,14); cprintf("%i%%\n",player[2].strafe);

                if(player[2].circle_strafe)
                {        gotoxy(48,16); cprintf("Yes\n"); }
                else
                {        gotoxy(48,16); cprintf("No\n"); }
                if(player[2].controller==MOUSE)
                {        gotoxy(48,17); cprintf("Mouse\n"); }
                else
                {        gotoxy(48,17); cprintf("Keyboard\n"); }
        }
        if(lmp.player[3])
        {
                gotoxy(58,10); cprintf("4\n");

                gotoxy(58,12); cprintf("%i%%\n",player[3].walk);
                gotoxy(58,13); cprintf("%i%%\n",player[3].turn);
                gotoxy(58,14); cprintf("%i%%\n",player[3].strafe);

                if(player[3].circle_strafe)
                {        gotoxy(58,16); cprintf("Yes\n"); }
                else
                {        gotoxy(58,16); cprintf("No\n"); }
                if(player[3].controller==MOUSE)
                {        gotoxy(58,17); cprintf("Mouse\n"); }
                else
                {        gotoxy(58,17); cprintf("Keyboard\n"); }
        }

        textbackground(LIGHTGRAY);textcolor(DARKGRAY);
        gotoxy(31,20);cputs("           ");
        gotoxy(31,21);cputs("");
        textbackground(BLACK); textcolor(WHITE);
        gotoxy(30,20);cputs("     OK     ");
        gotoxy(35,20);getch();
}
