// Emacs style mode select -*- C++ -*-
//----------------------------------------------------------------------------
//
// Copyright(C) 1998-2005 Simon Howard
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//--------------------------------------------------------------------------
//
// WAD loading and reading routines: taken from DMWAD by Tom Robinson
// (except list_entries(), which I did)
// 
//--------------------------------------------------------------------------

/************************ INCLUDES ****************************************/

#include "lmpit.h"

/************************ Globals ******************************************/

FILE *wadfp;

union REGS r;                    //how am I supposed to twiddle
                                 //any frobs without this? :)
char picentry[8];

/* Load the WAD, check if it's a WAD, set pos to start of dir **************/

long setwadpostodir(void)
{
        char wadtype[5];                //seems to cock up if I do
                                        //the exact length so I put 5
        long numentries, diroffset;

        rewind(wadfp);

        fgets(wadtype, 5, wadfp);               //check if IWAD!

        if (strcmp("IWAD", wadtype) && strcmp("PWAD", wadtype))
                        error("Error reading file, IWAD/PWAD identifier not found, found `%s'", wadtype);

        fread(&numentries, 4, 1, wadfp);        //read num entries
        fread(&diroffset, 4, 1, wadfp);         //read offset in wad to dir
        fsetpos(wadfp, &diroffset);             //set pos of pointer to dir

        return(numentries);                     //return num entries
}

/* Finds the entry in the WAD **********************************************/

long parsedir(char *entrytofind)
{
        short i;
        long entryoffset, entrylength, numentries, junk;
        char entryname[8];              //again, seems to cock up without this
                                        //extra 1 byte buffer at the end

        numentries = setwadpostodir();

        for (i=0 ; i<numentries ; i++)  //will continue until it runs out of
        {                               //entries
                fread(&entryoffset, sizeof(long), 1, wadfp);
                fread(&entrylength, sizeof(long), 1, wadfp);
                fgets(entryname, strlen(entrytofind)+1, wadfp);               //check if its
                if(8-strlen(entrytofind))
                        fread(&junk, 8-strlen(entrytofind), 1, wadfp);
                                                                //entrytofind
                if (!strcmp(entrytofind, entryname))
                        goto foundentry;
        }

        error("Gone through all %ld entries and can't find %s", numentries, entrytofind);

        foundentry:

        fsetpos(wadfp, &entryoffset);
        return(entrylength);
}

/* List WAD entries ********************************************************/

void list_entries()
{
        int entries=0, count=0, y;
        char buffer[10];
        entry_t entry;

        printf("Entry name      Offset\n\n");
        entries=setwadpostodir();

        for(count=0;count<entries;count++)
        {

                fread(&entry, sizeof(entry_t), 1, wadfp);

                strcpy(buffer, convert_string8(entry) );

                y=wherey();
                gotoxy(1,y);  printf("%s\n",buffer);
                gotoxy(17,y-1); printf("%i\n",entry.offset);
        }
}


/* Takes a string8 in an entry type and returns a valid string *************/

char *convert_string8(entry_t entry)
{
        static char buffer[10];

        memset(buffer,0,9);          // Otherwise the 8-letter long
        memcpy(&buffer, &entry.name, 8);        // entries double..

        return buffer;
}

/* Finds if an entry exists ************************************************/

int entry_exist(char *entrytofind)
{
        long numentries, count;
        static entry_t entry;
        char buffer[10];

        numentries=setwadpostodir();

        for(count=1;count<numentries;count++)
        {
                fread(&entry, sizeof(entry_t), 1, wadfp);

                strcpy(buffer, convert_string8(entry) );

                if(!strcmp(entrytofind, buffer))
                        goto foundentry;
        }
        return 0;

        foundentry:
        return 1;
}


/* Finds an entry and returns information about it *************************/

entry_t findinfo(char *entrytofind)
{
        long numentries, count;
        static entry_t entry;
        char buffer[10];

        numentries=setwadpostodir();

        for(count=1;count<numentries;count++)
        {
                fread(&entry, sizeof(entry_t), 1, wadfp);

                strcpy(buffer, convert_string8(entry) );

                if(!strcmp(entrytofind, buffer))
                        goto foundentry;
        }
        entry.offset=-1; entry.length=0; strcpy(entry.name,"");

        foundentry:
        return entry;
}

/* Adds an entry to the WAD ************************************************/

void addentry(entry_t entry)
{
        char buffer[10];
        long temp, numentries;
        entry_t tempentry;

        strcpy(buffer,convert_string8(entry));
        if(entry_exist(buffer))
                printf("\tWarning! Resource %s already exists!\n",convert_string8(entry));

        numentries=setwadpostodir();            // Prepare to set file pos
        fgetpos(wadfp, &temp);
        temp += (numentries * sizeof(entry_t));

        fsetpos(wadfp, &temp);                  // Now do it!
                                                // Now at end of directory..
        fwrite(&entry.offset,sizeof(long),1,wadfp);
        fwrite(&entry.length,sizeof(long),1,wadfp);
        fwrite(&entry.name,sizeof(char),8,wadfp);
        numentries++;
        
        temp=4;
        fsetpos(wadfp,&temp);
        fwrite(&numentries,sizeof(long),1,wadfp);
}
