comment #

NetBIOS library.

Copyright (c) 1994 Mark Thomas.

NPS Software.

	#

Public  nbDetect
Public  nbAddName
Public  nbListen
Public  nbHangup
Public  nbSend
Public  nbDeleteName
Public  nbCall
Public  nbReceive
Public  nbSendNCB
Public  nbClearNCB


INCLUDE NETBIOS.INC


_DATA   SEGMENT PARA PUBLIC 'DATA'

_DATA ENDS


_TEXT   SEGMENT PARA PUBLIC 'CODE'
ASSUME CS:_TEXT, DS:_DATA, ES:_DATA

nbDetect        PROC NEAR
        push    es                              ; Is NetBIOS installed?
        xor     ax,ax                           ; Returns NZ=Yes, Z=no
        mov     es,ax
        mov     dx,es:[05Ch*4]+2                ; Get Int5Ch vector.
        mov     ax,es:[05Ch*4]
        cmp     dx,0F000h                       ; If Int5Ch is in the BIOS
        je      NoNETBIOS                       ; segment (F000:xxxx) then
        mov     es,dx                           ; no NetBIOS is installed.
        or      dx,ax                           ; If Int5Ch = 0:0 then no
        jz      NoNETBIOS                       ; NETBIOS is installed.
        mov     si,ax                           ; If Int5Ch points to an IRET
        cmp     byte ptr es:[si],0cfh           ; (CFh), the no NETBIOS is
NoNETBIOS:                                      ; installed.
        pop     es
        ret
nbDetect        ENDP

                                ; es:bx = NCB
nbAddName       PROC NEAR       ; si = name

        call    nbClearNCB
        mov     [bx].ncbCommand,ncAddName

        lea     di,[bx].ncbName
        mov     cx,16/2
        rep     movsw

        xor     ax,ax
        mov     word ptr [bx].ncbPost,ax
        mov     word ptr [bx].ncbPost+2,ax

        mov     [bx].ncbLANA_Num,al
        int     5Ch
        ret
nbAddName       ENDP

                                        ; es:bx = NCB
nbListen        PROC NEAR               ; si=Name, dx=CallName.

        call    nbClearNCB
        mov     [bx].ncbCommand,ncListen

        lea     di,[bx].ncbName
        mov     cx,16/2
        rep     movsw

        mov     si,dx
        lea     di,[bx].ncbCallName
        mov     cx,16/2
        rep     movsw

        xor     ax,ax
        mov     word ptr [bx].ncbPost,ax
        mov     word ptr [bx].ncbPost+2,ax

        mov     [bx].ncbRTO,10
        mov     [bx].ncbSTO,10

        mov     [bx].ncbLANA_Num,al
        int     5Ch
        ret
nbListen        ENDP

                                                ; es:bx = NCB
nbHangup        PROC NEAR                       ; al=LSN
        call    nbClearNCB
        mov     [bx].ncbCommand,ncHangup
        mov     [bx].ncbLSN,al

        xor     ax,ax
        mov     word ptr [bx].ncbPost,ax
        mov     word ptr [bx].ncbPost+2,ax

        mov     [bx].ncbLANA_Num,al
        int     5ch
        ret
nbHangup        ENDP

                                                ; es:bx = NCB
nbSend          PROC NEAR                       ; al=LSN
        call    nbClearNCB                      ; dx:di = bufadr, cx=len
        mov     [bx].ncbCommand,ncSend
        mov     [bx].ncbLSN,al

        mov     word ptr [bx].ncbBufAdr+2,dx
        mov     word ptr [bx].ncbBufAdr,di
        mov     [bx].ncbBufLen,cx

        xor     ax,ax
        mov     word ptr [bx].ncbPost,ax
        mov     word ptr [bx].ncbPost+2,ax

        mov     [bx].ncbLANA_Num,al
        int     5ch
        ret
nbSend          ENDP

                                        ; es:bx = NCB
nbDeleteName    PROC NEAR               ; si=name
        call    nbClearNCB
        mov     [bx].ncbCommand,ncDeleteName

        lea     di,[bx].ncbName
        mov     cx,16/2
        rep     movsw

        xor     ax,ax
        mov     word ptr [bx].ncbPost,ax
        mov     word ptr [bx].ncbPost+2,ax

        mov     [bx].ncbLANA_Num,al
        int     5Ch
        ret
nbDeleteName    ENDP

                                        ; es:bx = NCB
nbCall          PROC NEAR               ; si=name, dx=call name
        call    nbClearNCB
        mov     [bx].ncbCommand,ncCall

        lea     di,[bx].ncbName
        mov     cx,16/2
        rep     movsw

        mov     si,dx
        lea     di,[bx].ncbCallName
        mov     cx,16/2
        rep     movsw

        xor     ax,ax
        mov     word ptr [bx].ncbPost,ax
        mov     word ptr [bx].ncbPost+2,ax

        mov     [bx].ncbRTO,10
        mov     [bx].ncbSTO,10

        mov     [bx].ncbLANA_Num,al
        int     5Ch
        ret
nbCall          ENDP

                                                ; es:bx = NCB
nbReceive       PROC NEAR                       ; al=LSN
        call    nbClearNCB                      ; dx:di = bufadr, cx=len
        mov     [bx].ncbCommand,ncReceive
        mov     [bx].ncbLSN,al

        mov     word ptr [bx].ncbBufAdr+2,dx
        mov     word ptr [bx].ncbBufAdr,di
        mov     [bx].ncbBufLen,cx

        xor     ax,ax
        mov     word ptr [bx].ncbPost,ax
        mov     word ptr [bx].ncbPost+2,ax

        mov     [bx].ncbLANA_Num,al
        int     5ch
        ret
nbReceive       ENDP


nbSendNCB       PROC NEAR       ; es:bx = NCD to send
        int     5ch
        ret
nbSendNCB       ENDP


nbClearNCB      PROC NEAR       ; es:bx = NCD to clear
        push    ax
        push    cx
        push    di
        xor     ax,ax
        mov     cx,(SIZE NCB) / 2
        mov     di,bx
        rep     stosw
        pop     di
        pop     cx
        pop     ax
        ret
nbClearNCB      ENDP

_TEXT ENDS

END
