/*

   TP.H

   Transfer Protokol

   (c) 1996 Oliver Kraus

   Transfer Block:

   short id
   short version
   id specific data

*/

#ifndef _TP_H
#define _TP_H

#include "ipx.h"

#define TP_VERSION (0x0101)

#define TP_MSG_PSTART 1000
#define TP_MSG_PDATA  1001
#define TP_MSG_PEND   1002

struct _tp_pdata_struct
{
   long total;
   long curr;
   unsigned long crc;
   char *path;
   clock_t file_start;
};
typedef struct _tp_pdata_struct tp_pdata_struct;


/* #define tp_debug_out(str) (puts(str)) */
#define tp_debug_out(str)

#define tp_get_blk_id(blk)       (((short *)(blk))[0])
#define tp_get_blk_ver(blk)      (((short *)(blk))[1])
#define tp_get_blk_data_adr(blk) ((char *)(((short *)(blk))+2))

#define tp_set_blk_id(blk,id)       ((((short *)(blk))[0]) = (id))
#define tp_set_blk_ver(blk,ver)     ((((short *)(blk))[1]) = (ver))

#define tp_ecb_get_id(ecb)       tp_get_blk_id((ecb)->fragaddr2)
#define tp_ecb_get_ver(ecb)      tp_get_blk_ver((ecb)->fragaddr2)
#define tp_ecb_get_data_adr(ecb) tp_get_blk_data_adr((ecb)->fragaddr2)

#define TP_BLK_HEADER_SIZE    (2*sizeof(short))

#define TP_FLAG_IS_NO_USER_CHECK    (0x0001)
#define TP_FLAG_IS_SKIP             (0x0002)
#define TP_FLAG_IS_DISABLE_CRC      (0x0004)
#define TP_FLAG_IS_TEST_MODE        (0x0008)
#define TP_FLAG_IS_CRC32            (0x0010)
#define TP_FLAG_IS_DIR              (0x0020)

#define TP_ID_ERROR (-1)

#define TP_ID_REQUEST (-2)
struct _tp_request_struct
{
   ipx_adr_struct adr;
   long file_size;
   int flags;
   unsigned attr;
   unsigned time;
   unsigned date;
};
typedef struct _tp_request_struct tp_request_struct;
typedef struct _tp_request_struct *tp_request;

#define TP_ID_ACK_REQUEST (-3)
struct _tp_ack_request_struct
{
   ipx_adr_struct adr;
   int exist;
};
typedef struct _tp_ack_request_struct tp_ack_request_struct;
typedef struct _tp_ack_request_struct *tp_ack_request;

#define TP_ID_FILE_START (-4)
struct _tp_file_start_struct
{
   int is_skip_file;
   int flags;
};
typedef struct _tp_file_start_struct tp_file_start_struct;
typedef struct _tp_file_start_struct *tp_file_start;

#define TP_ID_ACK_FILE_START (-5)

#define TP_ID_BLOCK_START (-6)

struct _tp_block_start_struct
{
   short cnt;
};
typedef struct _tp_block_start_struct tp_block_start_struct;
typedef struct _tp_block_start_struct *tp_block_start;

#define TP_ID_ACK_BLOCK_START (-7)

#define TP_ID_DATA (-8)

struct _tp_data_struct
{
   short no;
   short len;
};
typedef struct _tp_data_struct tp_data_struct;
typedef struct _tp_data_struct *tp_data;

#define TP_ID_BLOCK_END (-9)

struct _tp_block_end_struct
{
   unsigned long crc;
};
typedef struct _tp_block_end_struct tp_block_end_struct;
typedef struct _tp_block_end_struct *tp_block_end;

#define TP_ID_MISSED_BLOCKS (-10)

struct _tp_missed_blocks_struct
{
   short cnt;
};
typedef struct _tp_missed_blocks_struct tp_missed_blocks_struct;
typedef struct _tp_missed_blocks_struct *tp_missed_blocks;

#define TP_ID_ACK_BLOCK_END (-11)

#define TP_ID_FILE_END (-12)

#define TP_ID_ACK_FILE_END (-13)

#define TP_ID_NONE (-100)

#define TP_BLK_INFO_SIZE (TP_BLK_HEADER_SIZE+sizeof(tp_data_struct))
#endif
