//
// Doom solo / minimal netgame driver.
// Copyright (C) 2014 Simon Howard
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//

// These are structure definitions from the Doom source code.

#define DOOMCOM_ID 0x12345678l
#define BACKUPTICS 12

#define NCMD_EXIT       0x80000000l
#define NCMD_RETRANSMIT 0x40000000l
#define NCMD_SETUP      0x20000000l
#define NCMD_KILL       0x10000000l     // kill game
#define NCMD_CHECKSUM   0x0fffffffl

typedef unsigned char byte;

// The data sampled per tick (single player)
// and transmitted to other peers (multiplayer).
// Mainly movements/button commands per game tick,
// plus a checksum for internal state consistency.
typedef struct
{
    char        forwardmove;    // *2048 for move
    char        sidemove;       // *2048 for move
    short       angleturn;      // <<16 for angle delta
    short       consistancy;    // checks for net game
    byte        chatchar;
    byte        buttons;
} ticcmd_t;

typedef enum
{
    CMD_SEND    = 1,
    CMD_GET     = 2
} command_t;

//
// Network packet data.
//
typedef struct
{
    // High bit is retransmit request.
    unsigned long       checksum;
    // Only valid if NCMD_RETRANSMIT.
    byte                retransmitfrom;
    byte                starttic;
    byte                player;
    byte                numtics;
    ticcmd_t            cmds[BACKUPTICS];
} doomdata_t;

typedef struct
{
    // Supposed to be DOOMCOM_ID?
    long                id;

    // DOOM executes an int to execute commands.
    short               intnum;
    // Communication between DOOM and the driver.
    // Is CMD_SEND or CMD_GET.
    short               command;
    // Is dest for send, set by get (-1 = no packet).
    short               remotenode;

    // Number of bytes in doomdata to be sent
    short               datalength;

    // Info common to all nodes.
    // Console is allways node 0.
    short               numnodes;
    // Flag: 1 = no duplication, 2-5 = dup for slow nets.
    short               ticdup;
    // Flag: 1 = send a backup tic in every packet.
    short               extratics;
    // Flag: 1 = deathmatch.
    short               deathmatch;
    // Flag: -1 = new game, 0-5 = load savegame
    short               savegame;
    short               episode;        // 1-3
    short               map;            // 1-9
    short               skill;          // 1-5

    // Info specific to this node.
    short               consoleplayer;
    short               numplayers;

    // These are related to the 3-display mode,
    //  in which two drones looking left and right
    //  were used to render two additional views
    //  on two additional computers.
    // Probably not operational anymore.
    // 1 = left, 0 = center, -1 = right
    short               angleoffset;
    // 1 = drone
    short               drone;

    // The packet data to be sent.
    doomdata_t          data;

} doomcom_t;


