/* node.c */
/*
 
 * Copyright 1994 A.Oliver De Guzman
 * All rights reserved

 *   Permission is granted to any individual to copy, use, and/or
 * distribute this software provided that the distribution retains this
 * entire copyright notice. No part of this software may be used and/or
 * sold for profit or used with any commercial product.

 * DISCLAIMER:
 *   This software comes with NO WARRANTIES of any kind. In no event
 * will the author be liable for any financial, physical, moral, and/or
 * mental damages incurred directly or indirectly by the use or intent
 * to use of this software.
 
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "dfcss.h"
#include "node.h"

Node nodes[MAX_NODES];
int nodecount = 0, nodeidx = -1;

char *nodetypes[] = {
	"player",
	"guest",
	"status",
	"god",
	"unknown",
};

int InitNode(n)
int n;
{
	nodes[n].type = PLAYER;
	nodes[n].status = UNUSED;
	nodes[n].sd = -1;
	strcpy(nodes[n].name, "Anonymous");
	strcpy(nodes[n].email, "email@host");
	strcpy(nodes[n].alias, "alias");
	strcpy(nodes[n].ip, "0.0.0.0");
}

int InitNodes()
{
	int i;
	for (i=0; i<MAX_NODES; i++) InitNode(i);
}

int NewNodeIndex()
{
	int i;
	for (i=0; i<MAX_NODES; i++)
		if (IsUnused(nodes[i])) return(i);

	return(-1);
}

int NewNode(type, sd, name, email, alias, ip)
int type;
int sd;
char *name, *email, *alias;
char *ip;
{
	int n;

	n = NewNodeIndex();
	if (n!=-1){
		nodes[n].status = ACTIVE;
		nodes[n].type = type;
		nodes[n].sd = sd;
		if (name) strcpy(nodes[n].name, name);
		if (email) strcpy(nodes[n].email, email);
		if (alias) strcpy(nodes[n].alias, alias);
		if (ip) strcpy(nodes[n].ip, ip);
	}
	return(n);
}

int NumPlayers()
{
	int i, n=0;
	for (i=0; i<MAX_NODES; i++)
		if (IsPlayer(nodes[i])) n++;
	return(n);
}

int NumGuests()
{
	int i, n=0;
	for (i=0; i<MAX_NODES; i++)
		if (IsGuest(nodes[i])) n++;
	return(n);
}

int NumGods()
{
	int i, n=0;
	for (i=0; i<MAX_NODES; i++)
		if (IsGod(nodes[i])) n++;
	return(n);
}


int GetNodeType(s)
char *s;
{
	int i;
	for (i=0; i< UNKNOWN; i++)
		if (!strcmp(s, nodetypes[i])) return(i);

	return(UNKNOWN);
}

char *StrNodeType(type)
int type;
{
	if (type < UNKNOWN) return(nodetypes[type]);
	else return(nodetypes[UNKNOWN]);
}

int WriteNodes(msg)
char *msg;
{
	int n=0;

	for (nodeidx=0; nodeidx<MAX_NODES; nodeidx++){
		if (IsActive(nodes[nodeidx])){
			ASockWrite(nodes[nodeidx].sd, msg);
			n++;
		}
	}
	return(n);
}

char *NodeStat(n)
int n;
{
	static char msg[MAXMSG+1];

	sprintf(msg, nodes[n].alias);
	strncat(msg, "<", MAXMSG);
	strncat(msg, nodes[n].email, MAXMSG);
	strncat(msg, "> ", MAXMSG);
	strncat(msg, nodes[n].name, MAXMSG);
	strncat(msg, " [", MAXMSG);
	strncat(msg, nodes[n].ip, MAXMSG);
	strncat(msg, "]", MAXMSG);
	return(msg);
}


char *GuestsStat()
{
	static char msg[MAXMSG+1];
	char buff[128];
	int i;

	msg[0] = '\0';
	if (NumGuests()){
		sprintf(msg, "* Guests");
		sprintf(buff, "(%d):", NumGuests()); strcat(msg, buff);
		for (i=0; i<MAX_NODES; i++){
			if (IsGuest(nodes[i])){
				sprintf(buff, "\n* %2d ", i); strncat(msg, buff, MAXMSG);
				strncat(msg, NodeStat(i), MAXMSG);
			}
		}
	}
	return(msg);
}


char *PlayersStat()
{
	static char msg[MAXMSG+1];
	char buff[128];
	int i;

	msg[0] = '\0';
	if (NumPlayers()){
		sprintf(msg, "* Players");
		sprintf(buff, "(%d):", NumPlayers()); strcat(msg, buff);
		for (i=0; i<MAX_NODES; i++){
			if (IsPlayer(nodes[i])){
				sprintf(buff, "\n* %2d ", i); strncat(msg, buff, MAXMSG);
				strncat(msg, NodeStat(i), MAXMSG);
			}
		}
	}
	return(msg);
}
