#include <sys/time.h>
#include <stdio.h>
#include <time.h>
#include <ctype.h>

/*
 * showlog - display the content of a dialer created log file
 *
 * usage: showlog logfile
 */

static char* sccsid = "@(#)showlog.c	1.2	5/13/93";

main(argc, argv)
	int argc;
	char** argv;
{
	FILE* logf = fopen(*++argv, "r");
	struct timeval tv;
	struct tm* tm;
	unsigned char buf[1024];
	int bytecount;
	int i;

	if (!logf) {
		fprintf(stderr, "cannot open %s\n", *argv);
		exit(1);
	}

	while (fread(&tv, sizeof(tv), 1, logf)) {
		tm = localtime((time_t*)&tv.tv_sec);

		printf("%02.2d:%02.2d:%02.2d.%06.6d: ",tm->tm_hour, tm->tm_min, tm->tm_sec,
		       tv.tv_usec);

		if (!fread(&bytecount, sizeof(bytecount), 1, logf)) {
			fprintf(stderr, "premature EOF\n");
			exit(1);
		}
		printf("%d bytes: ", bytecount);

		if (fread(buf, sizeof(char), bytecount, logf) != bytecount) {
			fprintf(stderr, "premature EOF\n");
			exit(1);
		}

		for (i = 0; i < bytecount; i++) {
			if (buf[i] > 0177) {
				printf("M-");
				buf[i] &= 0177;
			}
			if (iscntrl(buf[i])) {
				printf("^");
				buf[i] = (buf[i] + '@') & 0177;
			}
			if (isprint(buf[i]))
				printf("%c", buf[i]);
			else
				fprintf(stderr, "unprintable char???");
		}

		printf("\n");
	}
}
