/*
 *	Name:		Windows Timer Module
 *	Project:	MUS File Player Library
 *	Version:	1.01
 *	Author:		Vladimir Arnost (QA-Software)
 *	Last revision:	Oct-28-1995
 *	Compiler:	Borland C++ 3.1, Watcom C/C++ 10.0
 *
 */

/*
 * Revision History:
 *
 *	Aug-23-1995	V1.00	V.Arnost
 *		Written from scratch
 *	Oct-28-1995	V1.01	V.Arnost
 *		Windows-related code moved to this module (MLTIMWIN.C)
 */

#if !(defined(__WINDOWS__) || defined(_Windows))
  #error This module may be compiled for Windows only
#endif

#define STRICT
#include <windows.h>
#include <mmsystem.h>
#include "muslib.h"


/*HINSTANCE*/ uint MLinstance = 0;

static uint	timersOn = 0;
static uint	timerMode = TIMER_WIN70;


/* static TIMERPROC lpfnMUSLibTimerProc; */
static LPTIMECALLBACK lpfnMUSLibTimerProc;
static UINT timerID;

#pragma argsused
/* void CALLBACK _export MUSLibTimerProc(HWND hwnd, UINT msg, UINT idTimer, DWORD dwTime) */
void CALLBACK _export MUSLibTimerProc(UINT wtimerID, UINT wMsg, DWORD dwUser, DWORD dw1, DWORD dw2)
{
    switch (timerMode) {
	case TIMER_WIN35:
	    MLplayerInterrupt();
	    MLplayerInterrupt();
	case TIMER_WIN70:
	    MLplayerInterrupt();
	case TIMER_WIN140:
	    MLplayerInterrupt();
    }
}

static int SetupTimer(uint period)
{
    if (timersOn & 0x100)			/* already initialized? */
	return 0;

#if 0
    lpfnMUSLibTimerProc = (TIMERPROC)MakeProcInstance(
	(FARPROC)MUSLibTimerProc, (HINSTANCE)MLinstance);
    timerID = SetTimer(NULL, NULL, period, lpfnMUSLibTimerProc);
#else
    lpfnMUSLibTimerProc = (LPTIMECALLBACK)MakeProcInstance(
	(FARPROC)MUSLibTimerProc, (HINSTANCE)MLinstance);
    timerID = timeSetEvent(period, 5, lpfnMUSLibTimerProc, 0, TIME_PERIODIC);
#endif
    if (!timerID)
	return -1;

    timersOn |= 0x100;
    return 0;
}

static int ShutdownTimer(void)
{
    if (!(timersOn & 0x100))			/* is initialized? */
	return -1;

#if 0
    KillTimer(NULL, timerID);
#else
    timeKillEvent(timerID);
#endif
    FreeProcInstance((FARPROC)lpfnMUSLibTimerProc);

    timersOn &= ~0x100;
    return 0;
}


/*
 * API: Initialize and start the timer
 */
int MLinitTimer(int mode)
{
    MLtime = 0;
    switch (timerMode = mode) {
	case TIMER_WIN35:
	    return SetupTimer(28);		/* 1000/35 */
	case TIMER_WIN70:
	    return SetupTimer(14);		/* 1000/70 */
	case TIMER_WIN140:
	    return SetupTimer(7);		/* 1000/140 */
	default:
	    return -1;
    }
}

/*
 * API: Deinitialize and stop the timer
 */
int MLshutdownTimer(void)
{
    switch (timerMode) {
	case TIMER_WIN35:
	case TIMER_WIN70:
	case TIMER_WIN140:
	    return ShutdownTimer();
	default:
	    return -1;
    }
}
