/*
 *	Name:		Windows MMSYSTEM music driver
 *	Project:	MUS File Player Library
 *	Version:	1.00
 *	Author:		Vladimir Arnost (QA-Software)
 *	Last revision:	Sep-4-1995
 *	Compiler:	Borland C++ 3.1, Watcom C/C++ 10.0
 *
 */

/*
 * Revision History:
 *
 *	Sep-4-1995	V1.00	V.Arnost
 *		Module created
 */

#define STRICT
#include <windows.h>
#include <mmsystem.h>
#include "muslib.h"


/* Driver descriptor */
static char WINname[] = "Windows MMSystem";

struct driverBlock WINdriver = {
	NULL,				// next
	DRV_WINDOWS,			// driverID
	WINname,			// name
	sizeof(struct MIDIdata),	// datasize
	MIDIinitDriver,
	MIDIdeinitDriver,
	WINdriverParam,
	WINloadBank,
	WINdetectHardware,
	WINinitHardware,
	WINdeinitHardware,

	MIDIplayNote,
	MIDIreleaseNote,
	MIDIpitchWheel,
	MIDIchangeControl,
	MIDIplayMusic,
	MIDIstopMusic,
	MIDIchangeVolume,
	MIDIpauseMusic,
	MIDIunpauseMusic,
	WINsendMIDI};


static HMIDIOUT hMidiOut = 0;


/* send MIDI command */
int WINsendMIDI(uint command, uint par1, uint par2)
{
    uchar event = command & MIDI_EVENT_MASK;
    if (event == MIDI_NOTE_ON)
	playingChannels++;
    else if (event == MIDI_NOTE_OFF)
	playingChannels--;

    return midiOutShortMsg(hMidiOut,
	(BYTE)command |
	((WORD)((BYTE)par1) << 8) |
	((DWORD)((BYTE)par2) << 16)
    );
}

/* send MIDI SYStem EXclusive message */
static int WINsendSYSEX(void *data, uint length)
{
    HGLOBAL hglb;
    MIDIHDR FAR* lpHdr;

    hglb = GlobalAlloc(GMEM_MOVEABLE | GMEM_SHARE | GMEM_ZEROINIT, sizeof(MIDIHDR));
    lpHdr = GlobalLock(hglb);

    if (!lpHdr)
	return -1;			/* out of memory */

    lpHdr->lpData = data;
    lpHdr->dwBufferLength = length;

    midiOutPrepareHeader(hMidiOut, lpHdr, sizeof(MIDIHDR));
    midiOutLongMsg(hMidiOut, lpHdr, sizeof(MIDIHDR));

    while (midiOutUnprepareHeader(hMidiOut, lpHdr, sizeof(MIDIHDR) == MIDIERR_STILLPLAYING))
	;

    GlobalUnlock(hglb);
    GlobalFree(hglb);

    return 0;
}

int WINdriverParam(uint message, uint param1, void *param2)
{
    switch (message) {
	case DP_SYSEX:
	    return WINsendSYSEX(param2, param1);
    }
    return 0;
}

#pragma argsused
int WINloadBank(int fd, uint bankNumber)
{
    return 0;
}

#pragma argsused
int WINdetectHardware(uint port, uchar irq, uchar dma)
{
    HMIDIOUT hTestMidiOut = 0;

    if (midiOutOpen(&hTestMidiOut, port, NULL, NULL, NULL))
	return 0;		/* error occurred--device can't be opened */
    midiOutClose(hTestMidiOut);
    return 1;
}

#pragma argsused
int WINinitHardware(uint port, uchar irq, uchar dma)
{
    return midiOutOpen(&hMidiOut, port, NULL, NULL, NULL);
}

int WINdeinitHardware(void)
{
    midiOutReset(hMidiOut);
    return midiOutClose(hMidiOut);
}

