# Watcom WMAKE script for 16-bit models

#		*Translator Definitions*
!ifndef MODEL
MODEL = s
!endif
CC = wcc -onatxe=12 -d1 -5 -m$(MODEL) -zq
LINK = wlink
LINK_OPT = sys dos op quiet op c
LIB = wlib
LIB_OPT = /q /n /c /t /s

!ifeq MODEL h
AWELIB = rawe32l.lib
!else
AWELIB = rawe32$(MODEL).lib
!endif

SRCDIR = ..
LIBNAME = muslib$(MODEL).lib
OBJDIR = OBJ_$(MODEL)\
AWEDIR = ..\AWE32

.c: $(SRCDIR)
.h: $(SRCDIR);$(AWEDIR)
.obj: $(OBJDIR)

.c.obj:
  $(CC) -fo=$(OBJDIR) $<

MUSLIB_H = deftypes.h muslib.h


$(LIBNAME): mlkernel.obj mltimdos.obj mlapi.obj mlmemory.obj mldummy.obj &
	    mlopl.obj mlopl_io.obj mlmidi.obj mlawe32.obj &
	    mlmpu401.obj mlsbmidi.obj mlsbmix.obj mlmisc.obj
  *$(LIB) $(LIB_OPT) $(LIBNAME) &
  +$(OBJDIR)mlkernel.obj &
  +$(OBJDIR)mltimdos.obj &
  +$(OBJDIR)mlapi.obj &
  +$(OBJDIR)mlmemory.obj &
  +$(OBJDIR)mldummy.obj &
  +$(OBJDIR)mlopl.obj &
  +$(OBJDIR)mlopl_io.obj &
  +$(OBJDIR)mlmidi.obj &
  +$(OBJDIR)mlawe32.obj &
  +$(OBJDIR)mlmpu401.obj &
  +$(OBJDIR)mlsbmidi.obj &
  +$(OBJDIR)mlsbmix.obj &
  +$(OBJDIR)mlmisc.obj
#  +$(AWEDIR)\$(AWELIB)


musplay: musplay$(MODEL).exe

musplay$(MODEL).exe: musplay.obj $(LIBNAME)
  $(LINK) $(LINK_OPT) file $(OBJDIR)musplay.obj libp $(AWEDIR) name musplay$(MODEL)

musplay.obj: musplay.c $(MUSLIB_H)

mlkernel.obj: mlkernel.c $(MUSLIB_H)
mltimdos.obj: mltimdos.c $(MUSLIB_H)
mlapi.obj: mlapi.c $(MUSLIB_H)
mlmemory.obj: mlmemory.c $(MUSLIB_H)
mldummy.obj: mldummy.c $(MUSLIB_H)
mlopl.obj: mlopl.c $(MUSLIB_H)
mlopl_io.obj: mlopl_io.c $(MUSLIB_H)
mlmidi.obj: mlmidi.c $(MUSLIB_H)
mlawe32.obj: mlawe32.c $(MUSLIB_H) ctaweapi.h
mlmpu401.obj: mlmpu401.c $(MUSLIB_H)
mlsbmidi.obj: mlsbmidi.c $(MUSLIB_H)
mlsbmix.obj: mlsbmix.c $(MUSLIB_H)
mlmisc.obj: mlmisc.c $(MUSLIB_H)

cleanup: .SYMBOLIC
  del $(OBJDIR)ml*.obj
  del $(OBJDIR)musplay.obj
