#include "patch.h"

// Open the control files, make the output wad

int main(int argc,char **argv)
{
	int ky,i,j,k,n;
	char *p,*q,tname[256];
	int first=1;
	int err,cleared=0;
	FILE *tst;

	iwadname[0]='\0';
	if ((p=getenv("IWAD"))!=NULL)
		strcpy(iwadname,p);

	nclstrs=0;
	clstrs=NULL;
	CopyEnvironmentCLArgs("BRK",argc,argv);

	nclopts=nclfiles=0;
	cloptions=clfiles=NULL;
	ParseCommandLine(-1,3);	// Get any number of options, up to three parms

	InitDir(&pdir);
	InitTextures(&pwt);
	InitDTex();
	InitRanges();

	if (nclfiles!=1)
	{
		printf("\nBRK.EXE by Jim Flynn, Copyright 1996 v1.2 -- Freeware --\n");
		printf("Break a wad into its component resources in subdirectories\n");
		printf("A control file (.RES) to reconstruct the wad is also generated\n");
		printf("\nUsage: BRK [options] wadfile[.wad]\n");
		printf("\n Resource selection option:\n");
		printf(" +XYZ does only XYZ resources, -XYZ does all BUT XYZ resources.\n");
		printf(" L LUMPS      W WADS       T TEXTURES\n");
		printf(" E EFFECTS    M MUSICS     G GRAPHICS\n");
		printf(" S SPRITES    P PATCHES    F FLATS\n");
		printf("\n General options, use SET BRK=options to set defaults:\n");
		printf(" /V verbose mode\n");
		printf(" /O:filename  Specify output resource text file name\n");
		printf(" /A Additional patches in PNAMES extracted\n");
		printf("\nSee BRK.TXT for details\n");
		exit(1);
	}

	cleared=0;
	strcpy(outname,"");
	for (i=0;i<nclopts;i++)
	{
		n = strspn(cloptions[i],"lwtemgspfLWTEMGSPF");
		if (n==strlen(cloptions[i]))
		{
			if (!cleared)	// if first selection option
			{
				if (cloptsense[i])	// clear all if it adds types
				{
					DoLumps=DoWads=DoTextures=DoEffects=DoMusics=0;
					DoGraphics=DoSprites=DoPatches=DoFlats=0;
				}
				else if (!cloptsense[i]) // set all if it subtracts types
				{
					DoLumps=DoWads=DoTextures=DoEffects=DoMusics=1;
					DoGraphics=DoSprites=DoPatches=DoFlats=1;
				}
				cleared=1;	// but don't do it for following selection opts
			}
			for (j=0;j<strlen(cloptions[i]);j++)
			{
				switch(tolower(cloptions[i][j]))
				{
					case 'l':
						DoLumps = cloptsense[i];
						break;
					case 'w':
						DoWads = cloptsense[i];
						break;
					case 't':
						DoTextures = cloptsense[i];
						break;
					case 'e':
						DoEffects = cloptsense[i];
						break;
					case 'm':
						DoMusics = cloptsense[i];
						break;
					case 'g':
						DoGraphics = cloptsense[i];
						break;
					case 's':
						DoSprites = cloptsense[i];
						break;
					case 'p':
						DoPatches = cloptsense[i];
						break;
					case 'f':
						DoFlats = cloptsense[i];
						break;
				}
			}
		}
		else if (tolower(cloptions[i][0])=='v')
			Verbose = 1;
		else if (tolower(cloptions[i][0])=='o' && cloptions[i][1]==':')
			strcpy(outname,cloptions[i]+2);
		else if (tolower(cloptions[i][0])=='a')
			AdditionalPatches = 1;
		else printf("Warning: command line option: %s not understood\n",cloptions[i]);
	}

	strcpy(pwadname,clfiles[0]);

	FreeDynStr(&clstrs,&nclstrs);
	FreeDynStr(&clfiles,&nclfiles);
	FreeDynStr(&cloptions,&nclopts);

	if (Verbose)
	{
		printf("Heap at program start\n");
		heap_dump();
	}

	p=strrchr(pwadname,'.');
    if (p!=NULL) *p='\0';
	strcpy(tname,outname[0]=='\0'? pwadname : outname);
	strcat(pwadname,".WAD");
	p = strrchr(tname,'.');
	if (p!=NULL) *p='\0';
	strcat(tname,".RES");

	pst = fopen(pwadname,"rb");
	if (pst!=NULL)
	{
		fread(&phdr,sizeof(WadHeader),1,pst);
		ReadDir(&phdr,&pdir,pst);

		ReadPNames(&pdir,pst,&pwt);
		ReadTextures(&pdir,pst,&pwt);
	    GetRanges(&pdir,&nplr,plevRng,&npsr,psprRng,&npfr,pflaRng,&nppr,ppatRng);

		WriteResourceControl(tname);
		fclose(pst);
	}
	if (Verbose)
	{
		printf("Heap at program end\n");
		heap_dump();
	}
	return 0;
}

