#include "patch.h"

/************************************************************
 PATCH.C
			 /-------------------------\
			||    MER subroutines     ||
			 \-------------------------/
									
************************************************************/

// Transfer the idx-th directory entry of a wad to the output wad

void WriteEntry(WadDir *dir,FILE *st,int idx,int *offset)
{
	int o,n,offs=*offset;
	char *buffer=NULL;

	o = dir->dirp[idx].resptr;
	n = dir->dirp[idx].reslen;
    if (n>0)
    {
		buffer = (char *)realloc(buffer,n);
		assert(buffer);
		fseek(st,o,SEEK_SET);
		fread(buffer,n,1,st);
		fwrite(buffer,n,1,ost);
		free(buffer);
    }
	AddDirEntry(&odir,offs,n,Str8(dir->dirp[idx].resname));
	offs += n;

	*offset = offs;
}

// Transfer a resource from patch wad or base wad to ouptput as appropriate

void WriteSimpleResource(char *resn,int *offset,int doit)
{
	int o,n,p,offs=*offset;
	char *buffer=NULL;

	if (NewOnly || !doit)
	{
		if ((p=IsIn(resn,&bdir))>=0)
			WriteEntry(&bdir,bst,p,&offs);
		else if (doit && (p=IsIn(resn,&pdir))>=0)
			WriteEntry(&pdir,pst,p,&offs);
	}
	else
	{
		if (doit && (p=IsIn(resn,&pdir))>=0)
			WriteEntry(&pdir,pst,p,&offs);
		else if ((p=IsIn(resn,&bdir))>=0)
			WriteEntry(&bdir,bst,p,&offs);
	}
	*offset = offs;
}

// Copy a resource start marker from the base if possible, patchwad otherwise

void CopyResourceStartN(int offs,int N,Rng *brng,Rng *prng)
{
    char marker[16];

    if (brng[0].end>=brng[0].start)
    {
		if (brng[N].end>=brng[N].start)
		{
        	strncpy(marker,bdir.dirp[brng[N].start-1].resname,8);
	   		marker[8]='\0';
			AddDirEntry(&odir,offs,0,marker);
		}
    }
    else if (prng[0].end>=prng[0].start)
    {
		if (prng[N].end>=prng[N].start)
		{
	        strncpy(marker,pdir.dirp[prng[N].start-1].resname,8);
	   		marker[8]='\0';
			AddDirEntry(&odir,offs,0,marker);
		}
    }
}

// Copy a resource end marker from the base if possible, patchwad otherwise
// Markers are dir entries like MAP01, P_START, F1_END, etc that have no
// size, but just delimit groups of related resources.

void CopyResourceEndN(int offs,int N,Rng *brng,Rng *prng)
{
    char marker[16];

    if (brng[0].end>=brng[0].start)
    {
		if (brng[N].end>=brng[N].start)
		{
        	strncpy(marker,bdir.dirp[brng[N].end+1].resname,8);
	   		marker[8]='\0';
			AddDirEntry(&odir,offs,0,marker);
		}
    }
    else if (prng[0].end>=prng[0].start)
    {
		if (prng[N].end>=prng[N].start)
		{
	        strncpy(marker,pdir.dirp[prng[N].end+1].resname,8);
    		marker[8]='\0';
  			AddDirEntry(&odir,offs,0,marker);
		}
    }
}

// Copy a Sprite Start, section N

void CopySpriteStartN(int offs,int N)
{
	CopyResourceStartN(offs,N,bsprRng,psprRng);
}

// Copy a Sprite End, section N

void CopySpriteEndN(int offs,int N)
{
	CopyResourceEndN(offs,N,bsprRng,psprRng);
}

// Copy a Flat Start, section N

void CopyFlatStartN(int offs,int N)
{
	CopyResourceStartN(offs,N,bflaRng,pflaRng);
}

// Copy a Flat End, section N

void CopyFlatEndN(int offs,int N)
{
	CopyResourceEndN(offs,N,bflaRng,pflaRng);
}

// Copy a Patch Start, section N

void CopyPatchStartN(int offs,int N)
{
	CopyResourceStartN(offs,N,bpatRng,ppatRng);
}

// Copy a Patch End, section N

void CopyPatchEndN(int offs,int N)
{
	CopyResourceEndN(offs,N,bpatRng,ppatRng);
}

// The strategy for the output wad is to read each resource from the base
// wad and if it is not PNAMES, TEXTUREn, or a patch resource to write it
// to the output wad, and update the output directory. Memory is allocated
// and freed to read each resource to minimize requirements.
//
// If it is PNAMES or TEXTUREn, then the merged version is written to the
// output wad instead, and the output directory updated accordingly.
//
// If it is a patch, then if it is a patch in the patch wad's PNAMES the
// patchwad version is written, else the basewad version is used. In either
// case the offset and length is entered in the output directory.
// 
// After writing the last patch, and before writing the end patches marker
// all patches in the patch wad that do not occur in the base wad are appended
// with appropriate directory updates. Then the end patch marker is written
// and the file closed.

void WriteOutputWad()
{
	int i,j,k,m,n,o,p,n1,n2;
	char *buffer=NULL,*q,*r;
	int offs = 0,noend=1,npats;
	char bstr[16],ostr[16],levname[8]="";
	FILE *mst;
	

	strncpy(ohdr.wadtag,"PWAD",4);
	ohdr.waddirlen=0;
	ohdr.waddiraddr=0;
	fseek(ost,0,SEEK_SET);
	fwrite(&ohdr,sizeof(WadHeader),1,ost);
	offs = sizeof(WadHeader);

	// For initial 6 resources of DOOM2.WAD transfer them
	// from patchwad if provided, base wad otherwise


	///////////////////////////////////////////////////////////////////
	// PLAYPAL,COLORMAP,ENDOOM,DEMO1,DEMO2,DEMO3

	m = odir.nentries;
	for (i=I_PLAYPAL;i<=I_DEMO3;i++)
	{
		WriteSimpleResource(resstr[i],&offs,DoLumps);
		if (odir.nentries>m)
			printf("Merged %-1d LUMPS: %8s        \r",odir.nentries-m,resstr[i]);
	}
	if (odir.nentries>m)
		printf("Merged %d LUMPS  %8s         \n",odir.nentries-m,"        ");


	///////////////////////////////////////////////////////////////////
	// PNAMES
	// if there are pnames in the output WadTextures, write the PNAMES resource
	if (owt.pnames.npnames)
	{
		fwrite(&owt.pnames.npnames,sizeof(int),1,ost);
		fwrite(owt.pnames.patchname[0],8,owt.pnames.npnames,ost);
		n = sizeof(int) + 8 * owt.pnames.npnames;
		AddDirEntry(&odir,offs,n,"PNAMES");
		offs += n;
		printf("Merged PNAMES                      \n");
	}


	///////////////////////////////////////////////////////////////////
	// TEXTURE1
	// if textures exist in the output WadTextures, write the TEXTURE1 resource
	if (owt.t1.N)
	{
		fwrite(&owt.t1.N,sizeof(int),1,ost);
		fwrite(owt.t1.offs,sizeof(int),owt.t1.N,ost);
		for (j=0,npats=0;j<owt.t1.N;j++)
		{
			fwrite(owt.t1.textures+j,sizeof(TextureDesc)-sizeof(Patch *),1,ost);
			fwrite(owt.t1.textures[j].patches,sizeof(Patch),owt.t1.textures[j].npatches,ost);
			npats += owt.t1.textures[j].npatches;
		}
		n = sizeof(int) + sizeof(int) * owt.t1.N
			+ (sizeof(TextureDesc)-sizeof(Patch *)) * owt.t1.N
			+ npats * sizeof(Patch);
		AddDirEntry(&odir,offs,n,"TEXTURE1");
		offs += n;
		printf("Merged TEXTURE1                      \n");
	}

	///////////////////////////////////////////////////////////////////
	// LEVELS
	// write the levels present to the output wad
	if (DoWads)
	{
		m = odir.nentries;
		if (ReplaceLevels)
		{
			if (NewOnly)
			{
				for (i=1;i<49;i++)
				{
					for (j=0;j<nblr;j++)
						if (blevRng[j].typ==i)
						{
							for (k=blevRng[j].start;k<=blevRng[j].end;k++)
								WriteEntry(&bdir,bst,k,&offs);
							goto levdone;
						}
					for (j=0;j<nplr;j++)
						if (plevRng[j].typ==i)
						{
							for (k=plevRng[j].start;k<=plevRng[j].end;k++)
								WriteEntry(&pdir,pst,k,&offs);
						}
levdone:;
					if (odir.nentries>m)
						printf("Merged %-1d LEVELS: MAP%02d   \r",(odir.nentries-m)/11,i);
				}
				if (odir.nentries>m)
					printf("Merged %d LEVELS             \n",(odir.nentries-m)/11);
			}
			else
			{
				for (i=1;i<49;i++)
				{
					for (j=0;j<nplr;j++)
						if (plevRng[j].typ==i)
						{
							for (k=plevRng[j].start;k<=plevRng[j].end;k++)
								WriteEntry(&pdir,pst,k,&offs);
						}
					for (j=0;j<nblr;j++)
						if (blevRng[j].typ==i)
						{
							for (k=blevRng[j].start;k<=blevRng[j].end;k++)
								WriteEntry(&bdir,bst,k,&offs);
						}
					if (odir.nentries>m)
						printf("Merged %-1d LEVELS: MAP%02d   \r",(odir.nentries-m)/11,i);
				}
				if (odir.nentries>m)
					printf("Merged %d LEVELS             \n",(odir.nentries-m)/11);
			}
		}
		else if (MapLevels)
		{
			mst = fopen(levmapfil,"r");
			if (mst)
			{
				buffer = realloc(buffer,256);
				assert(buffer);
				while (fgets(buffer,256,mst))
				{
					if (strnicmp(buffer,"map",3)==0 && (r=strchr(buffer,'=')))
					{
						q = buffer+3;
						if (*q=='0') q++;
						*r = '\0';
						n1 = atoi(q);
						r++;
						while (*r==' ') r++;
						r++;
						n2 = atoi(r);
						strncpy(levname,"",8);
						sprintf(levname,"MAP%02d",n1);
						if (tolower(r[-1])=='p')
						{
							for (j=0;j<nplr;j++)
								if (plevRng[j].typ==n2)
								{
									strncpy(pdir.dirp[plevRng[j].start].resname,levname,8);
									for (k=plevRng[j].start;k<=plevRng[j].end;k++)
									{
										WriteEntry(&pdir,pst,k,&offs);
									}
								}
						}
						else if (tolower(r[-1])=='b')
						{
							for (j=0;j<nblr;j++)
								if (blevRng[j].typ==n2)
								{
									strncpy(bdir.dirp[blevRng[j].start].resname,levname,8);
									for (k=blevRng[j].start;k<=blevRng[j].end;k++)
									{
										WriteEntry(&bdir,bst,k,&offs);
									}
								}
						}
						else
						{
							printf("Level mapping file syntax error, use MAPnn=Bmm or MAPnn=Pmm\n");
						}
					}
					if (odir.nentries>m)
						printf("Merged %-1d LEVELS: MAP%02d   \r",(odir.nentries-m)/11,i);
				}
				fclose(mst);
				if (odir.nentries>m)
					printf("Merged %d LEVELS             \n",(odir.nentries-m)/11);
				
			}
		}
		else if (BaseFirst)
		{

		}
		else
		{

		}
	}
	else
	{
		for (i=1;i<49;i++)
		{
			for (j=0;j<nblr;j++)
				if (blevRng[j].typ==i)
				{
					for (k=blevRng[j].start;k<=blevRng[j].end;k++)
						WriteEntry(&bdir,bst,k,&offs);
				}
			if (odir.nentries>m)
				printf("Merged %-1d LEVELS: MAP%02d   \r",(odir.nentries-m)/11,i);
		}
		if (odir.nentries>m)
			printf("Merged %d LEVELS             \n",(odir.nentries-m)/11);
	}

	// For all remaining simple resources of DOOM2.WAD transfer them
	// from patchwad if provided, basewad otherwise. Note that none of
	// these resources will work, unless they have the same name as a
	// resource in DOOM II.

	m = odir.nentries;
	for (i=I_GENMIDI;i<=I_DMXGUSC;i++)
	{
		WriteSimpleResource(resstr[i],&offs,DoLumps);
		if (odir.nentries>m)
			printf("Merged %-1d MIDI LUMPS: %8s     \r",odir.nentries-m,resstr[i]);
	}
	if (odir.nentries>m)
		printf("Merged %d MIDI LUMPS  %8s     \n",odir.nentries-m,"         ");

	m = odir.nentries;
	for (i=I_DPPISTOL;i<=I_DSRADIO;i++)
	{
		WriteSimpleResource(resstr[i],&offs,DoEffects);
		if (odir.nentries>m)
			printf("Merged %-3d SOUNDS: %8s          \r",odir.nentries-m,resstr[i]);
	}
	if (odir.nentries>m)
		printf("Merged %d SOUNDS  %8s         \n",odir.nentries-m,"         ");

	m = odir.nentries;
	for (i=I_D_RUNNIN;i<=I_D_DM2INT;i++)
	{
		WriteSimpleResource(resstr[i],&offs,DoMusics);
		if (odir.nentries>m)
			printf("Merged %-2d MUSICS: %8s          \r",odir.nentries-m,resstr[i]);
	}
	if (odir.nentries>m)
		printf("Merged %d MUSICS  %8s        \n",odir.nentries-m,"         ");

	m = odir.nentries;
	for (i=I_HELP;i<=I_INTERPIC;i++)
	{
		WriteSimpleResource(resstr[i],&offs,DoGraphics);
		if (odir.nentries>m)
			printf("Merged %-3d GRAPHICS: %8s         \r",odir.nentries-m,resstr[i]);
	}
 	if (odir.nentries>m)
		printf("Merged %d GRAPHICS  %8s        \n",odir.nentries-m,"         ");

	// Now it remains to combine the patches, sprites, and flats 
	// from the two wads.

	///////////////////////////////////////////////////////////////////
	// SPRITES
	// First we write the sprites in the basewad's blank or first section

	i = bsprRng[0].start;  		// assume all sprites in blank section
	j = bsprRng[0].end;
	if (j<i && psprRng[0].end<psprRng[0].start) goto flats;
    CopySpriteStartN(offs,0);

	if (bsprRng[1].end>=0 && bsprRng[1].end<bsprRng[0].end)
	{
		i = bsprRng[1].start;	// unless section 1 exists inside blank sec.
		j = bsprRng[1].end;
	}
	m = odir.nentries;
	for (k=i;k<=j;k++)
	{
		if (!NewOnly && DoSprites && (p=IsIn(bdir.dirp[k].resname,&pdir))>=0)
			WriteEntry(&pdir,pst,p,&offs);		// if superseded, from patch
		else
			WriteEntry(&bdir,bst,k,&offs);		// else copy from base
		if (odir.nentries>m)
			printf("Merged %-3d SPRITES: %8s          \r",odir.nentries-m,Str8(bdir.dirp[k].resname));
	}

	// Next the sprites in patchwad's blank or 1st sec, not occurring in base

	if (DoSprites)
	{
		i = psprRng[0].start;  		// assume all sprites in blank section
		j = psprRng[0].end;
		if (psprRng[1].end>=0 && psprRng[1].end<psprRng[0].end)
		{
			i = psprRng[1].start;	// unless section 1 exists inside blank sec.
			j = psprRng[1].end;
		}
		for (k=i;k<=j;k++)
		{
			if
			(
				(p=IsIn(pdir.dirp[k].resname,&bdir))<0 ||  // if new name
				(p<bsprRng[0].start || p>bsprRng[0].end)   // or not in patch rng
			)
			{
				WriteEntry(&pdir,pst,k,&offs);		// if new, write it out
				if (odir.nentries>m)
					printf("Merged %-3d SPRITES: %8s         \r",odir.nentries-m,Str8(pdir.dirp[k].resname));
			}
		}
	}
	if (odir.nentries>m)
		printf("Merged %d SPRITES  %8s         \n",odir.nentries-m,"         ");
    CopySpriteEndN(offs,0);

	///////////////////////////////////////////////////////////////////
	// FLATS
	// First we write the flats in the basewad's blank or first section
flats:;	
	i = bflaRng[0].start;  		// assume all flats in blank section
	j = bflaRng[0].end;
	
	if (j<i && pflaRng[0].end<pflaRng[0].start) goto patches;
    CopyFlatStartN(offs,0);
	CopyFlatStartN(offs,1);
	if (bflaRng[1].end>=0 && bflaRng[1].end<bflaRng[0].end)
	{
		i = bflaRng[1].start;	// unless section 1 exists inside blank sec.
		j = bflaRng[1].end;
	}
	m = odir.nentries;
	for (k=i;k<=j;k++)
	{
		if (!NewOnly && DoFlats && (p=IsIn(bdir.dirp[k].resname,&pdir))>=0)
			WriteEntry(&pdir,pst,p,&offs);		// if superseded, from patch
		else
			WriteEntry(&bdir,bst,k,&offs);		// else copy from base
		if (odir.nentries>m)
			printf("Merged %-3d FLATS: %8s         \r",odir.nentries-m,Str8(bdir.dirp[k].resname));
	}

	// Next the flats in patchwad's blank or 1st sec, not occurring in base

	if (DoFlats)
	{
		i = pflaRng[0].start;  		// assume all flats in blank section
		j = pflaRng[0].end;
		if (pflaRng[1].end>=0 && pflaRng[1].end<pflaRng[0].end)
		{
			i = pflaRng[1].start;	// unless section 1 exists inside blank sec.
			j = pflaRng[1].end;
		}
		for (k=i;k<=j;k++)
		{
			if
			(
				(p=IsIn(pdir.dirp[k].resname,&bdir))<0 ||  // if new name
				(p<bflaRng[0].start || p>bflaRng[0].end)   // or not in patch rng
			)
			{
				WriteEntry(&pdir,pst,k,&offs);		// if new, write it out
				if (odir.nentries>m)
					printf("Merged %-3d FLATS: %8s          \r",odir.nentries-m,Str8(pdir.dirp[k].resname));
			}
		}
	}
	CopyFlatEndN(offs,1);

	// Now write the flats in the basewad's second section

	CopyFlatStartN(offs,2);
	i = bflaRng[2].start;  		// assume all flats in blank section
	j = bflaRng[2].end;
	for (k=i;k<=j;k++)
	{
		if (!NewOnly && DoFlats && (p=IsIn(bdir.dirp[k].resname,&pdir))>=0)
			WriteEntry(&pdir,pst,p,&offs);		// if superseded, from patch
		else
			WriteEntry(&bdir,bst,k,&offs);		// else copy from base
		if (odir.nentries>m)
			printf("Merged %-3d FLATS: %8s          \r",odir.nentries-m,Str8(bdir.dirp[k].resname));
	}

	// Next the flats in patchwad's 2nd sec, not occurring in base

	if (DoFlats)
	{
		i = pflaRng[2].start;  		// assume all flats in blank section
		j = pflaRng[2].end;
		for (k=i;k<=j;k++)
		{
			if
			(
				(p=IsIn(pdir.dirp[k].resname,&bdir))<0 ||  // if new name
				(p<bflaRng[0].start || p>bflaRng[0].end)   // or not in patch rng
			)
			{
				WriteEntry(&pdir,pst,k,&offs);		// if new, write it out
				if (odir.nentries>m)
					printf("Merged %-3d FLATS: %8s          \r",odir.nentries-m,Str8(pdir.dirp[k].resname));
			}
		}
	}
	CopyFlatEndN(offs,2);

	// Now write the flats in the basewad's third section

	CopyFlatStartN(offs,3);
	i = bflaRng[3].start;  		// assume all flats in blank section
	j = bflaRng[3].end;
	for (k=i;k<=j;k++)
	{
		if (!NewOnly && DoFlats && (p=IsIn(bdir.dirp[k].resname,&pdir))>=0)
			WriteEntry(&pdir,pst,p,&offs);		// if superseded, from patch
		else
			WriteEntry(&bdir,bst,k,&offs);		// else copy from base
		if (odir.nentries>m)
			printf("Merged %-3d FLATS: %8s         \r",odir.nentries-m,Str8(bdir.dirp[k].resname));
	}

	// Next the flats in patchwad's blank or 1st sec, not occurring in base

	if (DoFlats)
	{
		i = pflaRng[3].start;  		// assume all flats in blank section
		j = pflaRng[3].end;
		for (k=i;k<=j;k++)
		{
			if
			(
				(p=IsIn(pdir.dirp[k].resname,&bdir))<0 ||  // if new name
				(p<bflaRng[0].start || p>bflaRng[0].end)   // or not in patch rng
			)
			{
				WriteEntry(&pdir,pst,k,&offs);		// if new, write it out
				if (odir.nentries>m)
					printf("Merged %-3d FLATS: %8s           \r",odir.nentries-m,Str8(pdir.dirp[k].resname));
			}
		}
	}
	if (odir.nentries>m)					    
		printf("Merged %d FLATS %8s           \n",odir.nentries-m,"         ");

	CopyFlatEndN(offs,3);
	CopyFlatEndN(offs,0);

	///////////////////////////////////////////////////////////////////
	// PATCHES
	// First we write the patches in the basewad's blank or first section
patches:;
	i = bpatRng[0].start;  		// assume all patches in blank section
	j = bpatRng[0].end;
	if (j<i && ppatRng[0].end<ppatRng[0].start) goto dodir;
    CopyPatchStartN(offs,0);
	CopyPatchStartN(offs,1);

	m = odir.nentries;
	if (bpatRng[1].end>=0 && bpatRng[1].end<bpatRng[0].end)
	{
		i = bpatRng[1].start;	// unless section 1 exists inside blank sec.
		j = bpatRng[1].end;
	}
	for (k=i;k<=j;k++)
	{
		if (!NewOnly && DoPatches && (p=IsIn(bdir.dirp[k].resname,&pdir))>=0)
			WriteEntry(&pdir,pst,p,&offs);		// if superseded, from patch
		else
			WriteEntry(&bdir,bst,k,&offs);		// else copy from base
		if (odir.nentries>m)
			printf("Merged %-3d PATCHES: %8s         \r",odir.nentries-m,Str8(bdir.dirp[k].resname));
	}

	// Next the patches in patchwad's blank or 1st sec, not occurring in base

	if (DoPatches)
	{
		i = ppatRng[0].start;  		// assume all patches in blank section
		j = ppatRng[0].end;
		if (ppatRng[1].end>=0 && ppatRng[1].end<ppatRng[0].end)
		{
			i = ppatRng[1].start;	// unless section 1 exists inside blank sec.
			j = ppatRng[1].end;
		}
		for (k=i;k<=j;k++)
		{
			if
			(
				(p=IsIn(pdir.dirp[k].resname,&bdir))<0 ||  // if new name
				(p<bpatRng[0].start || p>bpatRng[0].end)   // or not in patch rng
			)
			{
				WriteEntry(&pdir,pst,k,&offs);		// if new, write it out
				if (odir.nentries>m)
					printf("Merged %-3d PATCHES: %8s         \r",odir.nentries-m,Str8(pdir.dirp[k].resname));
			}
		}
	}
	CopyPatchEndN(offs,1);

	// Now write the patches in the basewad's second section

	CopyPatchStartN(offs,2);
	i = bpatRng[2].start;  		// assume all patches in blank section
	j = bpatRng[2].end;
	for (k=i;k<=j;k++)
	{
		if (!NewOnly && DoPatches && (p=IsIn(bdir.dirp[k].resname,&pdir))>=0)
			WriteEntry(&pdir,pst,p,&offs);		// if superseded, from patch
		else
			WriteEntry(&bdir,bst,k,&offs);		// else copy from base
		if (odir.nentries>m)
			printf("Merged %-3d PATCHES: %8s          \r",odir.nentries-m,Str8(bdir.dirp[k].resname));
	}

	// Next the patches in patchwad's 2nd sec, not occurring in base

	if (DoPatches)
	{
		i = ppatRng[2].start;  		// assume all patches in blank section
		j = ppatRng[2].end;
		for (k=i;k<=j;k++)
		{
			if
			(
				(p=IsIn(pdir.dirp[k].resname,&bdir))<0 ||  // if new name
				(p<bpatRng[0].start || p>bpatRng[0].end)   // or not in patch rng
			)
			{
				WriteEntry(&pdir,pst,k,&offs);		// if new, write it out
				if (odir.nentries>m)
					printf("Merged %-3d PATCHES: %8s       \r",odir.nentries-m,Str8(pdir.dirp[k].resname));
			}
		}
	}
	CopyPatchEndN(offs,2);

	// Now write the patches in the basewad's third section

	CopyPatchStartN(offs,3);
	i = bpatRng[3].start;  		// assume all patches in blank section
	j = bpatRng[3].end;
	for (k=i;k<=j;k++)
	{
		if (!NewOnly && DoPatches && (p=IsIn(bdir.dirp[k].resname,&pdir))>=0)
			WriteEntry(&pdir,pst,p,&offs);		// if superseded, from patch
		else
			WriteEntry(&bdir,bst,k,&offs);		// else copy from base
		if (odir.nentries>m)
			printf("Merged %-3d PATCHES: %8s         \r",odir.nentries-m,Str8(bdir.dirp[k].resname));
	}

	// Next the patches in patchwad's blank or 1st sec, not occurring in base

	if (DoPatches)
	{
		i = ppatRng[3].start;  		// assume all patches in blank section
		j = ppatRng[3].end;
		for (k=i;k<=j;k++)
		{
			if
			(
				(p=IsIn(pdir.dirp[k].resname,&bdir))<0 ||  // if new name
				(p<bpatRng[0].start || p>bpatRng[0].end)   // or not in patch rng
			)
			{
				WriteEntry(&pdir,pst,k,&offs);		// if new, write it out
				if (odir.nentries>m)
					printf("Merged %-3d PATCHES: %8s       \r",odir.nentries-m,Str8(pdir.dirp[k].resname));
			}
		}
	}
	if (odir.nentries>m)
		printf("Merged %d PATCHES %8s        \n",odir.nentries-m,"         ");
	CopyPatchEndN(offs,3);
	CopyPatchEndN(offs,0);

dodir:;
	// write the output wad's directory
	fwrite(odir.dirp,sizeof(WadDirEntry),odir.nentries,ost);

	// finally rewrite the output wad's header and close
	fseek(ost,0,SEEK_SET);
	if (MakeIwad) strncpy(ohdr.wadtag,"IWAD",4);
	ohdr.waddirlen = odir.nentries;
	ohdr.waddiraddr = offs;
	fwrite(&ohdr,sizeof(WadHeader),1,ost);

	free(buffer);
}


