PROGRAM SHOW;
{ This program shows the levels in a DOOM wad file }
{ Paul Robinson 6/17/94 -- Email: PAUL@TDR.COM }

{                                                 }
{ (C) Copyright 1994, Tansin A. Darcos & Company, }
{ Commercial Rights Reserved                      }
{ Country of Origin: United States of America     }
{                                                 }

TYPE

    HeaderType = RECORD
                Wadtype:        array[0..3] of char;  {"IWAD" or "PWAD"}
                NumEntries,                 {Number of Directory entries}
                dirpointer:     longint;    {Start of Directory}
             END;

    DirectoryEntryType = RECORD
                StartPointer,            {Pointer to start of Resource}
                EntryLength:    longint; {Length of Resource}
                ResourceName:   array[1..8] of char;
             END;

VAR
      Wad:  file;
      Header:headertype;
      DirectoryEntry:DirectoryEntryType;
      RSNAME:string[8];
      name:string[64];


PROCEDURE OpenWad;
VAR I,J,K:INTEGER;
    L:LONGINT;

BEGIN
   assign(wad,name);
   {$I-} Reset(wad,1); {$I+}
   if IOResult <> 0 then
     begin
       assign(wad,name+'.WAD');  {Assume the .WAD was forgotten }
       {$I-} Reset(wad,1); {$I+}
       if IOResult <> 0 then
         begin
            writeln('File ',name,' cannot be opened.');
            halt(2);
         end;
     end;
   blockread(Wad,Header,sizeof(Header));
   if (header.wadtype <> 'IWAD') and (header.wadtype<>'PWAD') then
     begin
       writeln('File ',name,' is not in wad format.');
       halt(2);
     end;
   seek(Wad,Header.DirPointer);
   J:=0; K:=0;
   For L := 1 to Header.NUMENTRIES do
         BEGIN
            blockread(Wad,DirectoryEntry,sizeof(DirectoryEntry));
            RsName := DirectoryEntry.ResourceName;
            For I := 8 downto 1 do
              if rsname[I] = #0 then
                  rsname[0] := chr(i-1);
            if (upcase(rsname[1])='E') and
               (upcase(rsname[3])='M') and
               (rsname[2] in ['1'..'3']) and
               (rsname[4] in ['1'..'9']) and
               (length(rsname)=4) then
             begin
                if j<1 then
                   begin
                   writeln('The following level(s) were found in this ',
                           header.wadtype,' wad:');
                   write('    ');
                   end;
                if K > 8 then
                  begin
                     writeln;
                     write('    ');
                     K := 0;
                  end;
                write(rsname,' ');
                inc(j);
                inc(k);
             end;

        END;
             if K<>0 then
               writeln;
        if J = 0 then
          writeln('This wad contains no level data.');
END;



begin
       if paramcount = 0 then
        begin
           write('Wad file Name?');
           readln(name);
        end
       else
        name := paramstr(1);
        if name='/?' then
          begin
             write('SW-Wad level finder  ');
             writeln('(C) Copyright Tansin A. Darcos & Company 1994');
             writeln('Commercial Rights Reserved.');
             writeln;
             writeln('This program reads a WAD file and lists out all of');
             writeln('the levels stored in that wad.');
             writeln;
             writeln('Usage:');
             writeln;
             writeln('SW [wadname[.WAD]]');
             writeln;
             writeln('If the name isn''t stated on the command line, SW');
             writeln('will ask for it.  The extension .WAD is assumed if');
             writeln('not stated.');
             halt(1);
          end;
        if name = '' then halt(1);
        OpenWad;
        close(Wad);
end.
