/*//////////////////////////////////////////////////////////
Winwad
Copyright (C) 2000 John Gaughan

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

The full GNU General Public License can be found archived with these
source files as "gpl.txt"
*///////////////////////////////////////////////////////////

// Windows headers
#include <afxwin.h>
#include <afxext.h>

// Standard headers
#include <vector>
#include <new>
using namespace std;

// Winwad headers
#include "resource.h"
#include "Global.h"
#include "CWad.h"
#include "CWinwad.h"
#include "CDirectoryWindow.h"
#include "Menus.h"



// Message map
BEGIN_MESSAGE_MAP (CDirectoryWindow, CFrameWnd)
ON_WM_GETMINMAXINFO ()
ON_WM_PAINT ()
ON_WM_SIZE ()
ON_COMMAND (IDM_FILE_NEW, OnFileNew)
ON_COMMAND (IDM_FILE_OPEN, OnFileOpen)
ON_COMMAND (IDM_FILE_SAVE, OnFileSave)
ON_COMMAND (IDM_FILE_SAVEAS, OnFileSaveAs)
ON_COMMAND (IDM_FILE_EXIT, OnFileExit)
ON_COMMAND (IDM_EDIT_CUT, OnEditCut)
ON_COMMAND (IDM_EDIT_COPY, OnEditCopy)
ON_COMMAND (IDM_EDIT_PASTE, OnEditPaste)
ON_COMMAND (IDM_EDIT_SELECTALL, OnEditSelectAll)
ON_COMMAND (IDM_EDIT_IMPORT, OnEditImport)
ON_COMMAND (IDM_EDIT_EXPORT, OnEditExport)
ON_COMMAND (IDM_EDIT_NEW, OnEditNew)
ON_COMMAND (IDM_EDIT_DELETE, OnEditDelete)
ON_COMMAND (IDM_EDIT_RENAME, OnEditRename)
ON_COMMAND (IDM_VIEW_RAW, OnViewRaw)
ON_COMMAND (IDM_VIEW_INTERPRET, OnViewInterpret)
ON_COMMAND (IDM_IWAD_USEIWAD, OnIwadUseIwad)
ON_COMMAND (IDM_IWAD_DONTUSEIWAD, OnIwadDontUseIwad)
ON_COMMAND (IDM_HELP_LICENSE, OnHelpLicense)
ON_COMMAND (IDM_HELP_ABOUT, OnHelpAbout)
END_MESSAGE_MAP ()



// Constructor
CDirectoryWindow::CDirectoryWindow ()
{
  // Local variables
  RECT     createRect;
  CMenu    menu;
  CRect    clientRect;

  // Create window
  Create (NULL, "Winwad");

  // Load menu
  menu.LoadMenu (IDM_DIR_FRAME);
  this->SetMenu (&menu);
  menu.Detach ();

  // Load accelerator table
  m_hAccelTable = ::LoadAccelerators (::AfxGetInstanceHandle (), MAKEINTRESOURCE (IDA_DIR_FRAME));

  // Set icon
  this->SetIcon (::LoadIcon (::AfxGetInstanceHandle (), MAKEINTRESOURCE (IDI_DIR_FRAME)), TRUE);

  // Get height and width of client area
  this->GetClientRect (&clientRect);

  // Initialize list box
  createRect.bottom = clientRect.bottom - 10;
  createRect.left   = 10;
  createRect.right  = 200;
  createRect.top    = 10;
  wndListBox.Create (LBS_STANDARD | WS_CHILD | WS_VISIBLE | LBS_MULTIPLESEL,
      createRect, this, IDC_LISTBOX);

  // Initialize edit box
  createRect.bottom = clientRect.bottom - 10;
  createRect.left   = 220;
  createRect.right  = clientRect.right - 10;
  createRect.top    = 10;
  wndContents.Create (ES_LEFT | ES_MULTILINE | ES_READONLY | WS_CHILD | WS_VISIBLE |
      WS_BORDER | WS_HSCROLL | WS_VSCROLL, createRect, this, IDC_CONTENTS);

  // Set up member variables
  this->m_bUseIWAD = false;
  this->m_bPreCache = false;
  this->m_bWadSaved = false;

  // Done constructing
  return;
}



// Window is being made
BOOL CDirectoryWindow::PreCreateWindow (CREATESTRUCT &cs)
{
  // Call superclass' function
  if (!CFrameWnd::PreCreateWindow (cs)) return FALSE;

  // All done!
  return TRUE;
}



// Close wad
void CDirectoryWindow::CloseWad ()
{
  // Delete contents of wad
  this->m_wWad.Clear ();

  // Done
  return;
}



// Menu: File/New
void CDirectoryWindow::OnFileNew ()
{
  // Close existing wad
  this->CloseWad ();

  // Create new wad
  this->m_wWad.SetWadType ("PWAD");
  this->m_bWadSaved = false;

  // Done
  return;
}



// Menu: File/Open
void CDirectoryWindow::OnFileOpen ()
{
  // Local variables
  char szFilename[1024];
  memset (szFilename, 0, 1024);

  // If file is not saved
  if (!this->m_bWadSaved)
  {

    // Prompt user for action
    switch (::AfxMessageBox ("Save wad before opening new one?", MB_YESNOCANCEL | MB_DEFBUTTON3 | MB_ICONQUESTION, NULL))
    {

    // Save wad
    case IDYES:

      // Call save menuitem
      this->OnFileSave ();
      break;

    // Don't save wad
    case IDNO:
      break;

    // Cancel action, return
    case IDCANCEL:
      return;
    }
  }

  // Create dialog
  CFileDialog dlg (TRUE, "wad", "*.wad", OFN_HIDEREADONLY | OFN_FILEMUSTEXIST,
      "Wad files (*.wad)|*.wad|All files (*.*)|*.*||");

  // Do dialog, if user cancels, return
  if (dlg.DoModal () != IDOK) return;

  // Get filename to open
  CString strFilename = dlg.GetFileName ();

  // Close existing wad then open new wad
  this->CloseWad ();
  this->m_wWad.SetFilename (strFilename.GetBuffer (0));
  this->m_wWad.LoadWad (m_bPreCache);

  // Done
  return;
}



// Menu: File/Save
void CDirectoryWindow::OnFileSave ()
{
  // Check filename
  char szFilename[1024];
  this->m_wWad.GetFilename (szFilename);

  // If filename is invalid, "Save As"
  if (szFilename[0]==0) this->OnFileSaveAs ();

  // Otherwise, tell wad to save itself
  if (!this->m_wWad.SaveWad ())
  {
    ::AfxMessageBox ("Error saving wad", MB_OK | MB_ICONEXCLAMATION, NULL);
  }

  // Done
  return;
}



// Menu: File/Save As
void CDirectoryWindow::OnFileSaveAs ()
{
  // Create dialog
  CFileDialog dlg (FALSE, "wad", "*.wad", OFN_HIDEREADONLY,
      "Wad files (*.wad)|*.wad|All files (*.*)|*.*||");

  // Do dialog, if user cancels, return
  if (dlg.DoModal () != IDOK) return;

  // Get filename and put it in wad
  CString strFilename = dlg.GetFileName ();
  this->m_wWad.SetFilename (strFilename.GetBuffer (0));

  // Now "Save" wad
  this->OnFileSave ();

  // Done
  return;
}



// Menu: File/Exit
void CDirectoryWindow::OnFileExit ()
{
  // Send a "WM_CLOSE" message to this window
  this->PostMessage (WM_CLOSE);

  // Done
  return;
}



// Cut an entry
void CDirectoryWindow::OnEditCut ()
{
  return;
}



// Copy an entry
void CDirectoryWindow::OnEditCopy ()
{
  return;
}



// Paste an entry
void CDirectoryWindow::OnEditPaste ()
{
  return;
}



// Select all entries
void CDirectoryWindow::OnEditSelectAll ()
{
  return;
}



// Import raw data from disk
void CDirectoryWindow::OnEditImport ()
{
  return;
}



// Export raw data to disk
void CDirectoryWindow::OnEditExport ()
{
  return;
}



// Create a new entry
void CDirectoryWindow::OnEditNew ()
{
  return;
}



// Delete an entry
void CDirectoryWindow::OnEditDelete ()
{
  return;
}



// Rename an entry
void CDirectoryWindow::OnEditRename ()
{
  return;
}



// Menu: View/RawData
void CDirectoryWindow::OnViewRaw ()
{
  return;
}



// Menu: View/InterpretData
void CDirectoryWindow::OnViewInterpret ()
{
  return;
}



// Menu: IWAD/UseIwad
void CDirectoryWindow::OnIwadUseIwad ()
{
  return;
}



// Menu: IWAD/DontUseIwad
void CDirectoryWindow::OnIwadDontUseIwad ()
{
  // Get menu
  CMenu *menu = this->GetMenu ();

  // Reverse selection
  this->m_bUseIWAD = !this->m_bUseIWAD;
  int nNewValue = (this->m_bUseIWAD ? MF_CHECKED : MF_UNCHECKED);

  menu->CheckMenuItem (IDM_IWAD_DONTUSEIWAD, nNewValue);

  // Done
  return;
}



// Menu: Help/License
void CDirectoryWindow::OnHelpLicense ()
{
  DisplayLicenseDialog ();
  return;
}



// Menu: Help/About
void CDirectoryWindow::OnHelpAbout ()
{
  DisplayAboutDialog ();
  return;
}



// Get Min/Max Info
void CDirectoryWindow::OnGetMinMaxInfo (MINMAXINFO FAR* lpMMI)
{
  // Set minimum window tracking sizes
  lpMMI->ptMinTrackSize.x = 400;
  lpMMI->ptMinTrackSize.y = 300;

  // Done
  return;
}



// OnPaint
void CDirectoryWindow::OnPaint ()
{
  // Get DC
  CPaintDC dc (this);
}



// Resize window
void CDirectoryWindow::OnSize (UINT nType, int cx, int cy)
{ 
  CFrameWnd::OnSize (nType, cx, cy);
  // If window is being minimized, cancel
  if (nType == SIZE_MINIMIZED) return;

  // If controls don't exist, cancel
  if (!wndListBox.m_hWnd || !wndContents.m_hWnd) return;

  // Local variables
  CRect resizeRect;

  // Resize list box
  resizeRect.bottom = cy - 10;
  resizeRect.left   = 10;
  resizeRect.right  = 200;
  resizeRect.top    = 10;
  wndListBox.MoveWindow (&resizeRect);

  // Resize edit box
  resizeRect.left   = 220;
  resizeRect.right  = cx - 10;
  wndContents.MoveWindow (&resizeRect);

  // Done
  return;
}
