;-------------------------------------------------------------------------------
;				   CPU-speed
;		By Solomon of Gash for Caustic Verses issue #1 - 1996
;
;I used Intels CPU-id source code to determine cpu type
;-------------------------------------------------------------------------------
;Feel free to use and change this source code, but don't spread it!  It must
;stay along with Caustic Verses issue #1 unless you have a written agreement
;with me!
;					/Solomon

	.186
	jumps

o	equ	offset				;I just love theese!
b	equ	byte ptr
w	equ	word ptr
d	equ	dword ptr

move	macro	reg,seg				;Very useful macro!
	mov	ax,seg
	mov	reg,ax
	assume reg:seg
endm

OPND32 MACRO op_code, op_erand
	db      66h     ; Force 32-bit operand size
  IFNB <op_code>
	db      op_code
    IFNB <op_erand>
	dd      op_erand; 32-bit immediate value
    ENDIF
  ENDIF
ENDM

CPUID MACRO
	db      0fh     ; Hardcoded opcode for CPUID instruction
	db      0a2h
ENDM

TRUE            equ     1
FAMILY_MASK     equ     0f00h
FAMILY_SHIFT    equ     8
MODEL_MASK      equ     0f0h
MODEL_SHIFT     equ     4
STEPPING_MASK   equ     0fh
FPU_FLAG        equ     1h
MCE_FLAG        equ     80h
CMPXCHG8B_FLAG  equ     100h


_stack segment para stack 'STACK' use16
_s dw 1024 dup(0)
_stack ends
DATA segment para public 'data' use16
oldtimer	dd	0			;saved timer-vector
speed	dd	0				;speed index
mhz	dw	0				;speed in mhz, use this!


fp_status       dw      ?
vendor_id       db      12 dup (?)
cpu_type        db      ?
modell           db      ?
stepping        db      ?
id_flag         db      0
fpu_type        db      0
intel_proc      db      0
feature_flags   dw      2 dup (0)
intel_id	db	"GenuineIntel"

no386	db	"386 processor not detected, buy a computer...",10,13,36

_386	db	"386 processor detected, speed: 000 MHz",8,8,8,8,8,8,8,36
_486	db	"486 processor detected, speed: 000 MHz",8,8,8,8,8,8,8,36
_586	db	"Pentium processor detected, speed: 000 MHz",8,8,8,8,8,8,8,36
_endl	db	10,13,36
;The 8s are backspaces...

msgtable	dw	0,0,0,o _386,o _486,o _586
speedtable	dw	0,0,0
		dw	3571			;((20*14/1e6)^-1) for 386
		dw	5000			;((20*10/1e6)^-1) for 486
		dw	5555			;((20*9/1e6)^-1) for Pentium
						;The Pentium timing is probably
						;not reliable, coz I don't have
						;any clock-table for it.
;If you don't like or trust theese values, change them!

DATA ends

CODE segment para public 'code' use16
start proc far
	assume cs:code
	mov     ax,data
	mov     ds,ax
	assume ds:data

	call	get_cpuid
	cmp	cpu_type,3
	jl	slut2				;quit if no 386
.386
	movzx	bx,cpu_type
	add	bx,bx
	add	bx,o msgtable
	mov	dx,ds:[bx]
	mov	ah,9
	int	21h				;print appropiate message

waitkey:
	call	get_speed
	call	print_speed

	in	al,60h
	cmp	al,1
	je	slut
	jmp	waitkey

slut:   
	mov	dx,o _endl
	mov	ah,9
	int	21h

	mov	ax,4c00h				;exit to dos
	int	21h

slut2:
	mov	dx,o no386
	mov	ah,9
	int	21h

	mov	ax,4c00h				;exit to dos
	int	21h


install_timer proc near
	move	ds,data
	cli
	move	es,0

	mov	eax,es:[20h]				;save old timer-vector
	mov	oldtimer,eax

	mov	ax,cs
	shl	eax,16
	mov	ax,o timer
	mov	es:[20h],eax				;install new

	mov	al,36h
	out	43h,al

;	mov	dx,12
;	mov	ax,34dch
;	mov	bx,hz
;	div	bx
;	mov	bx,ax
	mov	bx,59659				;20Hz
	mov	al,bl
	out	40h,al
	mov	al,bh
	out	40h,al

	sti

	ret
endp

remove_timer proc near
	move	ds,data
	cli
	move	es,0

	mov	eax,oldtimer				;restore timer-vector
	mov	es:[20h],eax

	mov	al,36h
	out	43h,al
	mov	al,0
	out	40h,al
	mov	al,0
	out	40h,al

	sti

	ret
endp

timer:
	mov	cx,1					;mark tick

	mov	al,20h
	out	20h,al

	iret

get_cpuid proc
;
;       This procedure determines the type of CPU in a system
;       and sets the cpu_type variable with the appropriate
;       value.
;       All registers are used by this procedure, none are preserved.

;       Intel 8086 CPU check
;       Bits 12-15 of the FLAGS register are always set on the
;       8086 processor.
;
check_8086:
	pushf                   ; push original FLAGS
	pop     ax              ; get original FLAGS
	mov     cx, ax          ; save original FLAGS
	and     ax, 0fffh       ; clear bits 12-15 in FLAGS
	push    ax              ; save new FLAGS value on stack
	popf                    ; replace current FLAGS value
	pushf                   ; get new FLAGS
	pop     ax              ; store new FLAGS in AX
	and     ax, 0f000h      ; if bits 12-15 are set, then CPU
	cmp     ax, 0f000h      ;   is an 8086/8088
	mov     cpu_type, 0     ; turn on 8086/8088 flag
	jne     check_80286     ; jump if CPU is not 8086/8088
	jmp     end_get_cpuid
;       Intel 286 CPU check
;       Bits 12-15 of the FLAGS register are always clear on the
;       Intel 286 processor in real-address mode.
;
check_80286:
	or      cx, 0f000h      ; try to set bits 12-15
	push    cx              ; save new FLAGS value on stack
	popf                    ; replace current FLAGS value
	pushf                   ; get new FLAGS
	pop     ax              ; store new FLAGS in AX
	and     ax, 0f000h      ; if bits 12-15 clear, CPU=80286
	mov     cpu_type, 2     ; turn on 80286 flag
	jnz     check_80386     ; if no bits set, CPU is 80286
	jmp     end_get_cpuid
;       Intel386 CPU check
;       The AC bit, bit #18, is a new bit introduced in the EFLAGS
;       register on the Intel486 DX CPU to generate alignment faults.
;       This bit cannot be set on the Intel386 CPU.
;
check_80386:
;       It is now safe to use 32-bit opcode/operands
	mov     bx, sp          ; save current stack pointer to align
	and     sp, not 3       ; align stack to avoid AC fault
	OPND32
	pushf                   ; push original EFLAGS
	OPND32
	pop     ax              ; get original EFLAGS
	OPND32
	mov     cx, ax          ; save original EFLAGS
	OPND32  35h, 40000h     ; flip AC bit in EFLAGS
	OPND32
	push    ax              ; save new EFLAGS value on stack
	OPND32
	popf                    ; replace current EFLAGS value
	OPND32
	pushf                   ; get new EFLAGS
	OPND32
	pop     ax              ; store new EFLAGS in EAX
	OPND32
	xor     ax, cx          ; can't toggle AC bit, CPU=80386
	mov     cpu_type, 3     ; turn on 80386 CPU flag
	mov     sp, bx          ; restore original stack pointer
	jz      end_get_cpuid   ; jump if 80386 CPU
	and     sp, not 3       ; align stack to avoid AC fault
	OPND32
	push    cx
	OPND32
	popf                    ; restore AC bit in EFLAGS first
	mov     sp, bx          ; restore original stack pointer

;       Intel486 DX CPU, Intel487 SX NDP, and Intel486 SX CPU check
;       Checking for ability to set/clear ID flag (Bit 21) in EFLAGS
;       which indicates the presence of a processor
;       with the ability to use the CPUID instruction.
;
check_80486:
	mov     cpu_type, 4     ; turn on 80486 CPU flag
	OPND32
	mov     ax, cx          ; get original EFLAGS
	OPND32  35h, 200000h    ; flip ID bit in EFLAGS
	OPND32
	push    ax              ; save new EFLAGS value on stack
	OPND32
	popf                    ; replace current EFLAGS value
	OPND32
	pushf                   ; get new EFLAGS
	OPND32
	pop     ax              ; store new EFLAGS in EAX
	OPND32
	xor     ax, cx          ; can't toggle ID bit,
	je      end_get_cpuid   ;   CPU=80486

;       Execute CPUID instruction to determine vendor, family,
;       model and stepping.
;
check_vendor:
	mov     id_flag, 1              ; set flag indicating use of CPUID inst.
	OPND32
	xor     ax, ax                  ; set up input for CPUID instruction
	CPUID                           ; macro for CPUID instruction
	OPND32
	mov     word ptr vendor_id, bx  ; setup to test for vendor id
	OPND32
	mov     word ptr vendor_id[+4], dx
	OPND32
	mov     word ptr vendor_id[+8], cx
	mov     si, offset vendor_id
	mov     di, offset intel_id
	mov     cx, length intel_id
compare:
	repe    cmpsb                   ; compare vendor id to "GenuineIntel"
	or      cx, cx
	jnz     end_get_cpuid           ; if not zero, not an Intel CPU,

intel_processor:
	mov     intel_proc, 1

cpuid_data:
	OPND32
	cmp     ax, 1                   ; make sure 1 is a valid input
					; value for CPUID
	jl      end_get_cpuid           ; if not, jump to end
	OPND32
	xor     ax, ax                  ; otherwise, use as input to CPUID
	OPND32
	inc     ax                      ; and get stepping, model and family
	CPUID
	mov     stepping, al
	and     stepping, STEPPING_MASK ; isolate stepping info

	and     al, MODEL_MASK          ; isolate model info
	shr     al, MODEL_SHIFT
	mov     modell, al

	and     ax, FAMILY_MASK         ; mask everything but family
	shr     ax, FAMILY_SHIFT
	mov     cpu_type, al            ; set cpu_type with family

	OPND32
	mov     feature_flags, dx       ; save feature flag data

end_get_cpuid:
	ret
get_cpuid endp

get_speed proc near
	move	ds,data

	mov	al,11111110b			;mask off all ints
	out	21h,al				;except timer
	mov	al,11111111b
	out	0a1h,al

	call	install_timer

	mov	ebx,0
	mov	cx,0
wer:
	jcxz	qwe				;wait a tick

	mov	cx,0
qwe:						;386	486	Pentium
	inc	ebx				;2+1	1+1	?
	jcxz	qwe				;9+2	8	?

	mov	speed,ebx

	call	remove_timer

	mov	al,0				;enable ints
	out	21h,al
	mov	al,0
	out	0a1h,al

	ret
endp

;Converts the speed index into MHz and prints it out
print_speed proc near
	mov	eax,speed
	movzx	bx,cpu_type
	add	bx,bx
	add	bx,o speedtable
	movzx	ebx,w ds:[bx]
	mov	edx,0
	idiv	ebx
	mov	mhz,ax				;use this value!

	cmp	ax,100				;print the first 100 if any
	jl	print0
	push	ax
	mov	dl,'1'
	mov	ah,2
	int	21h
	pop	ax
	sub	ax,100
	jmp	print1
print0:
	push	ax
	mov	dl,'0'
	mov	ah,2
	int	21h
	pop	ax
print1:
	aam						;print the rest
	add	ax,3030h
	xchg	ah,al
	mov	dx,ax
	mov	ah,2
	int	21h
	mov	dl,dh
	int	21h
	mov	dl,8
	int	21h					;three backspaces
	int	21h
	int	21h

	ret
endp

start endp
ends code

end start

