;
;                          Librairie Vesa 2.0                               
;                    - By EgoN & Arrakis - K!Prod -                         
;           Still in Development     Contact Authors before use ...         
;
;
; Version 0.08 : Now, you can do everything in a buffer and then copy
;                 to screen via an optimized Vesa 2.0 procedure
;                 or slowly with a Vesa 1.2 Compatible procedure ...
; Version 0.07 : Now The LFB work with PModeW !!!!!!!!!!!!!!!!
;
; Grand merci a EgoN sans qui je ne serais jamais passer au watcom ni
; au LFB du vesa 2.0 ...      EgoN Merci!                      Arrakis/K!P

.386P

.model flat

; EgoN Procedures
        public Mode3_,readVESA_,setVESA_,readINFO_
        public VCls_,VClrbuf_,VSwpscr_,lisgif_

; Arrakis Procedures
        public Selector_,Restore_
        public PutStr_, SetClip_,AddPTR_ 
        public BufPutStr_,SetColor_
        public WaitVbl_                                     
        public Rnd_,ptrLFB_,MemCopy_,SetBuf_,CopyBuf2Buf_
        public IsWin_
        public ConfigR2B_,Restore2Buf_
        public SwpFBuf_,CopyBuf2BufUnder_,VClrbufUnder_
        public BufferCopyVesa12_        ; a la demande de Dake/CalodoX
        public VlineBuf_

;        public PutPix_, GetPix_, Hline_, Vline_, GetSprite_, PutSprite_
;        public PutChar_, lispcx_, VSwpscr2_

clr=256  
eof=257  
w equ word ptr
b equ byte ptr
lfbmemlimit equ ((4096 * 1024) - 1)
.data

;structure pour l'appel d'interruption ou fonctions en mode reel
redi    dd ?
resi    dd ?
rebp    dd ?
reserv  dd ?
rebx    dd ?
redx    dd ?
recx    dd ?
reax    dd ?
flags   dw ?
res     dw ?
rds     dw ?
rfs     dw ?
rgs     dw ?
rip     dw ?
rcs     dw ?
rsp     dw ?
rss     dw ?

;selecteur de reserve oka ou
sel       dw ?

lfbsel    dw ?
physaddr  dd ?
linaddr   dd ?

ligsuiv   dd ?
VBuf      dd ?

VBufNorm  dd ?
VBufClip  dd ?

BufOffset dd ?                          ; Offset Pos => Y*640+X
BufL      dw ?                          ; Largeur a restaurer
BufH      dw ?                          ; Hauteur a restaurer
BufROffs  dd ?
BufRLen   dd ?

SauveEDI  dd ?                          ; pour sauver ces 2 registres sans
SauveESI  dd ?                          ; faire de push (chiant des fois)

;
; Variable pour le chargeur GIF (By *EgoN*)
;

  abStack       db 1281 dup (0)
  ab_prfx       dw 4096 dup (0)    
  ab_suffx      dw 4096 dup (0)   
  free          dw 0                
  nbbit         dw 0                 
  max           dw 0       
  stackp        dw 0                
  restbits      dw 0                
  restbyte      dw 0                
  casspecial    dw 0               
  act_code      dw 0                
  old_code      dw 0                
  readbyt       dw 0                
  lbyte         dw 0               


;
; Ben, c'est la font !!!! (FANZ.F16) by Strike-Seth-Ch'ais_pas_quoi_wolf
;

include font6.asm

.code
Rnd_ proc
       mov ebx,edi
        mov edi,46Ch
        mov eax,cs:[edi]
       mov edi,ebx
        ret
Rnd_ endp

;
; FONCTIONS DE MODE GRAPHIQUE
;

Mode3_ proc
        mov ax,3
        int 10h
        ret
Mode3_ endp

;
; FONCTIONS DE COPIE ET VIDAGE MEM SVGA
;

VSwpscr_  proc                  ; copie un buffer en video
       mov DX,ES                ; sauve ES dans DX
       mov EBX,ESI              ; sauve ESI dans EBX
        mov esi,eax             ; esi=eax=buffer
       mov EAX,EDI              ; sauve EDI dans EAX
        xor edi,edi
        mov es,lfbsel           ; es=Linear Frame Buffer Selecteur
        mov ecx,76800d          ; ecx=longueur d'1 ecran 640*480/4
        rep movsd               ; Copie en double word
       mov ES,DX
       mov ESI,EBX
       mov EDI,EAX
        ret
VSwpscr_ endp

VCls_ proc
       mov bx,es                ; bx=es sauvegarde (plus rapide que push es)
        mov es,[lfbsel]         ; es=Linear Frame Buffer Selecteur
        xor edi,edi
        mov ecx,76800d          ; ecx=longueur d'1 ecran 640*480/4
        xor eax,eax             ; eax=0000h
        rep stosd               ; Vide l'ecran avec le stylo 0
       mov es,bx                ; restaure es (plus rapide que pop es)
        ret
VCls_ endp

VClrbuf_ proc
       mov ebx,edi
        mov edi,eax             ; edi=eax=buffer
        xor eax,eax             ; eax=0000h
        mov ecx,76800d          ; ecx=longueur d'1 ecran 640*480/4
        rep stosd               ; efface l'ecran
       mov edi,ebx
        ret
VClrbuf_ endp

CopyBuf2Buf_ proc
       mov ebx,esi 
        mov esi,eax             ; esi=eax=buffer Source
       mov eax,edi 
        mov edi,edx             ; edi=edx=buffer Destination
        mov ecx,76800d          ; ecx=longueur d'1 ecran 640*480/4
        rep movsd               ; Copie en double word
       mov edi,eax
       mov esi,ebx
        ret
CopyBuf2Buf_ endp

;
; FONCTIONS VESA (INFO ET MODE)
;

readVESA_ PROC
       push esi 
       push edi
        push eax        ; sauvegarde l'adresse de la structure VESAINFO
        xor eax,eax
        mov ax,0100h
        mov bx,16d
        int 31h

        mov [sel],dx      ; sauvegarde le selecteur alloue
        mov [res],ax      ; sauvegarde le segment en mem reel alloue
        mov edi,offset redi
        mov ax,0300h
        mov bx,10h
        xor cx,cx
        mov [redi],0
        mov [reax],4f00h
        int 31h

        mov ax,[res]
        shl eax,4     ; transforme le segment en adresse 32 bitssss
        mov esi,eax
        pop edi
        mov ecx,64d
        rep movsd

        mov ax,0101h  ; libere le selecteur alloue
        mov dx,[sel]
        int 31h
       pop edi
       pop esi  
        ret
readVESA_ endp

readINFO_ proc
       push edi
       push esi
        push eax        ; sauvegarde l'adresse de la structure MODEInfo
        push edx        ; et le numero de fonction a infotiser
        xor eax,eax
        mov ax,0100h
        mov bx,16d
        int 31h

        mov [sel],dx      ; sauvegarde le selecteur alloue
        mov [res],ax      ; sauvegarde le segment en mem reel alloue
        mov edi,offset redi
        pop [recx]
        mov ax,0300h
        mov bx,10h
        xor cx,cx
        mov [redi],0
        mov [reax],4f01h
        int 31h


        mov ax,res
        shl eax,4     ; transforme le segment en adresse 32 bitssss
        mov esi,eax
        pop edi
        mov ecx,64d
        rep movsd

        mov ax,0101h  ; libere le selecteur alloue
        mov dx,[sel]
        int 31h
       pop esi
       pop edi
        ret
readINFO_ endp

setVESA_ proc
        mov bx,ax
        mov ax,4f02h
        int 10h
        ret
setVESA_ endp

;
; FONCTIONS DPMI
;

ptrLFB_ proc
       push esi   
       push edi

        mov [physaddr],eax              ; Sauvegarde l'adresse physique
        xor eax,eax                     ; fonction 0000h
        mov cx,1                        ; 1 selecteur
        int 31h                         ; alloue cx LDT descripteur(s)
        mov [lfbsel],ax                 ; sauvegarde le "Base Selector"

        mov bx,ax                       ; et le colle dans bx
        mov ax,9                        ; fonction 0009h
        mov cx,8092h                    ; CL= access right/type byte
        int 31h                         ; CH= 80386 extended rights/type byte

        mov ebx,[physaddr]              ; l'adresse physique doit etre
        mov cx,bx                       ; contenu dans BX:CX
        shr ebx,16      
        mov ax,0800h                    ; fonction 0800h
        mov esi,lfbmemlimit             ; la taille (en byte) doit etre
        mov di,si                       ; contenu dans SI:DI
        shr esi,16
        int 31h                         ; Map l'adresse physique
        mov ax,bx                       ; retour de l'adresse lineaire
        shl eax,16                      ; dans BX:CX
        mov ax,cx
        mov [linaddr],eax               ; que l'on sauvegarde
        mov dx,cx                       ; CX:DX = Linear base address
        mov cx,bx
        mov bx,[lfbsel]                 ; BX=Selecteur
        mov ax,7                        ; fonction 0007h
        int 31h                         ; Set Segment Base Address

        mov bx,[lfbsel]                 ; BX=Selecteur
        mov ecx,lfbmemlimit             ; la longueur doit etre contenu
        mov dx,cx                       ; dans CX:DX
        shr ecx,16
        mov ax,8                        ; fonction 0008h
        int 31h                         ; Set Segment Limit

        xor eax,eax
        mov ax,[lfbsel]                 ; renvoies le selecteur LFB
       pop edi
       pop esi           
        ret
ptrLFB_ endp

;
;  Chargeur GIF ( Pc Interdit, Watcom Convertion By *EgoN* )
;

lisgif_ proc
;        push esi     
;        push edi     
  pusha
  mov esi,eax
  mov edi,edx
  xor ebx,ebx
  xor edx,edx
  xor ecx,ecx
  xor eax,eax

  mov w [lbyte],0                 ;dernier code lu 0
  mov w [free],258                ;premire entre libre 258
  mov w [nbbit],9                 ;nb de bits d'un code = 9 
  mov w [max],511                 ;donc maximum d'entres = 511
  mov w [stackp],0                ;pointeur sur dbut
  mov w [restbits],0              ;pas de bits restants
  mov al,[esi]
  mov [restbyte],ax             ;rien  chercher
  inc esi

@mainloop:                      ;boucle pour chaque code
  call GetLogByte               ;lit un code
  cmp ax,eof                    ;signature fin de fichier ?
  jne @no_abandon
  jmp @abandon                  ;oui, abandonne
@no_abandon:
  cmp ax,clr                    ;code clr  ?
  jne @no_clear
  jmp @clear                    ;oui efface l'alphabet
@no_clear:
  mov w readbyt,ax              ;sauve le code actuel
  cmp ax,w free                 ;est-il dj dans l'alphabet ? (<free)
  jb @code_in_ab                ;oui, passe au traitement 
  mov ax,w old_code             ;non, donc cas spcial, transmettre 
  mov w act_code,ax             ;au traitement la dernire chane
  xor ebx,ebx
  mov bx,w stackp
  mov cx,w casspecial    ;et accrocher le premier caractre (toujours concret)
  mov w abStack[ebx],cx          ;gre la pile
  inc w stackp                  ;en consquence
@code_in_ab:                    ;code disponible dans l'alphabet :
  cmp ax,clr                    ;< code clr ?
  jb @concret                   ;oui, caractre concret
@fillstack_loop:                ;sinon passe au dcodage
  xor ebx,ebx
  mov bx,w act_code             ;le code est un pointeur dans l'alphabet
  shl ebx,1                      ;Word Array (!)
  push ebx
  mov ax,w ab_suffx[ebx]         ;cherche le suffixe, qui est concret
  xor ebx,ebx
  mov bx,w stackp               ;le place sur la pile
  shl ebx,1                      ;considre comme Word Array
  mov w abStack[ebx],ax
  inc w stackp
  pop ebx
  mov ax,w ab_prfx[ebx]          ;cherche le prfixe
  mov w act_code,ax             ;le prend comme code courant
  cmp ax,clr;> code clr 
  ja @fillstack_loop            ;poursuit le dcodage
@concret:                       ;plus que des caractres concrets sur la pile
  xor ebx,ebx
  mov bx,w stackp               ;empile le dernier code
  shl bx,1                      ;comme Word Array
  mov w abStack[ebx],ax
  mov w casspecial,ax           ;en prend note aussi pour le cas spcial 
  inc w stackp                  ;fait progresser le pointeur
  mov bx,w stackp               ;prpare la lecture de la pile
  dec bx                        ;dcrmente le pointeur
  shl bx,1                      ;sur Word Array 
@readstack_loop:                ;traite la pile
  mov ax,w abStack[ebx]          ;prend un caractre
  stosb                         ;et l'crit dans la mmoire de  destination

  dec bx                        ;pointeur de pile sur l'lment suivant
  dec bx
  jns @readstack_loop           ;fini ? non on poursuit
  mov w stackp,0                ;rinitialise le pointeur de pile
  xor ebx,ebx
  mov bx,w free              ;met  jour l'alphabet
  shl bx,1                      ; la position "free" 
  mov ax,w old_code             ;crit le dernier code dans prfixe
  mov w ab_prfx[ebx],ax
  mov ax,w act_code             ;et le code courant dans suffixe
  mov w ab_suffx[ebx],ax
  mov ax,w readbyt              ;le code  lu est le plus rcent
  mov w old_code,ax
  inc w free           ;met  jour la dernire position libre dans l'alphabet 
  mov ax,w free
  cmp ax,w max                  ;dj satur ??
  ja @no_mainloop
  jmp @mainloop                 ;non, on continue
@no_mainloop:
  cmp b nbbit,12                ;nombre de bits dj gal  12 ?
  jb @no_mainloop2
  jmp @mainloop                 ;oui, alors on recommence simplement
@no_mainloop2:
  inc w nbbit                   ;sinon on l'augmente
  mov cl,b nbbit                ;nouveau maximum d'entres
  mov ax,1                      ;1 dcal de nbbit vers la gauche
  shl ax,cl
  dec ax                        ;puis dcrment
  mov w max,ax                  ;enregistre le maximum 
  jmp @mainloop                 ;revient  la boucle principale
@clear:                         ;rinitialise l'alphabet:
  mov w nbbit,9                 ;nbbit reprend la valeur de dpart
  mov w max,511                 ;le maximum d'entres est 511
  mov w free,258                ;premire place libre = 258
  call GetLogByte               ;lit le code suivant
  mov w casspecial,ax           ;le note pour le cas spcial
  mov w old_code,ax             ;et comme ancien code
  stosb                         ;passe directement en mmoire car concret

@noovl2:
  jmp @mainloop                 ;retour  la boucle principale

@abandon:                       ;abandon par code Eof
  popa
;        pop edi    
;        pop esi    
  ret
lisgif_ endp

GetLogByte proc 
  push edi
  xor edi,edi
  xor eax,eax
  xor ebx,ebx
  xor ecx,ecx
  xor edx,edx
  
  mov ax,w nbbit                ;lit la taille en bits du code
  mov di,ax                     ;et la sauvegarde 
  mov dx,w restbits             ;dcale lbyte de 8-restbits vers la droite
  mov cx,8
  sub cx,dx                     ;calcule la diffrence
  mov ax,w lbyte
  shr ax,cl                     ;et lance le dcalage 
  mov w act_code,ax             ;sauve le code 
  sub di,dx                     ;restbits dj lus -> soustraire
@nextbyte:
  mov al,[esi]
  inc esi

  xor ah,ah
  mov w lbyte,ax                ;le met en lByte pour le prochain code
  dec w restbyte                ;octet trait
  jnz @suite
  push ax
  mov al,[esi]
  mov restbyte,ax
  inc esi
  pop ax

@suite:
  mov bx,1                      ;masque les bits restants dans l'octet
  mov cx,di                     ;fixe le nombre de bits
  shl bx,cl                     ;dcale 1 du nombre de bits
  dec bx                        ;et dcrmente
  and ax,bx                     ;masque le code 

  mov cx,dx                     ;effectue le dcalage recherch
  shl ax,cl                     ;de restbits vers la gauche 
  add w act_code,ax             ;ajoute le rsultat

  sbb dx,w nbbit                ;diminue le nombre restbits 
  add dx,8                      ;de ce qui dpasse 8 bits
  jns @positif
  add dx,8
@positif:
  sub di,8                      ;jusqu' 8 bits cherchs -> soustraire
  jle @fini                     ;<= 0 -> tout est fini
  add dx,w nbbit         ;sinon augmente restbits du nombre de bits manquants
  sub dx,8
  jmp @nextbyte                 ;et on continue

@fini:
  mov w restbits,dx   ;sauve le nombre de bits restants pour le prochain appel
  mov ax,w act_code   ;et charge ax
  pop edi
  ret
GetLogByte Endp



;
;  Chargeur PCX 
;

;lispcx_ proc
;    push edi
;    push esi
;    mov  esi,eax                 ; source (1er parametre)
;    mov  edi,edx                 ; destination (2eme parametre)
;    mov  edx,ebx                 ; on recupere la longueur (3eme parametre)
;    xor  ecx,ecx
;@Loop1 :
;    lodsb                        ; on charge un byte
;    mov  bl,al    
;    and  bl,0C0h                  ; est-ce un code de compactage
;    cmp  bl,0C0h
;    jne  @Single                 ; non! ben alors on pose UN pixel
;
;    mov  cl,al                   ; oui, alors on repete le pixel 
;    and  cl,03Fh
;    lodsb
;    mov ebx,ecx  
;    rep  stosb                   ; optimisable (rep movsw au moins!)
;    sub edx,ebx                  ; dec(longueur,nb pix)
;    jnz  @Loop1
;    pop esi
;    pop edi
;    ret
;
;@Single :
;    stosb
;    dec edx                      ; dec(longueur)
;    jnz  @Loop1
;    pop esi
;    pop edi
;    ret
;lispcx_ endp


;
; FONCTION PutChar(x,y, char, col);
;
; ax contient Coord X
; dx contient Coord Y
; bl contient le character
; cl contient la couleur
;                          Attention Incompatible Vesa 1.2 (a virer!)
;PutChar_ proc
;       push esi
;       push edi
;       push es
;
;        mov es,lfbsel           ; es=Linear Frame Buffer Selecteur
;
;        shl edx,7               ; edx=edx*128=Y*128
;        mov edi,edx             ; sauve dans edi
;        shl edx,2               ; edx=edx*4=Y*512
;        add edi,edx             ; edi=edi+edx=Y*(128+512)=Y*640
;        add edi,eax             ; edi=edi+eax=X+Y*640
;
; EDI contient l'adresse du coin haut-gauche du caractere
;
;        Mov esi, offset Fnt     ; DS:ESI pointe sur la fonte ???!!!
;
;        xor eax,eax
;        Mov al,bl               ; al contient le character
;        shl eax,4               ; ax=character*16 (hauteur=16)
;        add esi,eax             ; DS:ESI pointe sur LE character
;
;        mov ah,cl               ; ah contient la couleur
;        mov cl,16               ; hauteur
;@YY:
;        mov al,[esi]            ; Lit la premiere ligne du Char
;        or al,al
;        jnz @NoVide             ; vide ? ou pas vide ?
;
;        add edi,640             ; Si rien alors passe a la ligne suivante
;        inc esi                 ; DS:ESI pointe sur valeur du char suivante
;        dec cl                  ; une ligne de moins ...
;        jnz @YY                 ; derniere ligne ???
;       pop es                  ; ben voila, c'est fini ...
;       pop edi
;       pop esi  
;        ret
;
;@NoVide:                        ; pas vide ! alors on va afficher tout ca ...
;        mov ch,8                ; largeur
;@XX:
;        shl al,1                ; test pixel par pixel si present
;        jnc @nopixel            ; sinon n'affiche pas
;        mov es:[edi],ah         ; si oui affiche
;@nopixel:
;        inc edi                 ; dans tous les cas, passe au pix suivant
;        dec ch                  ; une colonne de la ligne en cours de moins
;        jnz @XX
;
;        add edi,640-8           ; passe a la ligne suivante
;        inc esi                 ; DS:ESI pointe sur valeur du char suivante
;        dec cl                  ; un ligne de moins ...
;        jnz @YY                 ; derniere ligne ???
;
;@CEstFini:
;       pop es                  ; ben voila, c'est fini ...
;       pop edi
;       pop esi           
;        ret
;PutChar_ endp

;
; FONCTION PutStr(x,y, col, String);
;
; ax contient Coord X
; dx contient Coord Y
; bl contient la couleur
; ecx contient l'adresse du texte
;                          Attention Incompatible Vesa 1.2 (a virer!)
PutStr_ proc
       push esi
       push edi
       push es
        mov es,lfbsel           ; es=Linear Frame Buffer Selecteur

        shl edx,7               ; edx=edx*128=Y*128
        mov edi,edx             ; sauve dans edi
        shl edx,2               ; edx=edx*4=Y*512
        add edi,edx             ; edi=edi+edx=Y*(128+512)=Y*640
        add edi,eax             ; edi=edi+eax=X+Y*640

; EDI contient l'adresse du coin haut-gauche du caractere

        mov dl,bl               ; dl contient la couleur
        mov ebx,ecx             ; ebx pointe sur la chaine de caracteres
@CarSuivPS:
        Mov esi, offset Fnt     ; DS:ESI pointe sur la fonte ???!!!
        xor eax,eax
        Mov al,[EBX]            ; al contient le character
        or al,al                ; c'est fini?
        jz @FiniPS              ; yep! on se barre ...
        shl eax,4               ; ax=character*16 (hauteur=16)
        add esi,eax             ; DS:ESI pointe sur LE character

        mov cl,16               ; hauteur
@YYPS:
        mov al,[esi]            ; Lit la premiere ligne du Char
        or al,al
        jnz @NoVidePS           ; vide ? ou pas vide ?

        add edi,640             ; Si rien alors passe a la ligne suivante
        inc esi                 ; DS:ESI pointe sur valeur du char suivante
        dec cl                  ; une ligne de moins ...
        jnz @YYPS               ; derniere ligne ???
        inc ebx                 ; caractere suivant ...
        sub edi,640*16-8        ; 16 lignes au dessus 8 pix a droite ...
        jmp @CarSuivPS

@NoVidePS:                      ; pas vide ! alors on va afficher tout ca ...
        mov ch,8                ; largeur
@XXPS:
        shl al,1                ; test pixel par pixel si present
        jnc @nopixelPS          ; sinon n'affiche pas
        mov es:[edi],dl         ; si oui affiche
@nopixelPS:
        inc edi                 ; dans tous les cas, passe au pix suivant
        dec ch                  ; une colonne de la ligne en cours de moins
        jnz @XXPS

        add edi,640-8           ; passe a la ligne suivante
        inc esi                 ; DS:ESI pointe sur valeur du char suivante
        dec cl                  ; un ligne de moins ...
        jnz @YYPS               ; derniere ligne ???
        inc ebx                 ; caractere suivant ...
        sub edi,640*16-8        ; 16 lignes au dessus 8 pix a droite ...
        jmp @CarSuivPS

@FiniPS:
       pop es                  ; ben voila, c'est fini ...
       pop edi
       pop esi          
        ret
PutStr_ endp


;
; FONCTION BufPutStr(x,y, col, String);  ** Pentium Optimized **
;
; ax contient Coord X
; dx contient Coord Y
; bl contient la couleur
; ecx contient l'adresse du texte

BufPutStr_ proc
       push esi
       push edi

        mov edi,VBuf            ; pointe sur le buffer
        shl edx,7               ; edx=edx*128=Y*128
        add edi,eax             ; edi=edi+eax=X+Y*640 *!*
        add edi,edx             ; edi=edi+edx
        shl edx,2               ; edx=edx*4=Y*512
        add edi,edx             ; edi=edi+edx=Y*(128+512)=Y*640

; EDI contient l'adresse du coin haut-gauche du caractere

        mov dl,bl               ; dl contient la couleur
        mov ebx,ecx             ; ebx pointe sur la chaine de caracteres
@CarSuivPSBuf:
        xor eax,eax             ; *!*
        Mov esi, offset Fnt     ; DS:ESI pointe sur la fonte ???!!!
        Mov al,[EBX]            ; al contient le character
        or eax,eax              ; c'est fini?  *!*
        jz short @FiniPSBuf           ; yep! on se barre ... *!*2
        shl eax,4               ; ax=character*16 (hauteur=16)
        mov ecx,16               ; hauteur   *!*
        add esi,eax             ; DS:ESI pointe sur LE character

@YYPSBuf:
        mov al,[esi]            ; Lit la premiere ligne du Char
        or al,al
        jnz SHORT @NoVidePSBuf        ; vide ? ou pas vide ? *!*2

        add edi,640             ; Si rien alors passe a la ligne suivante
        inc esi                 ; DS:ESI pointe sur valeur du char suivante
        dec cl                  ; une ligne de moins ...
        jnz short @YYPSBuf            ; derniere ligne ??? *!*2
        inc ebx                 ; caractere suivant ...
        sub edi,640*16-8        ; 16 lignes au dessus 8 pix a droite ...
        jmp short @CarSuivPSBuf ; *!*2

@NoVidePSBuf:                   ; pas vide ! alors on va afficher tout ca ...
        mov ch,8                ; largeur
@XXPSBuf:
        shl al,1                ; test pixel par pixel si present
        jnc short @nopixelPSBuf       ; sinon n'affiche pas *!*2
        mov [edi],dl            ; si oui affiche
@nopixelPSBuf:
        inc edi                 ; dans tous les cas, passe au pix suivant
        dec ch                  ; une colonne de la ligne en cours de moins
        jnz short @XXPSBuf    ; *!*2

        add edi,640-8           ; passe a la ligne suivante
        inc esi                 ; DS:ESI pointe sur valeur du char suivante
        dec cl                  ; un ligne de moins ...
        jnz short @YYPSBuf            ; derniere ligne ??? *!*2
        inc ebx                 ; caractere suivant ...
        sub edi,640*16-8        ; 16 lignes au dessus 8 pix a droite ...
        jmp short @CarSuivPSBuf  ;*!*2

@FiniPSBuf:
       pop edi
       pop esi           
        ret
BufPutStr_ endp

;
; FONCTION void PutPix(x,y,col);
; FONCTION byte GetPix(x,y);
;
; ax contient Coord X
; dx contient Coord Y
; bl contient la couleur    ou retour dans al
;                          Attention Incompatible Vesa 1.2 
;
;PutPix_ proc                    
;       push es
;       push edi
;        mov es,lfbsel           ; es=Linear Frame Buffer Selecteur
;
;        shl edx,7               ; edx=edx*128=Y*128
;        mov edi,edx             ; sauve dans edi
;        shl edx,2               ; edx=edx*4=Y*512
;        add edi,edx             ; edi=edi+edx=Y*(128+512)=Y*640
;        add edi,eax             ; edi=edi+eax=X+Y*640
;
;        mov es:[edi],bl
;
;       pop edi
;       pop es
;        ret
;PutPix_ endp
;
;GetPix_ proc                    
;       push es
;       push edi
;        mov es,lfbsel           ; es=Linear Frame Buffer Selecteur
;
;        shl edx,7               ; edx=edx*128=Y*128
;        mov edi,edx             ; sauve dans edi
;        shl edx,2               ; edx=edx*4=Y*512
;        add edi,edx             ; edi=edi+ebx=Y*(128+512)=Y*640
;        add edi,eax             ; edi=edi+eax=X+Y*640
;
;        mov al,es:[edi]
;
;       pop edi
;       pop es
;        ret
;GetPix_ endp

;
; FONCTION SetColor(stylo, r,v,b);
;
; al contient le stylo
; dl contient la composante Rouge
; bl contient la composante vert
; cl contient la composante Bleu

SetColor_ proc
        mov   ch,dl             ; sauve dl
        mov   dx, 3C8h         
        out   dx, al
        inc   dx
        mov   al, ch
        out   dx, al
        mov   al, bl
        out   dx, al
        mov   al, cl
        out   dx, al
        ret
SetColor_ endp

;
; FONCTION WaitVbl : Attends une Synchro Vertical.
;
WaitVbl_ proc
        mov   dx,3DAh
@label1:
        in    al,dx
        and   al,08h
        jnz   @label1
@label2:
        in    al,dx
        and   al,08h
        jz    @label2
        ret
WaitVbl_ endp


;
; FONCTION Hline(X1,X2, Y,col);
; FONCTION Vline(X, Y1,Y2, Col);
;
;                          Attention Incompatible Vesa 1.2 
;Hline_ proc
; ax: X1
; dx: X2
; bx: Y
; cl: col
;       push es
;       push edi
;        mov es,lfbsel           ; es=Linear Frame Buffer Selecteur
;
;        cmp ax,dx               ; X1<X2 ???
;        jl @FautPasChanger2     ; oui! alors ca va... FautPasChanger
;        xchg ax,dx              ; NON! alors faut inverser !!!!
;@FautPasChanger2:
;
;        shl ebx,7               ; ebx=ebx*128=Y*128
;        mov edi,ebx             ; sauve dans edi
;        shl ebx,2               ; ebx=ebx*4=Y*512
;        add edi,ebx             ; edi=edi+ebx=Y*(128+512)=Y*640
;        add edi,eax             ; edi=edi+eax=X+Y*640
;
;        mov bl,cl               ; sauve la couleur dans bl
;        sub edx,eax             ; calcul la longueur de la ligne
;        xor ecx,ecx             ; initialise ecx a 0
;        mov cx,dx               ; et la sauvegarde dans cx
;
;        mov bh,bl               ; bh=bl=col
;        mov ax,bx               ; ax=bx=colcol
;        shl ebx,16              ; colcol dans la partie haute de ebx
;        add eax, ebx            ; eax=colcolcolcol :)
;        mov bl,cl               ; prend la valeur basse de la longueur
;        and bl,011b             ; et ne garde que les deux bits les +faibles
;
;        shr cx,2                ; divise la longueur de la ligne par 4
;        rep stosd               ; et affiche 4 points a la fois
;        xor cx,cx               ; re-nettoie cx
;        mov cl,bl               ; et charge le nombre de point restant
;        rep stosb               ; et les affiche 1 a 1
;
;       pop edi
;       pop es                  ; on remet comme c'etait en arrivant
;        ret                     ; et on se casse ....
;Hline_ endp
;
;Vline_ proc
; ax: X
; dx: Y1
; bx: Y2
; cl: col
;       push es
;       push esi
;       push edi
;        mov es,lfbsel           ; es=Linear Frame Buffer Selecteur
;
;        cmp dx,bx               ; Comparons Y1 et Y2
;        jl @FautPasChanger1     ; si Y2>Y1 alors ca va
;        xchg dx,bx              ; sinon il faut changer tout ca ...
;@FautPasChanger1:
;
;        mov si,dx               ; il faut sauver dx, j'vais en avoir b'soin
;        shl edx,7               ; edx=edx*128=Y*128
;        mov edi,edx             ; sauve dans edi
;        shl edx,2               ; edx=edx*4=Y*512
;        add edi,edx             ; edi=edi+edx=Y*(128+512)=Y*640
;        add edi,eax             ; edi=edi+eax=X+Y*640
;
;        mov al,cl               ; sauve la couleur dans al
;        mov cx,bx               ; on prend Y2 dans cx
;        mov dx,si               ; on recup Y1 dans dx
;        sub cx,dx               ; calcul la longueur de la ligne
;
;@BoucleVert:
;        mov es:[edi],al         ; on pose un point
;        add edi,640             ; on passe a la ligne suivante
;        dec cx                  ; ca fait donc un point de moins
;        jnz @BoucleVert         ; comme ca jusqu'a p'us points !!!
;
;       pop edi
;       pop esi          
;       pop es                  ; ben voila, c'est fini ...
;        ret                     ; et on se casse ....
;Vline_ endp


VlineBuf_ proc         ; a finir !!!!
; ax: X
; dx: Y
; bx: len
; cl: col
        push edi

        mov edi,VBuf            ; pointe sur le buffer
        shl edx,7               ; edx=edx*128=Y*128
        add edi,edx             ; sauve dans edi
        shl edx,2               ; edx=edx*4=Y*512
        add edi,edx             ; edi=edi+edx=Y*(128+512)=Y*640
        add edi,eax             ; edi=edi+eax=X+Y*640

        mov eax,ecx             ; sauve la couleur dans al

@VLBBoucleVert:
        mov es:[edi],al         ; on pose un point
        add edi,640             ; on passe a la ligne suivante
        dec ebx                 ; ca fait donc un point de moins
        jnz short @VLBBoucleVert      ; comme ca jusqu'a p'us points !!! *!*2

        pop edi
        ret                     ; et on se casse ....
VlineBuf_ endp



;
; FONCTION void Selector(Y, longueur, hauteur, couleur)
;
Selector_ proc
; ax: Y
; dx: Longueur
; bl: haut
; cl: add to color         ; parametre plus utilise ...
;       push esi 
       push edi 
       mov bh,bl               ; on sauvegarde la hauteur dans bh

        mov edi,VBuf            ; pointe sur le buffer
        shl eax,7               ; edx=edx*128=Y*128
        add edi,eax             ; edi=edi+edx
        shl eax,2               ; edx=edx*4=Y*512
        add edi,eax             ; edi=edi+edx=Y*(128+512)=Y*640

        mov eax,640             ;
        sub ax,dx               ; ax=640-longueur
        mov ligsuiv,eax         ; longueur de vide dans ligsuiv
;        mov al,cl               ; al contient la couleur
        mov al,00010000b

        mov cx,dx               ; cx=longueur
        sub cx,3                ; -3 pour l'effet d'arrondit ...
@Shl01:
;        mov al,[edi]
;        or al,16
;        mov [edi],al
        or [edi],al
        inc edi                 ; point suivant ...
        dec cx                  ; donc un de moins ...
        jnz short @Shl01               ; hop on boucle *!*2

        add edi,ligsuiv         ; on passe a la ligne suivante !
        add edi,3               ; plus les 3 pixs manquant ...

        mov bl,2                ; deux fois pareille !
@Srep02:
        mov cx,dx
        dec cx
@Shl02:
;        mov al,[edi]
;        or al,16
;        mov [edi],al
        or [edi],al
        inc edi
        dec cx
        jnz short @Shl02   ;  *!*2
        add edi,ligsuiv         ; ligne suivante
        inc edi                 ; +1 (pix manquant!)
        dec bl
        jnz short @Srep02  ;  *!*2

        mov bl,bh                ; plein de fois pareille !
        sub bl,6                 ; moins les 6 lignes traitees a part !!!
@Srep03:
        mov cx,dx
@Shl03:
;        mov al,[edi]
;        or al,16
;        mov [edi],al
        or [edi],al
        inc edi
        dec cx
        jnz short @Shl03  ;  *!*2
        add edi,ligsuiv         ; ligne suivante
        dec bl
        jnz short @Srep03  ; *!*2

        mov bl,2                ; deux fois pareille !
@Srep04:
        mov cx,dx
        dec cx
@Shl04:
;        mov al,[edi]
;        or al,16
;        mov [edi],al
        or [edi],al
        inc edi
        dec cx
        jnz short @Shl04   ; *!*2
        add edi,ligsuiv         ; ligne suivante
        inc edi                 ; +1 (pix manquant!)
        dec bl
        jnz short @Srep04  ; *!*2

        mov cx,dx               ; cx=longueur
        sub cx,3                ; -3 pour l'effet d'arrondit ...
@Shl05:
;        mov al,[edi]
;        or al,16
;        mov [edi],al
        or [edi],al
        inc edi                 ; point suivant ...
        dec cx                  ; donc un de moins ...
        jnz short @Shl05               ; hop on boucle  *!*2

       pop  edi  
;       pop  esi  
        ret
Selector_ endp

;
; FONCTION void Restore(Y, Largeur, Hauteur, buffer);
;
Restore_ proc
; ax: Y
; dx: Longueur
; bl: haut
       push edi 
       mov bh,bl               ; on sauvegarde la hauteur dans bh

        mov edi,VBuf            ; pointe sur le buffer
        shl eax,7               ; edx=edx*128=Y*128
        add edi,eax             ; edi=edi+edx
        shl eax,2               ; edx=edx*4=Y*512
        add edi,eax             ; edi=edi+edx=Y*(128+512)=Y*640

        mov eax,640             ;
        sub ax,dx               ; ax=640-longueur
        mov ligsuiv,eax         ; longueur de vide dans ligsuiv
;        mov al,00010000b

        mov cx,dx               ; cx=longueur
        sub cx,3                ; -3 pour l'effet d'arrondit ...
@Rhl01:
        mov al,[edi]
        and al,15
        mov [edi],al
        inc edi                 ; point suivant ...
        dec cx                  ; donc un de moins ...
        jnz short @Rhl01               ; hop on boucle   *!*2

        add edi,ligsuiv         ; on passe a la ligne suivante !
        add edi,3               ; plus les 3 pixs manquant ...

        mov bl,2                ; deux fois pareille !
@Rrep02:
        mov cx,dx
        dec cx
@Rhl02:
        mov al,[edi]
        and al,15
        mov [edi],al
        inc edi
        dec cx
        jnz short @Rhl02            ;  *!*2
        add edi,ligsuiv         ; ligne suivante
        inc edi                 ; +1 (pix manquant!)
        dec bl
        jnz short @Rrep02             ; *!*2

        mov bl,bh                ; plein de fois pareille !
        sub bl,6                 ; moins les 6 lignes traitees a part !!!
@Rrep03:
        mov cx,dx
@Rhl03:
        mov al,[edi]
        and al,15
        mov [edi],al
        inc edi
        dec cx
        jnz short @Rhl03             ; *!*2
        add edi,ligsuiv         ; ligne suivante
        dec bl
        jnz short @Rrep03            ; *!*2

        mov bl,2                ; deux fois pareille !
@Rrep04:
        mov cx,dx
        dec cx
@Rhl04:
        mov al,[edi]
        and al,15
        mov [edi],al
        inc edi
        dec cx
        jnz short @Rhl04             ; *!*2
        add edi,ligsuiv         ; ligne suivante
        inc edi                 ; +1 (pix manquant!)
        dec bl
        jnz short @Rrep04            ; *!*2
              
        mov cx,dx               ; cx=longueur
        sub cx,3                ; -3 pour l'effet d'arrondit ...
@Rhl05:
        mov al,[edi]
        and al,15
        mov [edi],al
        inc edi                 ; point suivant ...
        dec cx                  ; donc un de moins ...
        jnz short @Rhl05               ; hop on boucle  *!*2

       pop  edi  
;       pop  esi  
        ret
Restore_ endp

;
;[!] FONCTION GetSprite(X, Y, Largeur, Hauteur, buffer); [!]
;
;
;GetSprite_ proc
; ax: X de depart
; dx: Y de depart
; bx: largeur
; cx: hauteur
; pile: @buffer
;
;        mov SauveESI,esi     
;        mov SauveEDI,edi     
;
;        pop esi                 ; recupere l'adresse de retour sur la pile
;        pop edi                 ; recupere le 5eme parametre !!! (adresse)
;        push esi                ; rempile l'adresse de retour ...
;        push ds                 ; sauvegarde DS
;        mov ds,lfbsel           ; ds=Linear Frame Buffer Selecteur
;
;        shl edx,7               ; edx=edx*128=Y*128
;        mov esi,edx             ; sauve dans esi
;        shl edx,2               ; edx=edx*4=Y*512
;        add esi,edx             ; esi=esi+edx=Y*(128+512)=Y*640
;        add esi,eax             ; esi=esi+eax=X+Y*640
;
;; ES:EDI pointe sur la destination du sprite
;; DS:ESI pointe sur le coin haut gauche du sprite en memoire Video
;
;        mov ES:[edi],bx         ; sauvegarde la largeur dans le sprite
;        inc edi                 
;        inc edi
;        mov ES:[edi],cx         ; sauvegarde la hauteur dans le sprite
;        inc edi                 
;        inc edi
;
;        mov edx,640             ; on va calculer la distance entre la fin
;        sub dx,bx               ; du sprite et le debut de la ligne suivante
;
;        mov al,bl               ; prend la valeur basse de la longueur
;        and al,011b             ; et ne garde que les deux bits les +faibles
;        shr bx,2                ; divise la longueur de la ligne par 4
;        mov ah,bl               ; largMax=640 -> Max(bx)=160=bl sauve dans ah
;        mov bx,cx               ; on fout la hauteur dans BX (pour plus tard)
;        xor ecx,ecx             ; on vide ECX juste au cas ou !!!  (idem)
;
;; AH contient le nb de DWORD et AL le nb de BYTE d'une ligne
;; DX contient la hauteur
;
;@AffLine1:
;        mov cl,ah
;        rep movsd               ; et affiche 4 points a la fois
;                        ;inutile-> xor cx,cx ; nettoie cx
;        mov cl,al               ; et charge le nombre de point restant
;        rep movsb               ; et les affiche 1 a 1
;        add esi,edx             ; passe a la ligne suivante 
;        dec bx                  ; une de moins !!!
;        jnz @AffLine1           ; fini ou pas ?
;
;        pop ds                  ; Restaure DS
;        mov esi,SauveESI
;        mov edi,SauveEDI
;        ret                     ; On rentre chez nous ....
;GetSprite_ endp
;
;
;;
;; FONCTION PutSprite(X, Y, adresse du Sprite);
;;
;
;PutSprite_ proc
;; ax: X de depart
;; dx: Y de depart
;; ebx: adresse du sprite
;       push esi  
;       push edi  
;       push es                 ; sauvegarde ES
;        mov es,lfbsel           ; ES=Linear Frame Buffer Selecteur
;
;        shl edx,7               ; edx=edx*128=Y*128
;        mov edi,edx             ; sauve dans edi
;        shl edx,2               ; edx=edx*4=Y*512
;        add edi,edx             ; edi=edi+edx=Y*(128+512)=Y*640
;        add edi,eax             ; edi=edi+eax=X+Y*640
;
;        mov esi,ebx             ; On recupere l'adresse du sprite
;
;; DS:ESI pointe sur le sprite
;; ES:EDI pointe sur la destination en memoire Video
;
;        mov bx,[esi]            ; sauvegarde la largeur dans le sprite
;        inc esi                 
;        inc esi
;        mov dx,[esi]            ; sauvegarde la hauteur dans le sprite
;        inc esi                 
;        inc esi
;
;        mov ecx,640             ; on va calculer la distance entre la fin
;        sub cx,bx               ; du sprite et le debut de la ligne suivante
;
;        mov al,bl               ; prend la valeur basse de la longueur
;        and al,011b             ; et ne garde que les deux bits les +faibles
;        shr bx,2                ; divise la longueur de la ligne par 4
;        mov ah,bl               ; largMax=640 -> Max(bx)=160=bl sauve dans ah
;        mov ebx,ecx             ; EBX contient LigSuiv
;        xor ecx,ecx             ; on vide ECX juste au cas ou !!!
;
;; AH contient le nb de DWORD et AL le nb de BYTE d'une ligne
;; DX contient la hauteur
;
;@AffLine2:
;        mov cl,ah
;        rep movsd               ; et affiche 4 points a la fois
;        mov cl,al               ; et charge le nombre de point restant
;        rep movsb               ; et les affiche 1 a 1
;        add edi,ebx             ; passe a la ligne suivante
;        dec dx                  ; une de moins !!!
;        jnz @AffLine2           ; fini ou pas ?
;
;        pop es                  ; Restaure ES
;        pop  edi         
;        pop  esi         
;        ret                     ; On rentre chez nous ....
;PutSprite_ endp

; eax=Source / edx=Destination / ebx=longueur
; optimizations: rendre adresse debut multiple de 4, et completer ...
MemCopy_ proc
        push esi
        push edi

        mov esi,eax             ; Source
        mov edi,edx             ; Destination
        mov ecx,ebx             ; Longueur
        shr ecx,2               ; nombre de DWORDs a copier
        and ebx,011b            ; restant a copier
        rep movsd               ; deplacer ecx DWORDs
        mov ecx,ebx             ; puis ebx BYTEs
        rep movsb               

        pop edi
        pop esi
        ret
MemCopy_ endp

;eax=pointer buffer / edx=add du 2e pointer p/r au 1er
SetBuf_ proc
        mov [VBufClip],eax          ; vrai adresse du buffer
        add eax,edx                 
        mov [VBuf],eax              ; 20lignes en dessous
        mov [VBufNorm],eax          ; pour pouvoir clipper an haut kom en
        ret                         ; bas sans aucun problmes !!!
SetBuf_ endp

IsWin_ proc
        mov ax,160Ah                    ; quelle est la version de win ?
        int 2Fh
        or al,al                        ; 
        jz @Error                       ; Il me repond en plus !!!
        Xor eax,eax                     ; KASSE TOA !
        ret
@Error:
        Mov eax,1                       ; Bah, on sait po! 
        ret                             ; Il n'y est donc pas
IsWin_ endp

; entree ax=x / dx=y / bx=Larg / cx=haut
ConfigR2B_ proc                 ; ! WARNING ! Multiple de 4 !!! sinon pfiou..
        push edi                ; sauve edi

        shl edx,7               ; edx=edx*128=Y*128
        mov edi,edx             ; sauve dans edi
        shl edx,2               ; edx=edx*4=Y*512
        add edi,edx             ; edi=edi+edx=Y*(128+512)=Y*640
        mov [BufROffs],edi      ; adresse de debut de ligne
        add eax,edi             ; eax=eax+edi=X+Y*640
        mov [BufOffset],eax     ; adresse de coin Haut-Gauche
        shr bx,2                ; bx=Largeur/4
        inc bx                  ; bx=1+(Largeur/4)
        shl bx,2                ; bx=(1+(Largeur/4))*4
        mov [BufL],bx           ; BufL = Largeur 
        mov [BufH],cx           ; BufH = Hauteur 

;        and ecx,0FFFFh          ; vide la partie haute de ecx
        shl ecx,5               ; Hauteur * 32
        mov ebx,ecx
        shl ecx,2               ; Hauteur * 128
        add ecx,ebx             ; Hauteur * 160 (640/4=160)
        mov [BufRLen],ecx

        pop edi                 ; restore edi
        ret
ConfigR2B_ endp

; entree eax=BufSource / edx=BuffDest
Restore2Buf_ proc
        push esi
        push edi
        mov ebx,[BufOffset]

        mov esi,eax             ; esi=eax=buffer Source
        add esi,ebx             ; + debut de la zone a copier

        mov edi,edx             ; edi=edx=buffer Destination
        add edi,ebx             ; + debut de la zone a copier

        mov edx,640             ; 640 contenu dans la partie basse de edx
        xor ebx,ebx             ; bug ??!!
        mov bx,[BufL]           ; bx=Largeur 
;        shl bx,2                ; bx=Largeur
        sub dx,bx               ; edx=ce kil manque entre 2 lignes
        xor ecx,ecx             ; ecx=0 (par securite)
        xor eax,eax             ; securite
        mov ax,[BufH]           ; ax=Hauteur
        shr bx,2                ; bx=Largeur /4
@R2BLoop:
        mov cx,bx               ; ecx=largeur d'1 ecran /4
        rep movsd               ; Copie en double word
        add esi,edx
        add edi,edx
        dec eax
        jnz @R2BLoop

        pop edi
        pop esi
        ret
Restore2Buf_ endp

; entree eax=BufSource
;VSwpscr2_  proc                  ; copie un buffer en video
;       mov DX,ES                ; sauve ES dans DX
;       mov EBX,ESI              ; sauve ESI dans EBX
;        mov esi,eax             ; esi=eax=buffer
;       mov EAX,EDI              ; sauve EDI dans EAX
;        mov edi,[BufROffs]      ; on commence pas tout en haut ...
;        add esi,edi
;        mov es,lfbsel           ; es=Linear Frame Buffer Selecteur
;        mov ecx,[BufRLen]       ; ecx=longueur de la zone utilisee
;        rep movsd               ; Copie en double word
;       mov ES,DX
;       mov ESI,EBX
;       mov EDI,EAX
;        ret
;VSwpscr2_ endp

; entree eax=BufSource
SwpFBuf_  proc                  ; copie un buffer en video
        push esi
        push edi
        push es
        mov ebx,[BufOffset]

        mov esi,eax             ; esi=eax=buffer Source
        add esi,ebx             ; + debut de la zone a copier

        mov es,lfbsel           ; es=Linear Frame Buffer Selecteur
        mov edi,ebx             ; debut de la zone a copier

        mov edx,640             ; 640 contenu dans la partie basse de edx
        xor ebx,ebx             ; Seait-ce le fameux bug ???????
        mov bx,[BufL]           ; bx=Largeur 
;        shl bx,2                ; bx=Largeur
        sub dx,bx               ; edx=ce kil manque entre 2 lignes
        xor ecx,ecx             ; ecx=0 (par securite)
        mov ax,[BufH]           ; ax=Hauteur
        shr bx,2                ; bx=Largeur
@SFBLoop:
        mov cx,bx               ; ecx=longueur d'1 ecran 640*480/4
        rep movsd               ; Copie en double word
        add esi,edx
        add edi,edx
        dec ax
        jnz @SFBLoop

        pop es
        pop edi
        pop esi
        ret
SwpFBuf_ endp



; eax=buf / dl=couleur max..
VClrbufUnder_ proc
       PUSH EDI
        mov edi,eax             ; edi=eax=buffer
        xor eax,eax             ; eax=0000h
        mov ecx,640*480         ; ecx=longueur d'1 ecran 640*480
;        mov ah,dl

@LoopClrBufUnder:
        mov al,[edi]
        cmp al,dl
        jnbe @NoClean
        mov [edi],ah
@NoClean:
        inc edi
        dec ecx
        jnz @LoopClrBufUnder
       POP EDI
        ret
VClrbufUnder_ endp



; eax=source / edx=dest / bl=color max
CopyBuf2BufUnder_ proc
       PUSH ESI
       PUSH EDI
        mov esi,eax             ; esi=eax=buffer Source
        mov edi,edx             ; edi=edx=buffer Destination
        mov ecx,640*480         ; ecx=longueur d'1 ecran 640*480
        mov ah,bl

@LoopCopyBufUnder:
        mov al,[esi]
        cmp al,ah
        jg  @NoCopy
        or al,al
        jz @NoCopy
        mov [edi],al
@NoCopy:
        inc edi
        inc esi
        dec ecx
        jnz @LoopCopyBufUnder

       POP EDI
       POP ESI
        ret
CopyBuf2BufUnder_ endp



; Eax=Source
BufferCopyVesa12_ proc
        PUSH EDI
        PUSH ESI 
        mov ESI,EAX              ; Buffer Source

        mov edi,offset redi      ; structure registre mode reel
        mov ax,0300h             ; appel fonction mode reel
        mov bx,10h               ; 10h => fonction vga/vesa
        xor cx,cx                ; rien a recopier (??)
        mov redx,0               ; Bank 0
        mov rebx,0               ; (??)
        mov reax,04F05h          ; fonction changement de bank
        int 31h                  ; emulation !

        mov edi,0A0000h          ; fenetre graphique
        mov ecx,16384d           ; ecx=longueur d'1 ecran 640*480/4
        rep movsd                ; Recopie 65536 bytes (une bank)

        mov edi,offset redi      ; structure registre mode reel
        mov ax,0300h             ; appel fonction mode reel
        mov bx,10h               ; 10h => fonction vga/vesa
        xor cx,cx                ; rien a recopier (??)
        mov redx,1               ; Bank 1
        mov rebx,0               ; (??)
        mov reax,04F05h          ; fonction changement de bank
        int 31h                  ; emulation !

        mov edi,0A0000h          ; fenetre graphique
        mov ecx,16384d           ; ecx=longueur d'1 ecran 640*480/4
        rep movsd                ; Recopie 65536 bytes (une bank)

        mov edi,offset redi      ; structure registre mode reel
        mov ax,0300h             ; appel fonction mode reel
        mov bx,10h               ; 10h => fonction vga/vesa
        xor cx,cx                ; rien a recopier (??)
        mov redx,2               ; Bank 2
        mov rebx,0               ; (??)
        mov reax,04F05h          ; fonction changement de bank
        int 31h                  ; emulation !

        mov edi,0A0000h          ; fenetre graphique
        mov ecx,16384d           ; ecx=longueur d'1 ecran 640*480/4
        rep movsd                ; Recopie 65536 bytes (une bank)

        mov edi,offset redi      ; structure registre mode reel
        mov ax,0300h             ; appel fonction mode reel
        mov bx,10h               ; 10h => fonction vga/vesa
        xor cx,cx                ; rien a recopier (??)
        mov redx,3               ; Bank 3
        mov rebx,0               ; (??)
        mov reax,04F05h          ; fonction changement de bank
        int 31h                  ; emulation !

        mov edi,0A0000h          ; fenetre graphique
        mov ecx,16384d           ; ecx=longueur d'1 ecran 640*480/4
        rep movsd                ; Recopie 65536 bytes (une bank)

        mov edi,offset redi      ; structure registre mode reel
        mov ax,0300h             ; appel fonction mode reel
        mov bx,10h               ; 10h => fonction vga/vesa
        xor cx,cx                ; rien a recopier (??)
        mov redx,4               ; Bank 4
        mov rebx,0               ; (??)
        mov reax,04F05h          ; fonction changement de bank
        int 31h                  ; emulation !

        mov edi,0A0000h          ; fenetre graphique
        mov ecx,11264d           ; ecx=longueur de ce qui reste
        rep movsd                ; Recopie 11264*4 bytes 

        POP ESI
        POP EDI
        ret
BufferCopyVesa12_ endp


SetClip_ proc
        or al,al
        jz @NoClip
        mov eax,[VBufClip]
        mov [VBuf],eax
        ret
@NoClip:
        mov eax,[VBufNorm]
        mov [VBuf],eax
        ret
SetClip_ endp        

AddPTR_ proc
        add eax,edx
        ret
AddPTR_ endp
end

; 0 = Faux; Le reste = Vrai;
