
{ *** UNIDSP.PAS *** }
{ - modu wspomaga odtwarzanie sampli na
       Sound Blaster, Covox, PC-Speaker }

{$A+,B-,D+,E+,F-,G+,I-,L+,N+,O-,P-,Q-,R-,S-,T-,V+,X+,Y+}
{$M 16384,0,655360}
Unit UniDSP;

Interface

Const
  dspSB = 1;
  dspSPK = 2;
  dspCOVOX = 3;
  
  { wybiera urzdzenie do odtwarzana }
  { DEV - identyfikator urzdzenia (dspSB,dspSPK,dspCOVOX)}
  { NEWPORT - port wyjciowy (SoundBlaster-$220,$240...,
  Covox-$378(LPT1) $278(LPT2) }
Procedure SetPort (dev: Word; newport: Word);

{ w przypadku karty SoundBlaster i Speakera inicjalizacja}
Procedure InitializeDSP;

{ wysanie prbki do przetwornika C/A }
Procedure SendSample (s: Byte);

{ czynnoci kocowe (nie trzeba wywoywa) }
Procedure DSPDone; Far;



Implementation

Var
  SBPort: Word;
  DSPDEVICE: Word;
  oldexit: pointer;
  
  
Procedure SetPort;
Begin
  SBPort := newport;
  dspdevice := dev;
End;


Procedure InitializeDSP;
Var
  b: Byte;
  success: Boolean;
  loop: Byte;
Begin
  Case dspdevice Of
    dspsb:
          Begin
            port [sbport + 6] := 1;
            success := False;
            port [sbport + 6] := 0;
            loop := 0;
            Repeat
              b := port [sbport + $e];
              Inc (loop);
              If b >= 128 Then success := True;
            Until (success = True) Or (loop > 100);
            If success = False Then Begin
              WriteLn ('Nie wykryto Sound Blaster-a!');
              Halt;
            End;
            loop := 0;
            success := False;
            Repeat
              b := port [sbport + $a];
              Inc (loop);
              If b = $aa Then success := True;
            Until (success = True) Or (loop > 15);
            If success = False Then Begin
              WriteLn ('Blad DSP Sound Blaster-a!');
              Halt;
            End;
            repeat
            until (port[sbport + $C] and 128 = 0);
            port[sbport+$C] := $D1;
          End;
    dspspk:
           Begin
             port [$61] := port [$61] Or 3;
             port [$43] := $90;
           End;
  End;
End;


Procedure SendSample; Assembler;
Asm
  cmp Word Ptr dspdevice, dspsb
  jne @nosb
  mov DX, sbport
  add DX, 0CH
  @loop1:
  In AL, DX
  ShR AL, 7
  cmp AL, 1
  je @loop1
  mov AL, 10h
  out DX, AL
  @loop2:
  In AL, DX
  ShR AL, 7
  cmp AL, 1
  je @loop2
  mov AL, s
  out DX, AL
  jmp @Exit
  @nosb:
  cmp Word Ptr dspdevice, dspcovox
  jne  @speaker
  @covox:
  mov AL, s
  mov DX, sbport
  out DX, AL
  jmp @Exit
  @speaker:
  mov AL, s
  ShL AL, 1
  out 42h, AL
  @Exit:
End;


Procedure DSPDone;
Begin
  If dspdevice = dspspk Then
    port [$61] := port [$61] And $fc;
  ExitProc := oldexit;
End;


Begin
  SetPort (dspspk, 0);
  oldexit := ExitProc;
  ExitProc := @dspdone;
End.


