;*** Include file for spew

                    .RADIX 10h
                    NOWARN    RES

AMAC                MACRO     Addr,Opc
                    LOCAL     c,t
                    C INSTR <Addr>,<#>
                    if c
                       t SUBSTR <Addr>,2
                       db     t,Opc
                    else
                       db     (Addr-Begin) AND 0ffh,((Addr-Begin) SHR 8)+Opc 
                    endif
                    ENDM

JMAC                MACRO     Displ,Opc
                    db        Displ-($+2)
                    db        Opc
                    ENDM

OSCALL              MACRO     x
                    db        x,0
                    ENDM

JP                  MACRO     Addr
                    AMAC      Addr,0
                    ENDM

RETURN              MACRO
                    db        0,10h
                    ENDM

GOSUB               MACRO     Addr
                    AMAC      Addr,10h
                    ENDM

PUSHB               MACRO     Addr
                    AMAC      Addr,20h
                    ENDM

POPB                MACRO     Addr
                    AMAC      Addr,30h
                    ENDM

LDA                 MACRO     Addr
                    AMAC      Addr,40h
                    ENDM

STA                 MACRO     Addr
                    AMAC      Addr,50h
                    ENDM

RDI                 MACRO     Addr
                    AMAC      Addr,60h
                    ENDM

WRI                 MACRO     Addr
                    AMAC      Addr,70h
                    ENDM

RDSYS               MACRO     Addr
                    db        Addr and 0ffh
                    db        (Addr SHR 8)+80h
                    ENDM

ADDW                MACRO     Addr
                    AMAC      Addr,90h
                    ENDM

JPOV                MACRO     Addr
                    JMAC      Addr,0a0h
                    ENDM

JPNO                MACRO     Addr
                    JMAC      Addr,0a1h
                    ENDM

JPC                 MACRO     Addr
                    JMAC      Addr,0a2h
                    ENDM

JPNC                MACRO     Addr
                    JMAC      Addr,0a3h
                    ENDM

JPZ                 MACRO     Addr
                    JMAC      Addr,0a4h
                    ENDM

JPNZ                MACRO     Addr
                    JMAC      Addr,0a5h
                    ENDM

JPBE                MACRO     Addr
                    JMAC      Addr,0a6h
                    ENDM

JPA                 MACRO     Addr
                    JMAC      Addr,0a7h
                    ENDM

JPS                 MACRO     Addr
                    JMAC      Addr,0a8h
                    ENDM

JPNS                MACRO     Addr
                    JMAC      Addr,0a9h
                    ENDM

JPP                 MACRO     Addr
                    JMAC      Addr,0aah
                    ENDM

JPNP                MACRO     Addr
                    JMAC      Addr,0abh
                    ENDM

JPL                 MACRO     Addr
                    JMAC      Addr,0ach
                    ENDM

JPGE                MACRO     Addr
                    JMAC      Addr,0adh
                    ENDM

JPLE                MACRO     Addr
                    JMAC      Addr,0aeh
                    ENDM

JPG                 MACRO     Addr
                    JMAC      Addr,0afh
                    ENDM

ADCA                MACRO     Addr
                    AMAC      Addr,0b0h
                    ENDM

SBBA                MACRO     Addr
                    AMAC      Addr,0c0h
                    ENDM

ORA                 MACRO     Addr
                    AMAC      Addr,0d0h
                    ENDM

ANDA                MACRO     Addr
                    AMAC      Addr,0e0h
                    ENDM

XORA                MACRO     Addr
                    AMAC      Addr,0f0h
                    ENDM


                    .MODEL    TINY
                    LOCALS

                    .CODE

Begin:              ORG       100h



