// file: vesa.h
// description: basic VESA structures and functions
// compiler: Watcom 10.0+
// platform: DOS, VESA 1.2+
// copyright (c) 1999 Street Raider // DDT Ent.

#ifndef VESA_H

#define VESA_H

typedef struct
{
  char VbeSignature[4];              // VBE Signature
  unsigned short int VbeVersion;     // VBE Version
  char *OemStringPtr;                // Pointer to OEM String
  unsigned int Capabilities;         // Capabilities of graphics cont.
  unsigned short int *VideoModePtr;  // Pointer to Video Mode List
  unsigned short int TotalMemory;    // Number of 64kb memory blocks
                                     // Added for VBE 2.0
  unsigned short int OemSoftwareRev; // VBE implementation Software revision
  char *OemVendorNamePtr;            // Pointer to Vendor Name String
  char *OemProductNamePtr;           // Pointer to Product Name String
  char *OemProductRevPtr;            // Pointer to Product Revision String
  char Reserved[222];                // Reserved for VBE impl. scratch area
  char OemData[256];                 // Data Area for OEM Strings
} VesaInfoBlock;

typedef struct
{
  unsigned short int ModeAttributes;  // mode attributes
  char WinAAttribute;                 // window A attributes
  char WinBAttributes;                // window B attributes
  unsigned short int WinGranularity;  // window granularity
  unsigned short int WinSize;         // window size
  unsigned short int WinASegment;     // window A start segment
  unsigned short int WinBSegment;     // window B start segment
  int *WinFuncPtr;                    // pointer to window function
  unsigned short int BytesPerScanLine;// bytes per scan line

  // Mandatory information for VBE 1.2 and above
  unsigned short int XResolution;     // horizontal res. in pixels or chars
  unsigned short int YResolution;     // vertical res. in pixels or chars
  char XCharSize;                     // character cell width in pixels
  char YCharSize;                     // character cell height in pixels
  char NumberOfPlanes;                // number of memory planes
  char BitsPerPixel;                  // bits per pixel
  char NumberOfBanks;                 // number of banks
  char MemoryModel;                   // memory model type
  char BankSize;                      // bank size in KB
  char NumberOfImagePages;            // number of images
  char Reserved;                      // reserved for page function

  // Direct Color fields (required for direct/6 and YUV/7 memory models)
  char RedMaskSize;                   // size of direct color red mask in bits
  char RedFieldPosition;              // bit position of lsb of red mask
  char GreenMaskSize;                 // size of direct color green mask in bits
  char GreenFieldPosition;            // bit position of lsb of green mask
  char BlueMaskSize;                  // size of direct color blue mask in bits
  char BlueFieldPosition;             // bit position of lsb of blue mask
  char RsvdMaskSize;                  // size of direct color rsrvd mask in bits
  char RsvdFieldPosition;             // bit position of lsb of reserved mask
  char DirectColorModeInfo;           // direct color mode attributes

  // Mandatory information for VBE 2.0 and above
  char *PhysBasePtr;                  // physical address for flat frame buffer
  char *OffScreenMemOffset;           // pointer to start of off screen memory
  unsigned short int OffScreenMemSize;// amount of off screen memory in 1k units
  char xReserved[206];                // remainder of ModeInfoBlock
} ModeInfoBlock;

extern unsigned short int SetVesaMode(int VideoMode);
#pragma aux SetVesaMode = \
  " mov eax,4F02h " \
  " int 10h       " \
  parm [ebx] modify [eax] value [ax];

#endif // VESA_H
