// Exact memory fsde -- CAN'T DECODE!

#include <iostream.h>
#include <fstream.h>
#include <math.h>
#include "FileIO.H"

const int BLOCK_SIZE = 200 << 10;
const int HOW_MANY_PROBES = 4096;
const int CONTEXT_ORDER = 25;

Files Data;
int *Probes[256], UsedProbes[256];
char CodingState;

void Transform(char *Block, int BlockLength);
void ClearProbes(), SetupBlock(char *Block, int BlockLength);

int main(int argc, char **argv)
{                             
   if(argc < 3)
   {
      cout << "Specify I/O files on command line.";
      return 0;
   }
   Data.Open(argv[1], argv[2]);
   if(Data.IOStatus != IO_OK)
   {
      if(Data.IOStatus == INPUT_ERROR) cout << "Could not read input file.";
      else cout << "Could not read output file.";
      return 0;
   }
   cout << "Decode? 'd': ";
   cin >> CodingState;
   
   char *Block = new char[BLOCK_SIZE];
   int InputLength = Data.GetLength();                
   float Blocks = InputLength / (float) BLOCK_SIZE;
   int HowManyBlocks = (int) Blocks, Remainder = 0;
   Remainder = (Blocks - HowManyBlocks) * BLOCK_SIZE;

   cout << HowManyBlocks << ' ' << (BLOCK_SIZE >> 10) << "k blocks with "
   << Remainder << " byte remainder." << endl;
   for(int i = 0; i < HowManyBlocks; i++)
   {
      cout << "Block " << i << ' ';
      SetupBlock(Block, BLOCK_SIZE);
      ClearProbes();
      Transform(Block, BLOCK_SIZE);
   }
   if(Remainder)
   {
      cout << "Remainder block: " << Remainder << " bytes - ";
      SetupBlock(Block, Remainder);
      ClearProbes();

      Transform(Block, Remainder);
   }
   delete [] Block;
   for(i = 0; i < 256; i++) delete [] Probes[i];
   return 0;
}               

void Transform(char *Block, int BlockLength)
{
   int i, j, Offset = 0, Longest, SearchOffset, UsedOrder = 1;
   char Predicted = 0, Context[CONTEXT_ORDER + 1];
   Data.Output.put(Block[Offset++]);

   while(Offset < BlockLength)
   {
      if(UsedOrder < CONTEXT_ORDER - 1) UsedOrder++;
      for(i = 1; i <= UsedOrder; i++)
         Context[UsedOrder - i] = Block[Offset - i];
      Context[UsedOrder] = '\0';
      char HighestOrderByte = Context[UsedOrder - 1];
      char C = Block[Offset];
      for(Longest = 0, i = 0; i < UsedProbes[HighestOrderByte]; i++)
      {
         SearchOffset = Probes[HighestOrderByte][i];
         if(SearchOffset == Offset - 1) continue;
         char *BlockPtr = Block + SearchOffset;
         char *ContextPtr = Context + UsedOrder - 1;
         for(j = 0; j < UsedOrder; j++)
            if(*BlockPtr-- != *ContextPtr--) break;
         if(j > Longest)
         {
            Longest = j;
            Predicted = Block[SearchOffset + 1];
            if(j == UsedOrder) break;
         }
      }
      Data.Output.put((char) (Predicted - C));
      if(CodingState == 'd')
      {
         C = Predicted - C;
         Block[Offset] = C;
      }
      for(i = UsedProbes[C]; i >= 1; i--) Probes[C][i] = Probes[C][i - 1];
      Probes[C][0] = Offset;
      if(UsedProbes[C] < HOW_MANY_PROBES - 1) UsedProbes[C]++;
      Offset++;
   }
   return;
}
                      
void SetupBlock(char *Block, int BlockLength)
{
   int Freqs[256];
   memset(Freqs, 0, 1024);
   for(int i = 0; i < BlockLength; i++)
   {
      Block[i] = Data.Input.get();
      Freqs[Block[i]]++;
   }
   int Allocate, Total = 0;
   for(i = 0; i < 256; i++)
   {
      Allocate = Freqs[i];
      if(Allocate > HOW_MANY_PROBES) Allocate = HOW_MANY_PROBES;
      Total += Allocate;
      if(Probes[i]) delete [] Probes[i];
      Probes[i] = new int[Allocate];
   }
   cout << "Allocated: " << (Total >> 8) << "k context search bytes for this block\n";
   return;
}

void ClearProbes()
{
   memset(UsedProbes, 0, 1024);
   return;
}
