;initialize all the other needed things

;initialize DirectDraw

		.data

		dllname db "ddraw.dll",0
		functionname db "DirectDrawCreate",0

		.code

	IFDEF masm
	 GetProcAddress equ GetProcAddress@8
	 LoadLibraryA equ LoadLibraryA@4
	ENDIF

		EXTRN LoadLibraryA:near
		EXTRN GetProcAddress:near

		push offset dllname
		call LoadLibraryA
		push offset functionname
		push eax
		call GetProcAddress

		.data

		 OurDirectDrawInterface   dd 0
		 OurPrimarySurface        dd 0
		 OurBackbufferSurface     dd 0

		.code

;create a DirectDraw interface
		push 0
		push offset OurDirectDrawInterface
		push 0
		call eax
		or eax,eax ;success ?
		jnz WM_QUIT_received

;setting up DirectDraw:

;you already know them: the macros for simplifying COM calling

		DXfunction_ macro interface , method 
		 mov edi,[interface] ;edi = DD-Objekt(adresse)
		 mov edi,[edi]   ;edi = VTable(adresse)
		 mov edi,[edi+method] ; callziel
		  push [interface]
		  call edi
		endm

		DXfunction macro  interface , method , err_interface, err_method
		local noerrmsg , MessageBoxTitle , MessageBoxContent
		 mov edi,[interface] ;edi = DD-Objekt(adresse)
		 mov edi,[edi]   ;edi = VTable(adresse)
		 mov edi,[edi+method] ; callziel
		  push [interface]
		  call edi
		or eax,eax
		jz noerrmsg
		 push MB_ICONHAND + MB_OK
		 push offset MessageBoxTitle
	  	 push offset MessageBoxContent
		 push 0
		 call MessageBoxA
		 jmp WM_QUIT_received

		noerrmsg:

		.data

		MessageBoxTitle db "DirectX Function Call Failed" ,0
		MessageBoxContent db err_interface , " : ", err_method ,0

		.code

		endm


;1. set the Cooperative Level (it is quite uncooperative for fullscreen). 

		push DDSCL_EXCLUSIVE + DDSCL_FULLSCREEN 
		push [Windowhandle]
		DXfunction OurDirectDrawInterface, DDSETCOOPERATIVELEVEL ,"OurDirectDrawInterface", "DDSETCOOPERATIVELEVEL"

;set needed video mode (only posible if DDSCL_EXCLUSIVE is set)
                push 0  ;no flag indicating standard mode 13hex (only useful for 320*200*8 mode)
                push 0  ;use std refresh rate (you may change this, but your monitor may not like it, so better use the default)
                push 32 ;32 bit mode
                push 480 ;y
                push 640 ;x
		DXfunction OurDirectDrawInterface, DDSETDISPLAYMODE ,"OurDirectDrawInterface", "DDSETDISPLAYMODE"

;2. create a primary surface with backbuffer

		.data

		SurfaceDescription DDSURFACEDESC <>

		.code

;set up the DDSURFACEDESC structure for telling DirectDraw that a 
;PrimarySurface with a backbuffers (you may use 1 or 3 or 4 or ... as well) is needed 
		mov dword ptr [SurfaceDescription.dwSize],size DDSURFACEDESC
		mov dword ptr [SurfaceDescription.ddssurfCaps], DDSCAPS_PRIMARYSURFACE or DDSCAPS_FLIP or DDSCAPS_COMPLEX
		mov dword ptr [SurfaceDescription.dwsurfFlags],DDSD_BACKBUFFERCOUNT or DDSD_CAPS
		mov dword ptr [SurfaceDescription.dwBackBufferCount], 2 ;triple buffering

		push 0
		push offset OurPrimarySurface
		push offset SurfaceDescription
		DXfunction OurDirectDrawInterface, DDCREATESURFACE, "OurDirectDrawInterface", "DDCREATESURFACE"

;get the backbuffer surface object (it was implicitly created with the front buffer)

		mov dword ptr [SurfaceDescription.ddssurfCaps], DDSCAPS_BACKBUFFER

		push offset OurBackbufferSurface
		push offset SurfaceDescription.ddssurfCaps
		DXfunction OurPrimarySurface, DDSGETATTACHEDSURFACE, "OurDirectDrawInterface", "DDSGETATTACHEDSURFACE"


; alloc mem for storing the data (coders art is the best ;-)

.data

 mempos dd 0 ;position of system mem backbuffer
 
 file1 db "back.raw",0
 file2 db "sun.raw",0
 file3 db "moon.raw",0
 file4 db "boat.raw",0

 thisdoesnotinterestme dd 0

.code


push (640*480*4)*2+(64*64*4)*3  ;size of memory block requested
push LMEM_FIXED ;we need the memory now, so let win32 map it to a 
                      ;fixed position so that we can access it. In this
                      ;case, the function returns the pointer to the mem
call LocalAlloc
mov [mempos],eax

;load files (see rdfile_n.inc)

mov [filename],offset file1
mov [filesize],640*480*3
mov [buffrpos],640*480*5
call loadfile2mem
mov [filename],offset file2
mov [filesize],64*64*3
mov [buffrpos],(640*480*4)*2 + 64*64 
call loadfile2mem
mov [filename],offset file3
mov [filesize],64*64*3
mov [buffrpos],(640*480*4)*2 + 64*64*5
call loadfile2mem
mov [filename],offset file4
mov [filesize],64*64*3
mov [buffrpos],(640*480*4)*2 + 64*64*9
call loadfile2mem

; gfx loaded; copy back.raw 2 the mem backbuffer, convert 24->32bit

mov edi,[mempos]
lea esi,[edi+640*480*5]
mov ecx,640*480
wrpl:
 lodsd
 dec esi
 bswap eax
 shr eax,8
 mov [edi+640*480*4],eax
 stosd
dec ecx
jnz wrpl

mov edi,[mempos]
lea esi,[edi+(640*480*4)*2 + 64*64]
lea edi,[edi+(640*480*4)*2]
mov ecx,64*64
wrpl2:
 lodsd
 dec esi
 bswap eax
 shr eax,8
 stosd
dec ecx
jnz wrpl2

mov edi,[mempos]
lea esi,[edi+(640*480*4)*2 + 64*64*5]
lea edi,[edi+(640*480*4)*2 + 64*64*4]
mov ecx,64*64
wrpl3:
 lodsd
 dec esi
 bswap eax
 shr eax,8
 stosd
dec ecx
jnz wrpl3

mov edi,[mempos]
lea esi,[edi+(640*480*4)*2 + 64*64*9]
lea edi,[edi+(640*480*4)*2 + 64*64*8]
mov ecx,64*64
wrpl4:
 lodsd
 dec esi
 bswap eax
 shr eax,8
 stosd
dec ecx
jnz wrpl4



;calculate time between 2 refreshes
;note that this value does not calculate the time between to
;"real" refreshes, but the average (-> multitasking !) time between
;the refreshes with all drawing involved.

;if the threads are started just before determining the average
;time between 2 flips, the value will be too high due to the additional
;time the thread creation consumes
;If they are started after getting the time, we do not have the
;missing flips due to the running threads included, so the value will
;be too low.

call flippage
call flippage       ;for better accuracy
call timeGetTime  
 push eax            ;save time of 0st flip
 mov ecx,16
 measureloop:
  push ecx
  call updatescreen
  pop ecx
 dec ecx
 jnz measureloop 
 call timeGetTime
 mov ecx,eax         ;time of 16th flip 
 pop eax
 sub ecx,eax       ; ecx = time in milliseconds for 16 flips
xor edx,edx
mov eax,1000*128  ; get refreshes per second (128 = 1 sec)
div ecx           ; eax=refresh rate (in Hz) * 128 / 16
mov ecx,eax
xor eax,eax       ; calculate value to add for moving the sun sprite
mov edx,1         ; so that 4 sec = 1 cycle of movement 
div ecx           ; eax = value for 16 refreshes in ...
shl eax,7 -3 -2   ; -3 due to the multiplier 128/16 above, -2 wg. 4 sec
mov [addpos],eax

; start 1st thread

push offset thread1id
push 0                  ;start thread immediately
push 0                  ;a parameter for the thread (not used here)
push offset thread1loop ;the start of the threads code
push 0                  ;default stack size (it grows if needed, remember ?)
push 0                  ;security attributes ? nah, not here ;-]
call CreateThread
mov [thread1handle],eax

; start 2nd thread

push offset thread2id
push 0              ;start thread immediately
push 0              ;a parameter for the thread (not used here)
push offset thread2 ;the start of the threads code
push 0              ;default stack size (it grows if needed, remember ?)
push 0              ;security attributes ? nah, not here ;-]
call CreateThread
mov [thread2handle],eax

; start 3rd thread

push offset thread3id
push 0               ;start thread immediately
push 0               ;a parameter for the thread (not used here)
push offset thread34 ;the start of the threads code
push 0               ;default stack size (it grows if needed, remember ?)
push 0               ;security attributes ? nah, not here ;-]
call CreateThread
mov [thread3handle],eax

;start it again -> 4th thread , this is NOT a restart, but more like
;a duplicate of the thread execution environment

push offset thread4id
push 0               ;start thread immediately
push 0               ;a parameter for the thread (not used here)
push offset thread34 ;the start of the threads code
push 0               ;default stack size (it grows if needed, remember ?)
push 0               ;security attributes ? nah, not here ;-]
call CreateThread
mov [thread4handle],eax
