;this thread runs until the thread1exit flag is set
;it writes the mem buffer to the backbuffer surface
;and flips the surfaces at the next retrace


;-------this is the thread--------------


	thread1loop:

	call updatescreen

	cmp [thread1exit],0
	jz thread1loop

	;thread terminates

	xor eax,eax  ;return code
	ret


;------end of thread----------------------

.data

backbufferptr dd 0

thread1exit   dd 0
thread1id     dd 0
thread1handle dd 0

sunpos dd 0
addpos dd 0

.code


flippage:   ;this function flips the surface

push DDFLIP_WAIT ;wait if not ready
push 0 
DXfunction_ OurPrimarySurface, DDSFLIP
or eax,eax ;error ? (normally the surface is lost, otherwise sth. fucked up)
jz doflip
 DXfunction_ OurPrimarySurface, DDSRESTORE
doflip:
ret

drawsprite: ;draws a sprite at position esi into position ebx
  
add ebx,[mempos] ;destpos
add esi,[mempos] ;srcpos
yloopsprite1:
 xloopsprite1:
  mov eax,[esi]
  add esi,4
  or eax,eax
  jz transparentpixel
  mov [ebx],eax
  transparentpixel:
  add ebx,4
  dec ecx
  test ecx,63
  jnz xloopsprite1
 add ebx,(640-64)*4
 or ecx,ecx
jnz yloopsprite1
ret

redrawbackground: ;draws a sprite sized 64*64 at position esi into position ebx
  
add ebx,[mempos] ;destpos
add esi,[mempos] ;srcpos
mov ecx,64*64
yloopbg:
 xloopbg:
  mov eax,[esi]
  mov [ebx],eax
  add esi,4
  add ebx,4
  dec ecx
  test ecx,63
  jnz xloopbg
 add ebx,(640-64)*4
 add esi,(640-64)*4
 or ecx,ecx
jnz yloopbg
ret

updatescreen:

;this function not only calculates the sprite position of the
;thread #1, it also does page flipping and writing to the 
;backbuffer

;init surface description buffer first
 mov edi, offset SurfaceDescription
 mov ecx, (size DDSURFACEDESC) /4
 xor eax,eax
 rep stosd
 mov [SurfaceDescription.dwSize], size DDSURFACEDESC

;lock backbuffer mem and write
  push 0                         ;not implemented in DX yet
  push DDLOCK_WAIT               ;wait until we can write to the surface
  push offset SurfaceDescription ;structure receiving data of locked mem
  push 0                         ; 0 = lock entire surface
 DXfunction_ OurBackbufferSurface, DDSLOCK
 or eax,eax ;error ? (normally the surface is lost, otherwise sth. fucked up)
 jz islocked
  DXfunction_ OurPrimarySurface, DDSRESTORE
  jmp nolockedsurface
 islocked:

;writing to the back buffer:
;note that each horizontal line of the surface can be longer than
;the length of the mode. The additional bytes should not be used.
;the entire length of a line in bytes is called Pitch.

pusha
   mov edi,[SurfaceDescription.lpSurface]
   mov ebp,[SurfaceDescription.lPitch]
   sub ebp,640*4 ;get additional pitch bytes
   mov esi,[mempos]
   mov eax,480

   copyloop:
   mov ecx,640
    rep movsd
   add edi,ebp
   dec eax
   jnz copyloop
popa

;unlocking the buffer

push 0 ;entire surface was locked
DXfunction_ OurBackbufferSurface, DDSUNLOCK
or eax,eax
jnz nolockedsurface

call flippage ;flip the buffers/surfaces, waitretrace as well

;clear old sprite
mov ecx,[sunpos]
shr ecx,24
sub ecx,128
imul ecx,640
sar ecx,8 ;* 230/256 ; ecx=x
mov ebx,ecx
add ebx,256+32
imul ecx,ecx
shr ecx,10
add ecx,120 ; ecx=y
imul ecx,640
add ebx,ecx
shl ebx,2 ;start of old sprite
mov esi,(640*480*4) ;background
add esi,ebx

call redrawbackground

;draw new sprite
mov eax,[addpos]
add [sunpos],eax
mov ecx,[sunpos]
shr ecx,24
sub ecx,128
imul ecx,640
sar ecx,8 ;* 230/256 ; ecx=x
mov ebx,ecx
add ebx,256+32
imul ecx,ecx
shr ecx,10 ; ecx=y
add ecx,120
 mov eax,ecx
imul ecx,640
add ebx,ecx
shl ebx,2 ;start of sprite
mov esi,(640*480*4)*2 ;1st sprite
 
cmp eax,204
jae nosunsprite
cmp eax,204-64
jb sunnoclip
 mov ecx,204
 sub ecx,eax
 shl ecx,6
jmp sunclip
sunnoclip:
mov ecx,64*64
sunclip:
 call drawsprite
nosunsprite:

nolockedsurface:

ret
