;*** Entry for HC#10
;    Ruud (who really had fun with this compo)
;
; Credits for : Adok, for making this compo possible
;               TAD and Claw for their advice, the sample and debugger etc
;               and the fun I had exchanging mails with them..
;               All other people who made this compo worth while..

by  EQU <BYTE PTR>
wo  EQU <WORD PTR>
dwo EQU <DWORD PTR>
off EQU <OFFSET DS:>

                    ;*** Text macro, all chars - 30h..

xText               MACRO     string
IRPC a, <string>
     db '&a'-30h
ENDM
                    ENDM

SALC                MACRO
                    db        0d6h
                    ENDM

                    .MODEL    TINY
                    .386
                    LOCALS

                    .CODE
                    ORG       100h

S:                  xchg      ax,cx
                    mov       al,13h
                    int       10h                 ;Video mode 13h
                    mov       di,si               ;Di at field table
                    mov       ah,3ch
                    mov       dx,off szKeys
                    int       21h
                    xchg      ax,bx
                    pusha
                    push      0a2b9h

InitTable:          stosb                         ;Table byte
                    sub       al,3
                    and       al,0fh              ;keep low nibble
                    jne       InitTable
                    mov       bl,81h

                    pop       es                  ;Border segment for di=110h

Square:             cwd                           ;dx=0, ah always < 80h
                    mov       bp,-141h            ;-screen line size -1
Sq0:                not       bp                  ;-(bp+1) 1th down, bp=320
Sq1:                rol       by [si+bDigTbl],1   ;Prepare for next line
                    SALC                          ;0->line, ff->no line
                    and       al,es:[di]          ;0->line, color->background
                    shl       bh,1                ;CY --> 7 high
                    adc       cl,bl
                    jns       Sq3
                    mov       al,7
Sq2:                stosb
                    dec       di
Sq3:                add       di,bp               ;up, down, left or right
                    loop      Sq2                 ;Finish line
                    dec       bp
                    xchg      dx,bp               ;Swap direction x,y
                    jnz       Sq0                 ;All lines of one square
                    inc       bp                  ;Second up, bp= -320
                    dec       bx                  ;f006 / 5 or 80h
                    js        Sq1                 ;Two squares for digit
                    jpe       DrawDigit

                    popa
                    inc       cx                  ;Need cx=1

                    ;*** Main loop, draw digits, make and check move
                    ;    wait for key etc.

MainLoop:           mov       dl,5eh              ;15eh = 320+30
                    pusha
                    
                    ;*** Thanx to TAD's email, I now use a table to find
                    ;    the co-ordinate adder !! Thanx TAD, saved 2 bytes !!
                    ;    and opens a new area to optimize !!

                    xchg      ax,bx               ;Converted key
                    mov       bl,[si+bx+Tab-S-0fch] ;Translate to address
                    lea       bp,[bx+di-34h]      ;Bp at new hole position
                    xor       di,bp               ;Bit difference
                    dec       di
                    and       di,14h              ;Check move 
                    jnz       DrawCels            ;>> illegal move
                    
                    xchg      ch,[bp+di]          ;New hole is 0 !! (di=0)
                    pop       di                  ;Old hole address
                    push      bp                  ;New hole address
                    xchg      ch,[di]             ;Value that fills the hole
                    mov       bl,off (bMoves-S-1) ;BCD counter offset for bx

Inc:                cmp       [bx+si],dl          ;Is it still text ??
                    SALC                          ;0 for text ff for digit
                    and       al,[bx+si]          ;Get digit value, 0=new
                    inc       ax                  ;Digit ++
                    aaa                           ;BCD counter !!
                    mov       [bx+si],al
                    dec       bx
                    jc        Inc                 ;Loop if not done

DrawCels:           mov       bp,0a2d7h
NextCel:            mov       di,2551h

                    ;*** Claw made me aware that it might be better to use
                    ;    a segment counter instead of recalculating it..
                    ;    Still not so sure about that but I use it anyway.
                    ;    Thanx Peter

                    inc       bp
                    aaa
                    inc       bp
                    jnc       @@NoRow
                    add       bp,278h
@@NoRow:            mov       es,bp
                    lodsb                         ;Color of background
l001:               mov       cl,30               ;30 dots wide plane
                    rep stosb                     ;Stuff a line
                    sub       di,dx               ;Line up, CY --> no more
                    jnb       l001                ;Fill the plane
                              
                    mov       di,129eh-0ah        ;Offset of left digit
                    aam
                    pusha

DrawDigit:          xchg      al,ah
                    movzx     si,al
                    add       di,0ah              ;At proper digit
                    mov       bx,0af07h           ;Bh=Mask, Bl=seg size 7
                    jpo       Square              ;parity odd for right digit
                    popa
                    cmpsb
                    dec       si
                    adc       bh,10h              ;Zero after 10h, if win !
                    jnc       NextCel             ;All 10h cels

                    popa                          ;All registers back
                    jz        IsExit              ;>> Exit, winning field

KeyLoop:            int       16h                 ;Ah still 0
                    dec       si
                    mov       [si],al             ;Key at 0ffh
                    mov       dx,si
                    mov       ah,40h
                    int       21h                 ;Write the key
                    lodsb                         ;Restore key, ah=0 !
                    inc       dx
                    ror       al,1                ;So odd is big enough
                    add       al,0e3h             ;Convert key.
                    cmp       al,0fch             ;NC for valid key
                    jnc       MainLoop            ;>> Bad key
                    cmp       al,0f3h
                    jne       KeyLoop             ;>> No space bar
                    mov       dl,off (bTxtQuit-S) xor ((bTxtWin-S) xor 5eh)

IsExit:             mov       al,3                ;Ah still 0
                    int       10h                 ;Mode 3
                    xchg      ax,dx               ;Need pointer in ax
                    xor       al,off (bTxtWin-S) xor 5eh
ls0:                xchg      ax,si               ;Need pointer in si
ls1:                js        ls2                 ;S-->not valid, "keys"
                    int       29h                 ;Show a char
ls2:                lodsb                         ;Get char - 30h
                    add       al,30h              ;S->"keys", convert bcd
                    jg        ls1                 ;Entire string
                    jnz       ls0                 ;>> After xx moves
                    ret

bTxtWin:            xText     <Winning field>     ;Winning field text
                    db        bTxtAfter-S-30h     ;End of this text

bTxtQuit:           xText     <You have quit>     ;Followed by (chosen) = 8bh
                    db        bTxtAfter-S-30h

bTxtAfter:          xText     < after >           ;After text
szKeys:             db        'keys',0            ;Unscrambled text
bMoves:             xText     < moves>            ;Moves text
                    db        0dh-30h,0ah-30h,-30h ;0dh,0ah, quit

bDigTbl             db        00010001b           ;'0'
                    db        01110111b           ;'1'
                    db        10000010b           ;'2'
                    db        00100010b           ;'3'
                    db        01100100b           ;'4'
                    db        00101000b           ;'5'
                    db        00001000b           ;'6'
                    db        01110001b           ;'7'
                    db        00000000b           ;'8'
Tab:                db        00110000b           ;'9' -4+34h
                    db        +1+34h
                    db        -1+34h
                    db        +4+34h

                    END       S


