import java.awt.*;
import java.awt.event.*;
import java.awt.Graphics;
import java.applet.*;
import java.lang.*;

public class AppletLoader extends Applet implements KeyListener {

Container tempContainer;
Frame myFrame;
Window myWindow;
int ScreenWidth,ScreenHeight;
Applet myApplet;

public void init(){

// find a frame to create window from
tempContainer=this;
do{
	try{
		tempContainer=tempContainer.getParent();
	}
	catch (NullPointerException e){
		// couldn't find a frame to create window from
                //  so make one
		tempContainer=new Frame();
                tempContainer.setBounds(0,0,0,0);
		tempContainer.setVisible(true);
		break;
	}
} while(!(tempContainer instanceof Frame));
myFrame=(Frame)tempContainer;

// create a borderless window
myWindow=new Window(myFrame);

// get the screen size
ScreenWidth=myWindow.getToolkit().getScreenSize().width;
ScreenHeight=myWindow.getToolkit().getScreenSize().height;

// set window to full screen
myWindow.setLocation(0,0);
myWindow.setSize(ScreenWidth,ScreenHeight);

// have a black window
myWindow.setBackground(Color.black);

// handle keypresses
myWindow.addKeyListener(this);

// construct the demo applet
myApplet=new DemoApplet(this);
myApplet.setSize(640,480);

// show the window
myWindow.setVisible(true);

// add the demo applet to the window
myWindow.setLayout(new BorderLayout());
myWindow.add(myApplet);

myApplet.init();

// put demo in centre of window
myApplet.setBounds(ScreenWidth/2-640/2,ScreenHeight/2-480/2,640,480);

}

public void start(){
//
// start the demo running
//

// show the window and make sure its active
myWindow.setVisible(true);
myWindow.toFront();
myWindow.requestFocus();

// put demo in centre of window
myApplet.setBounds(ScreenWidth/2-640/2,ScreenHeight/2-480/2,640,480);

myApplet.start();
}

public void stop(){
//
// stop the demo running
//

myApplet.stop();
// hide the window
myWindow.setVisible(false);
}

public void destroy(){
myApplet.destroy();
}

public void paint(Graphics g){
// fill applet with black
g.setColor(Color.black);
g.fillRect(0,0,this.getSize().width,this.getSize().height);

g.setColor(Color.green);
g.drawString("It's in another window",20,20);
}

public void keyTyped(KeyEvent e){
}

public void keyPressed(KeyEvent e){
// stop demo when escape pressed
if(e.getKeyCode()==KeyEvent.VK_ESCAPE) stop();
}

public void keyReleased(KeyEvent e){
}

}
