		ideal
		p386
		model	large,pascal

TESTLAST	=	0

TESTPAL		=	0
USUALVGA2	=	1

; SETVGA.ASM
extrn		set_vga_mode : far,\	; Initialize very complex X mode
		set_vga_page : far	; AL-number of page to visualize

; FASTFX.ASM
extrn		set_fast_fx : far,\
		draw_fast_fx : far,\
		next_fast_fx : far

; FLAME.ASM
extrn		set_flame_palette : far,\
		make_flame : far,\
		wait_vr : far,\
		start_flame_fade : far,\
		fade_to_flame : far,\
		fade_to_black : far,\
		get_fade_pal_ptr : far

; SHADEBOB.ASM
extrn		init_shadebob : far,\
		set_bob_traectory : far,\
		put_shadebob : far

; ROT.ASM
extrn		set_rotate_texture : far,\
		set_rotate_params : far,\
		set_rotate_center : far,\
		rot_draw_page : far,\
		rot_draw_column : far

; External images
extrn		_rot_image0 : far,\	; Binary image to rotate
		_rot_image0pal : far	; And its palette.

; External text image
extrn		HI_TEXT : far

		codeseg

; -- entry -----------------------------------------------------
;
		udataseg
old_vga_mode	db	?
		codeseg
proc		entry
	cld
	mov	ax,DGROUP
	mov	ds,ax
	mov	es,ax
	mov	ah,0fh
	int	10h
	mov	[old_vga_mode],al
	call	do_demo
	mov	al,[old_vga_mode]
	mov	ah,0
	push	ax
	int	10h
	pop	ax
	cmp	al,7
	mov	ax,0b800h
	jne	@@1
	mov	ah,0b0h
@@1:
	call	put_end_text
	mov	ax,4c00h
	int	21h
endp		entry
; -- put_end_text ----------------------------------------------
;
proc		put_end_text	near
	push	ds es
	mov	es,ax
	mov	ax,SEG HI_TEXT
	mov	ds,ax
	mov	si,offset HI_TEXT
	xor	di,di
	mov	cx,4000/4
	rep	movsd
	mov	dx,23*256
	xor	bx,bx
	mov	ah,2
	int	10h
	pop	es ds
	ret
endp		put_end_text

; -- do_demo ---------------------------------------------------
;
proc		do_demo	near
	mov	ax,13h
	int	10h
	mov	dx,03dah
	in	al,dx
	mov	dl,0c8h
	mov	al,0
	out	dx,al
	inc	dx
	mov	cx,300h
@@clrloop:
	out	dx,al
	loop	@@clrloop
IF	TESTLAST eq 0
	call	do_rotation
	call	demo_shadebob
ENDIF
	call	demo_running_figures
	ret
endp		do_demo

; **************************************************************

; -- sb_traect -------------------------------------------------
;
BOBXRAD		=	290/2
BOBYRAD		=	170/2
		udataseg
bob_time	dw	?
		codeseg
label		sine_table	word
include	"sinetbl.inc"
proc		sb_traect	far
	mov	si,[bob_time]
	shr	si,1
	imul	di,si,4*2
	and	di,(_TWOPI-1)*2
	movsx	eax,[di+sine_table]
	mov	edx,BOBXRAD
	imul	edx
	sar	eax,_FRACBITS
	add	ax,160-8	; Center coords without a half of bob
	push	ax	; Got X coordinate
	imul	di,si,5*2
	sub	di,_TWOPI/4*2
	neg	di
	and	di,(_TWOPI-1)*2
	movsx	eax,[di+sine_table]
	mov	edx,BOBYRAD
	imul	edx
	sar	eax,_FRACBITS
	add	eax,100-8	; Center w/o half of bob
	mov	bx,ax
	pop	ax
	add	[bob_time],3;_TWOPI/320
	or	ax,ax
	ret
endp		sb_traect
; -- sb_traect0 ------------------------------------------------
;
proc		sb_traect0	far
	mov	si,[bob_time]
	shr	si,1
	imul	di,si,12*2
	and	di,(_TWOPI-1)*2
	movsx	eax,[di+sine_table]
	mov	edx,BOBXRAD
	imul	edx
	sar	eax,_FRACBITS
	add	ax,160-8	; Center coords without a half of bob
	push	ax	; Got X coordinate
	imul	di,si,2
	sub	di,_TWOPI/4*2
	neg	di
	and	di,(_TWOPI-1)*2
	movsx	eax,[di+sine_table]
	mov	edx,BOBYRAD
	imul	edx
	sar	eax,_FRACBITS
	add	eax,100-8	; Center w/o half of bob
	mov	bx,ax
	pop	ax
	add	[bob_time],1;_TWOPI/320
	or	ax,ax
	ret
endp		sb_traect0
; -- sb_tract_line ---------------------------------------------
;
		udataseg
sbstartx	dw	?
sbendx		dw	?
sbstarty	dw	?
sbendy		dw	?
sblinelen	dw	?
sblinetime	dw	?
sblinedone	db	?
		codeseg
proc		sb_traect_line	far
	cmp	[sblinedone],1
	cmc
	jb	@@exit
	mov	bp,[sblinelen]
	mov	si,[sblinetime]
	mov	ax,[sbendy]
	mov	bx,[sbstarty]
	sub	ax,bx
	imul	si
	idiv	bp
	add	bx,ax
	mov	ax,[sbendx]
	mov	cx,[sbstartx]
	sub	ax,cx
	imul	si
	idiv	bp
	add	ax,cx
	add	si,2
	mov	[sblinetime],si
	cmp	si,bp
	jb	@@end
	mov	[sblinedone],1
@@end:
	or	ax,ax
@@exit:
	ret
endp		sb_traect_line

; -- demo_shadebob ---------------------------------------------
;
PUTBOBCOUNTER	=	72
label		lines_index	word
dw	-2,-2,-2,-2	; Wait a lot for flame
MACRO	set_startcoords	x,y
$STARTX		=	(&x)-8
$STARTY		=	(&y)-8
ENDM
MACRO	sbline	x0,y0,x1,y1
dw	$STARTX+x0,$STARTY+y0,$STARTX+x1,$STARTY+y1
ENDM
; 'H'
set_startcoords	20,10
sbline	0,0,0,80
sbline	60,0,60,80
sbline	0,40,60,40
; 'I'
set_startcoords	20+60+20,10
sbline	5,0,45,0
sbline	25,0,25,80
sbline	5,80,45,80
; '!'
set_startcoords	20+60+20+40+20*2,10
sbline	50-10,0,50+10,0
sbline	50+10,0,50,80-30
sbline	50-10,0,50,80-30
sbline	50,80-15,50,80
dw	-2
; 'T'
set_startcoords	20,100
sbline	0,0,40,0
sbline	20,0,20,80
; 'h'
set_startcoords	20+40+20,100
sbline	0,0,0,80
sbline	0,35,40,45
sbline	40,45,40,80
; 'e'
set_startcoords	20+40+20+40+20,100
MACRO	e_char
sbline	0,40,20,0
sbline	20,0,40,40
sbline	40,40,0,40
sbline	0,40,40,80
ENDM
e_char
; 'r'
set_startcoords	20+40+20+40+20+40+20,100
sbline	0,45,0,80
sbline	0,35,10,40
sbline	10,40,40,45
; 'e'
set_startcoords	20+40+20+40+20+40+20+40+20,100
e_char
dw	-2,-2,-2,-2
dw	-1	; End of lines sequence
proc		demo_shadebob	near
	call	set_flame_palette
	imul	ax,3
	shr	ax,2
	call	init_shadebob
	mov	[bob_time],0
	mov	ax,offset sb_traect
	mov	dx,cs
	call	set_bob_traectory
	push	ds
	pop	es
IF	1
@@loop0:
	mov	cx,PUTBOBCOUNTER
@@putbob:
	call	put_shadebob
	loop	@@putbob
	call	make_flame
	cmp	[bob_time],_TWOPI*2
	jb	@@loop0
	mov	ax,offset sb_traect_line
	mov	dx,cs
	call	set_bob_traectory
	xor	si,si
@@loop1:
	mov	ax,[si+lines_index]
	add	si,2
	cmp	ax,-1
	je	@@done_show
	cmp	ax,-2
	jne	@@draw_line
	mov	cx,10
@@makeflame:
	call	make_flame	; Let fire goes out
	loop	@@makeflame
	jmp	@@loop1
@@draw_line:
	mov	[sbstartx],ax
	mov	bx,[si+lines_index]
	mov	[sbstarty],bx
	mov	cx,[si+lines_index+2]
	mov	[sbendx],cx
	mov	dx,[si+lines_index+4]
	mov	[sbendy],dx
	sub	ax,dx
	sub	cx,bx
	cwd
	xor	ax,dx
	sub	ax,dx
	xchg	ax,cx
	cwd
	xor	ax,dx
	sub	ax,dx
	cmp	ax,cx
	jae	@@maxfound
	mov	ax,cx
@@maxfound:
	inc	ax
	mov	[sblinelen],ax
	mov	[sblinetime],0
	mov	[sblinedone],0
@@lineloop:
	call	put_shadebob
	cmp	[sblinedone],0
	je	@@lineloop
	add	si,6	; Remaining three coords
	jmp	@@loop1
@@done_show:
ENDIF
;	mov	ax,offset sb_traect0
;	mov	dx,cs
;	call	set_bob_traectory
;	mov	cx,PUTBOBCOUNTER*5
;@@beforefade:
;	call	put_shadebob
;	loop	@@beforefade
	call	start_flame_fade
	xor	ax,ax
@@fade:
	cmp	al,65
	cmc
	adc	ah,0
;	mov	cx,PUTBOBCOUNTER
;@@putbob0:
;	call	put_shadebob
;	loop	@@putbob0
;	call	make_flame
	call	wait_vr
	call	fade_to_flame
	add	al,2;4
	or	ah,ah
	jz	@@fade
	mov	cx,80
@@lastpause:
	call	wait_vr
	loop	@@lastpause
@@end:
	call	undraw_screen
	ret
endp		demo_shadebob
; -- undraw_screen ---------------------------------------------
;
proc		undraw_screen
	push	es
	call	get_fade_pal_ptr
	push	di
	xor	eax,eax
	mov	cx,300/4
	rep	stosw
	pop	di
	mov	ax,3f3fh
	mov	[es:di+3],ax
	mov	[es:di+3+2],al
	mov	ax,0a000h
	mov	es,ax
	mov	eax,01010101h
	mov	cx,64000/4
	rep	stosd
	mov	al,0
	call	fade_to_flame
	mov	bp,200/2-1
	xor	bx,bx
@@undrloop:
	xor	eax,eax
	mov	cx,320/4
	mov	di,bx
	rep	stosd
	mov	di,199*320
	sub	di,bx
	mov	cx,320/4
	rep	stosd
	mov	cx,3
@@wr0:
	call	wait_vr
	loop	@@wr0
	add	bx,320
	dec	bp
	jnz	@@undrloop
	mov	di,bx
	mov	cx,320/4
	xor	eax,eax
	rep	stosd
	mov	cx,200
@@wr1:
	call	wait_vr
	loop	@@wr1
	mov	bp,320/2
	xor	bx,bx
	mov	di,319
@@undrloop0:
	mov	cx,8
	cmp	bp,4
	jne	@@wr2
	imul	cx,40
@@wr2:
	call	wait_vr
	loop	@@wr2
	mov	al,0
	mov	[es:320*99+bx],al
	mov	[es:320*99+di],al
	mov	[es:320*100+bx],al
	mov	[es:320*100+di],al
	inc	bx
	dec	di
	dec	bp
	jnz	@@undrloop0
	mov	cx,400
@@wr3:
	call	wait_vr
	loop	@@wr3
	pop	es
	ret
endp		undraw_screen

; **************************************************************

; -- do_rotation -----------------------------------------------
;
RLINEBITS	=	3
		udataseg
rcurr_linesz	dw	?
rcurr_radius	dw	?
rcurr_radpause	dw	?
rcurr_zoom	dd	?
rzoom_step	dd	?
rcurr_time	dw	?
rcurr_centerx	dw	?
rcurr_centery	dw	?
rcurr_centers	db	?
rcurr_centercnt	dw	?
		codeseg
ROT_RAD		equ	[rcurr_radius];80
proc		do_rotation	near
	call	_init_rotrad
	mov	[rcurr_zoom],_FRACMUL
	mov	[rzoom_step],_FRACMUL/32
	mov	[rcurr_centercnt],80
	mov	[rcurr_centers],0
	mov	[rcurr_linesz],-1
	call	rotate_0
	ret
endp		do_rotation
; -- sqrt_fp ---------------------------------------------------
;
proc		sqrt_fp
	or	eax,eax
	jnz	@@notz
	ret
@@notz:
	mov	ecx,eax
	mov	ebx,eax
	shr	ebx,1
	REPT	16
	mov	eax,ecx
	xor	edx,edx
	shld	edx,eax,_FRACBITS
	shl	eax,_FRACBITS
	div	ebx
	add	ebx,eax
	shr	ebx,1
	ENDM
	ret
endp		sqrt_fp
; -- get_line_y_size -------------------------------------------
;
proc		get_line_y_size
	mov	ax,[rcurr_linesz]
	sar	ax,RLINEBITS
	ret
endp		get_line_y_size
; -- get_y_size ------------------------------------------------
;
proc		get_y_size	near
		udataseg
@@currysz	dw	?
		codeseg
	call	get_line_y_size
	mov	[@@currysz],ax
	movzx	eax,si
	cwd
	xor	ax,dx
	sub	ax,dx
	mov	bx,-1
	cmp	ax,ROT_RAD
	jg	@@end
	shl	eax,_FRACBITS
	jz	@@1
	sub	eax,_FRACMUL/2
@@1:
	imul	eax
	shrd	eax,edx,_FRACBITS
	mov	ebx,eax
	movzx	eax,ROT_RAD
	imul	eax
	shl	eax,_FRACBITS
	sub	eax,ebx
	call	sqrt_fp
	shr	ebx,_FRACBITS
@@end:
	cmp	bx,[@@currysz]
	jg	@@exit
	mov	bx,[@@currysz]
@@exit:
	ret
endp		get_y_size
; -- next_rzoom ------------------------------------------------
;
proc		next_rzoom	near
	mov	eax,[rzoom_step]
	add	eax,[rcurr_zoom]
	mov	[rcurr_zoom],eax
	cmp	eax,_FRACMUL*4
	jnb	@@invert
	cmp	eax,_FRACMUL/32
	ja	@@noti
@@invert:
	neg	[rzoom_step]
@@noti:
	ret
endp		next_rzoom
; -- draw_rotated_pic ------------------------------------------
;
proc		draw_rotated_pic	near
	pushad
	mov	si,-160
@@loop:
	call	get_y_size
	or	bx,bx
	jl	@@next
	mov	cx,bx
	add	cx,200/2
	sub	bx,200/2
	neg	bx
	mov	ax,si
	add	ax,320/2
	call	rot_draw_column
@@next:
	inc	si
	cmp	si,159
	jle	@@loop
	call	next_rzoom
	popad
	ret
endp		draw_rotated_pic
; -- next_rot_radius -------------------------------------------
;
proc		next_rot_radius	near
	cmp	[rcurr_linesz],(80/2) shl RLINEBITS
	jg	@@1
	inc	[rcurr_linesz]
@@1:
	cmp	ROT_RAD,80
	jb	@@inc
	dec	[rcurr_radpause]
	jg	@@exit
_init_rotrad:
	mov	ROT_RAD,5
	mov	[rcurr_radpause],80*30
	jmp	@@exit
@@inc:
	inc	ROT_RAD
@@exit:
	ret
endp		next_rot_radius
; -- next_rot_center -------------------------------------------
;
RADIUS0		=	79
RADIUS1		=	30
proc		next_rot_center	near
	movzx	ebx,[rcurr_centers]
	jmp	[ebx*2+@@steps]
@@steps	dw	@@startwait,@@feed_xcenter,@@do_circle,@@alldone
@@startwait:
	mov	[rcurr_centerx],0
	mov	[rcurr_centery],200/2+RADIUS0
	dec	[rcurr_centercnt]
	jnz	@@exit
	mov	[rcurr_centercnt],160
	jmp	@@next
@@feed_xcenter:
	inc	[rcurr_centerx]
	dec	[rcurr_centercnt]
	jnz	@@exit
	mov	[rcurr_centercnt],256*2
	jmp	@@next
@@do_circle:
	call	@@moveccircle
	dec	[rcurr_centercnt]
	jnz	@@exit
	jmp	@@next
@@alldone:
	call	@@moveccircle
	dec	[rcurr_centercnt]
	jmp	@@exit
@@next:
	inc	[rcurr_centers]
@@exit:
	mov	ax,[rcurr_centerx]
	mov	bx,[rcurr_centery]
	call	set_rotate_center
	ret
label		@@moveccircle	near	; Move center around circle
	movzx	ebx,[rcurr_centercnt]
	shl	bx,2
	mov	dx,RADIUS0
	and	bx,_TWOPI-1
	mov	ax,[ebx*2+sine_table]
	imul	dx
	shrd	ax,dx,_FRACBITS
	add	ax,320/2
	mov	[rcurr_centerx],ax
	sub	bx,_TWOPI/4
	neg	bx
	and	bx,_TWOPI-1
	mov	ax,RADIUS0
	imul	[ebx*2+sine_table]
	shrd	ax,dx,_FRACBITS
	add	ax,200/2
	mov	[rcurr_centery],ax
	retn
endp		next_rot_center
; -- rotate_0 --------------------------------------------------
;
proc		rotate_0	near
	push	es
	call	get_fade_pal_ptr
	push	ds
	mov	ax,SEG _rot_image0pal
	mov	ds,ax
	xor	si,si
	mov	cx,300h/4
	rep	movsd
	pop	ds es
	mov	al,0
	call	fade_to_flame
	mov	ax,SEG _rot_image0
	call	set_rotate_texture
	mov	ax,320/2
	mov	bx,200/2
	call	set_rotate_center
	mov	ax,0a000h
	call	rot_draw_page
	xor	bp,bp
@@mainloop:
	call	wait_vr
	movzx	ebx,[rcurr_time]
	and	bx,_TWOPI-1
	movsx	eax,[sine_table+ebx*2]
	sub	bx,_TWOPI/4
	neg	bx
	and	bx,_TWOPI-1
	movsx	ebx,[sine_table+ebx*2]
	mov	ecx,[rcurr_zoom]
	call	set_rotate_params
	call	draw_rotated_pic
	add	[rcurr_time],9
	call	next_rot_radius
	call	next_rot_center
	cmp	[rcurr_centers],3
	je	@@done
	in	al,60h
	cmp	al,1
	jne	@@mainloop
	mov	ah,0
	int	16h
@@done:
	xor	ax,ax
@@loop:
	cmp	al,64
	sbb	ah,ah
	push	ax
	call	wait_vr
	call	fade_to_flame
	movzx	ebx,[rcurr_time]
	and	bx,_TWOPI-1
	movsx	eax,[sine_table+ebx*2]
	sub	bx,_TWOPI/4
	neg	bx
	and	bx,_TWOPI-1
	movsx	ebx,[sine_table+ebx*2]
	mov	ecx,[rcurr_zoom]
	call	set_rotate_params
	call	draw_rotated_pic
	add	[rcurr_time],9
	call	next_rot_radius
	call	next_rot_center
	pop	ax
	add	al,2
	or	ah,ah
	jnz	@@loop
	push	es
	mov	ax,0a000h
	mov	es,ax
	xor	di,di
	xor	eax,eax
	mov	cx,64000/4
	rep	stosd
	pop	es
	ret
endp		rotate_0

; **************************************************************

; -- construct_fx_palette --------------------------------------
;
proc		construct_fx_palette	near
	push	es
	call	get_fade_pal_ptr
	push	di
	xor	eax,eax
	mov	cx,300h/4
	rep	stosd
	pop	di
	xor	bx,bx
	call	@@storepal
	mov	al,3fh
	call	@@storepal
	xchg	al,ah
	call	@@storepal
	xchg	ah,bl
	call	@@storepal
	mov	al,3fh
	call	@@storepal
	xchg	al,ah
	call	@@storepal
	shr	ah,1
	shr	bl,1
	call	@@storepal
	shr	ax,1
	mov	al,3fh/2
	shr	bl,1
	call	@@storepal
	mov	ax,03f3fh
	mov	bl,al
	call	@@storepal
	pop	es
	mov	al,0
	call	fade_to_black
	ret
label		@@storepal	near
	stosw
	xchg	ax,bx
	stosb
	xchg	ax,bx
	retn
endp		construct_fx_palette

; -- demo_running_figures --------------------------------------
;
proc		demo_running_figures	near
IF	USUALVGA2
	call	set_vga_mode
ENDIF
	call	construct_fx_palette
	call	set_fast_fx
IF	TESTLAST eq 0
	mov	ebp,2520
ELSE
	mov	ebp,10000
ENDIF
	mov	al,64
@@loop0:
	cmp	al,80h
	sbb	ah,ah
	and	al,ah
	push	ax
	call	wait_vr
	call	fade_to_black
IF	USUALVGA2
	mov	ax,bp
	and	ax,1
	call	set_vga_page
ELSE
	mov	ax,0a000h
ENDIF
	call	draw_fast_fx
	call	next_fast_fx
	dec	ebp
	pop	ax
	sub	al,4
	or	ah,ah
	jnz	@@loop0
@@loop:
	mov	ax,bp
	and	ax,1
	call	wait_vr
IF	USUALVGA2
	call	set_vga_page	; RET:AX-address of 
ELSE
	mov	ax,0a000h
ENDIF
	call	draw_fast_fx
	call	next_fast_fx
	dec	ebp
	jz	@@end
	in	al,60h
	cmp	al,1
	jnz	@@loop
	mov	ah,0
	int	16h
@@end:
	xor	ax,ax
@@fadeloop0:
	cmp	al,64
	sbb	ah,ah
	push	ax
	call	wait_vr
	call	fade_to_black
IF	USUALVGA2
	mov	ax,bp
	and	ax,1
	call	set_vga_page
ELSE
	mov	ax,0a000h
ENDIF
	call	draw_fast_fx
	call	next_fast_fx
	dec	ebp
	pop	ax
	add	al,2
	or	ah,ah
	jnz	@@fadeloop0
	ret
endp		demo_running_figures

		stack	1024

		end	entry
