#ifndef _VL_MAIN_H_
#define _VL_MAIN_H_
// -----------------------------------------------------------------------------
//
//      Mimic Engine
//      Copyright (C) 1997-1999 by Maciej Sinilo
//
//      MODULE  : VL_MAIN.H - Vector Library main header
//      CREATED : 24-03-99
//
// -----------------------------------------------------------------------------


#include <math.h>
#include <iostream.h>

//
// Define VL_ROW_ORIENT if you wanna your matrices to be row-oriented (I
// prefer this fashion, so column-oriented code is untested and may be buggy)
//



// __forceinline with MSVC?
#define VL_INL inline

// VL_DOUBLE_PREC defined = use doubles in Vector Library
// else - use floats (single precision) --> more than enough for me.
#ifdef VL_DOUBLE_PREC

#define vl_real double
#define VL_ZERO 0.0
#define VL_ONE  1.0
#define VL_HALF 0.5
#define VL_TWO  2.0

#else

#define vl_real float
#define VL_ZERO 0.0f
#define VL_ONE  1.0f
#define VL_HALF 0.5f
#define VL_TWO  2.0f

#endif  // VL_DOUBLE_PREC

#define VL_PI           3.14159265358979324
#define VL_TWOPI        6.28318530717958648
#define VL_EPSILON      (1E-3)

// Automatic conversions etc.
// Idea taken from PLIB by Steve Baker.
VL_INL vl_real vlSqrt(vl_real x)        { return sqrt(x); }
VL_INL vl_real vlSquare(vl_real x)      { return (x * x); }
VL_INL vl_real vlAbs(vl_real x)         { return ((x < VL_ZERO) ? -x : x); }
VL_INL int vlTolComp(vl_real a, vl_real b, vl_real tol)
{
        if ((a + tol) < b)      return -1;
        if ((b + tol) < a)      return 1;
        return 0;
}

// Enumerations
enum vlAxis { VL_AXIS_X, VL_AXIS_Y, VL_AXIS_Z, VL_AXIS_W };
enum { VL_X, VL_Y, VL_Z, VL_W };

#define SELF    (*this)

// Define all classes used in Vector Library
class vlVec2;
class vlPnt2;
class vlVec3;
class vlPnt3;
class vlVec4;
class vlPnt4;
class vlMatrix4;

// Fences
//class vlSphere;
//class vlBox;



// If compiler doesn't support bool type - use our own
#ifndef VL_COMPILER_BOOL
typedef int             bool;
#undef true
#undef false
#define true            1
#define false           0
#endif  // !_VL_COMPILER_BOOL


// -----------------------------------------------------------------------------
//      VL_MAIN - HEADER END
// -----------------------------------------------------------------------------
#endif  // !_VL_MAIN_H_

