#ifndef _VL_VP_H_
#define _VL_VP_H_
// -----------------------------------------------------------------------------
//
//      Mimic Engine
//      Copyright (C) 1997-1999 by Maciej Sinilo
//
//      MODULE  : VL_VP.H - Vector Processor class, basic interface
//      CREATED : 24-03-99
//
// -----------------------------------------------------------------------------

#include "vl_main.h"


// --- CLASS DEFINITION --------------------------------------------------------
//
// Vector Processor class -- main task of this class is to speed-up
// all vector operations. You can derive your own vector processors from
// this one and overload Transform_XXX methods with system-specific code
// (for example hand-optimized assembly code or special codes for 3DNow!
// technology).
// Note: I decided to use different names for transform methods, although
// it would be possible to give them all the same name. Why? Because I
// think the code is more readable that way. You see something like:
// pVP->Transform_P34(a, b, c, d) and you know that you are transforming
// 3D points into homogenous (4D) space (with one method name you would
// have to check the types of arguments). What's more - that way the
// compiler will take carea about arguments and it won't let the user
// to send pointer to vlVec4 to Transform_P34 method.
// The default implementation just works and nothing more, it isn't
// optimized in any way, only pure C++ code, so overload it if only
// it's possible!
//
class vlVectorProcessor
{
public:
        vlVectorProcessor() { }
        virtual ~vlVectorProcessor() { }

        virtual void Transform_V33(const vlMatrix4& transform,
                        const vlVec3 *pInput, vlVec3* pOutput, int count) const;
        virtual void Transform_P33(const vlMatrix4& transform,
                        const vlPnt3* pInput, vlPnt3* pOutput, int count) const;
        virtual void Transform_P44(const vlMatrix4& transform,
                        const vlPnt4* pInput, vlPnt4* pOutput, int count) const;
        virtual void Transform_P34(const vlMatrix4& transform,
                        const vlPnt3* pInput, vlPnt4* pOutput, int count) const;
};


// -----------------------------------------------------------------------------
//      VL_VP.H - HEADER END
// -----------------------------------------------------------------------------
#endif  // !_VL_VP_H_

