//
//          ,  .
//  ,s;`         ',
//.$$'              .
// S,
//     ` ~ ~  ~  ~~"s.
//.ss,               $SS,    h     i     n     e
//'$$$,             ,$$'
// `$$,.         .,$$`
//    `"+ , . , +"`
//
//
// _______________________________________________________________________________________
//
// This file was last changed on     : 2000-11-09
// Revision (please increase number) : A3
// (Only increase A if it's not backwards complient.)
// _______________________________________________________________________________________
//
// Description:
//   
//  This is the file that handles User Input.
//  It also has the WinMain() - function.
//
//  [2000-11-29] Version fix
//  [2000-11-30] Fixed by Otis

#include <stdlib.h>
#include <shlobj.h>
#include <tchar.h>
#include <process.h>

#include "..\misc\resource.h"

#include "sgdi.h"
#include "sfont.h"
#include "sbase.h"
#include "sversion.h"

// [OTIS] Application instance global var. I dumped it here, but obviously it should be stored somewhere....
// ermm... where the other global vars should be stored too ;)
HINSTANCE	m_ghAppInstance;

// Data library.
shineLibrary* gpoLibrary;

// The current article
shineArticle* Article = NULL;

// Help font
shineFont* gHelpFont;

// Are we viewing the help or an article?
bool ViewHelp = false;

// Y Position of the current article.
int yScroll = 0;

// History for articles, when pressing the right mousebutton.
int  NumHistoryFiles = 0;
char shineCurrentFile[100][256];
int  shineCurrentScroll[100];

// Mouse Cursors
HCURSOR hCursorRegular;
HCURSOR hCursorArticleLink;

int init = 1;

// Should the article be able to scroll
int ScrollArticle = 1;

// Exit shine.
int end = 0;

// Link to follow
shineLink* poLink;

// How much to scroll 
const int scrollVal = 20;

// If you are at the bottom, or top of the screen, chances are that you wont be able to scroll 'scrollVal'.
int RealScrollVal;

// Pressed Key
int key = 0;

// Default window size
const int cStartWidth = 1024;
const int cStartHeight = 768;

//________________________________________________________________________________________________________________________________________________________________________

int TraceLevel = cFatErr;

//________________________________________________________________________________________________________________________________________________________________________

void shineLog( void* nullptr, int Level, char* format, ... )
{
	return;
}

void shineLog( int row, char* sourceFile, int Level, char* format, ... )
{
	return;
	static char string[10000];
	static char finalString[10000];
	static char priority[100];

	switch( Level )
	{
		case 0:
			sprintf( priority, "Fatal Error:" );
			break;
		case 1:
			sprintf( priority, "High Priority Error:" );
			break;
		case 2:
			sprintf( priority, "Message:" );
			break;
		case 3:
			sprintf( priority, "Debug:" );
			break;
		case 4:
			sprintf( priority, "HighlevelDebug" );
			break;
		case 5:
			sprintf( priority, "SuperDebug:" );
			break;
	}

	FILE* f;

	va_list va;

	va_start( va, format );
	vsprintf( string, format, va );
	va_end( va );

	if( Level <= 1 )
	{
		MessageBox( NULL, string, "Shine Error", MB_OK );
	}
	else
	{

		if ( 0 == log )
			return;

		if ( Level > TraceLevel )
			return;

		f = fopen( "shine.log", "at" );

		if ( f )
		{
			fprintf( f, "%s %s (%d) : %s\n", priority, sourceFile, row, string );
			fclose( f );
		}
	}
}

//________________________________________________________________________________________________________________________________________________________________________

void shineLogEnable()
{
	log = 1;
}

//________________________________________________________________________________________________________________________________________________________________________

void shineLogDisable()
{
	log = 0;
}

//________________________________________________________________________________________________________________________________________________________________________

void reloadArticle( )
{
	static char string[256];
	sprintf( string, "SHINE rel %s - [%s]", cStringVersion, shineCurrentFile[NumHistoryFiles-1] );
	sgdiSetTitle( string );

	delete Article;
	ScrollArticle = 1;
	Article = new shineArticle();

	Article->setLibrary( gpoLibrary );
	Article->load( shineCurrentFile[NumHistoryFiles-1] );
	//Article->draw( 0,0, xres, yres, dc, yScroll, 0 );
	Article->draw( 0,0, sgdiGetXRes(), sgdiGetYRes(), sgdiGetDc(), yScroll, 0 );
}

//________________________________________________________________________________________________________________________________________________________________________

void FollowLink( char* filename, int automatic )
{
	// Load new article, load new music, set volume etc..

	SHELLEXECUTEINFO si;
	
	char workingDirectory[_MAX_PATH];
	char drive[_MAX_DRIVE];
	char dir[_MAX_DIR];
	char FileName[_MAX_FNAME]; // not used
	char Ext[_MAX_EXT]; // not used

	_splitpath( filename, drive, dir, FileName, Ext );
	strcpy( workingDirectory, drive );
	strcat( workingDirectory, dir );

	if( stricmp( Ext, ".shn" ) == 0 )
	{
		if( '%' != filename[0] )
		{
			shineCurrentScroll[NumHistoryFiles] = yScroll;
			strcpy( shineCurrentFile[NumHistoryFiles++], filename );
		}
		else
		{
			strcpy( shineCurrentFile[NumHistoryFiles-1], filename+1 );
		}
		yScroll = 0;
		reloadArticle();
	}
	else if( stricmp( Ext, ".s3m" ) == 0 || stricmp( Ext, ".it" ) == 0 || stricmp( Ext, ".xm" ) == 0 || stricmp( Ext, ".mod" ) == 0 || stricmp( Ext, ".mp3" ) == 0 )
	{
		Article->musicLoad( filename );
	}
	else if( '@' == FileName[0] )
	{
		// Internal function call

		if( 0 == stricmp( FileName, "@StopMusic" ) )
		{
			Article->musicStop();
		}

		if( 0 == stricmp( FileName, "@StartMusic" ) )
		{
			Article->musicResume();
		}

		if( 0 == stricmp( FileName, "@ResetVolume" ) )
		{
			Article->volumeSet( 50 );
		}

		if( 0 == stricmp( FileName, "@MuteVolume" ) )
		{
			Article->volumeSet( 0 );
		}

		if( 0 == stricmp( FileName, "@IncVolume" ) )
		{
			Article->volumeInc();
		}

		if( 0 == stricmp( FileName, "@DecVolume" ) )
		{
			Article->volumeDec();
		}

		if( 0 == stricmp( FileName, "@IncFontSize" ) )
		{
			fontZoom*=1.3f;
			reloadArticle();
		}

		if( 0 == stricmp( FileName, "@DecFontSize" ) )
		{
			fontZoom/=1.3f;
			reloadArticle();
		}

		if( 0 == stricmp( FileName, "@Debug0" ) )
		{
			TraceLevel = 0;
		}

		if( 0 == stricmp( FileName, "@Debug1" ) )
		{
			TraceLevel = 1;
		}

		if( 0 == stricmp( FileName, "@Debug2" ) )
		{
			TraceLevel = 2;
		}

		if( 0 == stricmp( FileName, "@Debug3" ) )
		{
			TraceLevel = 3;
		}

		if( 0 == stricmp( FileName, "@Debug4" ) )
		{
			TraceLevel = 4;
		}

		if( 0 == stricmp( FileName, "@Debug5" ) )
		{
			TraceLevel = 5;
		}

	}
	else
	{
		ZeroMemory(&si, sizeof(si));
		si.cbSize = sizeof(SHELLEXECUTEINFO);

		if(stricmp( Ext, ".lnk" ) == 0)
			si.lpDirectory = NULL;
		else
			si.lpDirectory = workingDirectory;
			
		si.lpVerb = NULL;
		si.nShow = 1;
		si.fMask = SEE_MASK_DOENVSUBST;
		si.lpFile = filename;
		si.lpParameters = NULL;
		ShellExecuteEx(&si);
	}
}

//________________________________________________________________________________________________________________________________________________________________________

void ScrollUp( int scroll )
{
	if ( yScroll == 0 )
	{
		return;
	}

	yScroll -= scroll;
	if ( 0 > yScroll )
	{
		scroll -= yScroll;
		yScroll = 0;
		Article->draw( 0,0, sgdiGetXRes(), sgdiGetYRes(), sgdiGetDc(), yScroll, 0 );
	}
	else
	{
		if( 1 == ScrollArticle )
		{
			sgdiScroll( scroll );
		}
		Article->draw( 0,0, sgdiGetXRes(), sgdiGetYRes(), sgdiGetDc(), yScroll, -scroll );
	}

}

//________________________________________________________________________________________________________________________________________________________________________

void ScrollDown( int scroll )
{
	if( yScroll == Article->getHeight() )
	{
		return;
	}

	if( 0 > Article->getHeight() )
	{
		return;
	}

	yScroll += scroll;
	if ( Article->getHeight() <= yScroll )
	{
		scroll = Article->getHeight() - yScroll;
		yScroll = Article->getHeight();
		Article->draw( 0,0, sgdiGetXRes(), sgdiGetYRes(), sgdiGetDc(), yScroll, 0 );
	}
	else
	{
		if( 1 == ScrollArticle )
		{
			sgdiScroll( -scroll );
		}
		Article->draw( 0,0, sgdiGetXRes(), sgdiGetYRes(), sgdiGetDc(), yScroll, scroll );
	}
}

//________________________________________________________________________________________________________________________________________________________________________

void DrawHelp()
{
	sgdiClear( RGB( 40,40,40 ) );
	shineFont* gHelpFont = new shineFont();
	static char string[1024];

	gHelpFont->setFace( "Arial", 140, 160, 400, false, false );
	gHelpFont->drawText( (char*)cStringVersion, 40,40, RGB( 65,60,60 ), sgdiGetDc() );

	//gHelpFont->setFace( "Arial", 40, 60, 400, false, false );
	//gHelpFont->drawText( "SHINE",        40,40, RGB( 40,40,40 ), sgdiGetDc() );

	gHelpFont->setFace( "Arial", 12, 16, 800, false, false );
	gHelpFont->drawText( "shineHelp", 50,50, RGB( 255,255,200 ), sgdiGetDc() );

	gHelpFont->setFace( "Arial", 8, 12, 400, false, false );
	gHelpFont->drawText( "Whats new?", 50, 80, RGB( 255,255,200 ), sgdiGetDc() );
	  gHelpFont->drawText( "A2",         50,90, RGB( 255,255,200 ), sgdiGetDc() );
	  gHelpFont->drawText( " White background bugfix. Thanks to Otis and Mikko Mononen", 70,100, RGB( 255,255,200 ), sgdiGetDc() );
	  gHelpFont->drawText( "A3",         50,120, RGB( 255,255,200 ), sgdiGetDc() );
	  gHelpFont->drawText( " This help",70,130, RGB( 255,255,200 ), sgdiGetDc() );
	  gHelpFont->drawText( " Additional fixes by Otis",70,140, RGB( 255,255,200 ), sgdiGetDc() );


	sprintf( string, "Release: %s Version %2.2f | Maincode by Baloo, Additional bugfixes by Otis, Mikko Mononen and Plek", cStringVersion, cVersion );
	gHelpFont->drawText( string, 10, 10, RGB( 100,100,100 ), sgdiGetDc() );
	gHelpFont->drawText( "http://shine.scene.org", 10, 20, RGB( 100,100,100 ), sgdiGetDc() );

}

//________________________________________________________________________________________________________________________________________________________________________

void InitHelp()
{
	// Delete article (To be loaded again)
	sgdiSetTitle( "shineHelp" );

	delete Article;
	ViewHelp = true;
	DrawHelp();
}

//________________________________________________________________________________________________________________________________________________________________________

void CloseHelp()
{
	// Cleanup
	delete gHelpFont;

	// Load old article
	static char string[1024];
	sprintf( string, "Shine - (%s)", shineCurrentFile[NumHistoryFiles-1] );
	sgdiSetTitle( string );
	ScrollArticle = 1;
	Article = new shineArticle();

	Article->setLibrary( gpoLibrary );
	Article->load( shineCurrentFile[NumHistoryFiles-1] );
	Article->draw( 0,0, sgdiGetXRes(), sgdiGetYRes(), sgdiGetDc(), yScroll, 0 );
	ViewHelp = false;
}

//________________________________________________________________________________________________________________________________________________________________________

int MouseMoveScroll = 0;
int MouseYPos = 0;

void shineEvent( sgdiEvent_t sgdiEvent )
{
	if( 1 == init )
	{
		return;
	}

	switch( sgdiEvent )
	{
		case cExit:
			end = 1;
			break;
		case cWindowResized:
			if( !ViewHelp )
			{
				reloadArticle();
			}
			else
			{
				DrawHelp();
			}
			break;
		case cFocus:
			if( !ViewHelp )
			{
				Article->draw( 0,0, sgdiGetXRes(), sgdiGetYRes(), sgdiGetDc(), yScroll, 0 );
			}
			else
			{
				DrawHelp();
			}
			break;
		case cMouseMove:
			if( !ViewHelp )
			{
				if( 1 == MouseMoveScroll )
				{
					int delta = sgdiGetMouseY() - MouseYPos;
					
					if( delta < 0 )
					{
						int ys = -delta * ((Article->getHeight()+sgdiGetYRes()) / (sgdiGetYRes()-cScrollHeight-cScrollHeight));
						ScrollUp( ys );
						MouseYPos = sgdiGetMouseY();
					}
					else
					{
						int ys = delta * ((Article->getHeight()+sgdiGetYRes()) / (sgdiGetYRes()-cScrollHeight-cScrollHeight));
						ScrollDown( ys );
						MouseYPos = sgdiGetMouseY();
					}
					
					break;
				}
				else
				{
					MouseYPos = sgdiGetMouseY();
				}

				poLink = Article->checkLink( sgdiGetMouseX(), sgdiGetMouseY(), yScroll, 0 );
				if( NULL != poLink )
				{
					SetCursor( hCursorArticleLink );
				}
				else
				{
					SetCursor( hCursorRegular );
				}
			}
			break;
		case cMouseRightButton:
			if( !ViewHelp )
			{
				// Previous article or quit
				if( 2 == NumHistoryFiles )
				{
					end = 1;
				}
				else
				{
					NumHistoryFiles--;
					yScroll = shineCurrentScroll[NumHistoryFiles];
					reloadArticle();
				}
			}
			else
			{
				// We viewed the help - back
				CloseHelp();
			}
			break;
		case cMouseLeftButtonPress:
			if( !ViewHelp )
			{
				if( sgdiGetMouseX() > sgdiGetXRes()-cScrollWidth )
				{ 
					// Mouse pressed on scrollbar.
					if( sgdiGetMouseY() < cScrollHeight ) 
					{
						// Arrow up
						Article->drawScrollBar( Article->getScrollStart(), Article->getScrollEnd(), 1 );
						ScrollUp( RealScrollVal );
						Article->drawScrollBar( Article->getScrollStart(), Article->getScrollEnd(), 0 );
						break;
					}

					if( sgdiGetMouseY() > sgdiGetYRes()-cScrollHeight )
					{
						// Arrow down
						Article->drawScrollBar( Article->getScrollStart(), Article->getScrollEnd(), 2 );
						ScrollDown( RealScrollVal );
						Article->drawScrollBar( Article->getScrollStart(), Article->getScrollEnd(), 0 );
						break;
					}

					if( sgdiGetMouseY() > Article->getScrollStart() && sgdiGetMouseY() < Article->getScrollEnd() )
					{
						MouseMoveScroll = 1;
					}
					else
					{
						if( sgdiGetMouseY() < Article->getScrollStart() )
						{
							ScrollUp( sgdiGetYRes()-cBorders );
						}
						else
						{
							ScrollDown( sgdiGetYRes()-cBorders );
						}
					}
				}
			}
			break;

		case cMouseLeftButton:
			if( !ViewHelp )
			{
				// Check article links
				poLink = Article->checkLink( sgdiGetMouseX(), sgdiGetMouseY(), yScroll, 1 );
				if( NULL != poLink )
				{
					int len = strlen( poLink->getLink() );
					sgdiClearEvent();
					FollowLink( poLink->getLink(), 0 );
				}
				
				// Stop scroll on release
				MouseMoveScroll = 0;
			}
			break;
		case cKeyDown:
			key = sgdiGetKey();
			switch( key )
			{
				case 'B':
					fontZoom*=1.3f;
					if( !ViewHelp )
					{
						reloadArticle();
					}
					break;
				case 'V':
					fontZoom/=1.3f;
					if( !ViewHelp )
					{
						reloadArticle();
					}
					break;
				case VK_F1:
					InitHelp();
					break;
				case VK_F2:
					if( !ViewHelp )
					{
						Article->musicStop();
					}
					break;
				case VK_DOWN:
					if( !ViewHelp )
					{
						ScrollDown( RealScrollVal );
					}
					break;
				case VK_UP:
					if( !ViewHelp )
					{
						ScrollUp( RealScrollVal );
					}
					break;
				case VK_NEXT:
					if( !ViewHelp )
					{
						if( Article->getHeight() < 0 )
						{
							yScroll = 0;
							break;
						}
						yScroll += sgdiGetYRes()-cBorders;

						if ( Article->getHeight() < yScroll )
							yScroll = Article->getHeight();

						Article->draw( 0,0, sgdiGetXRes(), sgdiGetYRes(), sgdiGetDc(), yScroll, 0 );
					}
					break;
				case VK_PRIOR:
					if( !ViewHelp )
					{
						if( Article->getHeight() < 0 )
						{
							yScroll = 0;
							break;
						}
						yScroll -= sgdiGetYRes()-cBorders;
						if ( yScroll < 0 )
							yScroll = 0;

						Article->draw( 0,0, sgdiGetXRes(), sgdiGetYRes(), sgdiGetDc(), yScroll, 0 );
					}
					break;
				case 27:
					end = 1;
					break;
			}
			break;
		case cMouseWheel:
			if( !ViewHelp )
			{
				if( yScroll <= 0 && sgdiGetMouseWheel() > 0)
					break;

				if( yScroll >= Article->getHeight() && sgdiGetMouseWheel() < 0)
					break;

				yScroll -= sgdiGetMouseWheel()*50;
				if ( yScroll < 0 )
				{
					yScroll = 0;
					Article->draw( 0,0, sgdiGetXRes(), sgdiGetYRes(), sgdiGetDc(), yScroll, 0 );
				}
				else
				{
					if ( Article->getHeight() < yScroll )
					{
						yScroll = Article->getHeight();
						Article->draw( 0,0, sgdiGetXRes(), sgdiGetYRes(), sgdiGetDc(), yScroll, 0 );
					}
					else
					{
						if( 1 == ScrollArticle )
						{
							sgdiScroll( sgdiGetMouseWheel()*50 );
						}
						Article->draw( 0,0, sgdiGetXRes(), sgdiGetYRes(), sgdiGetDc(), yScroll, -sgdiGetMouseWheel()*50 );
					}
				}
			}
			break;
	}

	// Reset the event
	sgdiClearEvent();
}


// [OTIS] added Init system routine. Is called by WM_CREATE handler.
void shineInitSystem()
{
	gpoLibrary->openArchive( "articles.s" );
	strcpy( shineCurrentFile[NumHistoryFiles++], "main.shn" );
	Article = new shineArticle();
	Article->setLibrary( gpoLibrary );
	
	hCursorRegular     = LoadCursor( NULL, IDC_ARROW );
	hCursorArticleLink = LoadCursor( m_ghAppInstance, MAKEINTRESOURCE(IDC_CURSOR1) );

	key = 0;
	Article->load( "main.shn" );
	Article->draw( 0,0, sgdiGetXRes(), sgdiGetYRes(), sgdiGetDc(), 0, 0 );
}


//________________________________________________________________________________________________________________________________________________________________________

int APIENTRY WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpCmdLine,int nCmdShow)
{
	int				iResult;
	static char		string[1000];

	// store hinstance
	m_ghAppInstance=hInstance;

	shineLogEnable();
	gpoLibrary       = new shineLibrary();

	sprintf( string, "SHINE rel %s", cStringVersion );

	// [OTIS] Added error correction on windowcreation.
	iResult=sgdiOpen( string, cStartWidth, cStartHeight );
	if(sgdiError==iResult)
	{
		// windowcreation failed. exit
		return 1;
	}

	// [OTIS] Windowopen was ok. Dive into main pump.
	for(init=0;!end;)
	{
		sgdiWaitEvent();
	}
	
	// [OTIS] Done. Clean stuff. 
	if( !ViewHelp )
	{
		Article->musicDeInit();
		delete Article;
	}
	sgdiClose();
	gpoLibrary->closeArchive();

	return 0;
}
