//
//          ,  .
//  ,s;`         ',
//.$$'              .
// S,
//     ` ~ ~  ~  ~~"s.
//.ss,               $SS,    h     i     n     e
//'$$$,             ,$$'
// `$$,.         .,$$`
//    `"+ , . , +"`
//
//
// _______________________________________________________________________________________
//
// This file was last changed on     : 2000-11-09
// Revision (please increase number) : A1
// (Only increase A if it's not backwards complient.)
// _______________________________________________________________________________________
//
// Description:
//  This class holds both the pixel raw data and the information about an image. 
//  It also has a wrapper function for jpeglib (c) IJG.
//  This lib has to be provided by you.
//  Download IJG's Jpeg lib at: http://www.ijg.org
//
//________________________________________________________________________________________________________________________________________________________________________

#include "sbase.h"

extern "C" {
#include "..\jpeg\jpeglib.h"
};

//________________________________________________________________________________________________________________________________________________________________________

void shineImage::allocate()
{
	data = new long[xres*yres];
	updateBitmapInfo();
}

//________________________________________________________________________________________________________________________________________________________________________

void shineImage::readJPEG( FILE* infile )
{
	struct jpeg_decompress_struct cinfo;
	JSAMPARRAY buffer;
	unsigned char *row;
	int row_stride;
	long* ptr = NULL;
	struct jpeg_error_mgr jerr;

	cinfo.err = jpeg_std_error(&jerr);

	jpeg_create_decompress(&cinfo);

	jpeg_stdio_src(&cinfo, infile);
	(void) jpeg_read_header(&cinfo, TRUE);
	(void) jpeg_start_decompress(&cinfo);
	row_stride = cinfo.output_width * cinfo.output_components;
	buffer = (*cinfo.mem->alloc_sarray)((j_common_ptr) &cinfo, JPOOL_IMAGE, row_stride, 1);

	if( NULL != data )
		delete [] data;

	data = new long[cinfo.image_width*cinfo.image_height];
	row = new unsigned char[cinfo.image_width*3];
	ptr = data;

	while (cinfo.output_scanline < cinfo.output_height) 
	{
		jpeg_read_scanlines(&cinfo, &row, 1 );
		for( unsigned int length=0; length<cinfo.output_width; length++ )
		{
			ptr[length]  = row[length*3+0]<<16;
			ptr[length] |= row[length*3+1]<<8;
			ptr[length] |= row[length*3+2];
		}
		ptr += cinfo.output_width;
	}

	xres = cinfo.output_width;
	yres = cinfo.output_height;
	xsize = xres;
	ysize = yres;
	updateBitmapInfo();

	delete row;

	(void) jpeg_finish_decompress(&cinfo);
	jpeg_destroy_decompress(&cinfo);

}

//________________________________________________________________________________________________________________________________________________________________________

void shineImage::loadJPEG( char* filename )
{
	FILE* f;

	shineLog( __LINE__, __FILE__, 4, "shineImage::loadJPEG() Loading JPEG file : %s", filename );
	f = fopen( filename, "rb" );

	if ( NULL == f )
	{
		shineLog( __LINE__, __FILE__, 0, "shineImage::loadJPEG() %s not found", filename );
	}
	else
	{
		readJPEG( f );
		fclose( f );
	}
}

//________________________________________________________________________________________________________________________________________________________________________

void shineImage::loadJPEG( shineLibrary* poLib, char* filename )
{
	FILE* f;

	shineLog( __LINE__, __FILE__, 4, "shineImage::loadJPEG() Loading JPEG file : %s (lib)", filename );

	poLib->seekFile( filename );
	f = poLib->getFile();
	readJPEG( f );
}

//________________________________________________________________________________________________________________________________________________________________________

void shineImage::updateBitmapInfo()
{
	bi = (BITMAPINFO*)biBuffer;
	bi->bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
	bi->bmiHeader.biPlanes = 1;
	bi->bmiHeader.biBitCount = 32;
	bi->bmiHeader.biCompression = BI_RGB;
	bi->bmiHeader.biWidth = xres;
	bi->bmiHeader.biHeight = -yres;
	((unsigned long*)bi->bmiColors)[0] = 0x000000FF;
	((unsigned long*)bi->bmiColors)[1] = 0x0000FF00;
	((unsigned long*)bi->bmiColors)[2] = 0x00FF0000;
}

//________________________________________________________________________________________________________________________________________________________________________

int shineImage::getXRes()
{
	return xres;
}

//________________________________________________________________________________________________________________________________________________________________________

int shineImage::getYRes()
{
	return yres;
}

//________________________________________________________________________________________________________________________________________________________________________

long* shineImage::getPixels()
{
	return data;
}

//________________________________________________________________________________________________________________________________________________________________________

int shineImage::getXSize()
{
	return xsize;
}

//________________________________________________________________________________________________________________________________________________________________________

int shineImage::getYSize()
{
	return ysize;
}

//________________________________________________________________________________________________________________________________________________________________________

void shineImage::setXPos( int x )
{
	xpos = x;
}

//________________________________________________________________________________________________________________________________________________________________________

void shineImage::setYPos( int y )
{
	ypos = y;
}

//________________________________________________________________________________________________________________________________________________________________________

int shineImage::getXPos()
{
	return xpos;
}

//________________________________________________________________________________________________________________________________________________________________________

int shineImage::getYPos()
{
	return ypos;
}

//________________________________________________________________________________________________________________________________________________________________________

void shineImage::setXSize( int x )
{
	xsize = x;
}

//________________________________________________________________________________________________________________________________________________________________________

void shineImage::setYSize( int y )
{
	ysize = y;
}

//________________________________________________________________________________________________________________________________________________________________________

void shineImage::setXRes( int x )
{
	xres = x;
}

//________________________________________________________________________________________________________________________________________________________________________

void shineImage::setYRes( int y )
{
	yres = y;
}

//________________________________________________________________________________________________________________________________________________________________________

void shineImage::areaBlit( int xpos, int ypos, int xoffs, int yoffs, HDC dc )
{
	StretchDIBits( dc, xpos, ypos, xres, yres, 
					   xoffs, yoffs, xres, yres, data, bi, DIB_RGB_COLORS, SRCCOPY);
}

//________________________________________________________________________________________________________________________________________________________________________

void shineImage::blit( int x, int y, HDC dc )
{
	StretchDIBits( dc, x, y, xsize, ysize, 0, 0, xres, yres, data, bi, DIB_RGB_COLORS, SRCCOPY);
}

//________________________________________________________________________________________________________________________________________________________________________

BITMAPINFO *shineImage::getBitmapInfo()
{
	return bi;
}

//________________________________________________________________________________________________________________________________________________________________________

shineImage::shineImage()
{
	data = NULL;
}

//________________________________________________________________________________________________________________________________________________________________________

shineImage::~shineImage()
{
	if( NULL != data )
		delete [] data;
}

//________________________________________________________________________________________________________________________________________________________________________
