//
//          ,  .
//  ,s;`         ',
//.$$'              .
// S,
//     ` ~ ~  ~  ~~"s.
//.ss,               $SS,    h     i     n     e
//'$$$,             ,$$'
// `$$,.         .,$$`
//    `"+ , . , +"`
//
//
// _______________________________________________________________________________________
//
// This file was last changed on     : 2000-11-09
// Revision (please increase number) : A1
// (Only increase A if it's not backwards complient.)
// _______________________________________________________________________________________
//
// Description:
//	Shine plugin control thread
//
///////////////////////////////////////////////////////////////////////////////////////

#include "sscheduler.h"
#include "shine.h"
#include "splugin.h"
#include "simage.h"
#include "sgdi.h"
#include "smusic.h"

//________________________________________________________________________________________________________________________________________________________________________

static rShinePluginUpdate_t rShinePluginUpdate;
static bool Closed = false;

unsigned long CALLBACK SchedulerMain( void* SchedulerClass )
{
	shineScheduler* Scheduler = (shineScheduler*)SchedulerClass;
	HDC				hDC;

	// get devicecontext for this thread.
	hDC=GetDC(sgdiGetWnd());

	while( 1 )
	{
		shineLog( SHNROW, cSuperDebug, "SchedulerMain() Sleeping for %d ms", Scheduler->sleepVal );
		Sleep( Scheduler->sleepVal );

		if( Closed )
		{
			return 0;
		}

		shineTimerEvent* poEvent = Scheduler->poNextEvent;

		// Update the plugin
		if( NULL != poEvent )
		{
			poEvent->nextTick += poEvent->interval;
			shineImage* poImage = poEvent->poPlugin->Image;

			//rShinePluginUpdate.musicVolume = getVolume();
			//rShinePluginUpdate.musicLeft   = getLeftChannel();
			//rShinePluginUpdate.musicRight  = getRightChannel();
			rShinePluginUpdate.mouseX	   = sgdiGetMouseX();
			rShinePluginUpdate.mouseY	   = sgdiGetMouseY();

			poEvent->poPlugin->update( timeGetTime(), poEvent->poPlugin->ID, rShinePluginUpdate );
			//poImage->blit( poImage->getXPos(), poImage->getYPos()-Scheduler->yScroll, sgdiGetDc() );
			poImage->blit( poImage->getXPos(), poImage->getYPos()-Scheduler->yScroll, hDC);
			shineLog( SHNROW, cSuperDebug, "SchedulerMain() TimerTick: Drawing plugin " );
		}

		Scheduler->getNextEvent();
	}
	ReleaseDC(sgdiGetWnd(),hDC);
}

//________________________________________________________________________________________________________________________________________________________________________

void shineScheduler::getNextEvent()
{
	shineTimerEvent* poEvent = oEvents.pFirst;
	if( NULL == poEvent )
	{
		return;
	}

	unsigned long lowestTime = poEvent->nextTick;
	poNextEvent = poEvent;

	while ( NULL != poEvent )
	{
		if( lowestTime > poEvent->nextTick )
		{
			shineLog( SHNROW, cSuperDebug, "shineScheduler::getNextEvent() Setting new time    : %d", poEvent->nextTick );
			lowestTime = poEvent->nextTick;
			poNextEvent = poEvent;
		}
		poEvent = poEvent->pNext;
	}
	sleepVal = lowestTime - timeGetTime(); 
	
	if( sleepVal < 0 )
	{
		sleepVal = 0;
	}

	shineLog( SHNROW, cSuperDebug, "shineScheduler::getNextEvent() Next event in %d ms", sleepVal );
}

//________________________________________________________________________________________________________________________________________________________________________

void shineScheduler::setYScroll( int y )
{
	yScroll = y;
}

//________________________________________________________________________________________________________________________________________________________________________

void shineScheduler::init( )
{
	Closed = false;
	poNextEvent = NULL;
	sleepVal = 100;
	hThread = CreateThread( NULL, 0, SchedulerMain, this, 0, &ThreadId );
}

//________________________________________________________________________________________________________________________________________________________________________

void shineScheduler::close()
{
	Closed = true;
	TerminateThread( hThread, 0 );
	CloseHandle( hThread );
	clearTimer();
}

//________________________________________________________________________________________________________________________________________________________________________

void shineScheduler::addTimer( shineTimerEvent* Event )
{
	Event->nextTick = timeGetTime() + Event->interval;
	oEvents.insert( Event );
	Event->poPlugin->update( timeGetTime(), Event->poPlugin->ID, rShinePluginUpdate );
}

//________________________________________________________________________________________________________________________________________________________________________

void shineScheduler::clearTimer()
{
	oEvents.clear();
}

//________________________________________________________________________________________________________________________________________________________________________
