//XMSEXAM.C   / EXAMPLE FOR FADE XMS ROUTINES//
//WRITING BY THE KING IN 01/02/95            //
#include "KMAGUNIT.C"

//This is a struct for move block via XMS to Conventional Memory//
//Or Conventional Memory To XMS//

struct XmsMoveStruct {
        long Length;               //The LENGTH of the block in BYTES
        unsigned int SHandle;      //Source Handle
        long SOffset;              //Source Offset
        unsigned int DHandle;      //Destinaton Handle
        long DOffset;              //Destinaton Offset
};


XmsMoveStruct XMove;     //An Xms Move Stuct , for moving
unsigned long Xms_Address;        //The Address to the software interrupt
unsigned int Handle;     //Handle for allocate memory
char ch;
//-----------------------------------------------//
//       Checking If XMS Program Installed       //
//-----------------------------------------------//

char XMSInstalled()
{
    char Installed;
    asm {
    Mov ax,0x4300    //Function Ax=4300, Int 2Fh , Checking XMS INSTALLED
    Int 0x2f
    Cmp al,0x80      //If Al=80h mean that XMS found.
    je Found
    Mov Installed,0 //Else Installed = False
    Jmp Exit       //Exit
    }
Found:asm {
    Mov Installed,1 //In Case XMS INSTALLED , Installed = True
    }

Exit:{
}
    return(Installed);  //Return to function result//
}

//-----------------------------------------------//
//     Get the XMS software intterupt handle.    //
//-----------------------------------------------//

void Get_XMS_Address()
{
    asm {
        Mov Ax,0x4310    //Function Ax=4310h , Int 2Fh , Get Handle Of Xms
        Int 0x2f          //Interrupt.
        Mov Word Ptr [Xms_Address+2],Es  //Moving to The Hi Word Of Handle
                                         //The Hi Word of the Interrupt.
        mov word ptr [Xms_Address],Bx    //Moving to The Low Word Of Handle
                                         //The Low Word of the Interrupt.
    }
}

//-----------------------------------------------//
//            Allocate Memory to handle.         //
//-----------------------------------------------//
unsigned char AllocateMemory(unsigned int &Handle,int AllocK)
{
char rett;
asm {
    mov ah,0x09            //Function Ah=09 , Allocate Memory
    Mov Dx,AllocK         //Dx=the size to allocate in KB
    Call Xms_Address      //Calling the interrupt
    Les Di,Handle         //[Es:Di] = Handle
    Mov [Es:Di],Dx        //[Es:Di] = Allocated Handle
    Mov rett,Al
    }
    return(rett);
}

//-----------------------------------------------//
//            Free Memory From handle.           //
//-----------------------------------------------//

char FreeMemory(int Handle)
{
char rett;
asm {
    Mov Ah,0x0A       //Function Ah=0Ah , Free Memory
    Mov Dx,Handle     //Dx=Handle
    Call Xms_Address  //Calling Intterupt
    mov rett,al
    }
    return(rett);
}

//-----------------------------------------------//
//    Reallocated Memory Without losing data     //
//-----------------------------------------------//

char ReAllocMemory(int Handle,int NewSize)
{
char rett;
asm {
    Mov Ah,0x0F       //Function Ah=0Fh , Reallocate memory
    Mov Bx,NewSize    //Bx = New Size
    Mov Dx,Handle     //Dx = Handle
    Call Xms_Address  //Calling Interrupt
    mov rett,al
    }
    return(rett);
}

//-----------------------------------------------//
// Moving Memory Form Convertional memory To XMS //
//-----------------------------------------------//

char RealToXms(long Size,long Source,int DHandle)
{
    char Ok;
    //Building Struct//
    XMove.Length = Size;
    XMove.SHandle = 0;
    XMove.SOffset = Source;
    XMove.DHandle = DHandle;
    XMove.DOffset = 0;
    asm {
        Mov Ah,0x0B      //Function Ah=0Bh , Moving Memory
        Lea SI,XMove     //[Ds:Si] = XMove
        Call Xms_Address //Calling Interrupt
        Mov Ok,Al
    }
    return(Ok);
}

//-----------------------------------------------//
// Moving Memory Form XMS To Convertional memory //
//-----------------------------------------------//

char XmsToReal(long Size,int SHandle,long Dest)
{
char Ok;

    XMove.Length  = Size;
    XMove.SHandle = SHandle;
    XMove.SOffset = 0;
    XMove.DHandle = 0;
    XMove.DOffset = Dest;
    asm {
        Mov Ah,0x0B            //Function Ah=0Bh , Moving Memory
        Lea SI,XMove           //[Ds:Si] = XMove
        Call Xms_Address       //Calling Interrupt
        Mov Ok,Al
    }
    return(Ok);
}
//---------------------------------------------//
//           Return Free XMS Memory            //
//---------------------------------------------//

unsigned int FreeMem()
{
unsigned int rett;
asm {
    Mov Ah,0x8           //Ah = 08h , Return Free Memory
    Call Xms_Address     //Calling Interrupt
    mov rett,ax
    }
    return(rett);
}

void main() {

    if (XMSInstalled()==TRUE)
    {
        printf("XMS Found.\n");
        Get_XMS_Address();
        printf("Total free memory = %d Kb\n",FreeMem());
        printf("\n");
        printf("Press Enter to try to Move the screen memory to XMS\n");
        getch();

        if ((AllocateMemory(Handle,8)) == FALSE)
        {
            printf("Cant Allocate 8k of memory in XMS\n");
            exit(1);
        }

        if (RealToXms(8000,(long)MK_FP(0x0b800,0),Handle) == FALSE)
        {
            printf("Cant Move From Convertsional memory to XMS.\n");
            exit(1);
        }

         clrscr();

         printf("Memory Moved Successfull..\n");
         printf("Press Enter To Restore the memory screen from XMS..\n");
         getch();

         if (XmsToReal(8000,Handle,(long)MK_FP(0x0b800,0)) == FALSE) {

            printf("Cant Move From XMS To Convertsional memory.");
            exit(1);
         }
         if (FreeMemory(Handle)==FALSE)
         {
            printf("Cant Free Memory...\n");
            exit(1);
         }
         gotoxy(1,24);
         printf("Well everything is ok ! :) Press enter to return.\n");
         getch();

    }
    else
        printf("XMS Not Found.");

}