#include <cmath>
#include "flat.h"

/*
 * globale variablen, die vor der benutzung des renderers gesetzt werden mssen
 */

// breite des screens in pixeln
long g_screenWidth;

// in den framebuffer werden die dreiecke gerendert, bevor dieser in den
// bildschirmspeicher kopiert/geflippt wird
long * g_framebuffer;


/*
 * globale variablen, auf die die span-renderer zugreifen und die von den
 * renderern gesetzt werden
 */

// farbe
long g_color;

// framebuffer-offset
long g_offset;

// laenge des spans
int g_length;


/*
 * hufig verwendete inline-funktionen
 */

inline bool aBiggerB(float a, float b) {
  // vergleicht zwei floats mit gleichem vorzeichen, ohne die fpu zu nutzen
  return (*(long *)&a) > (*(long *)&b);
}

inline void swapVertices(Vertex ** a, Vertex ** b) {
  // vertauscht zwei vertices (wird beim sortieren verwendet)
  Vertex * vertex = *a;
  *a = *b;
  *b = vertex;
}


/*
 * der renderer
 */

void renderFlatTriangle(Face & face) {
/*
 * zeichnet ein einfarbiges (flat) dreieck in den framebuffer
 */

  // pointer auf die vertices
  Vertex * v1 = face.v[0],
         * v2 = face.v[1],
         * v3 = face.v[2];

  // vertices nach ordinate aufsteigend sortieren (also so, dass v1
  // der oberste und v3 der unterste vertex ist)
  if (aBiggerB(v1->sy, v2->sy)) swapVertices(&v1, &v2);
  if (aBiggerB(v1->sy, v3->sy)) swapVertices(&v1, &v3);
  if (aBiggerB(v2->sy, v3->sy)) swapVertices(&v2, &v3);

  // screen-space koordinaten
  float x1 = v1->sx,
        y1 = v1->sy,
        x2 = v2->sx,
        y2 = v2->sy,
        x3 = v3->sx,
        y3 = v3->sy;

  // integer-varianten der screen-space ordinaten, aufgerundet
  int y1i = int(ceil(y1)),
      y2i = int(ceil(y2)),
      y3i = int(ceil(y3));

  // hoehe des dreiecks in pixeln
  int height = y3i - y1i;
  if (!height) return;

  // farbe des dreiecks
  g_color = face.color;

  // start offset
  g_offset = y1i * g_screenWidth;

  // steigung der linken und rechten seite
  float ldxdy, rdxdy;

  // laenge des laengsten spans
  float longest = (y2 - y1) / height * (x3 - x1) + (x1 - x2);

  if (longest < 0) {
    // wenn longest < 0, dann befindet sich v2 auf der rechten seite des dreiecks
    rdxdy = (x2 - x1) / (y2 - y1);
    ldxdy = (x3 - x1) / (y3 - y1);
  }
  else {
    rdxdy = (x3 - x1) / (y3 - y1);
    ldxdy = (x2 - x1) / (y2 - y1);
  }

  // prestep-faktor fuer subpixel-korrektes rendering
  float prestep = y1i - y1;

  // interpolations-variablen fuer die linke und die rechte x-koordinate
  float rx = x1 + prestep * rdxdy,
        lx = x1 + prestep * ldxdy;

  // laufvariable fr den aktuellen span
  int span;

  // obere haelfte des dreiecks zeichnen
  if (y1i != y2i) {
    // outer loop: alle spans der oberen dreieck-hlfte durchlaufen
    for (span = y1i; span < y2i; span++) {
      int lxi = int(ceil(lx));
      int rxi = int(ceil(rx));
      g_length = rxi - lxi;
      if (g_length > 0) {
        g_offset += lxi;
        renderFlatSpan();
        g_offset += g_screenWidth - lxi;
      }
      else g_offset += g_screenWidth;
      lx += ldxdy;
      rx += rdxdy;
    }
  }
  else span = y2i;

  // untere haelfte des dreiecks zeichnen
  if (y2i != y3i) {
    // neuer prestep
    prestep = y2i - y2;

    // neue steigung
    if (longest < 0) {
      rdxdy = (x3 - x2) / (y3 - y2);
      rx = x2 + prestep * rdxdy;
    }
    else {
      ldxdy = (x3 - x2) / (y3 - y2);
      lx = x2 + prestep * ldxdy;
    }

    for (; span < y3i; span++) {
      int lxi = int(ceil(lx));
      int rxi = int(ceil(rx));
      g_length = rxi - lxi;
      if (g_length > 0) {
        g_offset += lxi;
        renderFlatSpan();
        g_offset += g_screenWidth - lxi;
      }
      else g_offset += g_screenWidth;
      lx += ldxdy;
      rx += rdxdy;
    }
  }
}


/*
 * der span-renderer
 */

void renderFlatSpan() {
  long * dest = g_framebuffer + g_offset;

  int length = g_length;
  while (length) {
    *(dest++) = g_color;
    length--;
  }
}
