struct Vertex {
  float x, y, z;       // world-space koordinaten
  float sx, sy, sz;    // screen-space koordinaten (sz = 1 / z)
  float u, v;          // texture-space koordinaten (0.0...1.0)
  long color;
};

struct Face {
  Vertex * v[3];    // pointer zu den drei vertices
  long color;       // farbe (argb8888)
  long * texture;   // pointer zur textur
  float area;       // flche des dreiecks
};

void renderFlatSpan();
void renderFlatTriangle(Face & face);

extern long g_screenWidth;
extern long * g_framebuffer;
