;-----------------------------------------------------------------------
; TRIANGLE FILL FOR MODE 13H 256 COLOR MODE
;
; Compile with Tasm.
; C callable.
;
; This module is based on code developed by Steve Dollind for his
; XSPACE game.
; Copyright (C) 1992 Steven Dollins  --  sdollins@uiuc.edu
;
; Hacked into Mode 13h Mike Caruso / Charles Vonness
;                      mcaruso@ios.com  vonness@escape.com
;-----------------------------------------------------------------------

.model large
.data
      
	BUFFER dw  0

.code
global _triangle  : proc

;-----------------------------------------------------------------------
; void HLineClipR
;
;       Draws a horizontal line from (X1, Y) to (X2, Y).
;       Uses Watcom Parameter passing convention in registers
;
;   X1 in DX
;   X2 in CX
;   Y in AX
;   Color in BL
;   Y in DI
;
;-----------------------------------------------------------------------
_HLineClipR proc near 
	
	mov     di, BUFFER
	mov     es, di       
	mov     di,ax
	shl     ax, 8        
	shl     di, 6        
	add     di, ax       
	add     di, dx     
	mov     al, bl
	mov     ah, al       
	sub     cx, dx     
	shr     cx, 1        
	jnc     Start        
	stosb                
Start:  rep     stosw        
	ret
_HLineClipR endp


;-----------------------------------------------------------------------
; void triangle( int X0, int Y0, int X1, int Y1,
;                int X2, int Y2, unsigned Color, unsigned BUF);
;
;
; Written by S. Dollins

_triangle  proc
ARG   X0:word,Y0:word,X1:word,Y1:word,X2:word,Y2:word,Color:word,\
      BUF:word
LOCAL DX01:word, DY01:word, DX02:word, DY02:word, DX12:word, DY12:word, \
      DP01:word, DP02:word, DP12:word, XA01:word, XA02:word, XA12:word=STK

	push    bp
	mov     bp,sp
	mov     ax,BUF
	mov     BUFFER,ax
	sub     sp,STK
	push    ds es si di  ; Save es for polygon routine

	mov     ax,X0
	mov     bx,Y0
	mov     cx,X1
	mov     dx,Y1

	cmp     bx,dx   ; Y0,Y1
	jl      tri_Y0lY1
	je      tri_Y0eY1
	xchg    ax,cx   ; X0,X1
	xchg    bx,dx   ; Y0,Y1
tri_Y0lY1:
	cmp     dx,Y2   ; Y1,Y2
	jg      tri_a
	jmp     tri_sorted
tri_a:  xchg    cx,X2   ; X1,X2
	xchg    dx,Y2   ; Y1,Y2
	cmp     bx,dx   ; Y0,Y1
	jge     tri_b
	jmp     tri_sorted
tri_b:  je      tri_bot
	xchg    ax,cx   ; X0,X1
	xchg    bx,dx   ; Y0,Y1
	jmp     tri_sorted
tri_Y0eY1:
	cmp     bx,Y2   ; Y0,Y2
	jl      tri_bot
	jg      tri_c
	jmp     tri_done
tri_c:  xchg    ax,X2   ; X0,X2
	xchg    bx,Y2   ; Y0,Y2
	jmp     tri_sorted

tri_bot:
	cmp     ax,cx   ; X0,X1
	jl      tri_bot_sorted
	jg      tri_bot_a
	jmp     tri_done
tri_bot_a:
	xchg    ax,cx   ; X0,X1
tri_bot_sorted:
	cmp     bx,199
	jle     tri_bot_y0ok
	jmp     tri_done
tri_bot_y0ok:
	mov     si,Y2
	cmp     si,0
	jge     tri_bot_y2ok
	jmp     tri_done
tri_bot_y2ok:
	mov     X0,ax
	mov     Y0,bx
	mov     X1,cx
	mov     Y1,dx

	mov     bx,Y2   ;    bx <- Y2
	sub     bx,Y0   ;    bx <- Y2 - Y0
	mov     DY02,bx ;  DY02 <- Y2 - Y0
	mov     ax,X2   ;    ax <- X2
	sub     ax,X0   ;    ax <- X2 - X0
	mov     DX02,ax ;  DX02 <- X2 - X0
	mov     cx,ax   ;    cx <- DX02
	cwd             ; dx:ax <- DX02
	idiv    bx      ;    ax <- DX02 / DY02
	cmp     cx,0
	jge     short tri_bot02
	dec     ax      ;    ax <- DX02 / DY02 - 1
tri_bot02:
	mov     XA02,ax ;  XA02 <- DX02 / DY02
	imul    bx      ;    ax <- XA02 * DY02
	sub     cx,ax   ;    cx <- DX02 - XA02 * DY02
	mov     DP02,cx ;  DP02 <- DX02 - XA02 * DY02

	mov     bx,Y2   ;    bx <- Y2
	sub     bx,Y1   ;    bx <- Y2 - Y1
	mov     DY12,bx ;  DY02 <- Y2 - Y1
	mov     ax,X2   ;    ax <- X2
	sub     ax,X1   ;    ax <- X2 - X1
	mov     DX12,ax ;  DX12 <- X2 - X1
	mov     cx,ax   ;    cx <- DX12
	cwd             ; dx:ax <- DX12
	idiv    bx      ;    ax <- DX12 / DY12
	cmp     cx,0
	jge     short tri_bot12
	dec     ax      ;    ax <- DX12 / DY12 - 1
tri_bot12:
	mov     XA12,ax ;  XA12 <- DX12 / DY12
	imul    bx      ;    ax <- XA12 * DY12
	sub     cx,ax   ;    cx <- DX12 - XA12 * DY12
	mov     DP12,cx ;  DP12 <- DX12 - XA12 * DY12

	mov     ax,0    ; PL <- 0
	mov     bx,0    ; PS <- 0
	mov     cx,Y0   ;  Y <- Y0
	mov     si,X0
	mov     di,X1
	dec     di
tri_bot_loop:
	inc     cx      ; Y

	add     ax,DP02 ; PL,DP02
	jle     short tri_bot_shortl
	sub     ax,DY02 ; PL,DY02
	inc     si      ; XL
tri_bot_shortl:
	add     si,XA02 ; XL,XA02

	add     bx,DP12 ; PS,DP12
	jle     short tri_bot_shortr
	sub     bx,DY12 ; PS,DY12
	inc     di      ; XS
tri_bot_shortr:
	add     di,XA12 ; XS,XA12

	push    di      ; XS
	push    si      ; XL
	cmp     cx,Y2   ; Y,Y2
	jl      short tri_bot_loop

	jmp     tri_draw_lines


tri_sorted:
	cmp     bx,199
	jle     tri_y0ok
	jmp     tri_done
tri_y0ok:
	mov     si,Y2
	cmp     si,0
	jge     tri_y2ok
	jmp     tri_done
tri_y2ok:
	mov     X0,ax
	mov     Y0,bx
	mov     X1,cx
	mov     Y1,dx

	mov     bx,dx   ;    bx <- Y1
	sub     bx,Y0   ;    bx <- Y1 - Y0
	mov     DY01,bx ;  DY01 <- Y1 - Y0
	mov     ax,X1   ;    ax <- X1
	sub     ax,X0   ;    ax <- X1 - X0
	mov     DX01,ax ;  DX01 <- X1 - X0
	mov     cx,ax   ;    cx <- DX01
	cwd             ; dx:ax <- DX01
	idiv    bx      ;    ax <- DX01 / DY01
	cmp     cx,0    ;  DX01 ? 0
	jge     short tri_psl01
	dec     ax      ;    ax <- DX01 / DY01 - 1
tri_psl01:
	mov     XA01,ax ;  XA01 <- DX01 / DY01
	imul    bx      ;    ax <- XA01 * DY01
	sub     cx,ax   ;    cx <- DX01 - XA01 * DY01
	mov     DP01,cx ;  DP01 <- DX01 - XA01 * DY01

	mov     bx,Y2   ;    bx <- Y2
	sub     bx,Y0   ;    bx <- Y2 - Y0
	mov     DY02,bx ;  DY02 <- Y2 - Y0
	mov     ax,X2   ;    ax <- X2
	sub     ax,X0   ;    ax <- X2 - X0
	mov     DX02,ax ;  DX02 <- X2 - X0
	mov     cx,ax   ;    cx <- DX02
	cwd             ; dx:ax <- DX02
	idiv    bx      ;    ax <- DX02 / DY02
	cmp     cx,0
	jge     short tri_psl02
	dec     ax      ;    ax <- DX02 / DY02 - 1
tri_psl02:
	mov     XA02,ax ;  XA02 <- DX02 / DY02
	imul    bx      ;    ax <- XA02 * DY02
	sub     cx,ax   ;    cx <- DX02 - XA02 * DY02
	mov     DP02,cx ;  DP02 <- DX02 - XA02 * DY02

	mov     bx,Y2   ;    bx <- Y2
	sub     bx,Y1   ;    bx <- Y2 - Y1
	jle     short tri_const_computed
	mov     DY12,bx ;  DY12 <- Y2 - Y1
	mov     ax,X2   ;    ax <- X2
	sub     ax,X1   ;    ax <- X2 - X1
	mov     DX12,ax ;  DX12 <- X2 - X1
	mov     cx,ax   ;    cx <- DX12
	cwd             ; dx:ax <- DX12
	idiv    bx      ;    ax <- DX12 / DY12
	cmp     cx,0
	jge     short tri_psl12
	dec     ax      ;    ax <- DX12 / DY12 - 1
tri_psl12:
	mov     XA12,ax ;  XA12 <- DX12 / DY12
	imul    bx      ;    ax <- XA12 * DY12
	sub     cx,ax   ;    cx <- DX12 - XA12 * DY12
	mov     DP12,cx ;  DP12 <- DX12 - XA12 * DY12

tri_const_computed:
	mov     ax,DX01
	imul    word ptr DY02
	mov     bx,ax
	mov     cx,dx   ; DX01 * DY02 in cx:bx

	mov     ax,DX02
	imul    word ptr DY01 ; DX02 * DY01 in dx:ax
	cmp     cx,dx
	jg      tri_pt1rt
	jl      tri_pt1lt
	cmp     bx,ax
	ja      tri_pt1rt
	jb      tri_pt1lt
	jmp     tri_done

;------------------------------------
; Short sides are on the left
;
tri_pt1lt:
	mov     ax,0    ; PL <- 0
	mov     bx,0    ; PS <- 0
	mov     cx,Y0   ;  Y <- Y0
	mov     si,X0
	mov     di,si
	dec     si
tri_lt_loop:
	inc     cx      ; Y

	add     ax,DP02 ; PL,DP02
	jle     short tri_lt_shortl
	sub     ax,DY02 ; PL,DY02
	inc     si      ; XL
tri_lt_shortl:
	add     si,XA02 ; XL,XA02

	add     bx,DP01 ; PS,DP01
	jle     short tri_lt_shortr
	sub     bx,DY01 ; PS,DY01
	inc     di      ; XS
tri_lt_shortr:
	add     di,XA01 ; XS,XA01

	push    si      ; XL
	push    di      ; XS
	cmp     cx,Y1   ; Y,Y1
	jl      short tri_lt_loop

	jmp     short tri_lb_start
tri_lb_loop:
	inc     cx      ; Y

	add     ax,DP02 ; PL,DP02
	jle     short tri_lb_shortl
	sub     ax,DY02 ; PL,DY02
	inc     si      ; XL
tri_lb_shortl:
	add     si,XA02 ; XL,XA02

	add     bx,DP12 ; PS,DP12
	jle     short tri_lb_shortr
	sub     bx,DY12 ; PS,DY12
	inc     di      ; XS
tri_lb_shortr:
	add     di,XA12 ; XS,XA12

	push    si      ; XL
	push    di      ; XS
tri_lb_start:
	cmp     cx,Y2   ; Y,Y2
	jl      tri_lb_loop
	jmp     short tri_draw_lines

;------------------------------------
; short sides are on the right
;
tri_pt1rt:
	mov     ax,0    ; PL <- 0
	mov     bx,0    ; PS <- 0
	mov     cx,Y0   ;  Y <- Y0
	mov     si,X0
	mov     di,si
	dec     di
tri_rt_loop:
	inc     cx      ; Y

	add     ax,DP02 ; PL,DP02
	jle     short tri_rt_shortl
	sub     ax,DY02 ; PL,DY02
	inc     si      ; XL
tri_rt_shortl:
	add     si,XA02 ; XL,XA02

	add     bx,DP01 ; PS,DP01
	jle     short tri_rt_shortr
	sub     bx,DY01 ; PS,DY01
	inc     di      ; XS
tri_rt_shortr:
	add     di,XA01 ; XS,XA01

	push    di      ; XS
	push    si      ; XL
	cmp     cx,Y1   ; Y,Y1
	jl      short tri_rt_loop

	jmp     short tri_rb_start
tri_rb_loop:
	inc     cx      ; Y

	add     ax,DP02 ; PL,DP02
	jle     short tri_rb_shortl
	sub     ax,DY02 ; PL,DY02
	inc     si      ; XL
tri_rb_shortl:
	add     si,XA02 ; XL,XA02

	add     bx,DP12 ; PS,DP12
	jle     short tri_rb_shorts
	sub     bx,DY12 ; PS,DY12
	inc     di      ; XS
tri_rb_shorts:
	add     di,XA12 ; XS,XA12

	push    di      ; XS
	push    si      ; XL
tri_rb_start:
	cmp     cx,Y2   ; Y,Y2
	jl      short tri_rb_loop

;------------------------------------
; Draw the horizontal lines
;


tri_draw_lines:
line_loop:
	pop     dx
	pop     cx
	cmp     dx,cx
	jg      tri_draw_next
	mov     bl,byte ptr Color
	mov     ax,Y2
	add     cx,2
	mov     di,ax
	
	
	call    _HLineClipR
tri_draw_next:
	dec     word ptr Y2
	dec     word ptr DY02
	jnz     line_loop

tri_done:
	pop     di si es ds
	mov     sp,bp
	pop     bp
	ret
_triangle  endp
end
