;=============================================================================
; wplasma - Runtime Sinus Wave Plasma Demostration.
;                                                   File created: 10-21-93
; Copyright (C) 1993, Carlos Hasan                 Last modified: 10-21-93
;
; Description:
;   This file implements a runtime real plasma using sinus overlapping
;   waves at random speeds using the VGA 320x80x256 mode.
;
; Portability:
;  Requires Turbo Assembler 3.2 or better to be assembler.
;  Dependent on the IBM PC 286 and the VGA graphics card.
;=============================================================================

                jumps
                .model  small,pascal
                .286

                global  WavePlasma:proc

;======================= Demo equates and data ===============================

TIMEOUT         equ     70 * 10                 ; at least 10 secs.
MAXHW           equ     32                      ; max horiz wave amount.
MAXVW           equ     64                      ; max vert wave amount.
MAXH            equ     60                      ; horiz wave length.
MAXV            equ     80+MAXHW                ; vert wave length.
SEED            equ     57FEh                   ; randomize.

                .data

                include sintab2.inc             ; sinus table.

HWave1          db      MAXH dup (?)            ; horiz waves.
HWave2          db      MAXH dup (?)
VWave1          db      MAXV dup (?)            ; vert waves.
VWave2          db      MAXV dup (?)
HWavPos1        dw      ?                       ; horiz waves pos.
HWavPos2        dw      ?
VWavPos1        dw      ?                       ; vert waves pos.
VWavPos2        dw      ?
HWavInc1        dw      ?                       ; horiz wave speed.
VWavInc1        dw      ?                       ; vert wave speed.
Bitmap          db      256*MAXH+MAXV dup (?)   ; aux plasma buffer.

Palette         db      768 dup (?)             ; plasma palette.
FadePalette     db      768 dup (?)             ; faded palette.
Fade            db      ?                       ; fade level.
Esckey          db      ?                       ; true if key pressed.
Timer           dw      ?                       ; timer counter.
RandSeed        dw      ?                       ; Random seed.

;======================= Demo routines =======================================

                .code

;-----------------------------------------------------------------------------
; Random - Returns a 16-bit random number.
; Out:
;  AX - Random number.
;-----------------------------------------------------------------------------

Random          proc near

                mov     ax,[RandSeed]
                imul    ax,13A7h
                inc     ax
                mov     [RandSeed],ax
                ret

Random          endp

;-----------------------------------------------------------------------------
; WaitVRT - Waits the Vertical Retrace.
;-----------------------------------------------------------------------------

WaitVRT         proc near

                mov     dx,3DAh
WaitVR1:        in      al,dx
                test    al,8
                jne     WaitVR1
WaitVR2:        in      al,dx
                test    al,8
                je      WaitVR2
                ret

WaitVRT         endp

;-----------------------------------------------------------------------------
; SetPalette - set the CX entries of the VGA color palette.
; In:
;   DS:SI - Palette structure address.
;   CX    - Number of colors components.
;-----------------------------------------------------------------------------

SetPalette      proc near

                call    WaitVRT
                mov     dx,3C8h
                xor     al,al
                out     dx,al
                inc     dx
                rep     outsb
                ret

SetPalette      endp

;-----------------------------------------------------------------------------
; UpdHWaves - Updates the Horiz Waves.
;-----------------------------------------------------------------------------

UpdHWaves       proc near

                mov     ax,ds
                mov     es,ax
                cld
                lea     si,[HWave1+1]
                lea     di,[HWave1]
                mov     cx,MAXH-1
                rep     movsb
                mov     si,[HWavPos1]
                mov     al,[SinusTable+si]
                sar     al,1
                stosb
                add     si,[HWavInc1]
                cmp     si,360
                jb      SetHInc
                sub     si,360
SetHInc:        mov     [HWavPos1],si
                lea     si,[SinusTable]
                add     si,[HWavPos2]
                lea     bx,[HWave1]
                lea     di,[HWave2]
                mov     cx,MAXH
UpdHLoop:       lodsb
                sar     al,1
                add     al,[bx]
                sar     al,3
                add     al,16
                stosb
                add     si,3
                inc     bx
                loop    UpdHLoop
                add     [HWavPos2],4
                cmp     [HWavPos2],360
                jb      UpdHExit
                sub     [HWavPos2],360
UpdHExit:       ret

UpdHWaves       endp

;-----------------------------------------------------------------------------
; UpdVWaves - Updates the Vert Waves.
;-----------------------------------------------------------------------------

UpdVWaves       proc near

                mov     ax,ds
                mov     es,ax
                cld
                lea     si,[VWave1+1]
                lea     di,[VWave1]
                mov     cx,MAXV-1
                rep     movsb
                mov     si,[VWavPos1]
                mov     al,[SinusTable+si]
                sar     al,1
                stosb
                add     si,[VWavInc1]
                cmp     si,360
                jb      SetVInc
                sub     si,360
SetVInc:        mov     [VWavPos1],si
                lea     si,[SinusTable]
                add     si,[VWavPos2]
                lea     bx,[VWave1]
                lea     di,[VWave2]
                mov     cx,MAXV
UpdVLoop:       lodsb
                sar     al,1
                add     al,[bx]
                sar     al,2
                add     al,32
                stosb
                add     si,2
                inc     bx
                loop    UpdVLoop
                inc     [VWavPos2]
                cmp     [VWavPos2],360
                jb      UpdVExit
                sub     [VWavPos2],360
UpdVExit:       ret

UpdVWaves       endp

;-----------------------------------------------------------------------------
; UpdBmp - Updates the Plasma bitmap.
;-----------------------------------------------------------------------------

UpdBmp          proc near

                cld
                mov     cx,MAXV
                lea     si,[VWave2]
                lea     di,[BitMap]
UpBmLoop:       lodsb
                i=0
                REPT MAXH
                  inc   al
                  mov   [di+i],al
                  i=i+256
                ENDM
                inc     di
                loop    UpBmLoop
                ret

UpdBmp          endp

;-----------------------------------------------------------------------------
; PutBmp - Puts into the screen the Plasma bitmap.
;-----------------------------------------------------------------------------

PutBmp          proc near

                cld
                mov     ax,0A000h
                mov     es,ax
                mov     di,80*10
                lea     dx,[BitMap]
                lea     si,[HWave2]
                mov     bl,MAXH
                xor     ah,ah
PutLoop:        lodsb
                push    si
                mov     si,ax
                add     si,dx
                mov     cx,40
                rep     movsw
                pop     si
                inc     dh
                dec     bl
                jne     PutLoop
                ret

PutBmp          endp

;-----------------------------------------------------------------------------
; WavePlasma - Performs the demonstration.
; In:
;   DS - Data segment.
;-----------------------------------------------------------------------------

WavePlasma      proc

                pusha
                push    ds
                push    es

                mov     ax,0013h                ; set 320x200x256 mode.
                int     10h

                mov     dx,3C4h                 ; disable chain-four
                mov     al,04h
                out     dx,al
                inc     dx
                in      al,dx
                and     al,0F7h
                out     dx,al
                mov     dx,3C4h                 ; enable all planes
                mov     ax,0F02h
                out     dx,ax
                mov     ax,0A000h               ; clear video memory
                mov     es,ax
                xor     di,di
                xor     ax,ax
                mov     cx,8000h
                cld
                rep     stosw
                mov     dx,3D4h                 ; normal word addressing
                mov     al,14h
                out     dx,al
                inc     dx
                in      al,dx
                and     al,0BFh
                out     dx,al
                dec     dx                      ; address output byte mode
                mov     al,17h
                out     dx,al
                inc     dx
                in      al,dx
                or      al,40h
                out     dx,al
                mov     dx,3D4h                 ; set max scanline.
                mov     ax,0409h
                out     dx,ax

GenPalette:     lea     di,[Palette]            ; generation of the
                xor     al,al                   ; plasma palette.
                mov     [di+0],al
                mov     [di+1],al
                mov     [di+2],al
                add     di,3
                mov     cx,MAXH+MAXVW
                xor     ah,ah
                mov     bl,2
GPLoop:         mov     dl,32
                mov     al,ah
                shr     al,1
                sub     dl,al
                mov     [di+0],dl
                mov     dl,16
                mov     al,ah
                shr     al,2
                sub     dl,al
                mov     [di+1],dl
                mov     dl,63
                mov     al,ah
                shr     al,2
                sub     dl,al
                mov     [di+2],dl
                add     ah,bl
                cmp     ah,64
                jb      GPCont
                neg     bl
                add     ah,bl
                add     ah,bl
GPCont:         add     di,3
                loop    GPLoop

                mov     [Fade],0                ; setup variables.
                mov     [EscKey],0
                mov     [Timer],0
                mov     [RandSeed],SEED

                mov     [HWavPos1],0            ; setup wave parameters.
                mov     [HWavPos2],0
                mov     [VWavPos1],0
                mov     [VWavPos2],0
                mov     [HWavInc1],1
                mov     [VWavInc1],7

                mov     cx,MAXV                 ; use enough steps
SetupWaves:     push    cx                      ; to update all the
                call    UpdHWaves               ; waves entries.
                call    UpdVWaves
                pop     cx
                loop    SetupWaves


PlasmaLoop:     cmp     [EscKey],0              ; change fade level.
                jne     FadeOut
FadeIn:         mov     bl,[Fade]
                cmp     bl,64
                jae     SkipFade
                inc     [Fade]
                jmp     FadeInOut
FadeOut:        mov     bl,[Fade]
                cmp     bl,0
                jbe     FadeInOut
                dec     [Fade]

FadeInOut:      lea     si,[Palette]            ; set faded palette.
                lea     di,[FadePalette]
                mov     cx,768
                mov     ax,ds
                mov     es,ax
                cld
FadeLoop:       lodsb
                mul     bl
                shr     ax,6
                stosb
                loop    FadeLoop

DoFade:         lea     si,[FadePalette]        ; ensures thats always
                mov     cx,3*(MAXH+MAXVW+1)     ; waits the VR per frame.
                call    SetPalette
                jmp     DoPlasma

SkipFade:       call    WaitVRT

DoPlasma:       call    UpdHWaves               ; updates horiz waves.
                call    UpdVWaves               ; updates vert waves.
                call    UpdBmp                  ; updates bitmap.
                call    PutBmp                  ; draw plasma.

                call    Random                  ; change wave's speed.
                and     ax,7
                add     ax,3
                mov     [HWavInc1],ax
                call    Random
                and     ax,3
                add     ax,5
                mov     [VWavInc1],ax

                mov     ah,1                    ; if any key pressed,
                int     16h
                jz      CheckTimer
                mov     ah,0
                int     16h
                jmp     BeginFadeOut

CheckTimer:     inc     [Timer]                 ; or timeout,
                cmp     [Timer],TIMEOUT
                jb      CheckExit

BeginFadeOut:   inc     [EscKey]                ; then fade-out and exit.

CheckExit:      cmp     [Fade],0
                je      PlasmaExit
                jmp     PlasmaLoop

PlasmaExit:     mov     ax,0003h
                int     10h

                pop     es
                pop     ds
                popa
                ret

WavePlasma      endp

                end
