{ Unidad Mode13pm.Pas versin 3.0 beta eta theta neta
  Por: FAC aka Alfonso Alba

  Contiene procedimientos y funciones para trabajar en el modo 13h
  Unidad para TMT Pascal (no funciona con Turbo Pascal!)
}

-- most comment are in spanish... sorry about that
-- but this unit is very easy to understand.
-- everybody has a unit like this.

-- the Line procedure was originally written by Denthor of Asphyxia
-- actually, I use the DDA algorithm, but I don't use any lines in
-- this demo so I left the old procedure


unit Mode13pm;


interface

{ Tipos y constantes utilizadas }
const mText = 0;     { Constante para referenciar el modo de Texto }
      m13h = 1;       { Constante para el modo 13h }

type TColor = array[0..2] of byte;       { Componentes de un color }
     TPalette = array[0..255] of TColor; { Tipo para almacenar una paleta }

var CurrentMode : byte;  { Modo de video actual }
    VGA : dword;

{ Cambiar de modo grfico }
procedure SetMode13;      { Entrar al modo 13h }
procedure SetTextMode;    { Regresar al modo texto }

{ Procedimientos de dibujo }
procedure ClearScreen(color : byte; where : dword);
procedure PutPixel(x, y, color, where : dword);
function  GetPixel(x, y, where : dword) : byte;

procedure HLine(x1, x2, y, color, where : dword);
procedure Line(x1, y1, x2, y2 : word; color : byte; where : dword);

{ Manejo de paleta }
procedure GetPal(color : byte; var red, green, blue : byte);
procedure SetPal(color, red, green, blue : byte);
procedure GetPalette(var pal : TPalette);
procedure SetPalette(pal : TPalette);

{ Pantallas virtuales }

type TVirtual = array[0..63999] of byte;
     PTVirtual = ^TVirtual;

procedure SetupVirtual(var Vscr : PTVirtual; var Voff : dword);
procedure ShutDownVirtual(var Vscr : PTVirtual);
procedure CopyScreen(source, dest : dword);


procedure VRetrace;

procedure LoadPCX(fn : string; where : dword; DimX, DimY, OffX, OffY : word;
                  var pal : TPalette);


implementation

{ Cambio de modo grafico }

procedure SetMode13; { Cambia al modo 13 (320 * 200 * 256) }
begin
     asm
        mov eax, 0013h
        int 10h
     end;
     CurrentMode := m13h;
end;


procedure SetTextMode; { Cambia al modo de texto de 80 * 25 caracteres }
begin
     asm
        mov eax, 0003h
        int 10h
     end;
     CurrentMode := mText;
end;


{ Procedimientos de dibujo }

procedure ClearScreen(color : byte; where : dword); assembler;
{ Borra la pantalla pintndola con un determinado color }
     asm
        mov ecx, 16000
        mov edi, [where]
        mov al, [color]
        mov ah, al
        mov dx, ax
        shl eax, 16
        mov ax, dx
        rep stosd
     end;



procedure PutPixel(x, y, color, where : dword); assembler;
{ Dibuja un pxel }
     asm
        mov ebx, [y]                     { bx := y }
        lea ebx, [ebx + ebx * 4]         { bx := y * 5 }
        shl ebx, 6                       { bx := y * 5 * 64 = y * 320 }
        add ebx, [x]                     { bx := y * 320 + x }
        mov eax, [color]                 { al := color }
        add ebx, [where]                 { ebx := where + y * 320 + x }
        mov [ebx], al                    { dibuja el pxel }
     end;


function GetPixel(x, y, where : dword) : byte; assembler;
{ Devuelve el color del pxel en (x, y)}
     asm
        mov ebx, [y]
        lea ebx, [ebx + ebx * 4]
        shl ebx, 6
        add ebx, [x]
        add ebx, [where]
        mov al, [ebx]
     end;



procedure HLine(x1, x2, y, color, where : dword); assembler;
{ Dibuja una lnea horizontal desde (x1, y) hasta (x2, y) con x1 < x2 }
     asm
        xor edi, edi
        mov edi, [y]
        mov ecx, [x2]
        lea edi, [edi + edi * 4]
        shl edi, 6
        sub ecx, [x1]
        add edi, [x1]
        mov eax, [color]
        add edi, [where]
        mov ah, al
        shr ecx, 1
        jnc @start
        stosb
@start:
        rep   stosw
     end;


procedure Line(x1, y1, x2, y2 : word; color : byte; where : dword);
{ Dibuja una lnea desde (x1, y1) hasta (x2, y2) }
  function sgn(n : integer) : integer;
  begin
       if n > 0 then sgn := 1
                else begin if n < 0 then sgn := -1
                                    else sgn := 0;
                     end;
  end;

var i,s,d1x,d1y,d2x,d2y,u,v,m,n:integer;
begin
     u := x2 - x1;
     v := y2 - y1;
     d1x := SGN(u);
     d1y := SGN(v);
     d2x := SGN(u);
     d2y := 0;
     m := ABS(u);
     n := ABS(v);
     IF not (M > N) then
     BEGIN
          d2x := 0 ;
          d2y := SGN(v);
          m := ABS(v);
          n := ABS(u);
     END;
     s := m shr 1;
     FOR i := 0 TO m DO
     BEGIN
          putpixel(x1, y1, color, where);
          s := s + n;
          IF not (s < m) THEN
          BEGIN
               s := s - m;
               x1 := x1 + d1x;
               y1 := y1 + d1y;
          END
          ELSE
          BEGIN
               x1 := x1 + d2x;
               y1 := y1 + d2y;
          END;
     end;
end;



{ Manejo de paleta }

procedure GetPal(color : byte; var red, green, blue : byte);
{ Lee los valores de rojo, verde y azul de un color en la paleta }
var r, g, b : byte;
begin
     asm
        mov dx, 3C7h
        mov al, color
        out dx, al
        add dx, 2
        in al, dx
        mov r, al
        in al, dx
        mov g, al
        in al, dx
        mov b, al
     end;
     red := r;
     green := g;
     blue := b;
end;


procedure SetPal(color, red, green, blue : byte); assembler;
{ Fija los valores de rojo, verde y azul de un color en la paleta }
asm
   mov dx, 3C8h
   mov al, color
   out dx, al
   inc dx
   mov al, red
   out dx, al
   mov al, green
   out dx, al
   mov al, blue
   out dx, al
end;


procedure GetPalette(var pal : TPalette);
var paloff : dword;
begin
     paloff := ofs(pal);
asm
   mov edi, [paloff]
   mov dx, 3C7h
   xor al, al
   out dx, al
   add dx, 2
   mov ecx, 768
   rep insb
end;
end;

procedure SetPalette(pal : TPalette);
var paloff : dword;
begin
     paloff := ofs(pal);
asm
   mov esi, [paloff]
   mov dx, 3C8h
   xor al, al
   out dx, al
   inc dx
   mov ecx, 768
   rep outsb
end;
end;

{ Pantallas virtuales }

procedure SetupVirtual(var Vscr : PTVirtual; var Voff : dword);
begin
     Vscr := new(PTVirtual);
     Voff := ofs(Vscr^);
end;

procedure ShutDownVirtual(var Vscr : PTVirtual);
begin
     if Vscr <> nil then dispose(Vscr);
     Vscr := nil;
end;

procedure CopyScreen(source, dest : dword); assembler;
     asm
        mov ecx, 16000
        mov esi, [source]
        mov edi, [dest]
        rep movsd
     end;


{ Procedimientos diversos }

procedure VRetrace; assembler;
{ Espera hasta que ocurra un retrazado vertical }
asm
   mov dx, 3DAh         { El puerto $3DA nos dice si est activo el
                          retrazado vertical }
@loop1:
      in al, dx         { examinamos el puerto }
      test al, 08h      { y vemos si en ese momento se est efectuando
                          el retrace }
      jnz @loop1         { Si es as, esperamos hasta que termine }
@loop2:
      in al, dx         { Examinamos otra vez el puerto }
      test al, 08h      { y vemos si empieza algn retrace vertical }
      jz @loop2          { Y espera hasta que empiece el retrace }
end;


{ Procedimiento para cargar imagenes PCX }
procedure LoadPCX(fn : string; where : dword; DimX, DimY, OffX, OffY : word;
                  var pal : TPalette);

type TTemp = array[0..100000] of byte;
     PTTemp = ^TTemp;

var f : file;     { archivo que vamos a abrir }
    x, y : word;   { contadores y variables temporales }
    r, g, b : byte;   { para leer la paleta de colores }
    c, i, a : byte;      { ms contadores y variables temporales }
    flag : boolean;   { indicador de que hemos terminado }
    temp : PTTemp;
    pos : longint;

    function IncPos : boolean;
    begin
         inc(x); { incrementamos X }
         if x = DimX then { Si ya terminamos esa lnea, entonces... }
         begin
              x := 0; { Volvemos a empezar en la siguiente lnea }
              inc(y);
         end;
         if y = DimY then IncPos := true else IncPos := false;
    end;

begin
     temp := new(PTTemp);
     assign(f, fn); { abrimos el archivo de la imagen }
     reset(f, 1);
     BlockRead(f, temp^, filesize(f));
     pos := 128;
     flag := true; { Si flag = false, entonces hemos terminado }
     x := 0; { Empezamos en (0,0); }
     y := 0;
     while flag do
     begin
           c := temp^[pos];
           inc(pos);
          if ((c and $c0) = $c0) then
          { y comprobamos los 2 bits ms significativos }
          begin
               { si los bits estn activados, entonces el byte es un
                 contador }
                a := temp^[pos];
                inc(pos);
               for i := 1 to (c and $3f) do { hacemos el ciclo }
               begin
                    PutPixel(OffX + x, OffY + y, a, where);
                    { almacenamos el byte de datos }
                    if IncPos then flag := false;
                    { Incrementamos la posicin y comprobamos si no
                      hemos terminado de leer la imagen }
               end;
          end
          else
          { Si los 2 bits no estan activados, entonces el byte es un
            byte de datos }
          begin
               PutPixel(OffX + x, OffY + y, c, where);
               { y simplemente lo almacenamos }
               if IncPos then flag := false;
               { y continuamos con la siguiente posicin }
          end;
     end;

     { Si ya termin de leer la imagen, entonces sigue la paleta }
     pos := filesize(f) - 768;

     for i := 0 to 255 do { y leemos la paleta }
     begin
          r := temp^[pos];
          g := temp^[pos+1];
          b := temp^[pos+2];
          inc(pos, 3);
          pal[i][0] := r div 4;   { Los valores del archivo PCX }
          pal[i][1] := g div 4; { van de 0 a 255, as que hay }
          pal[i][2] := b div 4;  { que dividirlos entre 4 }
     end;

     close(f); { cerramos el archivo }
     dispose(temp);
end;


var i : byte;
begin
     CurrentMode := mText;
     VGA := _zero + $A0000;
end.
