#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <math.h>
#include <string.h>

#include <types.h>
#include <timer.h>
#include <font.h>
#include <keyb_hnd.h>
#include <graphs.h>
#include <icp.h>
#include <log.h>

#include "bump.h"
#include "matrix.h"

TRI *tri_ready;                     // Buffer de tringulos a pintar
TRI *first_tri;                     // Primer tringulo
WORLD world;

extern BYTE *virtual;
BYTE *old_virtual;
static BYTE *base,*env_map,*bump;

static WORD triangles_2_draw;
static WORD max_tri=0;         // El mayor nmero de tringulos en un objeto
static BYTE *goods;

static DWORD camera_frames;
static BOOLEAN camera_loaded;
static CAMERA_FRAME *track_camera;

static DWORD last_frame,temp_frame,light_counter=0,cur_light=0,new_light;
static float last_time,temp_time,time,last_ani,ani,fps=0;
static RGB_FIXED cur_color[256],delta_color[256];
static PAL_32 light[5];
static SDWORD cur_frame;
static MATRIZ kfr;
static float angulo;
static BYTE *buffer;
static WORD *obj;
static BYTE *blur;
static BYTE fps_info[15];

void init_bump3d(void) {


    cur_frame=0;

    // Meter aqu la cmara
    base=(BYTE *)malloc(256*256*2       // Textura 16 bits
                       +256*256+256*4   // Envmap + paleta
                       +256*256         // Shades
                       +256*256*2      // Bumpmap
                       +graphics_system.image_size);  // Blur

    if(base==NULL)
        fatal_error("Not enough memory (init_bump3d)");


    lib_log(2,"read_tga_picture('bump.tga')");
    if(read_tga_picture("bump.tga",base,256,256))
        fatal_error("Reading Tga file (init_bump3d)");

    lib_log(2,"filter_texture()");
    filter_texture(base);
    memset(cur_color,0,256*sizeof(RGB_FIXED));

    env_map=(BYTE *)base+256*256*2;
    lib_log(2,"make_env()");
    make_env(env_map,light);
    memcpy(env_map+256*256,&light[0],sizeof(PAL_32));

    lib_log(2,"convert_pal");
    convert_pal(env_map+256*256);
    lib_log(2,"filter_pal");
    filter_pal(env_map+256*256);

    lib_log(2,"make_bump");
    bump=(BYTE *)base+256*256*3+256*4;
    make_bump(base,bump);

    blur=(BYTE *)bump+256*256*2;

    init_the_world();

    if((obj=lib_fopen("jarron.icg"))==NULL)
        fatal_error("Can't load jarron icg (init_bump3d)");

    lib_log(2,"load_object");
    load_object(obj,0,0,0);
    free(obj);

    lib_log(2,"load_seq");
    if((buffer=lib_fopen("jarron.seq"))==NULL)
        fatal_error("Can't load jarron seq (init_bump3d)");

    world.frames=*((DWORD *)buffer);
    world.entidades=*((DWORD *)(buffer+4));
    world.track=(float *)(buffer+8);

    lib_log(2,"load_camera");
    load_camera("bump.cam");
    update_camera(0);

}

void init_bump3d_2(void) {

    frames_dr=frames=0;

    last_ani=last_time=lib_get_time();
    last_frame=0;
    ani=0.0;

    old_virtual=virtual;

}

void end_bump3d(void) {

    DWORD i,j;

    free(base);
    free(buffer);
    free(track_camera);

    for(i=0;i<2;i++) {
        free((world.object+i)->vertices);
        free((world.object+i)->flags);
        free((world.object+i)->proyecciones);
        free((world.object+i)->rot_vertices);
        free((world.object+i)->tri);
        free((world.object+i)->ecuaciones);
        free((world.object+i)->normal);
        free((world.object+i)->env);
        free((world.object+i)->texel);
        if((world.object+i)->n_text)
            free((world.object+i)->map);
        free(goods);
        free(tri_ready);

        j=0;
        while((world.entity+j)->w_object<world.n_objects) {
            free((world.entity+j++)->child);
        }
        free(world.entity);

    }

}

void frame_bump3d(BYTE *back) {

    SDWORD i;

    init_matriz(kfr);
    angulo=0.05;

    if(icg_boss) {

        if(K_Z) pre_rotation_z(world.object[0].o_space,angulo);
        if(K_Y) pre_rotation_y(world.object[0].o_space,angulo);
        if(K_X) pre_rotation_x(world.object[0].o_space,angulo);
        if(K_SPC) pre_translation(world.object[0].o_space,0,-10,0);
        if(K_UP) {
            translation(world.camara,0,0,-10);
            camera_loaded=FALSE;
        }
        if(K_DOWN) {
            translation(world.camara,0,0,10);
            camera_loaded=FALSE;
        }
        if(K_PGUP) {
            rotation_x(world.camara,-angulo);
            camera_loaded=FALSE;
        }
        if(K_PGDN) {
            rotation_x(world.camara,angulo);
            camera_loaded=FALSE;
        }
        if(K_LEFT) {
            rotation_y(world.camara,-angulo);
            camera_loaded=FALSE;
        }
        if(K_RIGHT) {
            rotation_y(world.camara,angulo);
            camera_loaded=FALSE;
        }
    }

    // Animacin
    time=lib_get_time();
    ani+=(time-last_ani)*10.0;

    if(light_counter==0) {
        new_light=rand()%5;
        calc_transition(&light[new_light],cur_color,delta_color);
        cur_light=new_light;
    }
    do_transition(&light_counter,ani,cur_color,delta_color);


    last_ani=time;
    while(ani>=1.0 && cur_frame<world.frames) {
        for(i=0;i<world.entidades;i++) {
            kfr[0][0]=*(world.track+cur_frame*12*world.entidades+i*12);
            kfr[0][1]=*(world.track+cur_frame*12*world.entidades+i*12+1);
            kfr[0][2]=*(world.track+cur_frame*12*world.entidades+i*12+2);
            kfr[1][0]=*(world.track+cur_frame*12*world.entidades+i*12+3);
            kfr[1][1]=*(world.track+cur_frame*12*world.entidades+i*12+4);
            kfr[1][2]=*(world.track+cur_frame*12*world.entidades+i*12+5);
            kfr[2][0]=*(world.track+cur_frame*12*world.entidades+i*12+6);
            kfr[2][1]=*(world.track+cur_frame*12*world.entidades+i*12+7);
            kfr[2][2]=*(world.track+cur_frame*12*world.entidades+i*12+8);
            kfr[3][0]=*(world.track+cur_frame*12*world.entidades+i*12+9);
            kfr[3][1]=*(world.track+cur_frame*12*world.entidades+i*12+10);
            kfr[3][2]=*(world.track+cur_frame*12*world.entidades+i*12+11);
            pre_mul_matriz(kfr,world.object[(world.entity+i+1)->w_object].o_space);
        }
        cur_frame++;
        ani--;
    }

    update_camera(cur_frame);

    rotar_objects();

#if BLUR_MOTION == TRUE

        if(back==NULL) clrscr(blur,graphics_system.image_size);
        else memcpy(blur,back,graphics_system.image_size);
        old_virtual=virtual;
        virtual=blur;
        draw_objects();
        virtual=old_virtual;
#else
        clrscr(virtual,graphics_system.image_size);
        draw_objects();
#endif

    temp_frame=frames_dr;
    temp_time=lib_get_time();
    if (temp_time-last_time>0.25) {
        fps=(float)(temp_frame-last_frame)/(temp_time-last_time);
        last_time=temp_time;
        last_frame=temp_frame;
    }

    if(K_F && icg_boss) {
        sprintf(fps_info,"Fps: %4.3f",fps);
        lib_write_string(fps_info,0,0,31,virtual);
    }

#if BLUR_MOTION == TRUE
        if(graphics_system.bbp==15)
            blur15(virtual,blur,last_virtual_frame_buffer,graphics_system.image_size);
        else
            blur16(virtual,blur,last_virtual_frame_buffer,graphics_system.image_size);
//        virtual=lib_flush_vga();
#else
//        virtual=lib_flush_vga();
#endif

}

static void load_camera(BYTE *name) {

    BYTE *buffer;

    if((buffer=lib_fopen(name))==NULL)
        fatal_error("Can't load bump camera");

    camera_frames=*((DWORD *)buffer);

    if((track_camera=malloc(camera_frames*sizeof(CAMERA_FRAME)))==NULL)
        fatal_error("Not enough memory: loading %s",name);
    else {
        memcpy(track_camera,buffer+4,camera_frames*sizeof(CAMERA_FRAME));
        camera_loaded=TRUE;
        free(buffer);
    }
}

static BOOLEAN zero(float a) {

    if(a<EPSILON && a>-EPSILON) return TRUE;
    else return FALSE;

}

static void update_camera(DWORD frame) {


    VECTOR pos,dst;

    float alpha,beta;

    if(!camera_loaded) return;

    // Movimiento por splines precalculadas

    if(frame<camera_frames) {

        pos=(track_camera+frame)->pos;
        dst=(track_camera+frame)->target;

        dst.x-=pos.x;
        dst.y-=pos.y;
        dst.z-=pos.z;

        init_matriz(world.camara);

        world.camara[3][0]=-pos.x;
        world.camara[3][1]=pos.y;
        world.camara[3][2]=-pos.z;

        if(!zero(dst.x) || !zero(dst.z)) {

            alpha=acos(dst.z/(sqrt(dst.x*dst.x+dst.z*dst.z)));
            if(dst.x<0) alpha=-alpha;

            rotation_y(world.camara,alpha);

        }


        if(!zero(world.camara[2][0]))
            dst.z=-dst.x/world.camara[2][0];
        else
            dst.z=dst.z/world.camara[2][2];

        if(!zero(dst.z) || !zero(dst.y)) {

            beta=acos(dst.z/(sqrt(dst.z*dst.z+dst.y*dst.y)));
            if(dst.y<0) beta=-beta;

            rotation_x(world.camara,-beta);

        }

        rotation_z(world.camara,-(track_camera+frame)->roll);
    }

}



void filter_texture(BYTE *txt) {

    DWORD x,y;
    WORD *wtxt=(WORD *)txt;

    if(graphics_system.bbp==16)
        for(x=0;x<256;x++) for(y=0;y<256;y++)
            *(wtxt+y*256+x)&=63455;
    else if(graphics_system.bbp==15)
        for(x=0;x<256;x++) for(y=0;y<256;y++)
            *(wtxt+y*256+x)&=64479;

}

void filter_pal(BYTE *pal) {

    DWORD i;
    WORD *wpal=(WORD *)pal;

    if(graphics_system.bbp==16)
        for(i=0;i<512;i++) *(wpal+i)&=63455;
    else if(graphics_system.bbp==15)
        for(i=0;i<512;i++) *(wpal+i)&=64479;
}

void calc_transition(PAL_32 *in, RGB_FIXED *color, RGB_FIXED *delta) {

    DWORD i;

    for(i=0;i<256;i++) {
        (delta+i)->r=((((in->pal_32[i].r)<<16)-(color+i)->r))/TRANSITION;
        (delta+i)->g=((((in->pal_32[i].g)<<16)-(color+i)->g))/TRANSITION;
        (delta+i)->b=((((in->pal_32[i].b)<<16)-(color+i)->b))/TRANSITION;
    }

}

void do_transition(DWORD *counter, float time, RGB_FIXED *color, RGB_FIXED *delta) {

    DWORD dtime=(DWORD)time;
    DWORD i;

    *counter+=dtime;
    if(*counter>TRANSITION) {
        dtime-=(*counter-TRANSITION);
        *counter=0;
    }

    for(i=0;i<256;i++) {
        (color+i)->r+=dtime*(delta+i)->r;
        (color+i)->g+=dtime*(delta+i)->g;
        (color+i)->b+=dtime*(delta+i)->b;
        *(env_map+256*256+i*4+1)=((color+i)->r)>>16;
        *(env_map+256*256+i*4+2)=((color+i)->g)>>16;
        *(env_map+256*256+i*4+3)=((color+i)->b)>>16;

    }

    convert_pal(env_map+256*256);
    filter_pal(env_map+256*256);

}

void init_the_world(void) {

    world.n_objects=0;              // Inicialmente no hay objetos
    world.n_materials=0;
    init_matriz(world.camara);      // Inicializar la matriz cmara

    world.render=ENV_TEXTURE;
    world.light.x=0;
    world.light.y=0;
    world.light.z=1;

//    world.dummy.proyecciones=(PIXEL *)malloc(3*MAX_DUMMIES*sizeof(PIXEL));
//    world.dummy.tri=(PTOS_TRI *)malloc(MAX_DUMMIES*sizeof(PTOS_TRI));
//    world.dummy.color=(BYTE *)malloc(3*MAX_DUMMIES*sizeof(BYTE));
//    world.dummy.env=(TEXT *)malloc(3*MAX_DUMMIES*sizeof(TEXT));
//    world.dummy.map=(TEXT *)malloc(3*MAX_DUMMIES*sizeof(TEXT));
}

static DWORD _0=0;

#pragma aux clrscr  =       \
    "xor eax,eax"           \
    "inner1:"               \
    "test edi,1111b"        \
    "jz align"              \
    "mov [edi],al"          \
    "inc edi"               \
    "dec ecx"               \
    "jmp inner1"            \
    "align:"                \
    "fild [_0]"             \
    "push ecx"              \
    "and ecx,0fffffff0h"    \
    "add edi,ecx"           \
    "neg ecx"               \
    "inner2:"               \
    "fst qword ptr [edi+ecx]"       \
    "fst qword ptr [edi+ecx+8]"     \
    "add ecx,16"                    \
    "jnz inner2"            \
    "pop ecx"               \
    "and ecx,1111b"         \
    "inner3:"               \
    "test ecx,ecx"          \
    "jz fin"                \
    "mov [edi],al"          \
    "inc edi"               \
    "dec ecx"               \
    "jmp inner3"            \
    "fin:"                  \
    "fstp st"               \
    modify [edi eax ecx]    \
    parm [edi][ecx];


void load_object(WORD *buffer, float x, float y, float z) {

    OBJECT *cur_obj;
    WORD i,j,k,l,n_texturas;
    float *mtx;
    RTEXT *rtext;
    DWORD *wbuffer,tmp;
    BYTE *bbuffer;

    j=*(buffer++);
    buffer+=2;          // Saltar puntero a jerarquas

    n_texturas=*(buffer++);
    for(i=0;i<n_texturas;i++) {
        buffer+=10;
        world.n_materials++;
    }

    for(i=0;i<j;i++) {

    cur_obj=world.object+world.n_objects;
    cur_obj->n_vertices=*(buffer++);

    cur_obj->vertices=(VECTOR *)malloc((cur_obj->n_vertices)*sizeof(VECTOR));
    if(cur_obj->vertices==NULL)
        fatal_error("Not enough memory");

    memcpy(cur_obj->vertices,buffer,(cur_obj->n_vertices)*sizeof(VECTOR));

    cur_obj->flags=(BYTE *)malloc((cur_obj->n_vertices)*sizeof(BYTE));
    if(cur_obj->flags==NULL)
        fatal_error("Not enough memory");

    cur_obj->proyecciones=(PIXEL *)malloc((cur_obj->n_vertices)*sizeof(PIXEL));
    if(cur_obj->proyecciones==NULL)
        fatal_error("Not enough memory");

    cur_obj->rot_vertices=(VECTOR *)malloc((cur_obj->n_vertices)*sizeof(VECTOR));
    if(cur_obj->rot_vertices==NULL)
        fatal_error("Not enough memory");

    buffer+=(cur_obj->n_vertices)*sizeof(VECTOR)/2;

    cur_obj->n_tri=*(buffer++);
    world.n_tri+=cur_obj->n_tri;      // Sumar a la cuenta global

    cur_obj->tri=(PTOS_TRI *)malloc((cur_obj->n_tri)*sizeof(PTOS_TRI));
    if(cur_obj->tri==NULL)
        fatal_error("Not enough memory");

    memcpy(cur_obj->tri,buffer,(cur_obj->n_tri)*sizeof(PTOS_TRI));

    buffer+=(cur_obj->n_tri)*sizeof(PTOS_TRI)/2;

    cur_obj->ecuaciones=(EQ_TRI *)malloc((cur_obj->n_tri)*sizeof(EQ_TRI));
    if(cur_obj->ecuaciones==NULL)
        fatal_error("Not enough memory");

    memcpy(cur_obj->ecuaciones,buffer,(cur_obj->n_tri)*sizeof(EQ_TRI));
    buffer+=(cur_obj->n_tri)*sizeof(EQ_TRI)/2;

    cur_obj->normal=(VECTOR *)malloc((cur_obj->n_vertices)*sizeof(VECTOR));
    if(cur_obj->normal==NULL)
        fatal_error("Not enough memory");

    memcpy(cur_obj->normal,buffer,(cur_obj->n_vertices)*sizeof(VECTOR));

    cur_obj->env=(TEXT *)malloc((cur_obj->n_vertices)*sizeof(TEXT));
    if(cur_obj->env==NULL)
        fatal_error("Not enough memory");


    buffer+=(cur_obj->n_vertices)*sizeof(VECTOR)/2;

    cur_obj->texel=(BYTE *)malloc((cur_obj->n_tri)*sizeof(BYTE));
    if(cur_obj->texel==NULL)
        fatal_error("Not enough memory");

    memcpy(cur_obj->texel,buffer,(cur_obj->n_tri)*sizeof(BYTE));
    bbuffer=(BYTE *)buffer;
    bbuffer+=(cur_obj->n_tri)*sizeof(BYTE);
    buffer=(WORD *)bbuffer;

    // Leer coordenadas a textura (si es que existen)

    cur_obj->n_text=*(buffer++);
    if(cur_obj->n_text) {
        cur_obj->map=(TEXT *)malloc((cur_obj->n_text)*sizeof(TEXT));
        if(cur_obj->map==NULL)
            fatal_error("Not enough memory");

        rtext=(RTEXT *)malloc((cur_obj->n_text)*sizeof(RTEXT));
        if(rtext==NULL)
            fatal_error("Not enough memory");

        memcpy(rtext,buffer,(cur_obj->n_text)*sizeof(RTEXT));
        for(k=0;k<cur_obj->n_text;k++) {
            (cur_obj->map+k)->u=255*(rtext+k)->u;
            (cur_obj->map+k)->v=255*(-(rtext+k)->v);
        }
        free(rtext);
        buffer+=(cur_obj->n_text)*sizeof(TEXT)/2;
    }

    cur_obj->orgx=x;
    cur_obj->orgy=y;
    cur_obj->orgz=z;

    if(cur_obj->n_tri>max_tri)  {
        goods=(BYTE *)realloc(goods,cur_obj->n_tri*sizeof(BYTE));
        max_tri=cur_obj->n_tri;
    }

    world.n_objects++;

    tri_ready=(TRI *)realloc(tri_ready,(world.n_tri+MAX_DUMMIES)*sizeof(TRI));
    if(tri_ready==NULL)
        fatal_error("Not enough memory");
}

    // Jerarquas

    wbuffer=(DWORD *)buffer;
    tmp=*wbuffer++;
    world.entity=malloc(tmp*sizeof(ENTITY));
    if(world.entity==NULL)
        fatal_error("Not enough memory");

    for(k=0;k<tmp;k++) {
        (world.entity+k)->w_object=*wbuffer;
        if(*wbuffer++!=-1) {
            cur_obj=world.object+*(wbuffer-1);
            mtx=(float *)wbuffer;
            init_matriz(cur_obj->e_space);
            init_matriz(cur_obj->o_space);
            cur_obj->o_space[0][0]=*(mtx);
            cur_obj->o_space[0][1]=*(mtx+1);
            cur_obj->o_space[0][2]=*(mtx+2);
            cur_obj->o_space[1][0]=*(mtx+3);
            cur_obj->o_space[1][1]=*(mtx+4);
            cur_obj->o_space[1][2]=*(mtx+5);
            cur_obj->o_space[2][0]=*(mtx+6);
            cur_obj->o_space[2][1]=*(mtx+7);
            cur_obj->o_space[2][2]=*(mtx+8);

            cur_obj->o_space[3][0]=*(mtx+9);
            cur_obj->o_space[3][1]=*(mtx+10);
            cur_obj->o_space[3][2]=*(mtx+11);
        }

        wbuffer+=sizeof(float)*12/sizeof(DWORD);
        (world.entity+k)->no_child=*wbuffer;
        (world.entity+k)->child=malloc(*wbuffer++*sizeof(ENTITY *));
        if((world.entity+k)->child==NULL && (world.entity+k)->no_child)
            fatal_error("Not enough memory");

        for(l=0;l<(world.entity+k)->no_child;l++)
            *((world.entity+k)->child+l)=world.entity+*wbuffer++;

    }
}

void rotar_objects(void) {

    DWORD i;
    VECTOR local_camara={0,0,0};
    VECTOR world_camara;
    VECTOR light;

    // El Objeto 2 es una luz Omni
    light.x=world.object[(world.entity->child[1]->w_object)].o_space[3][0];
    light.y=world.object[(world.entity->child[1]->w_object)].o_space[3][1];
    light.z=world.object[(world.entity->child[1]->w_object)].o_space[3][2];

    first_tri=NULL;
    triangles_2_draw=0;         // De momento, nada que pintar
    world.n_dummies=0;

    // Posicin de la cmara en el mundo
    inv_transform(&world_camara,&local_camara,world.camara);

    for(i=0;i<world.entity->no_child;i++) {
        hierarchical_transform(world.entity->child[i],world.camara,TRUE);
        if(i==0)
            hierarchical_render(world.entity->child[i],world_camara,light,TRUE);
    }

}


void hierarchical_transform(ENTITY *cur_child, MATRIZ eye, BYTE root) {

    DWORD i;
    OBJECT *obj=world.object+cur_child->w_object;

    if(root) {
        copy_matriz(obj->e_space,obj->o_space);
        obj->e_space[3][0]+=obj->orgx;
        obj->e_space[3][1]-=obj->orgy;
        obj->e_space[3][2]+=obj->orgz;
        post_mul_matriz(obj->e_space,eye);
    }
    else mul_matriz(obj->e_space,obj->o_space,eye);

    for(i=0;i<cur_child->no_child;i++)
        hierarchical_transform(cur_child->child[i],obj->e_space,FALSE);

}

void hierarchical_render(ENTITY *cur_child, VECTOR camara, VECTOR luz, BYTE root) {

    SDWORD i,j;
    BYTE *vis;
    OBJECT *obj;
    VECTOR *vertices,*rot_vertices,parent_camara,local_camara,local_luz,nlight;
    PTOS_TRI *cur_tri;
    EQ_TRI *eq_tri;
    float inv_modulo;

    obj=world.object+cur_child->w_object;
    vertices=obj->vertices;
    cur_tri=obj->tri;
    rot_vertices=obj->rot_vertices;
    eq_tri=obj->ecuaciones;
    vis=obj->flags;

    parent_camara.x=camara.x;
    parent_camara.y=camara.y;
    parent_camara.z=camara.z;
    if(root) {
        parent_camara.x-=obj->orgx;
        parent_camara.y+=obj->orgy;
        parent_camara.z-=obj->orgz;
    }

    inv_transform(&local_camara,&parent_camara,obj->o_space);
    inv_transform(&local_luz,&luz,obj->o_space);

    memset(vis,FALSE,obj->n_vertices*sizeof(BYTE));  // Ninguno visible

    // Goods --> Tringulos visibles
    // Vis   --> Puntos visibles

    back_face(obj->n_tri,goods,&local_camara,eq_tri,cur_tri,vis);
    transform_pts(obj->n_vertices,vis,vertices,rot_vertices,&obj->e_space,obj->proyecciones);

    for(j=0;j<obj->n_vertices;j++) {
        if(!*(vis+j)) continue;
        nlight.x=(vertices+j)->x-local_luz.x;
        nlight.y=(vertices+j)->y-local_luz.y;
        nlight.z=(vertices+j)->z-local_luz.z;
        inv_modulo=1/sqrt(nlight.x*nlight.x+nlight.y*nlight.y+nlight.z*nlight.z);
        nlight.x*=inv_modulo;
        nlight.y*=inv_modulo;
        nlight.z*=inv_modulo;
        (obj->env+j)->u=128+128*(nlight.x-((obj->normal+j)->x));
        (obj->env+j)->v=128+128*(nlight.y-((obj->normal+j)->y));

        if(nlight.x*((obj->normal+j)->x)  +
           nlight.y*((obj->normal+j)->y)  +
           nlight.z*((obj->normal+j)->z)<-0.1) {
                    if((obj->env+j)->u<128) (obj->env+j)->u=0;
                    else (obj->env+j)->u=255;
                    if((obj->env+j)->v<128) (obj->env+j)->v=0;
                    else (obj->env+j)->v=255;
        }

    }

    for(j=0;j<obj->n_tri;j++)
        if(*(goods+j)==TRUE) zclipping(obj,cur_tri+j,j);


    for(i=0;i<cur_child->no_child;i++)
        hierarchical_render(cur_child->child[i],local_camara,local_luz,FALSE);

}

//-----------------------------------------------------------------------------
//                             RADIX SORT
//
//  La primera vez que tuve noticia de este algoritmo fue en el nmero 10 de la
//      revista Imphobia (Junio 1995). Realmente es ms rpido que el quicksort.
//  La implementacin que viene a continuacin es aun ms rpida ya que ordena
//      una lista de tringulos que estn enlazados por lo que no necesito nin-
//      gn tipo de buffer intermedio, ni destino. Muy rpido. Debo dar todos
//      mis agradecimientos a Yann/Iguana, en cuyas fuentes pude ver que real-
//      mente esta idea funcionaba y que me ayudaron a conseguir acabar esto.
//-----------------------------------------------------------------------------

//  2 pasadas, listas de 256
#define BITS    8
#define RADIX   256     // 2^BITS
#define PASS    2       // SIZE/RADIX

/*//  4 pasadas, listas de 16
#define BITS    4
#define RADIX   16      // 2^BITS
#define PASS    4       // SIZE/RADIX */

// Pointers rulezz!!
static TRI **pgroups[RADIX],*groups[RADIX],*cur_tri,**pfirst_tri;

void radix_sort(void) {

    SWORD i,j,val;

    for(i=0;i<PASS;i++) {
        for(j=0;j<RADIX;j++) {
            pgroups[j]=groups+j;    // Iniciamos los punteros al principio
                                    //  de cada lista
            }
        // Empezar por el 1er tringulo
        for(cur_tri=first_tri;cur_tri;cur_tri=cur_tri->next_tri) {
            val=((cur_tri->depth)>>(i*BITS)) & (RADIX-1);
            *pgroups[val]=cur_tri;
            pgroups[val]=&cur_tri->next_tri;
        }

        // Tenemos en groups[], RADIX listas de tringulos ordenados segn la
        // pasada correspondiente.

        for(j=0;j<RADIX;j++) {
            *pgroups[j]=NULL;       // Finalizar la listas con NULLs
        }

        // Ahora enlazamos las listas que esten activas para que no queden los
        //  tringulos sueltos

        pfirst_tri=&first_tri;
        for(j=RADIX-1;j>=0;j--) {   // Ordenar de mayor Z a menos
            if(groups[j]) {
                *pfirst_tri=groups[j];  // Reenlazar las listas
                pfirst_tri=pgroups[j];
            }
        }
    }

}

void draw_objects(void) {

    OBJECT *obj;
    PIXEL *ptos;
    PTOS_TRI *cur_tri;
    BYTE *color;
    TEXT *env,*map;
    VERTEX points[3];
    TRI *buf_tri;

    if(world.render!=WIRE) radix_sort();
    buf_tri=first_tri;
    for(buf_tri=first_tri;buf_tri;buf_tri=buf_tri->next_tri) {
        obj=buf_tri->n_object;
        cur_tri=buf_tri->n_tri;
        ptos=obj->proyecciones;
        color=obj->color;
        env=obj->env;
        map=obj->map;

        points[0].x=(ptos+cur_tri->a)->x;
        points[1].x=(ptos+cur_tri->b)->x;
        points[2].x=(ptos+cur_tri->c)->x;
        points[0].y=(ptos+cur_tri->a)->y;
        points[1].y=(ptos+cur_tri->b)->y;
        points[2].y=(ptos+cur_tri->c)->y;


        points[0].u=(map+cur_tri->a)->u;
        points[0].v=(map+cur_tri->a)->v;
        points[1].u=(map+cur_tri->b)->u;
        points[1].v=(map+cur_tri->b)->v;
        points[2].u=(map+cur_tri->c)->u;
        points[2].v=(map+cur_tri->c)->v;

        points[0].u2=(env+cur_tri->a)->u;
        points[0].v2=(env+cur_tri->a)->v;
        points[1].u2=(env+cur_tri->b)->u;
        points[1].v2=(env+cur_tri->b)->v;
        points[2].u2=(env+cur_tri->c)->u;
        points[2].v2=(env+cur_tri->c)->v;

        if(points[0].u2-points[1].u2 >250 || points[0].u2-points[1].u2 <-250)
            points[0].u2=points[1].u2;
        if(points[0].u2-points[2].u2 >250 || points[0].u2-points[2].u2 <-250)
            points[0].u2=points[2].u2;
        if(points[1].u2-points[2].u2 >250 || points[1].u2-points[2].u2 <-250)
            points[1].u2=points[2].u2;
        if(points[0].v2-points[1].v2 >250 || points[0].v2-points[1].v2 <-250)
            points[0].v2=points[1].v2;
        if(points[0].v2-points[2].v2 >250 || points[0].v2-points[2].v2 <-250)
            points[0].v2=points[2].v2;
        if(points[1].v2-points[2].v2 >250 || points[1].v2-points[2].v2 <-250)
            points[1].v2=points[2].v2;


        draw_ptexture_poly(points,base);

    }

}

void make_light(PAL_32 *light, BYTE *phong, float r, float g, float b) {

    DWORD i;

    for(i=0;i<256;i++) {
        light->pal_32[i].a=*(phong+i)*0;
        light->pal_32[i].r=*(phong+i)*r;
        light->pal_32[i].g=*(phong+i)*g;
        light->pal_32[i].b=*(phong+i)*b;
    }
}

void make_env(BYTE *env_map, PAL_32 light[5]) {

    SDWORD i,j,k,radi;
    float angulo;
    BYTE phong[NSHADES];

    for(i=0;i<NSHADES;i++) {
        angulo=PI/2-(PI*i)/(2*(NSHADES-1));
        radi=(AMBIENT+DIFFUSE*cos(angulo)+SPECULAR*
              pow(cos(angulo),COEFFICIENT))*(NSHADES-1);

        if(radi>=NSHADES) radi=NSHADES-1;
        phong[i]=radi;
    }

    make_light(&light[0],phong,1,1,1);
    make_light(&light[1],phong,0,1,1);
    make_light(&light[2],phong,1,0,1);
    make_light(&light[3],phong,1,1,0);
    make_light(&light[4],phong,1,0.1,0.2);

    for(i=k=0;i<256;i++) for(j=0;j<256;j++,k++) {
        angulo=sqrt((i-128)*(i-128)+(j-128)*(j-128));
        *(env_map+k)=phong[(NSHADES-1)-(BYTE)((angulo*(NSHADES-1))/181)];
    }

}

WORD get_high(WORD color) {

    BYTE r,g,b;

    if(graphics_system.bbp==16) {
        r=(color&31)<<1;
        g=(color>>5)&63;
        b=((color>>11)&31)<<1;
    }
    else if(graphics_system.bbp==15) {
        r=(color&31)<<1;
        g=((color>>5)&31)<<1;
        b=((color>>10)&31)<<1;
    }

    return sqrt(r*r+g*g+b*b);

}

void make_bump(BYTE *textura, BYTE *bump) {

    SDWORD x,y,dy,dx,x1,y1,x2,y2;
    WORD *wtext=(WORD *)textura;
    for(y=0;y<256;y++) for(x=0;x<256;x++) {

        y1=get_high(*(wtext+((y+1)&0xff)*256+x));
        y2=get_high(*(wtext+((y-1)&0xff)*256+x));
        x1=get_high(*(wtext+y*256+((x+1)&0xff)));
        x2=get_high(*(wtext+y*256+((x-1)&0xff)));

        dy=(y2-y1)*4;         dx=(x2-x1)*4;

        if(dy>64) dy=64;
        if(dy<-64) dy=-64;
        if(dx>64) dx=64;
        if(dx<-64) dx=-64;

        *(bump+y*512+x*2)=dx;
        *(bump+y*512+x*2+1)=dy;
    }
}


// Clipping

void two_clip(OBJECT *obj, DWORD in, DWORD out1, DWORD out2) {

    float pc1,pc2,x1,y1,x2,y2,px1,py1,px2,py2,xratio,yratio,u1,v1,u2,v2;

    pc1=(obj->rot_vertices+out2)->z - (obj->rot_vertices+in)->z;
    pc1=(HITHER-(obj->rot_vertices+in)->z)/pc1;
    pc2=(obj->rot_vertices+out1)->z - (obj->rot_vertices+in)->z;
    pc2=(HITHER-(obj->rot_vertices+in)->z)/pc2;

    x1=pc1*((obj->rot_vertices+out2)->x - (obj->rot_vertices+in)->x)
            +(obj->rot_vertices+in)->x;
    y1=pc1*((obj->rot_vertices+out2)->y - (obj->rot_vertices+in)->y)
            +(obj->rot_vertices+in)->y;
    x2=pc2*((obj->rot_vertices+out1)->x - (obj->rot_vertices+in)->x)
            +(obj->rot_vertices+in)->x;
    y2=pc2*((obj->rot_vertices+out1)->y - (obj->rot_vertices+in)->y)
            +(obj->rot_vertices+in)->y;

    if(world.render==ENVMAP) {
        u1=pc1*((obj->env+out2)->u - (obj->env+in)->u)
            +(obj->env+in)->u;
        v1=pc1*((obj->env+out2)->v - (obj->env+in)->v)
            +(obj->env+in)->v;
        u2=pc2*((obj->env+out1)->u - (obj->env+in)->u)
            +(obj->env+in)->u;
        v2=pc2*((obj->env+out1)->v - (obj->env+in)->v)
            +(obj->env+in)->v;
    }

    if(world.render==TEXTURE || world.render==GOUR_TEXTURE) {
        u1=pc1*((obj->map+out2)->u - (obj->map+in)->u)
            +(obj->map+in)->u;
        v1=pc1*((obj->map+out2)->v - (obj->map+in)->v)
            +(obj->map+in)->v;
        u2=pc2*((obj->map+out1)->u - (obj->map+in)->u)
            +(obj->map+in)->u;
        v2=pc2*((obj->map+out1)->v - (obj->map+in)->v)
            +(obj->map+in)->v;
    }

    xratio=graphics_system.xratio/HITHER;
    yratio=graphics_system.yratio/HITHER;
    px1=xratio*x1+graphics_system.centerx;
    py1=yratio*y1+graphics_system.centery;
    px2=xratio*x2+graphics_system.centerx;
    py2=yratio*y2+graphics_system.centery;

    (world.dummy.tri+world.n_dummies)->a=world.n_dummies*3;
    (world.dummy.tri+world.n_dummies)->b=world.n_dummies*3+1;
    (world.dummy.tri+world.n_dummies)->c=world.n_dummies*3+2;

    (world.dummy.proyecciones+world.n_dummies*3)->x=(obj->proyecciones+in)->x;
    (world.dummy.proyecciones+world.n_dummies*3)->y=(obj->proyecciones+in)->y;
    (world.dummy.proyecciones+world.n_dummies*3+1)->x=px1;
    (world.dummy.proyecciones+world.n_dummies*3+1)->y=py1;
    (world.dummy.proyecciones+world.n_dummies*3+2)->x=px2;
    (world.dummy.proyecciones+world.n_dummies*3+2)->y=py2;

    if(world.render==TEXTURE || world.render==GOUR_TEXTURE) {
        (world.dummy.map+world.n_dummies*3)->u=(obj->map+in)->u;
        (world.dummy.map+world.n_dummies*3)->v=(obj->map+in)->v;
        (world.dummy.map+world.n_dummies*3+1)->u=u1;
        (world.dummy.map+world.n_dummies*3+1)->v=v1;
        (world.dummy.map+world.n_dummies*3+2)->u=u2;
        (world.dummy.map+world.n_dummies*3+2)->v=v2;
    }
    if(world.render==ENVMAP) {
        (world.dummy.env+world.n_dummies*3)->u=(obj->env+in)->u;
        (world.dummy.env+world.n_dummies*3)->v=(obj->env+in)->v;
        (world.dummy.env+world.n_dummies*3+1)->u=u1;
        (world.dummy.env+world.n_dummies*3+1)->v=v1;
        (world.dummy.env+world.n_dummies*3+2)->u=u2;
        (world.dummy.env+world.n_dummies*3+2)->v=v2;
    }

    (tri_ready+triangles_2_draw)->n_object=&world.dummy;
    (tri_ready+triangles_2_draw)->n_tri=world.dummy.tri+world.n_dummies;
    (tri_ready+triangles_2_draw)->next_tri=first_tri;
    first_tri=tri_ready+triangles_2_draw;
    (tri_ready+triangles_2_draw)->depth=(obj->rot_vertices+in)->z+HITHER*2;

    triangles_2_draw++;
    world.n_dummies++;

}

void one_clip(OBJECT *obj, DWORD in1, DWORD in2, DWORD out) {

    float pc1,pc2,x1,y1,x2,y2,px1,px2,py1,py2,xratio,yratio,u1,u2,v1,v2;

    pc1=(obj->rot_vertices+out)->z - (obj->rot_vertices+in1)->z;
    pc1=(HITHER-(obj->rot_vertices+in1)->z)/pc1;
    pc2=(obj->rot_vertices+out)->z - (obj->rot_vertices+in2)->z;
    pc2=(HITHER-(obj->rot_vertices+in2)->z)/pc2;

    x1=pc1*((obj->rot_vertices+out)->x - (obj->rot_vertices+in1)->x)
            +(obj->rot_vertices+in1)->x;
    y1=pc1*((obj->rot_vertices+out)->y - (obj->rot_vertices+in1)->y)
            +(obj->rot_vertices+in1)->y;
    x2=pc2*((obj->rot_vertices+out)->x - (obj->rot_vertices+in2)->x)
            +(obj->rot_vertices+in2)->x;
    y2=pc2*((obj->rot_vertices+out)->y - (obj->rot_vertices+in2)->y)
            +(obj->rot_vertices+in2)->y;


    if(world.render==ENVMAP) {
        u1=pc1*((obj->env+out)->u - (obj->env+in1)->u)
            +(obj->env+in1)->u;
        v1=pc1*((obj->env+out)->v - (obj->env+in1)->v)
            +(obj->env+in1)->v;
        u2=pc2*((obj->env+out)->u - (obj->env+in2)->u)
            +(obj->env+in2)->u;
        v2=pc2*((obj->env+out)->v - (obj->env+in2)->v)
            +(obj->env+in2)->v;
    }

    if(world.render==TEXTURE || world.render==GOUR_TEXTURE) {
        u1=pc1*((obj->map+out)->u - (obj->map+in1)->u)
            +(obj->map+in1)->u;
        v1=pc1*((obj->map+out)->v - (obj->map+in1)->v)
            +(obj->map+in1)->v;
        u2=pc2*((obj->map+out)->u - (obj->map+in2)->u)
            +(obj->map+in2)->u;
        v2=pc2*((obj->map+out)->v - (obj->map+in2)->v)
            +(obj->map+in2)->v;
    }

    xratio=graphics_system.xratio/HITHER;
    yratio=graphics_system.yratio/HITHER;
    px1=xratio*x1+graphics_system.centerx;
    py1=yratio*y1+graphics_system.centery;
    px2=xratio*x2+graphics_system.centerx;
    py2=yratio*y2+graphics_system.centery;

    // Tringulo 1

    (world.dummy.tri+world.n_dummies)->a=world.n_dummies*3;
    (world.dummy.tri+world.n_dummies)->b=world.n_dummies*3+1;
    (world.dummy.tri+world.n_dummies)->c=world.n_dummies*3+2;

    (world.dummy.proyecciones+world.n_dummies*3)->x=(obj->proyecciones+in1)->x;
    (world.dummy.proyecciones+world.n_dummies*3)->y=(obj->proyecciones+in1)->y;
    (world.dummy.proyecciones+world.n_dummies*3+1)->x=(obj->proyecciones+in2)->x;
    (world.dummy.proyecciones+world.n_dummies*3+1)->y=(obj->proyecciones+in2)->y;
    (world.dummy.proyecciones+world.n_dummies*3+2)->x=px1;
    (world.dummy.proyecciones+world.n_dummies*3+2)->y=py1;

    if(world.render==TEXTURE || world.render==GOUR_TEXTURE) {
        (world.dummy.map+world.n_dummies*3)->u=(obj->map+in1)->u;
        (world.dummy.map+world.n_dummies*3)->v=(obj->map+in1)->v;
        (world.dummy.map+world.n_dummies*3+1)->u=(obj->map+in2)->u;
        (world.dummy.map+world.n_dummies*3+1)->v=(obj->map+in2)->v;
        (world.dummy.map+world.n_dummies*3+2)->u=u1;
        (world.dummy.map+world.n_dummies*3+2)->v=v1;
    }
    if(world.render==ENVMAP) {
        (world.dummy.env+world.n_dummies*3)->u=(obj->env+in1)->u;
        (world.dummy.env+world.n_dummies*3)->v=(obj->env+in1)->v;
        (world.dummy.env+world.n_dummies*3+1)->u=(obj->env+in2)->u;
        (world.dummy.env+world.n_dummies*3+1)->v=(obj->env+in2)->v;
        (world.dummy.env+world.n_dummies*3+2)->u=u1;
        (world.dummy.env+world.n_dummies*3+2)->v=v1;
    }

    (tri_ready+triangles_2_draw)->n_object=&world.dummy;
    (tri_ready+triangles_2_draw)->n_tri=world.dummy.tri+world.n_dummies;
    (tri_ready+triangles_2_draw)->next_tri=first_tri;
    first_tri=tri_ready+triangles_2_draw;
    (tri_ready+triangles_2_draw)->depth=(obj->rot_vertices+in1)->z+
        (obj->rot_vertices+in2)->z+HITHER;

    triangles_2_draw++;
    world.n_dummies++;

    // Tringulo 2

    (world.dummy.tri+world.n_dummies)->a=world.n_dummies*3;
    (world.dummy.tri+world.n_dummies)->b=world.n_dummies*3+1;
    (world.dummy.tri+world.n_dummies)->c=world.n_dummies*3+2;

    (world.dummy.proyecciones+world.n_dummies*3)->x=(obj->proyecciones+in2)->x;
    (world.dummy.proyecciones+world.n_dummies*3)->y=(obj->proyecciones+in2)->y;
    (world.dummy.proyecciones+world.n_dummies*3+1)->x=px1;
    (world.dummy.proyecciones+world.n_dummies*3+1)->y=py1;
    (world.dummy.proyecciones+world.n_dummies*3+2)->x=px2;
    (world.dummy.proyecciones+world.n_dummies*3+2)->y=py2;

    if(world.render==TEXTURE || world.render==GOUR_TEXTURE) {
        (world.dummy.map+world.n_dummies*3)->u=(obj->map+in2)->u;
        (world.dummy.map+world.n_dummies*3)->v=(obj->map+in2)->v;
        (world.dummy.map+world.n_dummies*3+1)->u=u1;
        (world.dummy.map+world.n_dummies*3+1)->v=v1;
        (world.dummy.map+world.n_dummies*3+2)->u=u2;
        (world.dummy.map+world.n_dummies*3+2)->v=v2;
    }
    if(world.render==ENVMAP) {
        (world.dummy.env+world.n_dummies*3)->u=(obj->env+in2)->u;
        (world.dummy.env+world.n_dummies*3)->v=(obj->env+in2)->v;
        (world.dummy.env+world.n_dummies*3+1)->u=u1;
        (world.dummy.env+world.n_dummies*3+1)->v=v1;
        (world.dummy.env+world.n_dummies*3+2)->u=u2;
        (world.dummy.env+world.n_dummies*3+2)->v=v2;
    }

    (tri_ready+triangles_2_draw)->n_object=&world.dummy;
    (tri_ready+triangles_2_draw)->n_tri=world.dummy.tri+world.n_dummies;
    (tri_ready+triangles_2_draw)->next_tri=first_tri;
    first_tri=tri_ready+triangles_2_draw;
    (tri_ready+triangles_2_draw)->depth=(obj->rot_vertices+in2)->z+2*HITHER;

    triangles_2_draw++;
    world.n_dummies++;

}

void zclipping(OBJECT *obj,PTOS_TRI *tri,DWORD plane) {

    DWORD flag=0;
    if((obj->rot_vertices+tri->a)->z < HITHER) flag|=1;
    if((obj->rot_vertices+tri->b)->z < HITHER) flag|=2;
    if((obj->rot_vertices+tri->c)->z < HITHER) flag|=4;

    // Polgono totalmente oculto
    if(flag==7) return;

    // Polgono totalmente visible
    if(!flag) {

        (tri_ready+triangles_2_draw)->n_object=obj;
        (tri_ready+triangles_2_draw)->n_tri=tri;
        (tri_ready+triangles_2_draw)->next_tri=first_tri;
        first_tri=tri_ready+triangles_2_draw;

        if(world.render!=WIRE) {
            (tri_ready+triangles_2_draw)->depth=
            (obj->rot_vertices+tri->a)->z  +
            (obj->rot_vertices+tri->b)->z  +
            (obj->rot_vertices+tri->c)->z;
            (tri_ready+triangles_2_draw)->bitmap=*(obj->texel+plane);
                }

        triangles_2_draw++;
    }

#if Z_CLIPPING==TRUE

    // Polgono con un punto fuera
    if(flag==1) one_clip(obj,tri->c,tri->b,tri->a);     // 001
    if(flag==2) one_clip(obj,tri->a,tri->c,tri->b);     // 010
    if(flag==4) one_clip(obj,tri->b,tri->a,tri->c);     // 100

    // Polgono con dos puntos fuera
    if(flag==3) two_clip(obj,tri->c,tri->a,tri->b);     // 011
    if(flag==6) two_clip(obj,tri->a,tri->b,tri->c);     // 110
    if(flag==5) two_clip(obj,tri->b,tri->c,tri->a);     // 101

#endif

    return;

}

DWORD filesize(FILE *fp) {
    DWORD pos,size;
    pos=ftell(fp);          // Guardar posicin actual
    fseek(fp,0L,SEEK_END);  // Nos colocamos al final
    size=ftell(fp);         // Obtener tamao;
    fseek(fp,pos,SEEK_SET);
    return size;
}
