// Clipping 3D de aristas. Solo se hace clipping de aquellos planos que se
//  indiquen. Las aristas se cachean (proyeccin y pendiente)

// Mejoras: -La funcin clamp debera ser inline y con comparaciones enteras
//          -Bajar la precisin del copro al dividir

#include "clip.h"

BOOLEAN enter_left_clip,enter_right_clip;
BOOLEAN exit_left_clip,exit_right_clip;
VECTOR left_enter,right_enter;
VECTOR left_exit,right_exit;
BOOLEAN last_projection_valid;
PIXEL last_projection;

void clamp(float *x, float *y) {

    if(*x<0) *x=0;
    else if(*x>=graphics_system.xresolution) *x=(float)graphics_system.xresolution-1;

    if(*y<0) *y=0;
    else if(*y>=graphics_system.yresolution) *y=(float)graphics_system.yresolution-1;

}

BOOLEAN edge_clipping(VECTOR *a, VECTOR *b, VERTEX *vrt, DWORD *count,
                      CAMERA *cam, BYTE mask, BOOLEAN in, SWORD edge) {

    float dist1,dist2,slope,inv;
    float rx1,ry1,rz1,rx2,ry2,rz2;
    float x1,y1,z1,x2,y2,z2;
    MATRIZ *vspace=cam->w_cam;
    float xscale=cam->xscale,yscale=cam->yscale;
    float cache_zi;
    MAT_PLANO *clip_plane;
    BOOLEAN no_cache=FALSE;
    BOOLEAN a_split=FALSE,b_split=FALSE;
    EDGE *cache;
    DWORD i,c;
    FIXED16 dxdy;
    float fdxdy;

    // Las aristas llevan signo que indican la direccin

    if(edge>0) cache=world_mesh.edges+edge;
    else cache=world_mesh.edges-edge;

    x1=a->x; y1=a->y; z1=a->z;
    x2=b->x; y2=b->y; z2=b->z;

//    mask = Planos de clipping que no deben comprobarse
//    mask = 1 1 1 1 -> Left Plane Clipping
//             > Right Plane Clipping
//            > Down Plane Clipping
//           > Up Plane Clipping

    for(i=c=1;i<=CLIP_PLANES;i++,c<<=1) {

        if(c&mask) continue;

        clip_plane=&world_mesh.world_frustum[i-1];
        dist1=x1*clip_plane->a+y1*clip_plane->b+z1*clip_plane->c+clip_plane->d;
        dist2=x2*clip_plane->a+y2*clip_plane->b+z2*clip_plane->c+clip_plane->d;

        // Arista no visible. Cachearla
        if(dist1<0 && dist2<0) {

            // No cachear: aristas de cierre, aristas left_clip o right_clip

            if(!in) {

                if(!no_cache)
                    cache->cacheoffset=(frametime&TIMECOUNT)|OUT_CACHED;

                // Cerrar con aristas si es necesario por dcha e izquierda

                if (enter_right_clip && exit_right_clip) {
                    enter_right_clip=exit_right_clip=FALSE;
                    edge_clipping(&right_enter,&right_exit,vrt,count,cam,mask|3,TRUE,edge);
                }

                if (enter_left_clip && exit_left_clip) {
                    enter_left_clip=exit_left_clip=FALSE;
                    edge_clipping(&left_enter,&left_exit,vrt,count,cam,mask|1,TRUE,edge);
                }

                if (enter_right_clip && exit_right_clip) {
                    enter_right_clip=exit_right_clip=FALSE;
                    edge_clipping(&right_enter,&right_exit,vrt,count,cam,mask|3,TRUE,edge);
                }
            }

            last_projection_valid=FALSE;

            return FALSE;
        }

        // Pto a fuera de pantalla. Clipping

        else if(dist1<0) {

            a_split=TRUE;
            slope=(dist2)/(dist2-dist1);
            x1=x2+(x1-x2)*slope;
            y1=y2+(y1-y2)*slope;
            z1=z2+(z1-z2)*slope;

            if(i==1) {

                no_cache=TRUE;
                left_exit.x=x1;
                left_exit.y=y1;
                left_exit.z=z1;
                if (enter_left_clip==TRUE) {
                    enter_left_clip=FALSE;
                    edge_clipping(&left_enter,&left_exit,vrt,count,cam,mask|1,TRUE,edge);
                }
                else {
                    exit_left_clip=TRUE;
                    last_projection_valid=FALSE;
                }
            }
            else if(i==2) {

                no_cache=TRUE;
                right_exit.x=x1;
                right_exit.y=y1;
                right_exit.z=z1;
                if (enter_right_clip==TRUE) {
                    enter_right_clip=FALSE;
                    edge_clipping(&right_enter,&right_exit,vrt,count,cam,mask|3,TRUE,edge);
                }
                else {
                    exit_right_clip=TRUE;
                    last_projection_valid=FALSE;
                }
            }
            else last_projection_valid=FALSE;
        }

        // Pto b fuera de pantalla. Clipping

        else if(dist2<0) {

            b_split=TRUE;
            slope=(dist1)/(dist1-dist2);
            x2=x1+(x2-x1)*slope;
            y2=y1+(y2-y1)*slope;
            z2=z1+(z2-z1)*slope;
            if(i==1) {
                no_cache=TRUE;
                left_enter.x=x2;
                left_enter.y=y2;
                left_enter.z=z2;
                enter_left_clip=TRUE;
            }
            else if(i==2) {
                no_cache=TRUE;
                right_enter.x=x2;
                right_enter.y=y2;
                right_enter.z=z2;
                enter_right_clip=TRUE;
            }
        }
    }

//  Hecho el clipping con todos los planos necesarios

//  No es necesario recalcular el primer punto. A veces se puede aprovechar
//    el punto final de la ltima arista.
//  En una arista de cierre, si el primer punto no se clipea no se recalcula

    cache_zi=0.0;

    if(!last_projection_valid && (!in || a_split)) {

        rx1=x1*(*vspace)[0][0]+y1*(*vspace)[1][0]+z1*(*vspace)[2][0]
                    +(*vspace)[3][0];
        ry1=x1*(*vspace)[0][1]+y1*(*vspace)[1][1]+z1*(*vspace)[2][1]
                    +(*vspace)[3][1];
        rz1=x1*(*vspace)[0][2]+y1*(*vspace)[1][2]+z1*(*vspace)[2][2]
                    +(*vspace)[3][2];

        if(rz1<NEAR_CLIP) rz1=NEAR_CLIP;
        cache_zi=inv=1/rz1;

        (vrt+*count)->x=graphics_system.centerx+rx1*xscale*inv;
        (vrt+*count)->y=graphics_system.centery+ry1*yscale*inv;
        clamp(&(vrt+*count)->x,&(vrt+*count)->y);
        *count+=1;
    }

    rx2=x2*(*vspace)[0][0]+y2*(*vspace)[1][0]+z2*(*vspace)[2][0]
                    +(*vspace)[3][0];
    ry2=x2*(*vspace)[0][1]+y2*(*vspace)[1][1]+z2*(*vspace)[2][1]
                    +(*vspace)[3][1];
    rz2=x2*(*vspace)[0][2]+y2*(*vspace)[1][2]+z2*(*vspace)[2][2]
                    +(*vspace)[3][2];

    if(rz2<NEAR_CLIP) rz2=NEAR_CLIP;
    inv=1/rz2;

    if(inv>cache_zi) cache_zi=inv;

    if(cache_zi>nzi) nzi=cache_zi;

    (vrt+*count)->x=cam->centerx+rx2*xscale*inv;
    (vrt+*count)->y=cam->centery+ry2*yscale*inv;
    clamp(&(vrt+*count)->x,&(vrt+*count)->y);

    last_projection.x=(vrt+*count)->x;
    last_projection.y=(vrt+*count)->y;

    fdxdy=((vrt+*count)->x-(vrt+*count-1)->x)/((vrt+*count)->y-(vrt+*count-1)->y);

    if(fdxdy>32767.0) fdxdy=32767.0;
    else if (fdxdy<-32768.0) fdxdy=-32768.0;

    (vrt+*count-1)->slope=dxdy=(FIXED16)(fdxdy*65536.0);
    *count+=1;

    last_projection_valid=TRUE;

    // Cachear aristas
    // Las aristas de cierre nunca se cachean

    if(!in) {

        if(!no_cache && n_cached_edges<CACHED_EDGES-1) {

            // Cachear la arista en el sentido adecuado

            if(edge>0) {
                (world_mesh.edges+edge)->cacheoffset=n_cached_edges;
                (cached_edges+n_cached_edges)->x1=(vrt+*count-2)->x;
                (cached_edges+n_cached_edges)->y1=(vrt+*count-2)->y;
                (cached_edges+n_cached_edges)->x2=(vrt+*count-1)->x;
                (cached_edges+n_cached_edges)->y2=(vrt+*count-1)->y;
                (cached_edges+n_cached_edges)->slope=dxdy;
                (cached_edges+n_cached_edges)->nzi=cache_zi;
                (cached_edges+n_cached_edges++)->flags=
                    (edge<<2)|(b_split<<1)|a_split;
            }
            else {
                (world_mesh.edges-edge)->cacheoffset=n_cached_edges;
                (cached_edges+n_cached_edges)->x1=(vrt+*count-1)->x;
                (cached_edges+n_cached_edges)->y1=(vrt+*count-1)->y;
                (cached_edges+n_cached_edges)->x2=(vrt+*count-2)->x;
                (cached_edges+n_cached_edges)->y2=(vrt+*count-2)->y;
                (cached_edges+n_cached_edges)->slope=dxdy;
                (cached_edges+n_cached_edges)->nzi=cache_zi;
                (cached_edges+n_cached_edges++)->flags=
                    (-edge<<2)|(a_split<<1)|b_split;
            }
        }

        if (enter_left_clip && exit_left_clip) {
            enter_left_clip=exit_left_clip=FALSE;
            edge_clipping(&left_enter,&left_exit,vrt,count,cam,mask|1,TRUE,edge);
        }

        if (enter_right_clip && exit_right_clip) {
            enter_right_clip=exit_right_clip=FALSE;
            edge_clipping(&right_enter,&right_exit,vrt,count,cam,mask|3,TRUE,edge);
        }

        if (enter_left_clip && exit_left_clip) {
            enter_left_clip=exit_left_clip=FALSE;
            edge_clipping(&left_enter,&left_exit,vrt,count,cam,mask|1,TRUE,edge);
        }

    }

    return TRUE;

}
