//*****************************************************************************
//                    Visualizador de Mundos v0.00
//
//                          Ent/*Incognita*
//*****************************************************************************

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <string.h>
#include <math.h>
#include <types.h>
#include <graphs.h>
#include <timer.h>
#include <font.h>
#include <keyb_hnd.h>
#include <log.h>

#include "land.h"
#include "matrix.h"
#include "file.h"
#include "render.h"
#include "surface.h"


#define PI 3.141592653589793238462643383279502884197169399375105820975

extern BYTE *virtual;
WORLD world_mesh;
STACK_EDGE *cached_edges;
DWORD frametime;

DWORD _0=0;

void clrscr(DWORD);
#pragma aux clrscr  =       \
    "xor eax,eax"           \
    "mov edi,virtual"       \
    "inner1:"               \
    "test edi,1111b"        \
    "jz align"              \
    "mov [edi],al"          \
    "inc edi"               \
    "dec ecx"               \
    "jmp inner1"            \
    "align:"                \
    "fild [_0]"             \
    "push ecx"              \
    "and ecx,0fffffff0h"    \
    "add edi,ecx"           \
    "neg ecx"               \
    "inner2:"               \
    "fst qword ptr [edi+ecx]"       \
    "fst qword ptr [edi+ecx+8]"     \
    "add ecx,16"                    \
    "jnz inner2"            \
    "pop ecx"               \
    "and ecx,1111b"         \
    "inner3:"               \
    "test ecx,ecx"          \
    "jz fin"                \
    "mov [edi],al"          \
    "inc edi"               \
    "dec ecx"               \
    "jmp inner3"            \
    "fin:"                  \
    "fstp st"               \
    modify [edi eax ecx]    \
    parm [ecx];

float t1,t2,t3;

DWORD last_frame;
float last_time,temp_time,fps;
DWORD temp_frame;
BOOLEAN show_fps,show_info;

void initworld(BYTE world[20], BYTE camera[20], DWORD cache) {

    lib_log(1,"load_world()");
    if(load_world(world)) {
        fatal_error("Can't open world");
    }

    lib_log(1,"load_camera()");
    if(load_camera(camera)) {
        fatal_error("Can't open camera");
    }

    lib_log(1,"init_world()");
    init_world();

    lib_log(1,"init_surface_cache(%d)",cache);
    init_surface_cache(cache);

    lib_log(1,"convert_texture_pal()");
    convert_texture_pal();

    last_time=lib_get_time();
    last_frame=0;
    show_fps=show_info=FALSE;

}

void initworld2(void) {

    last_time=lib_get_time();
    last_frame=0;
    show_fps=show_info=FALSE;

}

void frame_world(DWORD frame) {

    BYTE fps_info[15];

    t1=lib_get_time();
    clrscr(graphics_system.image_size);
    t2=lib_get_time();

    update_camera(frame);
    render_frame(&world_mesh.camera);
    t3=lib_get_time();

    if(icg_boss) {
        if(K_F) show_fps=!show_fps;
        if(K_I) show_info=!show_info;
    }

    if(show_fps) {
        temp_frame=frames_dr;
        temp_time=lib_get_time();
        if (temp_time-last_time>0.25) {
            fps=(float)(temp_frame-last_frame)/(temp_time-last_time);
            last_time=temp_time;
            last_frame=temp_frame;
        }
        sprintf(fps_info,"Fps: %4.3f",fps);
        lib_write_string(fps_info,0,10,31,virtual);
    }

    if(show_info) show_nfo();
    frametime++;            // Cache de aristas

}


extern DWORD memory_needed;
extern DWORD n_polys_showed;
extern DWORD cached_surfaces;

void show_nfo(void) {

    BYTE string[30];
    DWORD starty=graphics_system.yresolution-16*9-1;

    sprintf(string,"Vertex: %d",world_mesh.no_vertex);
    lib_write_string(string,0,starty,31,virtual);

    sprintf(string,"Edges: %d",world_mesh.no_edges);
    lib_write_string(string,0,starty+16,31,virtual);

    sprintf(string,"Polys: %d",world_mesh.no_polys);
    lib_write_string(string,0,starty+32,31,virtual);

    sprintf(string,"Cached/Showed Polys: %d/%d",cached_surfaces,n_polys_showed);
    lib_write_string(string,0,starty+48,31,virtual);

    sprintf(string,"Cached/Clipped Edges: %d/%d",n_reused_edges,n_cached_edges);
    lib_write_string(string,0,starty+64,31,virtual);

    sprintf(string,"Size of World: %d Kb",memory_needed/1024);
    lib_write_string(string,0,starty+80,31,virtual);

    sprintf(string,"ClearScreen: %4.4f secs",t2-t1);
    lib_write_string(string,0,starty+96,31,virtual);

    sprintf(string,"Render: %4.4f secs",t3-t2);
    lib_write_string(string,0,starty+112,31,virtual);

}

void shut_down_world(void) {

    free(world_mesh.base);
    free(track_camera);
    free(surf_base);

}

void get_world_position(MATRIZ *cam,VECTOR *wpos) {

    VECTOR camara_origin={0,0,0};

    inv_transform(wpos,&camara_origin,cam);

}

void transform_frustum(CLIP_PLANE local[CLIP_PLANES], MAT_PLANO world[CLIP_PLANES],
                       VECTOR *wpos,MATRIZ cam) {

    DWORD i;
    VECTOR normal;

    for(i=0;i<CLIP_PLANES;i++) {
        vr_inv_transform(&normal,&local[i].normal,cam);
        world[i].a=normal.x;
        world[i].b=normal.y;
        world[i].c=normal.z;
        world[i].d=-(wpos->x*normal.x+wpos->y*normal.y+wpos->z*normal.z);

        if(normal.x>0) {
            local[i].min[0]=0;
            local[i].max[0]=3;
        }
        else {
            local[i].min[0]=3;
            local[i].max[0]=0;
        }

        if(normal.y>0) {
            local[i].min[1]=1;
            local[i].max[1]=4;
        }
        else {
            local[i].min[1]=4;
            local[i].max[1]=1;
        }

        if(normal.z>0) {
            local[i].min[2]=2;
            local[i].max[2]=5;
        }
        else {
            local[i].min[2]=5;
            local[i].max[2]=2;
        }
    }
}



// De momento, por defecto 90 de vision
// Hacer un init.c

void init_world(void) {

    float hfov,s,c,angle;

    frametime=0;

    init_matriz(world_mesh.camera.w_cam);
    translation(world_mesh.camera.w_cam,0,0,750);

    angle=world_mesh.camera.fov=60.0;
    hfov=2*tan(world_mesh.camera.fov/360*PI);
    world_mesh.camera.xscale=(float)(graphics_system.xresolution/hfov);
    world_mesh.camera.yscale=(float)((graphics_system.yresolution*640)/(hfov*480));
    world_mesh.camera.centerx=(float)graphics_system.centerx;
    world_mesh.camera.centery=(float)graphics_system.centery;

    // Fijar la pirmide de visin
    s=sin((angle*PI)/360);
    c=cos((angle*PI)/360);

    // Izquierda
    world_mesh.camera.view_frustum[0].normal.x=c;
    world_mesh.camera.view_frustum[0].normal.y=0;
    world_mesh.camera.view_frustum[0].normal.z=s;

    // Derecha
    world_mesh.camera.view_frustum[1].normal.x=-c;
    world_mesh.camera.view_frustum[1].normal.y=0;
    world_mesh.camera.view_frustum[1].normal.z=s;

    angle=atan(graphics_system.yresolution/(world_mesh.camera.yscale*2));

    s=sin(angle);
    c=cos(angle);

    // Abajo
    world_mesh.camera.view_frustum[2].normal.x=0;
    world_mesh.camera.view_frustum[2].normal.y=c;
    world_mesh.camera.view_frustum[2].normal.z=s;

    // Arriba
    world_mesh.camera.view_frustum[3].normal.x=0;
    world_mesh.camera.view_frustum[3].normal.y=-c;
    world_mesh.camera.view_frustum[3].normal.z=s;

}
