#include "render.h"
#include "scan.h"

#include <misc.h>

DWORD n_cached_edges;
DWORD n_reused_edges;
DWORD n_polys_showed;

void render_poly(CAMERA *cam, NGON *cpoly, BYTE mask) {

    DWORD j,base,cache,no_vrts,color;
    SWORD pedge;
    VECTOR a,b;
    VERTEX poly[50];
    float normalx;

    no_vrts=0;
    enter_left_clip=enter_right_clip=FALSE;
    exit_left_clip=exit_right_clip=FALSE;
    last_projection_valid=FALSE;
    base=cpoly->start_edge;

    nzi=0.0;

    for(j=0;j<cpoly->no_edges;j++) {

        pedge=*(world_mesh.edge_list+base+j);
            // De momento, no hay cach de aristas.

        if(pedge>0) {
            cache=(world_mesh.edges+pedge)->cacheoffset;
            if((cache&OUT_CACHED) && ((cache&TIMECOUNT)==(frametime&TIMECOUNT))) {
                last_projection_valid=FALSE;
                continue;
            }
            if((cache&TIMECOUNT)!=0) {

               if((((cached_edges+cache)->flags)>>2)==pedge && cache<n_cached_edges) {

                if(!last_projection_valid || ((cached_edges+cache)->flags)&ACLIP_CACHED) {
                    poly[no_vrts].x=(cached_edges+cache)->x1;
                    poly[no_vrts++].y=(cached_edges+cache)->y1;
                }
                last_projection.x=poly[no_vrts].x=(cached_edges+cache)->x2;
                last_projection.y=poly[no_vrts++].y=(cached_edges+cache)->y2;
                poly[no_vrts-2].slope=(cached_edges+cache)->slope;
                if((cached_edges+cache)->nzi>nzi) nzi=(cached_edges+cache)->nzi;
                last_projection_valid=TRUE;
                n_reused_edges++;
                continue;
                }

              }
        }
        else {
            cache=(world_mesh.edges-pedge)->cacheoffset;
            if((cache&OUT_CACHED) && ((cache&TIMECOUNT)==(frametime&TIMECOUNT))) {
                last_projection_valid=FALSE;
                continue;
            }
            if((cache&TIMECOUNT)!=0) {

               if((((cached_edges+cache)->flags)>>2)==-pedge && cache<n_cached_edges) {

                if(!last_projection_valid || ((cached_edges+cache)->flags)&BCLIP_CACHED) {
                    poly[no_vrts].x=(cached_edges+cache)->x2;
                    poly[no_vrts++].y=(cached_edges+cache)->y2;
                }
                last_projection.x=poly[no_vrts].x=(cached_edges+cache)->x1;
                last_projection.y=poly[no_vrts++].y=(cached_edges+cache)->y1;
                poly[no_vrts-2].slope=(cached_edges+cache)->slope;
                last_projection_valid=TRUE;
                if((cached_edges+cache)->nzi>nzi) nzi=(cached_edges+cache)->nzi;
                n_reused_edges++;
                continue;
                }

            }
        }

        if(pedge>0) {
            a.x=(world_mesh.pts+((world_mesh.edges+pedge)->a))->x;
            a.y=(world_mesh.pts+((world_mesh.edges+pedge)->a))->y;
            a.z=(world_mesh.pts+((world_mesh.edges+pedge)->a))->z;

            b.x=(world_mesh.pts+((world_mesh.edges+pedge)->b))->x;
            b.y=(world_mesh.pts+((world_mesh.edges+pedge)->b))->y;
            b.z=(world_mesh.pts+((world_mesh.edges+pedge)->b))->z;
        }
        else {
            a.x=(world_mesh.pts+((world_mesh.edges-pedge)->b))->x;
            a.y=(world_mesh.pts+((world_mesh.edges-pedge)->b))->y;
            a.z=(world_mesh.pts+((world_mesh.edges-pedge)->b))->z;

            b.x=(world_mesh.pts+((world_mesh.edges-pedge)->a))->x;
            b.y=(world_mesh.pts+((world_mesh.edges-pedge)->a))->y;
            b.z=(world_mesh.pts+((world_mesh.edges-pedge)->a))->z;
        }

        edge_clipping(&a,&b,poly,&no_vrts,cam,mask,FALSE,pedge);

        }

//        if(no_vrts==2) {
//            fatal_error("Pocos vrtices");
//        }

        if(no_vrts<3) return;

        color=50;

        // Hacer una rutina especial para la ltima arista
/*        if(poly[0].x==poly[no_vrts-1].x &&
           poly[no_vrts-1].y==poly[no_vrts-1].y) no_vrts--; */

        n_polys_showed++;

        normalx=cpoly->eq.a*cam->w_cam[0][0]+
                cpoly->eq.b*cam->w_cam[1][0]+
                cpoly->eq.c*cam->w_cam[2][0];

        calc_texture(cpoly,&cpoly->p,&cpoly->m,&cpoly->n,cam);
        round(RC_UP);
        precision(PC_24);
        if((normalx<0.5 && normalx>-0.5) || cpoly->mipadjust>5.0)
            scan_poly32(poly,no_vrts);
        else scan_poly(poly,no_vrts);
        precision(PC_53);
        round(RC_NEAR);

//        for(j=0;j<no_vrts-1;j++) {
//            draw_clip_line(poly[j].x,poly[j].y,poly[j+1].x,poly[j+1].y,31);
//        }
//        draw_clip_line(poly[no_vrts-1].x,poly[no_vrts-1].y,poly[0].x,poly[0].y,31);

}

#define DEBUG 5000

void recursive_render(BSP_TREE *bsp, VECTOR *wpos, CAMERA *cam, BYTE mask) {

    MAT_PLANO *plane;
    float dist;
    DWORD i,c;
    VECTOR min,max;

    if(!bsp) return;

    for(i=c=1;i<=CLIP_PLANES;i++,c<<=1) {

        if(c&mask) continue;

        plane=&world_mesh.world_frustum[i-1];

        min.x=bsp->limit[cam->view_frustum[i-1].min[0]];
        min.y=bsp->limit[cam->view_frustum[i-1].min[1]];
        min.z=bsp->limit[cam->view_frustum[i-1].min[2]];

        max.x=bsp->limit[cam->view_frustum[i-1].max[0]];
        max.y=bsp->limit[cam->view_frustum[i-1].max[1]];
        max.z=bsp->limit[cam->view_frustum[i-1].max[2]];

        if(plane->a*max.x+plane->b*max.y+plane->c*max.z+plane->d<0) return;

        if(plane->a*min.x+plane->b*min.y+plane->c*min.z+plane->d>0)
            mask|=c;

    }

    plane=&bsp->root.eq;

    dist=plane->a*wpos->x+plane->b*wpos->y+plane->c*wpos->z+plane->d;

    if(dist<0) {
        if(-dist<DEBUG) recursive_render(bsp->right,wpos,cam,mask);
        render_poly(cam,&bsp->root,mask);
        recursive_render(bsp->left,wpos,cam,mask);
    }
    else {
        if(-dist>-DEBUG) recursive_render(bsp->left,wpos,cam,mask);
//        render_poly(cam,&bsp->root,mask);
        recursive_render(bsp->right,wpos,cam,mask);
    }
}

void render_frame(CAMERA *cam) {

    DWORD i;
    VECTOR wpos;
    MATRIZ *vspace=cam->w_cam;
//    MAT_PLANO *plane;

    get_world_position(vspace,&wpos);
    transform_frustum(world_mesh.camera.view_frustum,world_mesh.world_frustum,
                      &wpos,vspace);

    n_polys_showed=0;
    cached_surfaces=0;

    // Clear cache

    n_cached_edges=n_reused_edges=1;
    if(!(frametime&TIMECOUNT))
        for(i=0;i<world_mesh.no_edges;i++) (world_mesh.edges+i)->cacheoffset=0;

//    for(i=0;i<world_mesh.no_polys;i++) {
//        plane=&(world_mesh.bsp+i)->root.eq;
//        if(plane->a*wpos.x+plane->b*wpos.y+plane->c*wpos.z+plane->d<0)
//            render_poly(cam,&(world_mesh.bsp+i)->root,0);
//    }

    recursive_render(world_mesh.bsp,&wpos,cam,0);
}
