{Ŀ}
{ june'97 by Cazz }
{}
{$A+,B-,D-,E-,F-,G+,I-,L-,N-,O-,P-,Q-,R-,S-,T-,V-,X+}
{$M 2048,0,655360}
unit part1;

     interface

procedure dopart1;

     implementation

uses pcx,keyboard,vga256,misc,timer,midas;

const letter_faces:array[1..2,1..3] of integer=(
                                    (1,2,3),(1,4,3));
      letter_verts:array[1..4,1..2] of integer=(
                                    (-36,-36),(36,-36),(36,36),(-36,36));

const trace:array[1..192] of integer=(
$7F,$7F,$7F,$7F,$7F,$7E,$7E,$7D,$7D,$7C,$7C,$7B,$7A,$79,$78,$77,$76,$75,$74,
$72,$71,$70,$6E,$6C,$6B,$69,$67,$65,$63,$61,$5F,$5D,$5B,$59,$57,$54,$52,$50,
$4D,$4B,$48,$45,$43,$40,$3D,$3B,$38,$35,$32,$2F,$2C,$29,$27,$24,$20,$1D,$1A,
$17,$14,$11,$0E,$0B,$8,$5,$2,0,$3,$6,$0A,$0D,$10,$13,$16,$19,$1B,$1E,$21,
$24,$26,$29,$2B,$2D,$2F,$31,$33,$35,$37,$38,$3A,$3B,$3C,$3D,$3E,$3F,$3F,$3F,
$40,$40,$40,$3F,$3F,$3E,$3E,$3D,$3C,$3B,$39,$38,$36,$35,$33,$31,$2F,$2D,$2A,
$28,$26,$23,$20,$1E,$1B,$18,$15,$12,$0F,$0C,$9,$6,$3,0,$3,$6,$9,$0C,$0F,$12,
$14,$17,$19,$1B,$1C,$1E,$1F,$1F,$20,$20,$20,$1F,$1E,$1D,$1C,$1A,$18,$16,$14,
$11,$0F,$0C,$9,$6,$3,0,$3,$6,$9,$0B,$0D,$0F,$10,$10,$10,$0F,$0D,$0B,$9,$6,
$3,0,$3,$6,$7,$8,$7,$6,$3,0,$3,$4,$3,0,$2,0);

var  x,y:array[1..4] of integer;
     letter_o:pointer;
     add_x,add_y:integer;
     letter_angle:byte;
     scr,bmp:pointer;
     a,b,e:byte;
     c:word;

procedure loadletter;
var       off:longint;
          temp:pointer;
begin
  load_pcx_datafile(2,320,vidseg,ofs(scr^),true);
  off:=ofs(letter_o^);
  for a:=0 to 127 do
    begin
      for b:=0 to 127 do
        begin
          e:=mem[vidseg:a*320+b];
          mem[seg(letter_o^):off]:=e;
          mem[seg(letter_o^):off+256]:=e;
          inc(off);
          mem[seg(letter_o^):off]:=e;
          mem[seg(letter_o^):off+256]:=e;
          inc(off);
        end;
      inc(off,256);
    end;
end;

{ 32-bit 256x128 }
{ not very right, but fast, really }
{ only right/down screen clipping }
procedure scale32(x,y:integer;w,h:word;src:pointer);
var       xd,xd2,yd:longint;
          xp,yp:integer;
          xc,yc:longint;
          off:word;
          ye,xe:integer;
          oof:word;
begin
  if (x>319) or (y>199) then exit;
  xd:=65536 div w;
  xd2:=xd*4;
  yd:=32768 div h;
  xe:=x+w-1;
  ye:=y+h-1;
  if xe>319 then xe:=319;
  if ye>199 then ye:=199;
  if (xe<=x) or (ye<=y) then exit;
  yc:=0;
  off:=y*320+x;
    asm
            mov ax,vidseg
            mov es,ax

            push ds
            lds si,src
            mov oof,si

            mov bx,ye
            sub bx,y
@bigger:
            push bx
            mov di,off
            db 66h; mov bx,word ptr yc
            xor bl,bl
            db 66h; xor ax,ax
            mov ax,oof
            db 66h; add bx,ax
            db 66h; sal bx,8
            db 66h; mov dx,word ptr xd2

            mov cx,xe
            sub cx,x
            inc cx
            sar cx,1
            jnc @nocarry
            jz @over

            db 66h; mov ax,bx
            db 66h; shr ax,8
            db 66h; mov si,ax
            movsb

            db 66h; mov ax,word ptr xd
            db 66h; add bx,ax

@nocarry:

            sar cx,1
            jnc @inner
            jz @over

            db 66h; mov ax,bx
            db 66h; shr ax,8
            db 66h; mov si,ax
            movsw

            db 66h; mov ax,word ptr xd
            db 66h; add ax,ax
            db 66h; add bx,ax

@inner:
            db 66h; mov si,bx
            db 66h; shr si,8
            db 66h; mov ax,ds:[si]
            db 66h; mov es:[di],ax
            add di,4
            db 66h; add bx,dx
            dec cx
            jnz @inner

@over:
            add off,320
            db 66h; mov ax,word ptr yd
            db 66h; add word ptr yc,ax

            pop bx
            dec bx
            jnz @bigger
            pop ds
    end;
end;

procedure init;
begin
  getmem(scr,65535);
  getmem(letter_o,65535);
  vidseg:=seg(scr^);
  clear(0,vidseg);
  load_pcx_datafile(1,320,vidseg,ofs(scr^),true);
  getimage(0,0,255,127,320,scr,bmp,false);
  clear(0,vidseg);
  loadletter;
  clear(0,vidseg);
  initkey;
  initpalette(pal);
  vidseg:=$a000;
end;

procedure preVR; far;
begin
  inc(letter_angle,2);
  inc(c);
  if a>0 then dec(a);
end;

procedure dopart1;
begin
  init;
  c:=1;
  a:=255;
  add_x:=35;
  errnr:=tmrSyncScr(scrsync,@preVR,@immVR,nil);
  if errnr<>0 then midaserror(errnr);
  repeat
    lfrm:=frm;
    if (c>600) and (c mod 4=0) then
      begin
        for e:=0 to 255 do
          begin
            if pal[e,1]>0 then dec(pal[e,1]);
            if pal[e,2]>0 then dec(pal[e,2]);
            if pal[e,3]>0 then dec(pal[e,3]);
          end;
        initpalette(pal);
      end;
    if (c<=192) then add_y:=97-trace[c]
    else add_y:=97;
    for b:=1 to 4 do
      begin
        rotate2d(letter_verts[b,1],letter_verts[b,2],letter_angle,x[b],y[b]);
        x[b]:=x[b]+add_x;
        y[b]:=y[b]+add_y;
      end;
    texture(x[letter_faces[1,1]],y[letter_faces[1,1]],0,0,
            x[letter_faces[1,2]],y[letter_faces[1,2]],255,0,
            x[letter_faces[1,3]],y[letter_faces[1,3]],255,255,letter_o);
    texture(x[letter_faces[2,1]],y[letter_faces[2,1]],0,0,
            x[letter_faces[2,2]],y[letter_faces[2,2]],0,255,
            x[letter_faces[2,3]],y[letter_faces[2,3]],255,255,letter_o);

    scale32(70+a,65+a shr 2,255+a*2,127+a*2,bmp);
    repeat until frm>lfrm;
    if key[1] then begin over:=true; break; end;
  until (c>800);
  disabkey;
  freemem(bmp,256*128);
  freemem(letter_o,65535);
  freemem(scr,65535);
end;

end.