{Ŀ}
{ june'97 by Cazz }
{}
{$A+,B-,D-,E-,F-,G+,I-,L-,N-,O-,P-,Q-,R-,S-,T-,V-,X+}
{$M 2048,0,655360}
{ to load 256 color pcx pictures }
{ cutdown version }
unit pcx;

     interface

procedure load_pcx_datafile(nr:byte;bpr,s:word;o:word;p:boolean);

     implementation

uses vga256,misc;

type PCX_header=record
             manufacturer:byte;         { [10] }
             version:byte;              { doesn't matter }
             encoding:byte;             { [1] }
             bits_p_p:byte;             { bits per pixel [8] }
             x1,y1,x2,y2:integer;       { start- and end-points }
             hdpi,vdpi:integer;
             colmap:array[1..48] of byte;
             r1:byte;                   { reserved, set to 0 }
             nplanes:byte;              { nr. of color planes [1] }
             bytes_p_l:word;            { bytes per line, usually not needed }
             palinfo:word;              { dont't care, better if [1] }
             hscr,vscr:word;            { these too }
             filler:array[1..54] of byte;
     end;

var  header:PCX_header;
     f:file;

{ PCX loading routines from datafile }
{ loads pcx header }
function load_header_datafile:boolean;
begin
  load_header_datafile:=true;
  blockread(f,header,sizeof(header));
  with header do
    begin
      if manufacturer<>10 then load_header_datafile:=false;
      if encoding<>1 then load_header_datafile:=false;
      if bits_p_p<>8 then load_header_datafile:=false;
      if nplanes<>1 then load_header_datafile:=false;
    end;
end;

{ loads pcx from datafile into buffer (s,o) }
procedure load_pcx_datafile(nr:byte;bpr,s:word;o:word;p:boolean);
var       size:longint;
          ex,ey,xc,yc:integer;
          cnt:word;
          b,n:byte;
          siz,offs:longint;
          buffer:array[1..1024] of byte;
          reed,b_off:word;
begin
  if (nr>maxdata) or (nr<1) then error('Error accessing datafile.');
  assign(f,'obscene.dat');
  {$i-} reset(f,1); {$i+}
  if ioresult<>0 then error('Dumb user has deleted datafile "obscene.dat".');
  offs:=index[nr,1];
  siz:=index[nr,2];
  if (siz>65535) or (siz<1000) then error('Unable to load datafile.');
  seek(f,offs);

  if not load_header_datafile then error('Datafile or loader error.');
  with header do
    begin
      ex:=x2-x1+1;
      ey:=y2-y1+1;
    end;

{ unpacking part }
  xc:=0;
  yc:=0;
  b_off:=1024;
  reed:=0;
  while yc<ey do
    begin
      if b_off>reed then
        begin
          blockread(f,buffer,sizeof(buffer),reed);
          b_off:=1;
        end;
      b:=buffer[b_off];
      inc(b_off);
      if (b and $c0)=$c0 then
        begin
          n:=(b and $3f);
          if b_off>reed then
            begin
              blockread(f,buffer,sizeof(buffer),reed);
              b_off:=1;
            end;
          b:=buffer[b_off];
          inc(b_off);
          fillchar(mem[s:o],n,b);
          inc(o,n);
          inc(xc,n);
        end
      else
        begin
          mem[s:o]:=b;
          inc(o);
          inc(xc);
        end;
      if (xc>=ex) then
        begin
          dec(xc,ex);
          dec(o,ex-bpr);
          inc(yc);
        end;
    end;
  if p then
    begin
      seek(f,offs+siz-769);
      blockread(f,b,1);
      if b=12 then
        blockread(f,pal,768);
      for b:=0 to 255 do
        begin
          pal[b,1]:=pal[b,1] shr 2;
          pal[b,2]:=pal[b,2] shr 2;
          pal[b,3]:=pal[b,3] shr 2;
        end;
    end;
  close(f);
end;

end.