{Ŀ}
{ june'97 by Cazz }
{}
{$A+,B-,D-,E-,F-,G+,I-,L-,N-,O-,P-,Q-,R-,S-,T-,V-,X+}
{$M 2048,0,655360}
unit    VGA256;
{ cutdown version }

        interface

type    rgb=array[1..3] of byte;
        palette=array[0..255] of rgb;

const   vidseg:word=$a000;
        vidram:pointer=ptr($a000,0);

procedure wait;
procedure hline(x,x1,y:integer;c:byte);
procedure page(source,dest:pointer);
procedure clear(_color:byte;dest:word);
{ image stuff }
procedure texture(X1,Y1,U1,V1,X2,Y2,U2,V2,X3,Y3,U3,V3:Integer;Texture:Pointer);
procedure putimage(x,y:integer;s,scr:pointer);
procedure getimage(x1,y1,x2,y2,bpr:integer;src:pointer;var dest:pointer;id:boolean);
{ palette stuff }
procedure initpalette(var p);

var     pal:palette;

        implementation

procedure wait; assembler;
asm
  mov dx,3dah
@V1:
  in al,dx
  test al,8
  jz @V1
@V2:
  in al,dx
  test al,8
  jnz @V2
end;

procedure swapint(var a,b); assembler;
asm
  les di,[a]
  mov ax,es:[di]
  les di,[b]
  xchg es:[di],AX
  les di,[a]
  mov es:[di],ax
end;

procedure hline(x,x1,y:integer;c:byte); assembler;
asm
  mov bx,x
  mov cx,x1
  cmp bx,cx
  jb @skip
  xchg bx,cx
@skip:
  inc cx
  sub cx,bx
  mov ax,vidseg
  mov es,ax
  mov ax,y
  shl ax,6
  mov di,ax
  shl ax,2
  add di,ax
  add di,bx
  mov al,c
  shr cx,1
  jnc @skip2
  stosb
@skip2:
  mov ah,al
  rep stosw
@out:
end;

procedure page(source,dest:pointer); assembler;
asm
  push ds
  les di,dest
  lds si,source
  xor di,di
  xor si,si
  db 66h; mov cx,16000
  dw 0; db 66h; rep movsw
  pop ds
end;

procedure clear(_color:byte;dest:word); assembler;
asm
  mov ax,dest
  mov es,ax
  xor di,di
  db 66h; mov cx,16000
  xor bx,bx
  mov bl,_color
  mov bh,bl
  mov ax,bx
  db 66h; rol ax,16
  mov ax,bx
  db 66h; rep stosw
end;

{ originally coded by Jeroen Bouwens in pure pascal (sloooooow)     }
{ optimized and converted into inline assembler by Cazz of Zombie :-}
{ ONLY for 256x256 bitmap }
Procedure texture(X1,Y1,U1,V1,X2,Y2,U2,V2,X3,Y3,U3,V3:Integer;Texture:Pointer);
{The actual texture-map routine. Only a little commented :-}
Var TexOfs                                       : Array [0..320] Of Word;
    SO,Long                                      : Word;
    XL,UL,VL,XR,UR,VR                            : Array [0..200] Of LongInt;
    DY21,DY31,DY32,DX21,DX31,DX32,DU21,DU31,DU32 : LongInt;
    DV21,DV31,DV32,U,V,I,J                       : LongInt;

    a1,a2,a3,a4,a5,a6,a7,a8,a9:longint;
    l1,l2,shrr,shrl,b1,b2:longint;

Begin
  {Sort for increasing y-coordinates}
  asm
        mov cx,2
@swapper:
        mov ax,word ptr y3
        mov bx,word ptr y2
        cmp ax,bx
        jge @noswap1
        mov word ptr y3,bx
        mov word ptr y2,ax

        mov ax,word ptr x3
        xchg ax,word ptr x2
        mov word ptr x3,ax

        mov ax,word ptr u3
        xchg ax,word ptr u2
        mov word ptr u3,ax

        mov ax,word ptr v3
        xchg ax,word ptr v2
        mov word ptr v3,ax
@noswap1:

        mov ax,word ptr y1
        mov bx,word ptr y2
        cmp ax,bx
        jle @noswap2
        mov word ptr y1,bx
        mov word ptr y2,ax

        mov ax,word ptr x1
        xchg ax,word ptr x2
        mov word ptr x1,ax

        mov ax,word ptr u1
        xchg ax,word ptr u2
        mov word ptr u1,ax

        mov ax,word ptr v1
        xchg ax,word ptr v2
        mov word ptr v1,ax
@noswap2:

        mov ax,word ptr y1
        mov bx,word ptr y3
        cmp ax,bx
        jle @noswap3
        mov word ptr y1,bx
        mov word ptr y3,ax

        mov ax,word ptr x1
        xchg ax,word ptr x3
        mov word ptr x1,ax

        mov ax,word ptr u1
        xchg ax,word ptr u3
        mov word ptr u1,ax

        mov ax,word ptr v1
        xchg ax,word ptr v3
        mov word ptr v1,ax
@noswap3:
        dec cx
        jnz @swapper

{ if (y1=y2) and (x1>x2) then do it up to noswap4 }
        mov ax,word ptr y1
        cmp ax,word ptr y2
        jnz @noswap4
        mov ax,word ptr x1
        cmp ax,word ptr x2
        jle @noswap4
        xchg ax,word ptr x2
        mov word ptr x1,ax
        mov ax,word ptr u1
        xchg ax,word ptr u2
        mov word ptr u1,ax
        mov ax,word ptr v1
        xchg ax,word ptr v2
        mov word ptr v1,ax
@noswap4:

  {Calculate X,U and V along the edges and store these}
    mov ax,y2
    sub ax,y1
    cwd
    mov word ptr dy21,ax
    mov [word ptr dy21+2],dx
    mov ax,y3
    sub ax,y1
    cwd
    mov word ptr dy31,ax
    mov [word ptr dy31+2],dx
    mov ax,y3
    sub ax,y2
    cwd
    mov word ptr dy32,ax
    mov [word ptr dy32+2],dx

    mov ax,x2
    sub ax,x1
    cwd
    mov word ptr dx21,ax
    mov [word ptr dx21+2],dx
    mov ax,x3
    sub ax,x1
    cwd
    mov word ptr dx31,ax
    mov [word ptr dx31+2],dx
    mov ax,x3
    sub ax,x2
    cwd
    mov word ptr dx32,ax
    mov [word ptr dx32+2],dx

    mov ax,u2
    sub ax,u1
    cwd
    mov word ptr du21,ax
    mov [word ptr du21+2],dx
    mov ax,u3
    sub ax,u1
    cwd
    mov word ptr du31,ax
    mov [word ptr du31+2],dx
    mov ax,u3
    sub ax,u2
    cwd
    mov word ptr du32,ax
    mov [word ptr du32+2],dx

    mov ax,v2
    sub ax,v1
    cwd
    mov word ptr dv21,ax
    mov [word ptr dv21+2],dx
    mov ax,v3
    sub ax,v1
    cwd
    mov word ptr dv31,ax
    mov [word ptr dv31+2],dx
    mov ax,v3
    sub ax,v2
    cwd
    mov word ptr dv32,ax
    mov [word ptr dv32+2],dx

{ some calcs }
    mov ax,x1
    db 66h; db 98h;                     { cwde }
    db 66h; shl ax,8
    db 66h; mov word ptr xl[0],ax
    mov ax,u1
    db 66h; db 98h;                     { cwde }
    db 66h; shl ax,8
    db 66h; mov word ptr ul[0],ax
    mov ax,v1
    db 66h; db 98h;                     { cwde }
    db 66h; shl ax,8
    db 66h; mov word ptr vl[0],ax

    mov ax,y1
    cmp ax,y2
    jz @v6rdne

    db 66h; mov ax,word ptr xl[0]
    db 66h; mov word ptr xr[0],ax
    db 66h; mov ax,word ptr ul[0]
    db 66h; mov word ptr ur[0],ax
    db 66h; mov ax,word ptr vl[0]
    db 66h; mov word ptr vr[0],ax

    jmp @valma
@v6rdne:

    mov ax,x2
    db 66h; db 98h;                     { cwde }
    db 66h; shl ax,8
    db 66h; mov word ptr xr[0],ax
    mov ax,u2
    db 66h; db 98h;                     { cwde }
    db 66h; shl ax,8
    db 66h; mov word ptr ur[0],ax
    mov ax,v2
    db 66h; db 98h;                     { cwde }
    db 66h; shl ax,8
    db 66h; mov word ptr vr[0],ax
@valma:
  end;

{ out of screen check }
  asm
    db 66h; xor ax,ax
    db 66h; mov word ptr b1,ax
    mov ax,y3
    sub ax,word ptr y1
    db 66h; db 98h;                     { cwde }
    db 66h; mov word ptr b2,ax

    cmp y1,0
    jge @no_diff_b1
    mov ax,y1
    neg ax
    db 66h; db 98h;                     { cwde }
    db 66h; mov word ptr b1,ax
@no_diff_b1:

    cmp y3,199
    jle @no_diff_b2
    mov ax,199
    sub ax,y1
    db 66h; db 98h;                     { cwde }
    db 66h; mov word ptr b2,ax
@no_diff_b2:
  end;
  if b1>b2 then exit;
{  asm
    db 66h; cmp word ptr dy31,0
    jnz @noexit
    retn 28
@noexit:
  end;}
  if dy31=0 then exit;

  asm
      db 66h; mov bx,word ptr dy31
      db 66h; mov ax,word ptr dx31
      db 66h; sal ax,8
      db 66h; cwd
      db 66h; idiv bx
      db 66h; mov word ptr a1,ax

      db 66h; mov ax,word ptr du31
      db 66h; sal ax,8
      db 66h; cwd
      db 66h; idiv bx
      db 66h; mov word ptr a3,ax

      db 66h; mov ax,word ptr dv31
      db 66h; sal ax,8
      db 66h; cwd
      db 66h; idiv bx
      db 66h; mov word ptr a5,ax

{ if dy32<>0 }
      db 66h; cmp word ptr dy32,0
      jz @not_this1

      db 66h; mov bx,word ptr dy32
      db 66h; mov ax,word ptr dx32
      db 66h; sal ax,8
      db 66h; cwd
      db 66h; idiv bx
      db 66h; mov word ptr a6,ax

      db 66h; mov ax,word ptr du32
      db 66h; sal ax,8
      db 66h; cwd
      db 66h; idiv bx
      db 66h; mov word ptr a7,ax

      db 66h; mov ax,word ptr dv32
      db 66h; sal ax,8
      db 66h; cwd
      db 66h; idiv bx
      db 66h; mov word ptr a8,ax
@not_this1:

{ if dy21<>0 }
      db 66h; cmp word ptr dy21,0
      jz @not_this2

      db 66h; mov bx,word ptr dy21
      db 66h; mov ax,word ptr dx21
      db 66h; sal ax,8
      db 66h; cwd
      db 66h; idiv bx
      db 66h; mov word ptr a2,ax

      db 66h; mov ax,word ptr du21
      db 66h; sal ax,8
      db 66h; cwd
      db 66h; idiv bx
      db 66h; mov word ptr a4,ax

      db 66h; mov ax,word ptr dv21
      db 66h; sal ax,8
      db 66h; cwd
      db 66h; idiv bx
      db 66h; mov word ptr a9,ax
@not_this2:

{ xl,yl,vl }

      db 66h; mov cx,word ptr y2
      db 66h; sub cx,word ptr y1
      mov si,4
      db 66h; xor di,di
@loop1:
      db 66h; mov ax,word ptr xl[di]
      db 66h; add ax,word ptr a1
      db 66h; mov word ptr xl[si],ax

      db 66h; mov ax,word ptr xr[di]
      db 66h; add ax,word ptr a2
      db 66h; mov word ptr xr[si],ax

      db 66h; mov ax,word ptr ul[di]
      db 66h; add ax,word ptr a3
      db 66h; mov word ptr ul[si],ax

      db 66h; mov ax,word ptr ur[di]
      db 66h; add ax,word ptr a4
      db 66h; mov word ptr ur[si],ax

      db 66h; mov ax,word ptr vl[di]
      db 66h; add ax,word ptr a5
      db 66h; mov word ptr vl[si],ax

      db 66h; mov ax,word ptr vr[di]
      db 66h; add ax,word ptr a9
      db 66h; mov word ptr vr[si],ax

      add si,4
      add di,4
      dec cx
      cmp cx,0
      jg @loop1

      db 66h; mov cx,word ptr y3
      db 66h; sub cx,word ptr y2
      db 66h; xor di,di
      db 66h; mov di,word ptr y2
      db 66h; sub di,word ptr y1
      db 66h; shl di,2
      db 66h; mov si,di
      db 66h; add si,4
@loop2:
      db 66h; mov ax,word ptr xl[di]
      db 66h; add ax,word ptr a1
      db 66h; mov word ptr xl[si],ax

      db 66h; mov ax,word ptr xr[di]
      db 66h; add ax,word ptr a6
      db 66h; mov word ptr xr[si],ax

      db 66h; mov ax,word ptr ul[di]
      db 66h; add ax,word ptr a3
      db 66h; mov word ptr ul[si],ax

      db 66h; mov ax,word ptr ur[di]
      db 66h; add ax,word ptr a7
      db 66h; mov word ptr ur[si],ax

      db 66h; mov ax,word ptr vl[di]
      db 66h; add ax,word ptr a5
      db 66h; mov word ptr vl[si],ax

      db 66h; mov ax,word ptr vr[di]
      db 66h; add ax,word ptr a8
      db 66h; mov word ptr vr[si],ax

      add si,4
      add di,4
      dec cx
      cmp cx,0
      jg @loop2

  {Calculate texture-offsets for longest horizontal line (at Y=Y2)}

        db 66h; mov si,word ptr dy21
        db 66h; sal si,2
        db 66h; mov ax,word ptr xl[si]
        db 66h; cmp ax,word ptr xr[si]
        jge @not_thisone1

        db 66h; mov bx,word ptr ul[si]
        db 66h; mov ax,word ptr vl[si]
        db 66h; mov word ptr u,bx
        db 66h; mov word ptr v,ax

        xor al,al
        db 66h; sar bx,8
        db 66h; add ax,bx
        db 66h; mov word ptr so,ax

        db 66h; mov bx,word ptr xr[si]
        db 66h; sub bx,word ptr xl[si]
        db 66h; inc bx

        db 66h; mov ax,word ptr ur[si]
        db 66h; sub ax,word ptr ul[si]
        db 66h; shl ax,8
        db 66h; cwd
        db 66h; idiv bx
        db 66h; mov word ptr l1,ax

        db 66h; mov ax,word ptr vr[si]
        db 66h; sub ax,word ptr vl[si]
        db 66h; shl ax,8
        db 66h; cwd
        db 66h; idiv bx
        db 66h; mov word ptr l2,ax

        db 66h; dec bx
        db 66h; sar bx,8

        db 66h; mov cx,word ptr l1
        db 66h; mov dx,word ptr l2
            db 66h; mov di,bx
            db 66h; xor si,si
@inner1:
            db 66h; mov ax,word ptr v
            xor al,al

            db 66h; mov bx,word ptr u
            db 66h; sar bx,8
            db 66h; add ax,bx
            db 66h; sub ax,word ptr so

            mov word ptr texofs[si],ax

            db 66h; add word ptr u,cx
            db 66h; add word ptr v,dx

            db 66h; add si,2
            db 66h; dec di
            db 66h; cmp di,0
            jge @inner1

            jmp @this_is_over
@not_thisone1:

        db 66h; mov bx,word ptr ur[si]
        db 66h; mov ax,word ptr vr[si]
        db 66h; mov word ptr u,bx
        db 66h; mov word ptr v,ax

        xor al,al
        db 66h; sar bx,8
        db 66h; add ax,bx
        db 66h; mov word ptr so,ax

        db 66h; mov bx,word ptr xl[si]
        db 66h; sub bx,word ptr xr[si]
        db 66h; inc bx

        db 66h; mov ax,word ptr ul[si]
        db 66h; sub ax,word ptr ur[si]
        db 66h; shl ax,8
        db 66h; cwd
        db 66h; idiv bx
        db 66h; mov word ptr l1,ax

        db 66h; mov ax,word ptr vl[si]
        db 66h; sub ax,word ptr vr[si]
        db 66h; shl ax,8
        db 66h; cwd
        db 66h; idiv bx
        db 66h; mov word ptr l2,ax

        db 66h; dec bx
        db 66h; sar bx,8

        db 66h; mov cx,word ptr l1
        db 66h; mov dx,word ptr l2
            db 66h; mov di,bx
            db 66h; xor si,si
@inner2:
            db 66h; mov ax,word ptr v
            xor al,al

            db 66h; mov bx,word ptr u
            db 66h; shr bx,8
            db 66h; add ax,bx
            db 66h; sub ax,word ptr so

            mov word ptr texofs[si],ax

            db 66h; add word ptr u,cx
            db 66h; add word ptr v,dx

            db 66h; add si,2
            db 66h; dec di
            db 66h; cmp di,0
            jge @inner2

@this_is_over:

  {Fill polygon (=Read back X,U and V-coordinates from buffer) }
              db 66h; mov si,word ptr dy21
              db 66h; shl si,2
              db 66h; mov ax,word ptr xl[si]
              db 66h; cmp ax,word ptr xr[si]
              jge @noooooooh

              db 66h; mov dx,word ptr b1
@bigloop1:
              push dx
              mov si,dx
              add si,si
              add si,si
              db 66h; mov ax,word ptr vl[si]
              xor al,al
              db 66h; mov bx,word ptr ul[si]
              db 66h; sar bx,8
              db 66h; add ax,bx
              db 66h; xor bx,bx
              mov bx,word(texture)
              add ax,bx
              db 66h; mov word ptr so,ax

              db 66h; mov ax,word ptr xr[si]
              db 66h; sar ax,8
              cmp ax,320
              jl @no_change1_1
              mov ax,319
@no_change1_1:
              cmp ax,0
              jl @over1
              db 66h; mov word ptr shrr,ax

              db 66h; mov ax,word ptr xl[si]
              xor si,si
              db 66h; sar ax,8
              cmp ax,0
              jge @no_change2_1
              neg ax
              add ax,ax
              mov si,ax
              db 66h; xor ax,ax
@no_change2_1:
              cmp ax,320
              jge @over1
              db 66h; mov word ptr shrl,ax

              cmp ax,word ptr shrr
              jg @over1

              mov ax,vidseg
              mov es,ax
              mov ax,dx
              add ax,word ptr y1
              imul di,ax,320
              add di,word ptr shrl

              push ds
              lds bx,texture

              mov dx,word ptr so
              mov cx,word ptr shrr
              sub cx,word ptr shrl
              inc cx
@inner3:
              mov bx,word ptr texofs[si]
              add bx,dx

              mov al,ds:[bx]
              mov es:[di],al
              inc di

              add si,2
              dec cx
              jnz @inner3

              pop ds
@over1:
              pop dx
              inc dx
              cmp dx,word ptr b2
              jle @bigloop1

              jmp @nohh_over
@noooooooh:

              db 66h; mov dx,word ptr b1
@bigloop2:
              push dx
              mov si,dx
              add si,si
              add si,si
              db 66h; mov ax,word ptr vr[si]
              xor al,al
              db 66h; mov bx,word ptr ur[si]
              db 66h; sar bx,8
              db 66h; add ax,bx
              db 66h; xor bx,bx
              mov bx,word(texture)
              add ax,bx
              db 66h; mov word ptr so,ax

              db 66h; mov ax,word ptr xl[si]
              db 66h; sar ax,8
              cmp ax,320
              jl @no_change1_2
              mov ax,319
@no_change1_2:
              cmp ax,0
              jl @over2
              db 66h; mov word ptr shrl,ax

              db 66h; mov ax,word ptr xr[si]
              xor si,si
              db 66h; sar ax,8
              cmp ax,0
              jge @no_change2_2
              neg ax
              add ax,ax
              mov si,ax
              db 66h; xor ax,ax
@no_change2_2:
              cmp ax,319
              jge @over2
              db 66h; mov word ptr shrr,ax

              cmp ax,word ptr shrl
              jg @over2

              mov ax,vidseg
              mov es,ax
              mov ax,dx
              add ax,word ptr y1
              imul di,ax,320
              add di,word ptr shrr

              push ds
              lds bx,texture

              mov dx,word ptr so
              mov cx,word ptr shrl
              sub cx,word ptr shrr
              inc cx
@inner4:
              mov bx,word ptr texofs[si]
              add bx,dx

              mov al,ds:[bx]
              mov es:[di],al
              inc di

              add si,2
              dec cx
              jnz @inner4

              pop ds
@over2:
              pop dx
              inc dx
              cmp dx,word ptr b2
              jle @bigloop2

@nohh_over:
    end;
End;

procedure putimage(x,y:integer;s,scr:pointer); assembler;
var       px:integer;
asm                     { too bored to optimize :-) }
  push ds
  cmp y,199
  jg @over
  les di,scr
  imul bx,y,320
  add bx,x
  add di,bx
  lds si,s
  mov si,word(s)
  lodsw
  mov px,ax
  lodsw
  mov bx,ax
@next:
  cmp y,0
  jge @y_noff
  inc y
  dec bx
  jz @over
  add si,px
  add di,320
  jmp @next
@y_noff:

  add bx,y
  cmp bx,199
  jle @corr_y
  mov bx,200
@corr_y:
  sub bx,y

@looper:
  mov cx,px
  mov dx,x
@loop2:
  cmp dx,319
  ja @_black

  mov al,ds:[si]
  test al,al
  jz  @_black
  mov es:[di],al
@_black:
  inc dx
  inc si
  inc di
  dec cx
  jnz @loop2

  inc y
  add di,320
  sub di,px
  dec bx
  jnz @Looper

@over:
  pop ds
end;

procedure getimage(x1,y1,x2,y2,bpr:integer;src:pointer;var dest:pointer;id:boolean);
var       w,h,y,x:integer;
          cnt1,cnt2:word;
begin
  if x1>x2 then swapint(x1,x2);
  if y1>y2 then swapint(y1,y2);
  w:=x2-x1+1; h:=y2-y1+1;
  getmem(dest,w*h+4);
  cnt1:=word(dest);
  if id then            { if not id then you can't use putimage }
    begin
      memw[seg(dest^):cnt1]:=w;
      memw[seg(dest^):cnt1+2]:=h;
      inc(cnt1,4);
    end;
  for y:=y1 to y2 do
    begin
      cnt2:=ofs(src^)+y*bpr+x1;
      for x:=x1 to x2 do
        begin
          mem[seg(dest^):cnt1]:=mem[seg(src^):cnt2];
          inc(cnt1); inc(cnt2);
        end;
    end;
end;

{ ---------------------------- PALETTE ----------------------------- }
procedure initpalette(var p); assembler;
asm
  push ds
  lds si,p
  mov dx,3c8h
  xor al,al
  out dx,al
  inc dx
  mov cx,768
  rep outsb
  pop ds
end;

end.