unit Part2;

interface

uses
	zipvga, crt, fastsine, oneres;

procedure Run;

implementation

(*const
	oldlscpal:array[0..383] of byte=(
		0,0,0,48,48,48,1,0,43,1,3,43,2,5,44,2,7,44,3,9,45,4,11,46,5,13,47,6,15,48,
		7,17,49,8,19,50,9,21,51,10,22,52,11,24,52,12,26,54,13,28,54,14,30,56,15,32,
		56,16,34,58,17,34,58,17,36,58,18,38,60,19,40,60,20,42,62,21,44,62,10,31,0,
		11,31,0,11,31,1,11,32,1,12,32,1,12,32,2,12,33,2,13,33,2,14,33,3,15,33,3,15,
		34,3,15,34,4,15,35,4,16,35,4,16,35,5,16,36,5,17,36,5,17,36,6,18,37,6,18,38,
		7,19,38,8,20,39,8,20,40,9,21,40,10,22,41,10,22,42,11,23,42,12,24,43,12,24,
		44,13,25,44,14,25,45,14,26,46,15,27,46,16,27,47,17,28,47,18,28,48,19,29,49,
		19,30,49,20,30,50,21,31,51,21,32,51,22,32,52,23,33,53,23,34,53,24,34,54,25,
		35,55,25,36,55,26,36,56,27,37,57,27,38,57,27,39,57,27,41,57,27,42,57,27,43,
		57,27,44,57,27,45,57,27,46,57,27,47,57,27,49,57,27,50,57,27,51,57,27,52,57,
		27,53,57,27,55,57,27,56,57,27,57,57,27,58,57,27,58,57,26,58,57,25,58,57,24,
		58,56,23,58,55,22,58,54,20,58,53,19,58,51,18,58,50,17,58,50,16,58,49,15,58,
		48,14,58,47,13,58,46,12,58,45,11,58,44,11,58,44,10,58,43,10,58,42,9,57,41,
		8,57,40,8,56,39,7,56,38,6,55,37,5,55,35,4,54,33,4,54,31,2,32,32,32,63,63,63,
		63,63,63,63,63,63,63,63,63,48,48,48,63,63,63,63,63,63);*)

type
	TrigTable = array[0..511] of integer;

const
	firstframe = 1024;
	lastframe = firstframe+1024;

var
	lscpal : array[0..383] of byte;
	ISin, ICos : TrigTable;
	Y320 : array[0..255] of word;
	scr, mp, mt : ^screen2;
	i, j : word;
	x, y, z, h : integer;
	xv, yv, zv : integer;
	wl : word;
	fog, gray, p : palette;
	start, stop, frame, fr : longint;
	oldpal : palette absolute lscpal;
	rng : array[0..319] of byte;
	fper, fiso : longint;
	quit : boolean;

function tcount : longint;

var
	c, d : word;

begin
	asm
		mov ah, 0
		int 26
		mov c, cx
		mov d, dx
	 end;
	tcount := 256*c + d;
end;

procedure Init;

var
	i : word;

begin
	for i := 0 to 511 do
	 begin
		ISin[i] := round(256*sin(i*pi/256));
		ICos[i] := round(256*cos(i*pi/256));
	 end;
	for i := 0 to 255 do
	 begin
		Y320[i] := i*320;
	 end;
end;

function maxi(a,b:word):word; assembler;

asm
	mov ax, a
	mov bx, b
	cmp ax, bx
	jg @dont
	xchg ax, bx
 @dont:
end;

	function ncol(mc,n,dvd:integer):integer;

	var
		loc:integer;

	begin
		loc:=(mc+n-random(2*n)) div dvd; ncol:=loc;
		if loc>128 then ncol:=128; if loc<5 then ncol:=5
	end;

	procedure plasma(x1,y1,x2,y2:word);

	var xn,yn,dxy,p1,p2,p3,p4:word;

	begin
		if (x2-x1<2) and (y2-y1<2) then exit;
		p1:=mp^[y1*256 + x1]; p2:=mp^[y2*256 + x1]; p3:=mp^[y1*256 + x2];
		p4:=mp^[y2*256 + x2]; xn:=(x2+x1) shr 1; yn:=(y2+y1) shr 1;
		dxy:=5*(x2-x1+y2-y1) div 3;
		if mp^[y1*256 + xn]=0 then mp^[y1*256 + xn]:=ncol(p1+p3,dxy,2);
		if mp^[yn*256 + x1]=0 then mp^[yn*256 + x1]:=ncol(p1+p2,dxy,2);
		if mp^[yn*256 + x2]=0 then mp^[yn*256 + x2]:=ncol(p3+p4,dxy,2);
		if mp^[y2*256 + xn]=0 then mp^[y2*256 + xn]:=ncol(p2+p4,dxy,2);
		mp^[yn*256 + xn]:=ncol(p1+p2+p3+p4,dxy,4);
		plasma(x1,y1,xn,yn); plasma(xn,y1,x2,yn);
		plasma(x1,yn,xn,y2); plasma(xn,yn,x2,y2);
	end;

procedure DrawField (var mp, mt : screen2; xp, yp, zobs, dir : integer; fs, dist, wl : byte; var scr : screen2);

(* mp : the array to get the voxels from, silly! :)
** xp, yp, zobs : xposition, yposition, z of observer
** dir : direction (in degrees of course)
** dist : rendering depth
** wl : water level
** scr : a 64k buffer for the drawing
*)

var
	z : integer;
	ix, iy, x, y : integer;
	iy1, iyp, ixp : integer;
	s, csf, snf : integer;
	mpc : integer;
	i,j:integer;
	oldc : byte;

begin
	fillchar (rng, sizeof(rng), 200);

	{if Zobs < 64 then
		zobs := 64;}

	dir := dir mod 512;
	while dir < 0 do
		inc(dir,512);
	csf := ICos[dir];
	snf := ISin[dir];

	{for iy := yp to yp + dist do}
	for iy := yp + 8 to yp + dist do
	 begin
		iy1 := 1 + ((iy - yp) SHL 1);
		s := 4 + 300 div iy1;
		for ix := xp + yp - iy to xp - yp + iy do
		 begin
			ixp := xp + ((ix - xp)*csf + (iy - yp)*snf) shr 8;
			{ixp := ixp mod 256;
			while ixp < 0 do
				inc (ixp, 256);}
			 ixp := ixp and 255;
			iyp := yp + ((iy - yp)*csf - (ix - xp)*snf) shr 8;
			{iyp := iyp mod 256;
			while iyp < 0 do
				inc (iyp, 256);}
			iyp := iyp and 255;
			x:=160 + 360*(ix - xp) div iy1;
			if (x >= 0) and (x + s < 320) then
			 begin
				z := mp[(iyp mod 256)*256 + ixp mod 256];
				if @mt = @mp then
					mpc := {z div 16 + 16*((yp - iy + dist)*16 div dist)} z
				else
					{mpc := mt[(iyp mod 256)*256 + ixp mod 256] div 16 + 16*((yp - iy + dist)*16 div dist)};
					mpc := mt[iyp*256 + ixp];

				mpc := mini(mini(255, mpc), mpc*((yp + fs - iy + dist)*16 div dist) div 16);

				if (z < wl) and (zobs > wl) then
					z := wl;
				y := 100 + (zobs - z)*30 div iy1;
				if (y <= 199) and (y >= 0) then
					for j := x to x + s do
						if y < rng[j] then
							asm
								les di, scr

								mov si, y
								shl si, 1
								add si, offset Y320
								add di, ds:[si]
								add di, j

								mov ax, mpc

								xor ch, ch
								mov si, j
								add si, offset rng
								mov cl, [ds:si]
								sub cx, y
								inc cx

							 @LoopY:
								mov es:[di], al
								add di, 320

								dec cx
								jnz @LoopY

								mov ax, y
								mov ds:[si], al
							 end;
						{begin
							for i:=y to rng[j] do
								scr[Y320[i] + j] := mpc;
							rng[j] := y;
						 end;}
			 end;
		 end;
	 end;
end;

(*procedure DrawIso (var mp, mt : voxelarray; xp, yp, zp : integer; wl : byte; var scr : voxelarray);

var
	i, j : word;
	x0, y0 : integer;
	x, y : word;
	ex, ey : word;
	f : word;
	so : word;
	c, z : word;

begin
	fillchar (rng, sizeof(rng), 200);

	x0 := xp - 64;
	y0 := yp - 64;

	while x0 < 0 do
		inc (x0, 256);
	while y0 < 0 do
		inc (y0, 256);

	x0 := x0 mod 256;
	y0 := y0 mod 256;

	for j := 63 downto 0 do
		for i := 127 downto 0 do
		 begin
			c := mp[((j*2 + y0) mod 256)*256 + (i + x0) mod 256];
			if c > 254 then
				c := 254;

			z := maxi(c, wl);

			x := 159 + i - j*2;
			y := 73 + i div 2 + j - z div 8;

			{c := mt[((j*2 + y0) mod 256)*256 + (i + x0) mod 256];}
			c := c div 16 + 16*mini(15, mini(j div 4, i div 8));

			if (i = 63) and (j = 31) then
			 begin
				if y < rng[x] then
					rng[x] := y;

				y := 73 + i div 2 + j - zp div 8;

				if y <= rng[x] then
				 begin
					ex := x;
					ey := y;
				 end
				else
				 begin
					ex := 0;
					ey := 200;
				 end;
			 end
			else if y < rng[x] then
			 {begin
				for f := y to rng[x] do
					scr[Y320[f] + x] := c;
				rng[x] := y;
			 end;}
			 asm
				les di, scr

				mov si, y
				shl si, 1
				add si, offset Y320
				add di, ds:[si]
				add di, x

				mov ax, c

				xor ch, ch
				mov si, x
				add si, offset rng
				mov cl, [ds:si]
				sub cx, y
				inc cx

			 @LoopY:
				mov es:[di], al
				add di, 320

				dec cx
				jnz @LoopY

				mov ax, y
				mov ds:[si], al
			 end;
		 end;

	if ey < 200 then
		scr[Y320[ey] + ex] := 255;
end;*)

procedure Run;

begin
	new (scr);

	InitB;

	{initvga;}
	{brightness (0, 63);}
	(*for i := 0 to 63 do
	 begin
		p[i][0] := 0;
		p[i][1] := 0;
		p[i][2] := i;
	 end;
	for i := 64 to 127 do
	 begin
		p[i][0] := i - 64;
		p[i][1] := 0;
		p[i][2] := 127 - i;
	 end;
	for i := 128 to 255 do
	 begin
		p[i][0] := (255 - i) div 2;
		p[i][1] := 0;
		p[i][2] := 0;
	 end;
	fillchar (p[255], 3, 63);
	setpalette (p);*)
	(*for i := 0 to 255 do
	 begin
		fog[i][0] := 32 - (i div 16 + 1)*2 + (i mod 16)*(i div 16 + 1) div 6;
		fog[i][1] := 32 - (i div 16 + 1)*2 + (i mod 16)*(i div 16 + 1) div 8;
		fog[i][2] := 32 - (i div 16 + 1)*2;
	 end;*)

	(*for i := 0 to 383 do
		lscpal[i] := i*(i mod 3)*32 div 384;
	for i := 0 to 255 do
		for j := 0 to 2 do
		 begin
			x := oldpal[((i*24) mod 384) div 3, j]{ + oldpal[((mini(i + 1, 255)*24) mod 384) div 3, j]) shr 1};
			fog[i, j] := 32 - (i div 16 + 1)*2 + x*(i div 16 + 1) div 16;
		 end;*)

	(*for i := 0 to 255 do
		for j := 0 to i - 1 do
			if (p[i][0] = p[j][0]) and (p[i][2] = p[j][2]) then
				p[j, 0] := 255 - p[j, 0];*)

	(*savepalette ('Foggy.pal', p);
	compilepalette ('foggy', 'foggypalette');*)

	(*fog[255][0] := 63;
	fog[255][1] := 63;
	fog[255][2] := 0;

	setpalette (fog);

	for i := 0 to 255 do
		vscr[i div 16, i mod 16] := i;

	readkey;*)

	{for i := 0 to 254 do
		for j := 0 to 2 do
			gray[i, j] := i div 4;}
	(*for i := 0 to 254 do
		for j := 0 to 2 do
			gray[i, j] := (oldpal[i div 2, j] + oldpal[(i + 1) div 2, j]) shr 1;

	gray[255][0] := 63;
	gray[255][1] := 0;
	gray[255][2] := 0;

	setpalette (gray);*)

	init;
	new (mp);
	{x := 0;
	for i := 0 to 255 do
		for j := 0 to 255 do
		 begin
			(*mp^[j*256 + i] := (bsin(i*256 div 45 + bcos(j)*64 div 45) + bsin(j*512 div 45)) div 2;*)
			mp^[j*256 + i] := (bsin(i*256 div 45 + j*256 div 45) + bcos(i*512 div 45) div 2 +
					bcos(j*256 div 45 + i*256 div 45) + bcos(j*384 div 45) div 2) div 3;
			x := maxi(x, mp^[j*256 + i] + 1);
		 end;
	savepic2 ('voxel.mp', mp^);}
	fetch ('voxel.mp');
	blockread (lf, mp^, 32768);
	blockread (lf, mp^[32768], 32768);

	if maxavail >= sizeof(mt^) then
	 begin
		new (mt);

		(*{for i := 0 to 255 do
			for j := 0 to 255 do
				mt^[j*256 + i] := (mp^[j*256 + i] - mp^[j*256 + i - 1])*16 + 128;}
		for i := 0 to 65535 do
			mt^[i] := ((random((mp^[i] - mp^[i-1])*16) + 128)*mp^[i]) div 256;
			{mt^[i] := (bsin(i*123 div 45)*mp^[i]) div 256;}*)
		fetch ('voxel.mt');
		blockread (lf, mt^, 32768);
		blockread (lf, mt^[32768], 32768);
	 end
	else
		mt := mp;
	(*savepic2 ('voxel.mt', mt^);*)

	(*plasma (0, 0, 256, 256);*)

	(*for i := 0 to 199 do
		moveword (mp^[(i*50 shr 6)*256], vscr[i], 128);

	readkey;

	for i := 0 to 199 do
		moveword (mt^[(i*50 shr 6)*256], vscr[i], 128);

	readkey;*)

	{if mt <> mp then
	 begin
		for i := 0 to 199 do
			moveword (mt^[i*256], vscr[i], 128);
		readkey;
	 end;}

	{setpalette (fog);}

	x := 0;
	y := 0;
	z := 255;
	xv := 0;
	yv := 4;
	zv := 0;
	frame := 0;
	wl := 63;

	fper := 0;
	fiso := 0;

	quit := false;

	{start := tcount;}
	(*repeat
	until tcount mod 144 = 0;*)
	repeat
		getpos;
		fr := track*256 + 4*row;

		if fr < firstframe + 256 then
			brightness ((fr - firstframe) div 4, 63 - (fr - firstframe) div 4)
		else if fr > lastframe - 64 then
			brightness (lastframe - fr, 0);

		filldword (scr^, 16000, 0);

		h := ISin[(frame and 255)*2] div 2;

		{if (tcount div 144) mod 2 = 0 then
		 begin}
			drawfield (mp^, mt^, x, y, z, h, 32, 72, wl, scr^);
			{inc (fper);
		 end
		else
		 begin
			drawiso (mp^, mt^, x, y, z, wl, scr^);
			inc (fiso);
		 end;}

		if trapretrace then
			retrace;
		{setrgb (0, 0, 0, 0);}
		movedword (scr^, vscr, 16000);
		{setrgb (0, 31, 31, 31);}

		if z < 128 + maxi(mp^[y*256 + x], mp^[(y + 10)*256 + x]) then
			inc (zv)
		else
			if zv > -4 then
				dec (zv);

		if h < 0 then
			h := h + 512;

		xv := ISin[h and 511] div 64;
		yv := ICos[h and 511] div 64;

		if mp^[256*(10 + y) + x] - 1 > mp^[256*(10 + y) + x + xv + 1] then
			inc (xv)
		else if mp^[256*(10 + y) + x] - 1 > mp^[256*(10 + y) + x - xv - 1] then
			dec (xv);

		frame := (frame + 1) mod 1024;
		{if frame < 1024 then
			inc (frame);}

		{inc(mp^[y*256 + x]);}

		x := (x + xv) mod 256;
		y := (y + yv) mod 256;
		z := z + zv;

		{if keypressed then
			case readkey of
				'+', '=' : if wl < 255 then
					inc (wl);
				'-' : if wl > 0 then
					dec(wl);
				#27 : quit := true;
			 end;}
	until keypressed or (fr >= lastframe){ and (tcount mod 144 = 0)};
	{stop := tcount;}

	{closevga;}

	{writeln ('FPS = ', frame/((stop - start)/18.2):10:10);}

	(*writeln ('Perspective: ', fper);
	writeln ('Isometric:   ', fiso);*)

	if mp <> mt then
		dispose (mt);
	dispose (mp);
	dispose (scr);
end;

end.